/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.media.jai.PlanarImage;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.GetLegendGraphic;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.legendgraphic.BaseLegendTest;
import org.geoserver.wms.legendgraphic.BufferedImageLegendGraphicBuilder;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.image.util.ImageUtilities;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.xml.styling.SLDParser;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class BufferedImageLegendGraphicOutputFormatTest
extends BaseLegendTest<BufferedImageLegendGraphicBuilder> {
    @Before
    public void setLegendProducer() throws Exception {
        this.legendProducer = new BufferedImageLegendGraphicBuilder();
        this.service = new GetLegendGraphic(this.getWMS());
    }

    @Test
    public void testUserSpecifiedRule() throws Exception {
        Style multipleRulesStyle = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle();
        Assert.assertNotNull((Object)multipleRulesStyle);
        Rule rule = (Rule)((FeatureTypeStyle)multipleRulesStyle.featureTypeStyles().get(0)).rules().get(0);
        LOGGER.info("testing single rule " + rule.getName() + " from style " + multipleRulesStyle.getName());
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(multipleRulesStyle);
        req.setRule(rule.getName());
        req.setLegendOptions(new HashMap());
        int HEIGHT_HINT = 30;
        req.setHeight(30);
        ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testUserSpecifiedRule", image, LegendUtils.DEFAULT_BG_COLOR);
        String errMsg = "expected just one legend of height 30, for the rule " + rule.getName();
        int resultLegendCount = image.getHeight() / 30;
        Assert.assertEquals((String)errMsg, (long)1L, (long)resultLegendCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRainfall() throws Exception {
        Style multipleRulesStyle = this.getCatalog().getStyleByName("rainfall").getStyle();
        Assert.assertNotNull((Object)multipleRulesStyle);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        try {
            SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
            req.setLayer(feature.getSchema());
            req.setStyle(multipleRulesStyle);
            req.setLegendOptions(new HashMap());
            int HEIGHT_HINT = 30;
            req.setHeight(30);
            ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
            BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
            this.assertNotBlank("testRainfall", image, LegendUtils.DEFAULT_BG_COLOR);
            this.assertNotBlank("testRainfall", image, LegendUtils.DEFAULT_BG_COLOR);
        }
        finally {
            RenderedImage ri = coverage.getRenderedImage();
            if (coverage instanceof GridCoverage2D) {
                ((GridCoverage2D)coverage).dispose(true);
            }
            if (ri instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
            }
        }
    }

    @Test
    public void testNoLayerProvidedAndNonStrictRequest() throws Exception {
        Style style = this.getCatalog().getStyleByName("rainfall").getStyle();
        Assert.assertNotNull((Object)style);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        req.setStrict(false);
        req.setLayer(null);
        req.setStyle(style);
        int HEIGHT_HINT = 30;
        req.setHeight(30);
        ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testRainfall", image, LegendUtils.DEFAULT_BG_COLOR);
        this.assertNotBlank("testRainfall", image, LegendUtils.DEFAULT_BG_COLOR);
    }

    @Test
    public void testMultipleLayers() throws Exception {
        Assume.assumeFalse((System.getProperty("macos-github-build") != null ? 1 : 0) != 0);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        int titleHeight = this.getTitleHeight(req);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle());
        ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testMultipleLayers", image, LegendUtils.DEFAULT_BG_COLOR);
        int height = image.getHeight();
        GetLegendGraphicRequest.LegendRequest legend = new GetLegendGraphicRequest.LegendRequest(ftInfo.getFeatureType());
        legend.setStyle(this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle());
        req.getLegends().add(legend);
        ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testMultipleLayers", image, LegendUtils.DEFAULT_BG_COLOR);
        Assert.assertEquals((long)(2 * (height + titleHeight)), (long)image.getHeight());
        this.assertPixel(image, 1, titleHeight / 2, new Color(0, 0, 0));
        this.assertPixel(image, 10, 10 + titleHeight, new Color(192, 160, 0));
        this.assertPixel(image, 10, 30 + titleHeight, new Color(0, 0, 0));
        this.assertPixel(image, 10, 50 + titleHeight, new Color(224, 64, 0));
        this.assertPixel(image, 1, 60 + titleHeight + titleHeight / 2, new Color(0, 0, 0));
        this.assertPixel(image, 10, 70 + titleHeight * 2, new Color(192, 160, 0));
        this.assertPixel(image, 10, 90 + titleHeight * 2, new Color(0, 0, 0));
        this.assertPixel(image, 10, 110 + titleHeight * 2, new Color(224, 64, 0));
    }

    @Test
    public void testForceTitlesOff() throws Exception {
        Catalog cat = this.getCatalog();
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("forceTitles", "off");
        req.setLegendOptions(options);
        FeatureTypeInfo ftInfo = cat.getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        ArrayList layers = new ArrayList();
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(cat.getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle());
        ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testMultipleLayers", image, LegendUtils.DEFAULT_BG_COLOR);
        int height = image.getHeight();
        GetLegendGraphicRequest.LegendRequest legend = new GetLegendGraphicRequest.LegendRequest(ftInfo.getFeatureType());
        legend.setStyle(cat.getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle());
        req.getLegends().add(legend);
        ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testForceTitlesOff", image, LegendUtils.DEFAULT_BG_COLOR);
        Assert.assertEquals((long)(2 * height), (long)image.getHeight());
        this.assertPixel(image, 10, 10, new Color(192, 160, 0));
        this.assertPixel(image, 10, 30, new Color(0, 0, 0));
        this.assertPixel(image, 10, 50, new Color(224, 64, 0));
        this.assertPixel(image, 10, 70, new Color(192, 160, 0));
        this.assertPixel(image, 10, 90, new Color(0, 0, 0));
        this.assertPixel(image, 10, 110, new Color(224, 64, 0));
    }

    @Test
    public void testMultipleLayersWithDifferentStyles() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        int titleHeight = this.getTitleHeight(req);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        ArrayList<FeatureType> layers = new ArrayList<FeatureType>();
        layers.add(ftInfo.getFeatureType());
        layers.add(ftInfo.getFeatureType());
        layers.forEach(ft -> req.getLegends().add(new GetLegendGraphicRequest.LegendRequest(ft)));
        Style style1 = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle();
        ((GetLegendGraphicRequest.LegendRequest)req.getLegends().get(0)).setStyle(style1);
        Style style2 = this.getCatalog().getStyleByName(MockData.LAKES.getLocalPart()).getStyle();
        ((GetLegendGraphicRequest.LegendRequest)req.getLegends().get(1)).setStyle(style2);
        ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertPixel(image, 10, 10 + titleHeight, new Color(192, 160, 0));
        this.assertPixel(image, 10, 30 + titleHeight, new Color(0, 0, 0));
        this.assertPixel(image, 10, 50 + titleHeight, new Color(224, 64, 0));
        this.assertPixel(image, 10, 70 + titleHeight * 2, new Color(64, 64, 192));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleLayersWithVectorAndCoverage() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        int titleHeight = this.getTitleHeight(req);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        ArrayList<FeatureType> layers = new ArrayList<FeatureType>();
        layers.add(ftInfo.getFeatureType());
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        try {
            SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
            layers.add(feature.getSchema());
            layers.forEach(ft -> req.getLegends().add(new GetLegendGraphicRequest.LegendRequest(ft)));
            Style style1 = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle();
            ((GetLegendGraphicRequest.LegendRequest)req.getLegends().get(0)).setStyle(style1);
            Style style2 = this.getCatalog().getStyleByName("rainfall").getStyle();
            ((GetLegendGraphicRequest.LegendRequest)req.getLegends().get(1)).setStyle(style2);
            ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
            BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
            this.assertPixel(image, 10, 10 + titleHeight, new Color(192, 160, 0));
            this.assertPixel(image, 10, 30 + titleHeight, new Color(0, 0, 0));
            this.assertPixel(image, 10, 50 + titleHeight, new Color(224, 64, 0));
            this.assertPixel(image, 10, 70 + titleHeight * 2, new Color(115, 38, 0));
        }
        finally {
            RenderedImage ri = coverage.getRenderedImage();
            if (coverage instanceof GridCoverage2D) {
                ((GridCoverage2D)coverage).dispose(true);
            }
            if (ri instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleLayersWithVectorAndInvisibleCoverage() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        req.setScale(1000.0);
        int titleHeight = this.getTitleHeight(req);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        ArrayList<FeatureType> layers = new ArrayList<FeatureType>();
        layers.add(ftInfo.getFeatureType());
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        try {
            SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
            layers.add(feature.getSchema());
            layers.forEach(ft -> req.getLegends().add(new GetLegendGraphicRequest.LegendRequest(ft)));
            Style style1 = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart()).getStyle();
            ((GetLegendGraphicRequest.LegendRequest)req.getLegends().get(0)).setStyle(style1);
            ((GetLegendGraphicRequest.LegendRequest)req.getLegends().get(1)).setStyle(this.readSLD("InvisibleRaster.sld"));
            ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
            BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
            this.assertPixel(image, 10, 10 + titleHeight, new Color(192, 160, 0));
            this.assertPixel(image, 10, 30 + titleHeight, new Color(0, 0, 0));
            this.assertPixel(image, 10, 50 + titleHeight, new Color(224, 64, 0));
            Assert.assertTrue((image.getHeight() < 70 + titleHeight * 2 ? 1 : 0) != 0);
        }
        finally {
            RenderedImage ri = coverage.getRenderedImage();
            if (coverage instanceof GridCoverage2D) {
                ((GridCoverage2D)coverage).dispose(true);
            }
            if (ri instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
            }
        }
    }

    @Test
    public void testMultipleLayersWithVectorAndInvisibleVector() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        req.setScale(1000.0);
        int titleHeight = this.getTitleHeight(req);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.ROAD_SEGMENTS.getNamespaceURI(), MockData.ROAD_SEGMENTS.getLocalPart());
        ArrayList<FeatureType> layers = new ArrayList<FeatureType>();
        layers.add(ftInfo.getFeatureType());
        layers.add(ftInfo.getFeatureType());
        layers.forEach(ft -> req.getLegends().add(new GetLegendGraphicRequest.LegendRequest(ft)));
        ArrayList<Style> styles = new ArrayList<Style>();
        StyleInfo roadStyle = this.getCatalog().getStyleByName(MockData.ROAD_SEGMENTS.getLocalPart());
        styles.add(roadStyle.getStyle());
        styles.add(this.readSLD("InvisibleLine.sld"));
        Iterator stylesIterator = styles.iterator();
        for (GetLegendGraphicRequest.LegendRequest legend : req.getLegends()) {
            if (!stylesIterator.hasNext()) break;
            legend.setStyle((Style)stylesIterator.next());
        }
        ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertPixel(image, 10, 10 + titleHeight, new Color(192, 160, 0));
        this.assertPixel(image, 10, 30 + titleHeight, new Color(0, 0, 0));
        this.assertPixel(image, 10, 50 + titleHeight, new Color(224, 64, 0));
        Assert.assertTrue((image.getHeight() < 70 + titleHeight * 2 ? 1 : 0) != 0);
    }

    @Test
    public void testMixedGeometry() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("MIXEDGEOMETRY");
        builder.setNamespaceURI("test");
        builder.setDefaultGeometry("GEOMETRY");
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        builder.setCRS(crs);
        GeometryFactory geometryFactory = new GeometryFactory();
        AttributeTypeImpl at = new AttributeTypeImpl((Name)new NameImpl("ID"), String.class, false, false, Collections.EMPTY_LIST, null, null);
        builder.add((AttributeDescriptor)new AttributeDescriptorImpl((AttributeType)at, (Name)new NameImpl("ID"), 0, 1, false, null));
        GeometryTypeImpl gt = new GeometryTypeImpl((Name)new NameImpl("GEOMETRY"), Geometry.class, crs, false, false, Collections.EMPTY_LIST, null, null);
        builder.add((AttributeDescriptor)new GeometryDescriptorImpl((GeometryType)gt, (Name)new NameImpl("GEOMETRY"), 0, 1, false, null));
        SimpleFeatureType fType = builder.buildFeatureType();
        req.setLayer((FeatureType)fType);
        req.setStyle(this.readSLD("MixedGeometry.sld"));
        ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testMixedGeometry", image, LegendUtils.DEFAULT_BG_COLOR);
        this.assertPixel(image, 10, 10, new Color(0, 0, 0));
        this.assertPixel(image, 10, 30, new Color(0, 0, 255));
        this.assertPixel(image, 10, 50, new Color(255, 0, 0));
    }

    @Test
    public void testSymbolContainedInIcon() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("BigSymbol.sld"));
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testSymbolSize", image, LegendUtils.DEFAULT_BG_COLOR);
        this.assertPixel(image, 1, 1, new Color(255, 255, 255));
        this.assertPixel(image, 10, 10, new Color(255, 0, 0));
    }

    @Test
    public void testSymbolContainedInIconUsingExpression() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("SymbolExpression.sld"));
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testSymbolContainedInIconUsingExpression", image, LegendUtils.DEFAULT_BG_COLOR);
        this.assertPixel(image, 1, 20, new Color(255, 255, 255));
        this.assertPixel(image, 10, 30, new Color(255, 0, 0));
    }

    @Test
    public void testProportionalSymbolSize() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("ProportionalSymbols.sld"));
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testProportionalSymbolSize", image, LegendUtils.DEFAULT_BG_COLOR);
        this.assertPixel(image, 1, 1, new Color(255, 255, 255));
        this.assertPixel(image, 5, 5, new Color(255, 0, 0));
        this.assertPixel(image, 10, 10, new Color(255, 0, 0));
        this.assertPixel(image, 1, 21, new Color(255, 255, 255));
        this.assertPixel(image, 5, 25, new Color(255, 255, 255));
        this.assertPixel(image, 7, 27, new Color(255, 0, 0));
        this.assertPixel(image, 10, 30, new Color(255, 0, 0));
        this.assertPixel(image, 1, 41, new Color(255, 255, 255));
        this.assertPixel(image, 5, 45, new Color(255, 255, 255));
        this.assertPixel(image, 6, 46, new Color(255, 255, 255));
        this.assertPixel(image, 10, 50, new Color(255, 0, 0));
        this.assertPixel(image, 1, 61, new Color(255, 255, 255));
        this.assertPixel(image, 6, 68, new Color(255, 255, 255));
        this.assertPixel(image, 10, 70, new Color(255, 0, 0));
    }

    @Test
    public void testProportionalSymbolThickBorder() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("ProportionalSymbolsThickBorder.sld"));
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testProportionalSymbolSizeThickBorder", image, LegendUtils.DEFAULT_BG_COLOR);
        this.assertPixel(image, 1, 1, new Color(255, 255, 255));
        this.assertPixel(image, 5, 5, new Color(0, 0, 0));
        this.assertPixel(image, 10, 10, new Color(255, 0, 0));
        this.assertPixel(image, 1, 21, new Color(255, 255, 255));
        this.assertPixel(image, 5, 25, new Color(255, 255, 255));
        this.assertPixel(image, 10, 30, new Color(255, 0, 0));
    }

    @Test
    public void testProportionalSymbolsLine() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("ProportionalSymbolsLine.sld"));
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("ProportionalSymbolsLine", image, LegendUtils.DEFAULT_BG_COLOR);
        this.assertPixel(image, 1, 1, new Color(255, 255, 255));
        this.assertPixel(image, 5, 5, new Color(0, 0, 0));
        this.assertPixel(image, 7, 12, new Color(255, 0, 0));
        this.assertPixel(image, 1, 21, new Color(255, 255, 255));
        this.assertPixel(image, 5, 25, new Color(255, 255, 255));
        this.assertPixel(image, 10, 30, new Color(255, 0, 0));
    }

    @Test
    public void testProportionalSymbolSizeUOM() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("ProportionalSymbolsUOM.sld"));
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testProportionalSymbolSize", image, LegendUtils.DEFAULT_BG_COLOR);
        this.assertPixel(image, 1, 1, new Color(255, 255, 255));
        this.assertPixel(image, 5, 5, new Color(255, 0, 0));
        this.assertPixel(image, 10, 10, new Color(255, 0, 0));
        this.assertPixel(image, 1, 21, new Color(255, 255, 255));
        this.assertPixel(image, 5, 25, new Color(255, 255, 255));
        this.assertPixel(image, 7, 27, new Color(255, 0, 0));
        this.assertPixel(image, 10, 30, new Color(255, 0, 0));
        this.assertPixel(image, 1, 41, new Color(255, 255, 255));
        this.assertPixel(image, 5, 45, new Color(255, 255, 255));
        this.assertPixel(image, 6, 46, new Color(255, 255, 255));
        this.assertPixel(image, 10, 50, new Color(255, 0, 0));
        this.assertPixel(image, 1, 61, new Color(255, 255, 255));
        this.assertPixel(image, 6, 68, new Color(255, 255, 255));
        this.assertPixel(image, 10, 70, new Color(255, 0, 0));
    }

    @Test
    public void testProportionalSymbolSizePartialUOM() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        req.setScale(RendererUtilities.calculatePixelsPerMeterRatio((double)10.0, (Map)Collections.EMPTY_MAP));
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("ProportionalSymbolsPartialUOM.sld"));
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testProportionalSymbolSize", image, LegendUtils.DEFAULT_BG_COLOR);
        this.assertPixel(image, 1, 1, new Color(255, 255, 255));
        this.assertPixel(image, 5, 5, new Color(255, 0, 0));
        this.assertPixel(image, 10, 10, new Color(255, 0, 0));
        this.assertPixel(image, 1, 1, new Color(255, 255, 255));
        this.assertPixel(image, 5, 5, new Color(255, 0, 0));
        this.assertPixel(image, 10, 10, new Color(255, 0, 0));
    }

    @Test
    public void testMinSymbolSize() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("minSymbolSize", "10");
        req.setLegendOptions(options);
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("ProportionalSymbols.sld"));
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testProportionalSymbolSize", image, LegendUtils.DEFAULT_BG_COLOR);
        this.assertPixel(image, 1, 1, new Color(255, 255, 255));
        this.assertPixel(image, 5, 5, new Color(255, 0, 0));
        this.assertPixel(image, 10, 10, new Color(255, 0, 0));
        this.assertPixel(image, 1, 61, new Color(255, 255, 255));
        this.assertPixel(image, 7, 67, new Color(255, 0, 0));
        this.assertPixel(image, 10, 70, new Color(255, 0, 0));
    }

    @Test
    public void testInternationalizedLabels() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("forceLabels", "on");
        req.setLegendOptions(options);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("Internationalized.sld"));
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        int noLocalizedWidth = image.getWidth();
        req.setLocale(Locale.ITALIAN);
        image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        int itWidth = image.getWidth();
        Assert.assertTrue((itWidth != noLocalizedWidth ? 1 : 0) != 0);
        req.setLocale(Locale.ENGLISH);
        image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        int enWidth = image.getWidth();
        Assert.assertTrue((enWidth != noLocalizedWidth ? 1 : 0) != 0);
        Assert.assertTrue((enWidth != itWidth ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenderingTransformationRasterVector() throws Exception {
        Style transformStyle = this.readSLD("RenderingTransformRasterVector.sld");
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        CoverageInfo cInfo = this.getCatalog().getCoverageByName(MockData.TASMANIA_DEM.getNamespaceURI(), MockData.TASMANIA_DEM.getLocalPart());
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        try {
            SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
            req.setLayer(feature.getSchema());
            req.setStyle(transformStyle);
            req.setLegendOptions(new HashMap());
            ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
            BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
            this.assertNotBlank("testRenderingTransform", image, LegendUtils.DEFAULT_BG_COLOR);
            this.assertPixel(image, 1, 1, new Color(255, 255, 255));
            this.assertPixel(image, 10, 10, new Color(0, 0, 0));
            this.assertPixel(image, 19, 19, new Color(255, 255, 255));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            RenderedImage ri = coverage.getRenderedImage();
            if (coverage instanceof GridCoverage2D) {
                ((GridCoverage2D)coverage).dispose(true);
            }
            if (ri instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testColorMapWithCql() throws Exception {
        Style style = this.readSLD("ColorMapWithCql.sld");
        Assert.assertNotNull((Object)style.featureTypeStyles());
        Assert.assertEquals((long)1L, (long)style.featureTypeStyles().size());
        FeatureTypeStyle fts = (FeatureTypeStyle)style.featureTypeStyles().get(0);
        Assert.assertNotNull((Object)fts.rules());
        Assert.assertEquals((long)1L, (long)fts.rules().size());
        Rule rule = (Rule)fts.rules().get(0);
        Assert.assertNotNull((Object)rule.symbolizers());
        Assert.assertEquals((long)1L, (long)rule.symbolizers().size());
        Assert.assertTrue((boolean)(rule.symbolizers().get(0) instanceof RasterSymbolizer));
        RasterSymbolizer symbolizer = (RasterSymbolizer)rule.symbolizers().get(0);
        Assert.assertNotNull((Object)symbolizer.getColorMap());
        Assert.assertEquals((long)3L, (long)symbolizer.getColorMap().getColorMapEntries().length);
        ColorMapEntry[] entries = symbolizer.getColorMap().getColorMapEntries();
        Color color = LegendUtils.color((ColorMapEntry)entries[0]);
        int red = color.getRed();
        Assert.assertEquals((long)255L, (long)red);
        int green = color.getGreen();
        Assert.assertEquals((long)0L, (long)green);
        int blue = color.getBlue();
        Assert.assertEquals((long)0L, (long)blue);
        double quantity = LegendUtils.getQuantity((ColorMapEntry)entries[1]);
        Assert.assertEquals((double)20.0, (double)quantity, (double)0.0);
        double opacity = LegendUtils.getOpacity((ColorMapEntry)entries[2]);
        Assert.assertEquals((double)0.5, (double)opacity, (double)0.0);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        try {
            SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
            req.setLayer(feature.getSchema());
            req.setStyle(style);
            req.setLegendOptions(new HashMap());
            int HEIGHT_HINT = 30;
            req.setHeight(30);
            ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
            BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
            this.assertNotBlank("testColorMapWithCql", image, LegendUtils.DEFAULT_BG_COLOR);
            int fixedWidth = image.getWidth();
            String fixedLabel = entries[2].getLabel();
            entries[2].setLabel("${Concatenate('-', '4', '9', ' ', '-', ' ', '-', '2', '0', ' ', 'm', 'm')}");
            Assert.assertEquals((Object)fixedLabel, (Object)LegendUtils.getLabel((ColorMapEntry)entries[2]));
            image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
            this.assertNotBlank("testColorMapWithCql", image, LegendUtils.DEFAULT_BG_COLOR);
            Assert.assertEquals((long)fixedWidth, (long)image.getWidth());
        }
        finally {
            RenderedImage ri = coverage.getRenderedImage();
            if (coverage instanceof GridCoverage2D) {
                ((GridCoverage2D)coverage).dispose(true);
            }
            if (ri instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
            }
        }
    }

    @Test
    public void testRenderingTransformationVectorRaster() throws Exception {
        Style transformStyle = this.readSLD("RenderingTransformVectorRaster.sld");
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.NAMED_PLACES.getNamespaceURI(), MockData.NAMED_PLACES.getLocalPart());
        Assert.assertNotNull((Object)ftInfo);
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(transformStyle);
        req.setLegendOptions(new HashMap());
        ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testRenderingTransform", image, LegendUtils.DEFAULT_BG_COLOR);
        this.assertPixel(image, 10, 70, new Color(188, 188, 255));
        this.assertPixel(image, 10, 80, new Color(68, 68, 255));
        this.assertPixel(image, 10, 130, new Color(255, 152, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExternalGraphic() throws Exception {
        Style externalGraphicStyle = this.readSLD("ExternalGraphicDemo.sld");
        Assert.assertNotNull((Object)externalGraphicStyle);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        try {
            GetLegendGraphicRequest.LegendRequest legend = new GetLegendGraphicRequest.LegendRequest();
            legend.setStyle(externalGraphicStyle);
            req.getLegends().add(legend);
            req.setScale(1.0);
            int HEIGHT_HINT = 30;
            req.setHeight(30);
            ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
            BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
            this.assertPixel(image, 10, 45, Color.YELLOW);
        }
        finally {
            RenderedImage ri = coverage.getRenderedImage();
            if (coverage instanceof GridCoverage2D) {
                ((GridCoverage2D)coverage).dispose(true);
            }
            if (ri instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
            }
        }
    }

    @Test
    public void testLabelMargin() throws Exception {
        int x;
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.POINTS.getNamespaceURI(), MockData.POINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        Style externalGraphicStyle = this.readSLD("ExternalGraphicDemo.sld");
        req.setStyle(externalGraphicStyle);
        int HEIGHT_HINT = 20;
        req.setHeight(20);
        HashMap<String, String> legendOptions = new HashMap<String, String>();
        legendOptions.put("labelMargin", "10");
        req.setLegendOptions(legendOptions);
        ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertEquals((long)40L, (long)image.getHeight());
        for (x = 21; x <= 29; ++x) {
            this.assertPixel(image, x, 10, new Color(255, 255, 255));
        }
        legendOptions.put("labelMargin", "20");
        req.setLegendOptions(legendOptions);
        ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        Assert.assertEquals((long)40L, (long)image.getHeight());
        for (x = 21; x <= 39; ++x) {
            this.assertPixel(image, x, 10, new Color(255, 255, 255));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbsoluteMargins() throws Exception {
        Style style = this.readSLD("ColorMapWithLongLabels.sld");
        Assert.assertNotNull((Object)style.featureTypeStyles());
        Assert.assertEquals((long)1L, (long)style.featureTypeStyles().size());
        FeatureTypeStyle fts = (FeatureTypeStyle)style.featureTypeStyles().get(0);
        Assert.assertNotNull((Object)fts.rules());
        Assert.assertEquals((long)1L, (long)fts.rules().size());
        Rule rule = (Rule)fts.rules().get(0);
        Assert.assertNotNull((Object)rule.symbolizers());
        Assert.assertEquals((long)1L, (long)rule.symbolizers().size());
        Assert.assertTrue((boolean)(rule.symbolizers().get(0) instanceof RasterSymbolizer));
        RasterSymbolizer symbolizer = (RasterSymbolizer)rule.symbolizers().get(0);
        Assert.assertNotNull((Object)symbolizer.getColorMap());
        Assert.assertEquals((long)3L, (long)symbolizer.getColorMap().getColorMapEntries().length);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        CoverageInfo cInfo = this.getCatalog().getCoverageByName("world");
        Assert.assertNotNull((Object)cInfo);
        GridCoverage coverage = cInfo.getGridCoverage(null, null);
        try {
            SimpleFeatureCollection feature = FeatureUtilities.wrapGridCoverage((GridCoverage2D)((GridCoverage2D)coverage));
            req.setLayer(feature.getSchema());
            req.setStyle(style);
            HashMap<String, String> legendOptions = new HashMap<String, String>();
            legendOptions.put("dx", "0.5");
            legendOptions.put("dy", "0");
            req.setLegendOptions(legendOptions);
            int HEIGHT_HINT = 30;
            req.setHeight(30);
            ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
            BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
            int absoluteWidth = image.getWidth();
            legendOptions.put("absoluteMargins", "false");
            image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
            Assert.assertTrue((image.getWidth() > absoluteWidth ? 1 : 0) != 0);
        }
        finally {
            RenderedImage ri = coverage.getRenderedImage();
            if (coverage instanceof GridCoverage2D) {
                ((GridCoverage2D)coverage).dispose(true);
            }
            if (ri instanceof PlanarImage) {
                ImageUtilities.disposePlanarImageChain((PlanarImage)((PlanarImage)ri));
            }
        }
    }

    @Test
    public void testThickPolygonBorder() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("ThickBorder.sld"));
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testThickPolygonBorder", image, LegendUtils.DEFAULT_BG_COLOR);
        this.assertPixel(image, 1, 1, new Color(255, 255, 255));
        this.assertPixel(image, 6, 6, new Color(0, 0, 0));
        this.assertPixel(image, 10, 10, new Color(255, 0, 0));
        this.assertPixel(image, 1, 21, new Color(255, 255, 255));
        this.assertPixel(image, 10, 30, new Color(0, 255, 0));
    }

    @Test
    public void testThickPolygonAsymmetricSymbol() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        req.setWidth(40);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("ThickBorder.sld"));
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("testThickPolygonBorder", image, LegendUtils.DEFAULT_BG_COLOR);
        this.assertPixel(image, 1, 1, new Color(255, 255, 255));
        this.assertPixel(image, 9, 6, new Color(0, 0, 0));
        this.assertPixel(image, 20, 10, new Color(255, 0, 0));
        this.assertPixel(image, 1, 23, new Color(255, 255, 255));
        this.assertPixel(image, 20, 30, new Color(0, 255, 0));
    }

    @Test
    public void testLargeCirclePlacement() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        req.setWidth(48);
        req.setHeight(25);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("largeCircle.sld"));
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("largeCircle", image, LegendUtils.DEFAULT_BG_COLOR);
        Color colorTop = this.getPixelColor(image, 24, 0);
        Color colorBottom = this.getPixelColor(image, 24, 24);
        this.assertColorSimilar(colorTop, colorBottom, 20);
    }

    private void assertColorSimilar(Color expected, Color actual, int componentTolerance) {
        Assert.assertEquals((float)expected.getRed(), (float)actual.getRed(), (float)componentTolerance);
        Assert.assertEquals((float)expected.getGreen(), (float)actual.getGreen(), (float)componentTolerance);
        Assert.assertEquals((float)expected.getBlue(), (float)actual.getBlue(), (float)componentTolerance);
    }

    @Test
    public void testSimpleLine() throws Exception {
        GetLegendGraphicRequest req = new GetLegendGraphicRequest(null);
        req.setWidth(20);
        req.setHeight(20);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(MockData.MPOINTS.getNamespaceURI(), MockData.MPOINTS.getLocalPart());
        req.setLayer(ftInfo.getFeatureType());
        req.setStyle(this.readSLD("line.sld"));
        BufferedImage image = ((BufferedImageLegendGraphicBuilder)this.legendProducer).buildLegendGraphic(req);
        this.assertNotBlank("line", image, LegendUtils.DEFAULT_BG_COLOR);
        Color colorCenter = this.getPixelColor(image, 10, 10);
        this.assertColorSimilar(Color.BLUE, colorCenter, 20);
        Color colorOutsideCenter = this.getPixelColor(image, 6, 6);
        this.assertColorSimilar(Color.WHITE, colorOutsideCenter, 20);
    }

    private Style readSLD(String sldName) throws IOException {
        StyleFactory styleFactory = CommonFactoryFinder.getStyleFactory(null);
        SLDParser stylereader = new SLDParser(styleFactory, ((Object)((Object)this)).getClass().getResource(sldName));
        Style[] readStyles = stylereader.readXML();
        Style style = readStyles[0];
        return style;
    }
}

