/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.time.Instant;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import junit.framework.Test;
import org.apache.http.conn.HttpClientConnectionManager;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.kvp.URLKvpParser;
import org.geoserver.platform.ServiceException;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.test.RemoteOWSTestSupport;
import org.geoserver.test.ows.KvpRequestReaderTestSupport;
import org.geoserver.wms.CacheConfiguration;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSInfoImpl;
import org.geoserver.wms.kvp.PaletteManager;
import org.geoserver.wms.map.GetMapKvpRequestReader;
import org.geoserver.wms.map.MockHttpClientConnectionManager;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.Style;
import org.geotools.util.DateRange;
import org.geotools.util.logging.Logging;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class GetMapKvpRequestReaderTest
extends KvpRequestReaderTestSupport {
    private static final Logger LOG = Logging.getLogger(GetMapKvpRequestReaderTest.class);
    GetMapKvpRequestReader reader;
    Dispatcher dispatcher;
    public static final String STATES_SLD = "<StyledLayerDescriptor version=\"1.0.0\"><UserLayer><Name>sf:states</Name><UserStyle><Name>UserSelection</Name><FeatureTypeStyle><Rule><Filter xmlns:gml=\"http://www.opengis.net/gml\"><PropertyIsEqualTo><PropertyName>STATE_ABBR</PropertyName><Literal>IL</Literal></PropertyIsEqualTo></Filter><PolygonSymbolizer><Fill><CssParameter name=\"fill\">#FF0000</CssParameter></Fill></PolygonSymbolizer></Rule><Rule><LineSymbolizer><Stroke/></LineSymbolizer></Rule></FeatureTypeStyle></UserStyle></UserLayer></StyledLayerDescriptor>";

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetMapKvpRequestReaderTest());
    }

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        CatalogFactory cf = this.getCatalog().getFactory();
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        LayerGroupInfo gi = cf.createLayerGroup();
        gi.setName("testGroup");
        gi.getLayers().add(this.getCatalog().getLayerByName(MockData.BASIC_POLYGONS.getLocalPart()));
        gi.getStyles().add(this.getCatalog().getStyleByName("polygon"));
        cb.calculateLayerGroupBounds(gi);
        this.getCatalog().add(gi);
        LayerGroupInfo gi2 = cf.createLayerGroup();
        gi2.setName("testGroup2");
        gi2.getLayers().add(this.getCatalog().getLayerByName(MockData.BASIC_POLYGONS.getLocalPart()));
        gi2.getStyles().add(this.getCatalog().getStyleByName("raster"));
        gi2.getLayers().add(this.getCatalog().getLayerByName(MockData.BUILDINGS.getLocalPart()));
        gi2.getStyles().add(this.getCatalog().getStyleByName("raster"));
        cb.calculateLayerGroupBounds(gi2);
        this.getCatalog().add(gi2);
    }

    protected void oneTimeTearDown() throws Exception {
        super.oneTimeTearDown();
        GeoServerLoader.setLegacy((boolean)false);
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.dispatcher = (Dispatcher)applicationContext.getBean("dispatcher");
        WMS wms = new WMS(this.getGeoServer());
        this.reader = new GetMapKvpRequestReader(wms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSldEntityResolver() throws Exception {
        WMS wms = new WMS(this.getGeoServer());
        GeoServerInfo geoserverInfo = wms.getGeoServer().getGlobal();
        try {
            geoserverInfo.setXmlExternalEntitiesEnabled(Boolean.valueOf(true));
            this.getGeoServer().save(geoserverInfo);
            GetMapKvpRequestReaderTest.assertNotNull((Object)wms.getGeoServer().getGlobal().isXmlExternalEntitiesEnabled());
            GetMapKvpRequestReaderTest.assertTrue((boolean)wms.getGeoServer().getGlobal().isXmlExternalEntitiesEnabled());
            GetMapKvpRequestReader reader = new GetMapKvpRequestReader(wms);
            GetMapKvpRequestReaderTest.assertNull((Object)reader.entityResolverProvider.getEntityResolver());
            geoserverInfo.setXmlExternalEntitiesEnabled(Boolean.valueOf(false));
            this.getGeoServer().save(geoserverInfo);
            reader = new GetMapKvpRequestReader(wms);
            GetMapKvpRequestReaderTest.assertNotNull((Object)reader.entityResolverProvider.getEntityResolver());
            geoserverInfo.setXmlExternalEntitiesEnabled(null);
            this.getGeoServer().save(geoserverInfo);
            reader = new GetMapKvpRequestReader(wms);
            GetMapKvpRequestReaderTest.assertNotNull((Object)reader.entityResolverProvider.getEntityResolver());
        }
        finally {
            geoserverInfo.setXmlExternalEntitiesEnabled(null);
            this.getGeoServer().save(geoserverInfo);
        }
    }

    public void testCreateRequest() throws Exception {
        GetMapRequest request = this.reader.createRequest();
        GetMapKvpRequestReaderTest.assertNotNull((Object)request);
    }

    public void testReadMandatory() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("styles", MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("request", "GetMap");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        String layer = MockData.BASIC_POLYGONS.getLocalPart();
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getLayers().size());
        GetMapKvpRequestReaderTest.assertTrue((boolean)((MapLayerInfo)request.getLayers().get(0)).getName().endsWith(layer));
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getStyles().size());
        Style expected = this.getCatalog().getStyleByName(layer).getStyle();
        Style style = (Style)request.getStyles().get(0);
        GetMapKvpRequestReaderTest.assertEquals((Object)expected, (Object)style);
        GetMapKvpRequestReaderTest.assertEquals((String)"image/jpeg", (String)request.getFormat());
        GetMapKvpRequestReaderTest.assertEquals((int)600, (int)request.getHeight());
        GetMapKvpRequestReaderTest.assertEquals((int)800, (int)request.getWidth());
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getBbox());
        GetMapKvpRequestReaderTest.assertEquals((double)-10.0, (double)request.getBbox().getMinX(), (double)0.0);
        GetMapKvpRequestReaderTest.assertEquals((double)-10.0, (double)request.getBbox().getMinY(), (double)0.0);
        GetMapKvpRequestReaderTest.assertEquals((double)10.0, (double)request.getBbox().getMaxX(), (double)0.0);
        GetMapKvpRequestReaderTest.assertEquals((double)10.0, (double)request.getBbox().getMaxY(), (double)0.0);
        GetMapKvpRequestReaderTest.assertEquals((String)"epsg:3003", (String)request.getSRS());
    }

    public void testReadOptional() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("bgcolor", "000000");
        kvp.put("transparent", "true");
        kvp.put("tiled", "true");
        kvp.put("tilesorigin", "1.2,3.4");
        kvp.put("buffer", "1");
        kvp.put("palette", "SAFE");
        kvp.put("time", "2006-02-27T22:08:12Z");
        kvp.put("elevation", "4");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertEquals((Object)Color.BLACK, (Object)request.getBgColor());
        GetMapKvpRequestReaderTest.assertTrue((boolean)request.isTransparent());
        GetMapKvpRequestReaderTest.assertTrue((boolean)request.isTiled());
        GetMapKvpRequestReaderTest.assertEquals((Object)new Point2D.Double(1.2, 3.4), (Object)request.getTilesOrigin());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getBuffer());
        GetMapKvpRequestReaderTest.assertEquals((Object)PaletteManager.safePalette, (Object)request.getPalette());
        GetMapKvpRequestReaderTest.assertEquals(Arrays.asList(4.0), (Object)request.getElevation());
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        cal.clear();
        cal.set(2006, 1, 27, 22, 8, 12);
        List times = request.getTime();
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getTime().size());
        GetMapKvpRequestReaderTest.assertEquals((Object)cal.getTime(), (Object)((DateRange)times.get(0)).getMinValue());
    }

    public void testDefaultStyle() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart() + "," + MockData.BUILDINGS.getPrefix() + ":" + MockData.BUILDINGS.getLocalPart());
        raw.put("styles", ",");
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        GetMapKvpRequestReaderTest.assertEquals((int)2, (int)request.getStyles().size());
        LayerInfo basicPolygons = this.getCatalog().getLayerByName(MockData.BASIC_POLYGONS.getLocalPart());
        LayerInfo buildings = this.getCatalog().getLayerByName(MockData.BUILDINGS.getLocalPart());
        GetMapKvpRequestReaderTest.assertEquals((Object)basicPolygons.getDefaultStyle().getStyle(), request.getStyles().get(0));
        GetMapKvpRequestReaderTest.assertEquals((Object)buildings.getDefaultStyle().getStyle(), request.getStyles().get(1));
    }

    public void testInterpolations() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("interpolations", "bicubic");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getInterpolations());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getInterpolations().size());
        GetMapKvpRequestReaderTest.assertNotNull(request.getInterpolations().get(0));
        GetMapKvpRequestReaderTest.assertTrue((boolean)(request.getInterpolations().get(0) instanceof InterpolationBicubic));
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("interpolations", "bicubic,,bilinear");
        request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getInterpolations());
        GetMapKvpRequestReaderTest.assertEquals((int)3, (int)request.getInterpolations().size());
        GetMapKvpRequestReaderTest.assertNotNull(request.getInterpolations().get(0));
        GetMapKvpRequestReaderTest.assertNull(request.getInterpolations().get(1));
        GetMapKvpRequestReaderTest.assertNotNull(request.getInterpolations().get(2));
        GetMapKvpRequestReaderTest.assertTrue((boolean)(request.getInterpolations().get(2) instanceof InterpolationBilinear));
    }

    public void testInterpolationsForLayerGroups() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("layers", "testGroup2");
        kvp.put("interpolations", "bicubic");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getInterpolations());
        GetMapKvpRequestReaderTest.assertEquals((int)2, (int)request.getInterpolations().size());
        GetMapKvpRequestReaderTest.assertNotNull(request.getInterpolations().get(0));
        GetMapKvpRequestReaderTest.assertTrue((boolean)(request.getInterpolations().get(0) instanceof InterpolationBicubic));
        GetMapKvpRequestReaderTest.assertNotNull(request.getInterpolations().get(1));
        GetMapKvpRequestReaderTest.assertTrue((boolean)(request.getInterpolations().get(1) instanceof InterpolationBicubic));
        kvp.put("layers", "testGroup2,testGroup," + this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("interpolations", "bicubic,bilinear,nearest neighbor");
        request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getInterpolations());
        GetMapKvpRequestReaderTest.assertEquals((int)4, (int)request.getInterpolations().size());
        GetMapKvpRequestReaderTest.assertNotNull(request.getInterpolations().get(0));
        GetMapKvpRequestReaderTest.assertTrue((boolean)(request.getInterpolations().get(0) instanceof InterpolationBicubic));
        GetMapKvpRequestReaderTest.assertNotNull(request.getInterpolations().get(1));
        GetMapKvpRequestReaderTest.assertTrue((boolean)(request.getInterpolations().get(1) instanceof InterpolationBicubic));
        GetMapKvpRequestReaderTest.assertNotNull(request.getInterpolations().get(2));
        GetMapKvpRequestReaderTest.assertTrue((boolean)(request.getInterpolations().get(2) instanceof InterpolationBilinear));
        GetMapKvpRequestReaderTest.assertNotNull(request.getInterpolations().get(3));
        GetMapKvpRequestReaderTest.assertTrue((boolean)(request.getInterpolations().get(3) instanceof InterpolationNearest));
        kvp.put("layers", "testGroup2,testGroup," + this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("interpolations", ",bilinear");
        request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getInterpolations());
        GetMapKvpRequestReaderTest.assertEquals((int)4, (int)request.getInterpolations().size());
        GetMapKvpRequestReaderTest.assertNull(request.getInterpolations().get(0));
        GetMapKvpRequestReaderTest.assertNull(request.getInterpolations().get(1));
        GetMapKvpRequestReaderTest.assertNotNull(request.getInterpolations().get(2));
        GetMapKvpRequestReaderTest.assertTrue((boolean)(request.getInterpolations().get(2) instanceof InterpolationBilinear));
        GetMapKvpRequestReaderTest.assertNull(request.getInterpolations().get(3));
    }

    public void testFilter() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("filter", "<Filter><FeatureId id=\"foo\"/></Filter>");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getFilter());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getFilter().size());
        Id fid = (Id)request.getFilter().get(0);
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)fid.getIDs().size());
        GetMapKvpRequestReaderTest.assertEquals((Object)"foo", fid.getIDs().iterator().next());
    }

    public void testCQLFilter() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("cql_filter", "foo = bar");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getCQLFilter());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getCQLFilter().size());
        PropertyIsEqualTo filter = (PropertyIsEqualTo)request.getCQLFilter().get(0);
    }

    public void testFeatureId() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("featureid", "foo");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getFeatureId());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getFeatureId().size());
        GetMapKvpRequestReaderTest.assertEquals((Object)"foo", request.getFeatureId().get(0));
    }

    public void testSortBy() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        kvp.put("sortBy", "FID D");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getSortBy().size());
        List sort = (List)request.getSortBy().get(0);
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)sort.size());
        this.assertSortBy((SortBy)sort.get(0), "FID", SortOrder.DESCENDING);
    }

    public void testSortByGroup() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("layers", "testGroup2");
        kvp.put("sortBy", "FID D");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        GetMapKvpRequestReaderTest.assertEquals((int)2, (int)request.getSortBy().size());
        List sort1 = (List)request.getSortBy().get(0);
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)sort1.size());
        this.assertSortBy((SortBy)sort1.get(0), "FID", SortOrder.DESCENDING);
        List sort2 = (List)request.getSortBy().get(0);
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)sort2.size());
        this.assertSortBy((SortBy)sort2.get(0), "FID", SortOrder.DESCENDING);
    }

    public void testSortByLessThanRequired() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("layers", this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.LAKES));
        kvp.put("sortBy", "FID D");
        GetMapRequest request = this.reader.createRequest();
        try {
            this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"sortBy"));
        }
    }

    private void assertSortBy(SortBy sort, String propertyName, SortOrder direction) {
        GetMapKvpRequestReaderTest.assertEquals((String)propertyName, (String)sort.getPropertyName().getPropertyName());
        GetMapKvpRequestReaderTest.assertEquals((Object)direction, (Object)sort.getSortOrder());
    }

    public void testSldNoDefault() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryNoDefault.sld");
        String decoded = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        kvp.put("sld", decoded);
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        GetMapRequest request = this.reader.createRequest();
        this.reader.setLaxStyleMatchAllowed(false);
        request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getSld());
        GetMapKvpRequestReaderTest.assertEquals((String)URLKvpParser.fixURL((String)decoded), (String)request.getSld().toExternalForm());
        Style style = (Style)request.getStyles().get(0);
        GetMapKvpRequestReaderTest.assertNotNull((Object)style);
        GetMapKvpRequestReaderTest.assertEquals((String)"BasicPolygons", (String)style.getName());
    }

    public void testSldDefault() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryDefault.sld");
        String decoded = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        kvp.put("sld", decoded);
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getSld());
        GetMapKvpRequestReaderTest.assertEquals((String)URLKvpParser.fixURL((String)decoded), (String)request.getSld().toExternalForm());
        Style style = (Style)request.getStyles().get(0);
        GetMapKvpRequestReaderTest.assertNotNull((Object)style);
        GetMapKvpRequestReaderTest.assertEquals((String)"TheLibraryModeStyle", (String)style.getName());
    }

    public void testSldCache() throws Exception {
        WMS wms = new WMS(this.getGeoServer());
        WMSInfo oldInfo = (WMSInfo)wms.getGeoServer().getService(WMSInfo.class);
        WMSInfoImpl info = new WMSInfoImpl();
        info.setCacheConfiguration(new CacheConfiguration(true));
        this.getGeoServer().remove((ServiceInfo)oldInfo);
        this.getGeoServer().add((ServiceInfo)info);
        URL sld = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryDefault.sld");
        StringBuilder builder = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(sld.openStream()));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                builder.append(inputLine);
            }
        }
        MockHttpClientConnectionManager manager = new MockHttpClientConnectionManager(builder.toString(), true);
        this.reader = new GetMapKvpRequestReader(wms, (HttpClientConnectionManager)manager);
        HashMap<String, String> kvp = new HashMap<String, String>();
        String url = "http://cached_sld";
        kvp.put("sld", url);
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getSld());
        GetMapKvpRequestReaderTest.assertEquals((int)manager.getConnections(), (int)1);
        request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertEquals((int)manager.getConnections(), (int)1);
    }

    public void testSldCacheNotEnabled() throws Exception {
        WMS wms = new WMS(this.getGeoServer());
        WMSInfo oldInfo = (WMSInfo)wms.getGeoServer().getService(WMSInfo.class);
        WMSInfoImpl info = new WMSInfoImpl();
        info.setCacheConfiguration(new CacheConfiguration(true));
        this.getGeoServer().remove((ServiceInfo)oldInfo);
        this.getGeoServer().add((ServiceInfo)info);
        URL sld = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryDefault.sld");
        StringBuilder builder = new StringBuilder();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(sld.openStream()));){
            String inputLine;
            while ((inputLine = in.readLine()) != null) {
                builder.append(inputLine);
            }
        }
        MockHttpClientConnectionManager manager = new MockHttpClientConnectionManager(builder.toString(), false);
        this.reader = new GetMapKvpRequestReader(wms, (HttpClientConnectionManager)manager);
        HashMap<String, String> kvp = new HashMap<String, String>();
        String url = "http://cached_sld";
        kvp.put("sld", url);
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getSld());
        GetMapKvpRequestReaderTest.assertEquals((int)manager.getConnections(), (int)1);
        request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertEquals((int)manager.getConnections(), (int)2);
    }

    public void testSldDisabled() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryDefault.sld");
        String decoded = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        kvp.put("sld", decoded);
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        WMS wms = new WMS(this.getGeoServer());
        WMSInfo oldInfo = (WMSInfo)wms.getGeoServer().getService(WMSInfo.class);
        WMSInfoImpl info = new WMSInfoImpl();
        info.setDynamicStylingDisabled(Boolean.TRUE);
        this.getGeoServer().remove((ServiceInfo)oldInfo);
        this.getGeoServer().add((ServiceInfo)info);
        this.reader = new GetMapKvpRequestReader(wms);
        GetMapRequest request = this.reader.createRequest();
        boolean error = false;
        try {
            request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        }
        catch (ServiceException e) {
            error = true;
        }
        this.getGeoServer().remove((ServiceInfo)info);
        this.getGeoServer().add((ServiceInfo)oldInfo);
        GetMapKvpRequestReaderTest.assertTrue((boolean)error);
    }

    public void testSldBodyDisabled() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("sld_body", STATES_SLD);
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        WMS wms = new WMS(this.getGeoServer());
        WMSInfo oldInfo = (WMSInfo)wms.getGeoServer().getService(WMSInfo.class);
        WMSInfoImpl info = new WMSInfoImpl();
        info.setDynamicStylingDisabled(Boolean.TRUE);
        this.getGeoServer().remove((ServiceInfo)oldInfo);
        this.getGeoServer().add((ServiceInfo)info);
        this.reader = new GetMapKvpRequestReader(wms);
        GetMapRequest request = this.reader.createRequest();
        boolean error = false;
        try {
            request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        }
        catch (ServiceException e) {
            error = true;
        }
        this.getGeoServer().remove((ServiceInfo)info);
        this.getGeoServer().add((ServiceInfo)oldInfo);
        GetMapKvpRequestReaderTest.assertTrue((boolean)error);
    }

    public void testSldNamed() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryNoDefault.sld");
        String decoded = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        kvp.put("sld", decoded);
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        kvp.put("styles", "TheLibraryModeStyle");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getSld());
        GetMapKvpRequestReaderTest.assertEquals((String)URLKvpParser.fixURL((String)decoded), (String)request.getSld().toExternalForm());
        Style style = (Style)request.getStyles().get(0);
        GetMapKvpRequestReaderTest.assertNotNull((Object)style);
        GetMapKvpRequestReaderTest.assertEquals((String)"TheLibraryModeStyle", (String)style.getName());
    }

    public void testSldFailLookup() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryNoDefault.sld");
        kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        kvp.put("styles", "ThisStyleDoesNotExists");
        GetMapRequest request = this.reader.createRequest();
        try {
            this.reader.setLaxStyleMatchAllowed(false);
            request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
            GetMapKvpRequestReaderTest.fail((String)"The style looked up, 'ThisStyleDoesNotExists', should not have been found");
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    public void testSldConnectionFailure() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = new URL("http://hostthatdoesnotexist/");
        kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        kvp.put("styles", "ThisStyleDoesNotExists");
        GetMapRequest request = this.reader.createRequest();
        try {
            this.reader.setLaxStyleMatchAllowed(false);
            request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
            GetMapKvpRequestReaderTest.fail((String)"The style looked up, 'ThisStyleDoesNotExists', should not have been found");
        }
        catch (ServiceException e) {
            GetMapKvpRequestReaderTest.assertTrue((String)"Exception should not reveal its cause", (e.getCause() == null ? 1 : 0) != 0);
        }
    }

    public void testSldNotExist() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = new URL(GetMapKvpRequestReaderTest.class.getResource(""), "does-not-exist");
        kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        kvp.put("styles", "ThisStyleDoesNotExists");
        GetMapRequest request = this.reader.createRequest();
        try {
            this.reader.setLaxStyleMatchAllowed(false);
            request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
            GetMapKvpRequestReaderTest.fail((String)"The style looked up, 'ThisStyleDoesNotExists', should not have been found");
        }
        catch (ServiceException e) {
            GetMapKvpRequestReaderTest.assertTrue((String)"Exception should not reveal its cause", (e.getCause() == null ? 1 : 0) != 0);
        }
    }

    public void testSldNotXML() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReaderTest.class.getResource("paletted.tif");
        kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        kvp.put("styles", "ThisStyleDoesNotExists");
        GetMapRequest request = this.reader.createRequest();
        try {
            this.reader.setLaxStyleMatchAllowed(false);
            request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
            GetMapKvpRequestReaderTest.fail((String)"The style looked up, 'ThisStyleDoesNotExists', should not have been found");
        }
        catch (ServiceException e) {
            GetMapKvpRequestReaderTest.assertTrue((String)"Exception should not reveal its cause", (e.getCause() == null ? 1 : 0) != 0);
        }
    }

    public void testSldNotSld() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReaderTest.class.getResource("WMSPostLayerGroupNonDefaultStyle.xml");
        kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        kvp.put("styles", "ThisStyleDoesNotExists");
        GetMapRequest request = this.reader.createRequest();
        try {
            this.reader.setLaxStyleMatchAllowed(false);
            request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
            GetMapKvpRequestReaderTest.fail((String)"The style looked up, 'ThisStyleDoesNotExists', should not have been found");
        }
        catch (ServiceException e) {
            GetMapKvpRequestReaderTest.assertTrue((String)"Exception should not reveal its cause", (e.getCause() == null ? 1 : 0) != 0);
        }
    }

    public void testSldFeatureTypeConstraints() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsFeatureTypeConstaint.sld");
        String decoded = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        kvp.put("sld", decoded);
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getSld());
        GetMapKvpRequestReaderTest.assertEquals((String)URLKvpParser.fixURL((String)decoded), (String)request.getSld().toExternalForm());
        Style style = (Style)request.getStyles().get(0);
        GetMapKvpRequestReaderTest.assertNotNull((Object)style);
        GetMapKvpRequestReaderTest.assertEquals((String)"TheLibraryModeStyle", (String)style.getName());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getLayers().size());
        MapLayerInfo layer = (MapLayerInfo)request.getLayers().get(0);
        GetMapKvpRequestReaderTest.assertEquals((String)this.getLayerId(MockData.BASIC_POLYGONS), (String)layer.getName());
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)layer.getLayerFeatureConstraints().length);
        GetMapKvpRequestReaderTest.assertEquals((Object)ff.equals((Expression)ff.property("ID"), (Expression)ff.literal((Object)"xyz")), (Object)layer.getLayerFeatureConstraints()[0].getFilter());
    }

    public void testSldLibraryFeatureTypeConstraints() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsFeatureTypeConstaint.sld");
        String decoded = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        kvp.put("sld", decoded);
        kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        kvp.put("styles", "TheLibraryModeStyle");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertNotNull((Object)request.getSld());
        GetMapKvpRequestReaderTest.assertEquals((String)URLKvpParser.fixURL((String)decoded), (String)request.getSld().toExternalForm());
        Style style = (Style)request.getStyles().get(0);
        GetMapKvpRequestReaderTest.assertNotNull((Object)style);
        GetMapKvpRequestReaderTest.assertEquals((String)"TheLibraryModeStyle", (String)style.getName());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getLayers().size());
        MapLayerInfo layer = (MapLayerInfo)request.getLayers().get(0);
        GetMapKvpRequestReaderTest.assertEquals((String)this.getLayerId(MockData.BASIC_POLYGONS), (String)layer.getName());
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)layer.getLayerFeatureConstraints().length);
        GetMapKvpRequestReaderTest.assertEquals((Object)ff.equals((Expression)ff.property("ID"), (Expression)ff.literal((Object)"xyz")), (Object)layer.getLayerFeatureConstraints()[0].getFilter());
    }

    public void testWmtVer() throws Exception {
        this.dispatcher.setCiteCompliant(true);
        String request = "wms?SERVICE=WMS&&WiDtH=200&FoRmAt=image/png&LaYeRs=cite:Lakes&StYlEs=&BbOx=0,-0.0020,0.0040,0&ReQuEsT=GetMap&HeIgHt=100&SrS=EPSG:4326&WmTvEr=1.1.1";
        GetMapKvpRequestReaderTest.assertEquals((String)"image/png", (String)this.getAsServletResponse(request).getContentType());
    }

    public void testRemoteWFS() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWFSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", "topp:states");
        raw.put("styles", MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("format", "image/png");
        raw.put("srs", "epsg:4326");
        raw.put("bbox", "-100,20,-60,50");
        raw.put("height", "300");
        raw.put("width", "300");
        raw.put("remote_ows_type", "WFS");
        raw.put("remote_ows_url", "http://demo.opengeo.org/geoserver/wfs?");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        GetMapKvpRequestReaderTest.assertEquals((String)"WFS", (String)request.getRemoteOwsType());
        GetMapKvpRequestReaderTest.assertEquals((Object)new URL("http://demo.opengeo.org/geoserver/wfs?"), (Object)request.getRemoteOwsURL());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getLayers().size());
        GetMapKvpRequestReaderTest.assertEquals((int)PublishedType.REMOTE.getCode(), (int)((MapLayerInfo)request.getLayers().get(0)).getType());
        GetMapKvpRequestReaderTest.assertEquals((String)"topp:states", (String)((MapLayerInfo)request.getLayers().get(0)).getName());
    }

    public void testRemoteWFSNoStyle() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWFSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", "topp:states");
        raw.put("format", "image/png");
        raw.put("srs", "epsg:4326");
        raw.put("bbox", "-100,20,-60,50");
        raw.put("height", "300");
        raw.put("width", "300");
        raw.put("remote_ows_type", "WFS");
        raw.put("remote_ows_url", "http://demo.opengeo.org/geoserver/wfs?");
        GetMapRequest request = this.reader.createRequest();
        try {
            request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
            GetMapKvpRequestReaderTest.fail((String)"This should have thrown an exception because of the missing style");
        }
        catch (ServiceException e) {
            GetMapKvpRequestReaderTest.assertEquals((String)"NoDefaultStyle", (String)e.getCode());
        }
    }

    public void testRemoteWFSInvalidURL() throws Exception {
        if (!RemoteOWSTestSupport.isRemoteWFSStatesAvailable((Logger)LOGGER)) {
            return;
        }
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", "topp:states");
        raw.put("format", "image/png");
        raw.put("srs", "epsg:4326");
        raw.put("bbox", "-100,20,-60,50");
        raw.put("height", "300");
        raw.put("width", "300");
        raw.put("remote_ows_type", "WFS");
        raw.put("remote_ows_url", "http://phantom.openplans.org:8080/crapserver/wfs?");
        GetMapRequest request = this.reader.createRequest();
        try {
            request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
            GetMapKvpRequestReaderTest.fail((String)"This should have thrown an exception because of the non existent layer");
        }
        catch (ServiceException e) {
            e.printStackTrace();
            GetMapKvpRequestReaderTest.assertEquals((String)"RemoteOWSFailure", (String)e.getCode());
        }
    }

    public void testGroupInSLD() throws Exception {
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.put("srs", "epsg:4326");
        kvp.put("bbox", "124.38035938267053,-58.45445933799711,169.29632161732948,-24.767487662002893");
        kvp.put("width", "640");
        kvp.put("height", "480");
        kvp.put("format", "image/png");
        URL url = GetMapKvpRequestReader.class.getResource("BaseMapGroup.sld");
        kvp.put("sld", URLDecoder.decode(url.toString(), "UTF-8"));
        kvp.put("version", "1.1.1");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(kvp), kvp);
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getLayers().size());
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)request.getStyles().size());
        GetMapKvpRequestReaderTest.assertEquals((String)this.getLayerId(MockData.BASIC_POLYGONS), (String)((MapLayerInfo)request.getLayers().get(0)).getName());
        Style expectedStyle = this.getCatalog().getStyleByName("polygon").getStyle();
        GetMapKvpRequestReaderTest.assertEquals((Object)expectedStyle, request.getStyles().get(0));
    }

    public void testViewParams() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("styles", "");
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("request", "GetMap");
        raw.put("service", "wms");
        raw.put("viewParams", "where:WHERE PERSONS > 1000000;str:ABCD");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        List viewParamsList = request.getViewParams();
        GetMapKvpRequestReaderTest.assertEquals((int)1, (int)viewParamsList.size());
        Map viewParams = (Map)viewParamsList.get(0);
        GetMapKvpRequestReaderTest.assertEquals((Object)"WHERE PERSONS > 1000000", viewParams.get("where"));
        GetMapKvpRequestReaderTest.assertEquals((Object)"ABCD", viewParams.get("str"));
    }

    public void testMultipleViewParams() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("styles", "");
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("request", "GetMap");
        raw.put("service", "wms");
        raw.put("viewParams", "where:WHERE PERSONS > 1000000;str:ABCD,where:WHERE PERSONS > 10;str:FOO");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        List viewParamsList = request.getViewParams();
        GetMapKvpRequestReaderTest.assertEquals((int)2, (int)viewParamsList.size());
        Map viewParams = (Map)viewParamsList.get(0);
        GetMapKvpRequestReaderTest.assertEquals((Object)"WHERE PERSONS > 1000000", viewParams.get("where"));
        GetMapKvpRequestReaderTest.assertEquals((Object)"ABCD", viewParams.get("str"));
        viewParams = (Map)viewParamsList.get(1);
        GetMapKvpRequestReaderTest.assertEquals((Object)"WHERE PERSONS > 10", viewParams.get("where"));
        GetMapKvpRequestReaderTest.assertEquals((Object)"FOO", viewParams.get("str"));
    }

    public void testFanOutViewParams() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", this.getLayerId(MockData.BASIC_POLYGONS) + "," + this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("styles", "");
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("request", "GetMap");
        raw.put("service", "wms");
        raw.put("viewParams", "where:WHERE PERSONS > 1000000;str:ABCD");
        GetMapRequest request = this.reader.createRequest();
        request = this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        List viewParamsList = request.getViewParams();
        GetMapKvpRequestReaderTest.assertEquals((int)2, (int)viewParamsList.size());
        Map viewParams = (Map)viewParamsList.get(0);
        GetMapKvpRequestReaderTest.assertEquals((Object)"WHERE PERSONS > 1000000", viewParams.get("where"));
        GetMapKvpRequestReaderTest.assertEquals((Object)"ABCD", viewParams.get("str"));
        viewParams = (Map)viewParamsList.get(1);
        GetMapKvpRequestReaderTest.assertEquals((Object)"WHERE PERSONS > 1000000", viewParams.get("where"));
        GetMapKvpRequestReaderTest.assertEquals((Object)"ABCD", viewParams.get("str"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingLayersAndStylesParametersWithSld() throws Exception {
        URL url = GetMapKvpRequestReader.class.getResource("BasicPolygonsLibraryNoDefault.sld");
        String decoded = URLDecoder.decode(url.toExternalForm(), "UTF-8");
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("sld", decoded);
        raw.put("format", "image/jpeg");
        raw.put("crs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("transparent", "true");
        raw.put("request", "GetMap");
        raw.put("version", "1.3.0");
        GeoServer geoServer = this.getGeoServer();
        WMSInfo service = (WMSInfo)geoServer.getService(WMSInfo.class);
        service.setCiteCompliant(true);
        geoServer.save((ServiceInfo)service);
        try {
            GetMapRequest request = this.reader.createRequest();
            this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        }
        finally {
            service.setCiteCompliant(false);
            geoServer.save((ServiceInfo)service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMissingCrsParameterInGetMapRequest11() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("styles", MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("format", "image/jpeg");
        raw.put("srs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("transparent", "true");
        raw.put("request", "GetMap");
        raw.put("version", "1.1.0");
        GeoServer geoServer = this.getGeoServer();
        WMSInfo service = (WMSInfo)geoServer.getService(WMSInfo.class);
        service.setCiteCompliant(true);
        geoServer.save((ServiceInfo)service);
        try {
            GetMapRequest request = this.reader.createRequest();
            this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
        }
        finally {
            service.setCiteCompliant(false);
            geoServer.save((ServiceInfo)service);
        }
    }

    private void validateMissingParameterInGetMapRequest13(String paramToRemove) throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("styles", MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("format", "image/jpeg");
        raw.put("crs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("transparent", "true");
        raw.put("request", "GetMap");
        raw.put("version", "1.3.0");
        raw.remove(paramToRemove);
        GeoServer geoServer = this.getGeoServer();
        WMSInfo service = (WMSInfo)geoServer.getService(WMSInfo.class);
        service.setCiteCompliant(true);
        geoServer.save((ServiceInfo)service);
        try {
            GetMapRequest request = this.reader.createRequest();
            this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
            throw new Exception("Shouldn't get here");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"Shouldn't get here")));
            service.setCiteCompliant(false);
            geoServer.save((ServiceInfo)service);
            return;
        }
    }

    public void testMissingStylesParameterInGetMapRequest13() throws Exception {
        this.validateMissingParameterInGetMapRequest13("styles");
    }

    public void testMissingCrsParameterInGetMapRequest13() throws Exception {
        this.validateMissingParameterInGetMapRequest13("crs");
    }

    public void testTransparencyValueInInspireGetMapRequest() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("styles", MockData.BASIC_POLYGONS.getLocalPart());
        raw.put("format", "image/jpeg");
        raw.put("crs", "epsg:3003");
        raw.put("bbox", "-10,-10,10,10");
        raw.put("height", "600");
        raw.put("width", "800");
        raw.put("transparent", "ZZZZZZ");
        raw.put("request", "GetMap");
        GeoServer geoServer = this.getGeoServer();
        WMSInfo service = (WMSInfo)geoServer.getService(WMSInfo.class);
        service.setCiteCompliant(true);
        geoServer.save((ServiceInfo)service);
        try {
            GetMapRequest request = this.reader.createRequest();
            this.reader.read((Object)request, this.parseKvp(raw), this.caseInsensitiveKvp(raw));
            throw new Exception("Shouldn't get here");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"Shouldn't get here")));
            service.setCiteCompliant(false);
            geoServer.save((ServiceInfo)service);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSldTooLongLookup() throws Exception {
        HttpServer server = this.createServer();
        GeoServer geoServer = this.getGeoServer();
        WMSInfo wmsInfo = (WMSInfo)geoServer.getService(WMSInfo.class);
        wmsInfo.setRemoteStyleMaxRequestTime(1000);
        geoServer.save((ServiceInfo)wmsInfo);
        try {
            WMS wms = new WMS(this.getGeoServer());
            this.reader = new GetMapKvpRequestReader(wms);
            server.start();
            int port = server.getAddress().getPort();
            HashMap<String, String> kvp = new HashMap<String, String>();
            URL url = new URL("http://localhost:" + port + "/sld/style.sld");
            kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
            kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
            kvp.put("styles", "ThisStyleDoesNotExists");
            GetMapRequest request = this.reader.createRequest();
            Instant startInstant = Instant.now();
            try {
                this.reader.setLaxStyleMatchAllowed(false);
                request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
                GetMapKvpRequestReaderTest.fail((String)"The style looked up, 'ThisStyleDoesNotExists', should not have been found");
            }
            catch (ServiceException e) {
                LOG.log(Level.INFO, e.getMessage(), e);
            }
            long millis = Instant.now().toEpochMilli() - startInstant.toEpochMilli();
            GetMapKvpRequestReaderTest.assertTrue((String)"Max timeout should be 2 seconds", (millis < 2000L ? 1 : 0) != 0);
        }
        finally {
            server.stop(0);
            wmsInfo = (WMSInfo)geoServer.getService(WMSInfo.class);
            wmsInfo.setRemoteStyleMaxRequestTime(60000);
            geoServer.save((ServiceInfo)wmsInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSldTimeoutLookup() throws Exception {
        HttpServer server = this.createServer();
        GeoServer geoServer = this.getGeoServer();
        WMSInfo wmsInfo = (WMSInfo)geoServer.getService(WMSInfo.class);
        wmsInfo.setRemoteStyleTimeout(1000);
        geoServer.save((ServiceInfo)wmsInfo);
        try {
            WMS wms = new WMS(this.getGeoServer());
            this.reader = new GetMapKvpRequestReader(wms);
            server.start();
            int port = server.getAddress().getPort();
            HashMap<String, String> kvp = new HashMap<String, String>();
            URL url = new URL("http://localhost:" + port + "/sld/style.sld");
            kvp.put("sld", URLDecoder.decode(url.toExternalForm(), "UTF-8"));
            kvp.put("layers", MockData.BASIC_POLYGONS.getPrefix() + ":" + MockData.BASIC_POLYGONS.getLocalPart());
            kvp.put("styles", "ThisStyleDoesNotExists");
            GetMapRequest request = this.reader.createRequest();
            Instant startInstant = Instant.now();
            try {
                this.reader.setLaxStyleMatchAllowed(false);
                request = this.reader.read((Object)request, this.parseKvp(kvp), this.caseInsensitiveKvp(kvp));
                GetMapKvpRequestReaderTest.fail((String)"The style looked up, 'ThisStyleDoesNotExists', should not have been found");
            }
            catch (ServiceException e) {
                LOG.log(Level.INFO, e.getMessage(), e);
            }
            long millis = Instant.now().toEpochMilli() - startInstant.toEpochMilli();
            GetMapKvpRequestReaderTest.assertTrue((String)"Max timeout should be 2 seconds", (millis < 2000L ? 1 : 0) != 0);
        }
        finally {
            server.stop(0);
            wmsInfo = (WMSInfo)geoServer.getService(WMSInfo.class);
            wmsInfo.setRemoteStyleTimeout(30000);
            geoServer.save((ServiceInfo)wmsInfo);
        }
    }

    private HttpServer createServer() throws IOException {
        HttpServer server = HttpServer.create(new InetSocketAddress("localhost", 0), 0);
        LOG.log(Level.INFO, "Creating a mock http server at port: {0}", server.getAddress().getPort());
        server.createContext("/sld", this.createLongResponseHandler());
        ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(2);
        server.setExecutor(threadPoolExecutor);
        return server;
    }

    private HttpHandler createLongResponseHandler() {
        HttpHandler handler = new HttpHandler(){

            @Override
            public void handle(HttpExchange t) throws IOException {
                try {
                    t.sendResponseHeaders(200, 5000000000L);
                    TimeUnit.SECONDS.sleep(4L);
                    OutputStream outputStream = t.getResponseBody();
                    outputStream.write("This is a bad style".getBytes());
                    outputStream.flush();
                    outputStream.close();
                }
                catch (InterruptedException e) {
                    LOG.log(Level.INFO, e.getMessage(), e);
                }
            }
        };
        return handler;
    }
}

