/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.TestHttpClientRule;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CoverageInfoImpl;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.test.http.MockHttpClient;
import org.geoserver.test.http.MockHttpResponse;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.map.OpenLayers3MapOutputFormat;
import org.geoserver.wms.map.OpenLayersMapOutputFormat;
import org.geoserver.wms.map.RawMap;
import org.geotools.data.FeatureSource;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class OpenLayersMapOutputFormatTest
extends WMSTestSupport {
    Pattern lookForEscapedParam = Pattern.compile(Pattern.quote("\"</script><script>alert('x-scripted');</script><script>\": 'foo'"));
    @Rule
    public TestHttpClientRule clientMocker = new TestHttpClientRule();

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        WorkspaceInfo workspaceInfo = this.getCatalog().getWorkspaceByName(MockData.DEFAULT_PREFIX);
        StoreInfo store = this.createStaticRasterStore(workspaceInfo);
        NamespaceInfo nameSpace = this.getCatalog().getNamespaceByPrefix(MockData.DEFAULT_PREFIX);
        this.createStaticRasterLayer(nameSpace, store, "staticRaster");
    }

    @Test
    public void testXssFix() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureSource fs = catalog.getFeatureTypeByName(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = fs.getBounds();
        LOGGER.info("about to create map ctx for BasicPolygons with bounds " + env);
        GetMapRequest request = this.createGetMapRequest(MockData.BASIC_POLYGONS);
        request.getRawKvp().put("</script><script>alert('x-scripted');</script><script>", "foo");
        request.getRawKvp().put("25064;ALERT(1)//419", "1");
        WMSMapContent map = new WMSMapContent();
        map.getViewport().setBounds(new ReferencedEnvelope((Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.setRequest(request);
        StyleInfo styleByName = catalog.getStyleByName("Default");
        Style basicStyle = styleByName.getStyle();
        FeatureLayer layer = new FeatureLayer(fs, basicStyle);
        layer.setTitle("Title");
        map.addLayer((Layer)layer);
        request.setFormat("application/openlayers");
        String htmlDoc = this.getAsHTML(map);
        int index = htmlDoc.replace("\\n", "").replace("\\r", "").indexOf("\"</script\\><script\\>alert(\\'x-scripted\\');</script\\><script\\>\": 'foo'");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = htmlDoc.replace("\\n", "").replace("\\r", "").indexOf("\"25064;ALERT(1)//419\": '1'");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testRastersFilteringCapabilities() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?service=WMS&version=1.1.0&request=GetMap&layers=gs:staticRaster&styles=&bbox=0.2372206885127698,40.562080748421806,14.592757149389236,44.55808294568743&width=768&height=330&srs=EPSG:4326&format=application/openlayers");
        String content = response.getContentAsString();
        Assert.assertThat((Object)content.contains("var supportsFiltering = true;"), (Matcher)CoreMatchers.is((Object)true));
        response = this.getAsServletResponse("wms?service=WMS&version=1.1.0&request=GetMap&layers=wcs:World&styles=&bbox=0.2372206885127698,40.562080748421806,14.592757149389236,44.55808294568743&width=768&height=330&srs=EPSG:4326&format=application/openlayers");
        content = response.getContentAsString();
        Assert.assertThat((Object)content.contains("var supportsFiltering = false;"), (Matcher)CoreMatchers.is((Object)true));
        response = this.getAsServletResponse("wms?service=WMS&version=1.1.0&request=GetMap&layers=wcs:World,gs:staticRaster&styles=&bbox=0.2372206885127698,40.562080748421806,14.592757149389236,44.55808294568743&width=768&height=330&srs=EPSG:4326&format=application/openlayers");
        content = response.getContentAsString();
        Assert.assertThat((Object)content.contains("var supportsFiltering = true;"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void testWMTSFilteringCapabilities() throws Exception {
        this.createWMTSCatalogStuff();
        MockHttpServletResponse response = this.getAsServletResponse("wms?service=WMS&version=1.1.0&request=GetMap&layers=gs:wmtslayername&styles=&bbox=0.2372206885127698,40.562080748421806,14.592757149389236,44.55808294568743&width=768&height=330&srs=EPSG:4326&format=application/openlayers");
        String content = response.getContentAsString();
        Assert.assertThat((Object)content.contains("var supportsFiltering = false;"), (Matcher)CoreMatchers.is((Object)true));
        response = this.getAsServletResponse("wms?service=WMS&version=1.1.0&request=GetMap&layers=gs:wmtslayername,gs:staticRaster&styles=&bbox=0.2372206885127698,40.562080748421806,14.592757149389236,44.55808294568743&width=768&height=330&srs=EPSG:4326&format=application/openlayers");
        content = response.getContentAsString();
        Assert.assertThat((Object)content.contains("var supportsFiltering = true;"), (Matcher)CoreMatchers.is((Object)true));
    }

    private StoreInfo createStaticRasterStore(WorkspaceInfo workspace) {
        Catalog catalog = this.getCatalog();
        CoverageStoreInfo store = catalog.getFactory().createCoverageStore();
        store.setWorkspace(workspace);
        store.setType("StaticRaster");
        store.setEnabled(true);
        store.setName("StaticRaster");
        store.setURL("http://127.0.0.1:geoserver");
        catalog.add((StoreInfo)store);
        return store;
    }

    private StoreInfo createWMTSCatalogStuff() throws MalformedURLException, IOException {
        String capabilities = this.clientMocker.getServer() + "/geoserver/gwc?REQUEST=GetCapabilities&VERSION=1.0.0&SERVICE=WMTS";
        MockHttpClient client = new MockHttpClient();
        client.expectGet(new URL(capabilities), (HTTPResponse)new MockHttpResponse(((Object)((Object)this)).getClass().getResource("/nasa.getcapa.xml"), "text/xml", new String[0]));
        this.clientMocker.bind((HTTPClient)client, capabilities);
        Catalog catalog = this.getCatalog();
        WorkspaceInfo workspace = this.getCatalog().getWorkspaceByName(MockData.DEFAULT_PREFIX);
        NamespaceInfo nameSpace = this.getCatalog().getNamespaceByPrefix(MockData.DEFAULT_PREFIX);
        WMTSStoreInfo store = catalog.getFactory().createWebMapTileServer();
        store.setWorkspace(workspace);
        store.setType("WMTS");
        store.setEnabled(true);
        store.setName("wmts");
        store.setCapabilitiesURL(capabilities);
        catalog.add((StoreInfo)store);
        WMTSLayerInfo resource = catalog.getFactory().createWMTSLayer();
        resource.setNamespace(nameSpace);
        resource.setName("wmtslayername");
        resource.setNativeName("AMSR2_Snow_Water_Equivalent");
        resource.setEnabled(true);
        resource.setStore((StoreInfo)store);
        catalog.add((ResourceInfo)resource);
        LayerInfoImpl layer = new LayerInfoImpl();
        layer.setResource((ResourceInfo)resource);
        layer.setEnabled(true);
        layer.setName("wmtslayername");
        catalog.add((LayerInfo)layer);
        return store;
    }

    private void createStaticRasterLayer(NamespaceInfo namespace, StoreInfo store, String layerName) {
        Catalog catalog = this.getCatalog();
        CoverageInfoImpl coverageInfo = new CoverageInfoImpl(catalog);
        coverageInfo.setNamespace(namespace);
        coverageInfo.setName(layerName);
        coverageInfo.setNativeCoverageName(layerName);
        coverageInfo.setStore(store);
        LayerInfoImpl layer = new LayerInfoImpl();
        layer.setResource((ResourceInfo)coverageInfo);
        layer.setEnabled(true);
        layer.setName(layerName);
        layer.setDefaultStyle(catalog.getStyleByName("raster"));
        coverageInfo.setNativeCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        coverageInfo.setSRS("EPSG:4326");
        catalog.add((ResourceInfo)coverageInfo);
        catalog.add((LayerInfo)layer);
    }

    @Test
    public void testUrnCodeFix() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureSource fs = catalog.getFeatureTypeByName(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = fs.getBounds();
        LOGGER.info("about to create map ctx for BasicPolygons with bounds " + env);
        GetMapRequest request = this.createGetMapRequest(MockData.BASIC_POLYGONS);
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
        request.setCrs(crs);
        WMSMapContent map = new WMSMapContent();
        map.setRequest(request);
        request.setFormat("application/openlayers");
        String htmlDoc = this.getAsHTML(map);
        int index = htmlDoc.indexOf("yx : {'EPSG:4326' : true}");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testOL3vsOL2() throws Exception {
        String path = "wms?service=WMS&version=1.1.0&request=GetMap&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=&bbox=-180,-90,180,90&width=768&height=330&srs=EPSG:4326&format=";
        String firefoxAgent = "Firefox 40.1";
        String ie8Agent = "MSIE 8.";
        String contentFirefox = this.getResponseContent(path + "application/openlayers", "Firefox 40.1", "text/html; subtype=openlayers3");
        Assert.assertThat((Object)contentFirefox, (Matcher)CoreMatchers.containsString((String)"openlayers3/ol.js"));
        String contentIE8 = this.getResponseContent(path + "application/openlayers", ie8Agent, "text/html; subtype=openlayers2");
        Assert.assertThat((Object)contentIE8, (Matcher)CoreMatchers.containsString((String)"OpenLayers.js"));
        String contentOL2 = this.getResponseContent(path + "application/openlayers2", "Firefox 40.1", "text/html; subtype=openlayers2");
        Assert.assertThat((Object)contentOL2, (Matcher)CoreMatchers.containsString((String)"OpenLayers.js"));
        String contentOL3 = this.getResponseContent(path + "application/openlayers3", "Firefox 40.1", "text/html; subtype=openlayers3");
        Assert.assertThat((Object)contentOL3, (Matcher)CoreMatchers.containsString((String)"openlayers3/ol.js"));
        String exception = this.getResponseContent(path + "application/openlayers3", ie8Agent, "application/vnd.ogc.se_xml");
        Assert.assertThat((Object)exception, (Matcher)CoreMatchers.containsString((String)"not supported"));
    }

    public String getResponseContent(String path, String userAgent, String expectedMimeType) throws Exception {
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("GET");
        request.setContent(new byte[0]);
        if (userAgent != null) {
            request.addHeader("USER-AGENT", (Object)userAgent);
        }
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request);
        Assert.assertEquals((Object)expectedMimeType, (Object)response.getContentType());
        return response.getContentAsString();
    }

    String getAsHTML(WMSMapContent map) throws IOException {
        OpenLayersMapOutputFormat mapProducer = (OpenLayersMapOutputFormat)GeoServerExtensions.extensions(OpenLayersMapOutputFormat.class).get(0);
        RawMap rawMap = mapProducer.produceMap(map);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        rawMap.writeTo((OutputStream)bos);
        return new String(bos.toByteArray(), "UTF-8");
    }

    String getAsHTMLOL3(WMSMapContent map) throws IOException {
        OpenLayers3MapOutputFormat mapProducer = (OpenLayers3MapOutputFormat)GeoServerExtensions.extensions(OpenLayers3MapOutputFormat.class).get(0);
        RawMap rawMap = mapProducer.produceMap(map);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        rawMap.writeTo((OutputStream)bos);
        return new String(bos.toByteArray(), "UTF-8");
    }

    @Test
    public void testExceptionsInImage() throws Exception {
        String path = "wms?service=WMS&version=1.1.0&request=GetMap&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=&bbox=-180,-90,180,90&width=768&height=330&srs=EPSG:4326&format=application/openlayers";
        String html = this.getAsString(path);
        Assert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"\"exceptions\": 'application/vnd.ogc.se_inimage'"));
    }

    @Test
    public void testExceptionsXML() throws Exception {
        String path = "wms?service=WMS&version=1.1.0&request=GetMap&layers=" + this.getLayerId(MockData.BASIC_POLYGONS) + "&styles=&bbox=-180,-90,180,90&width=768&height=330&srs=EPSG:4326&format=application/openlayers&exceptions=application/vnd.ogc.se_xml";
        String html = this.getAsString(path);
        Assert.assertThat((Object)html, (Matcher)CoreMatchers.containsString((String)"\"EXCEPTIONS\": 'application/vnd.ogc.se_xml'"));
        Assert.assertThat((Object)html, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"\"exceptions\": 'application/vnd.ogc.se_inimage'")));
    }

    @Test
    public void testXssOL3() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureSource fs = catalog.getFeatureTypeByName(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = fs.getBounds();
        LOGGER.info("about to create map ctx for BasicPolygons with bounds " + env);
        GetMapRequest request = this.createGetMapRequest(MockData.BASIC_POLYGONS);
        request.putHttpRequestHeader("USER-AGENT", "Firefox 40.1");
        request.getRawKvp().put("</script><script>alert('x-scripted');</script><script>", "foo");
        request.getRawKvp().put("25064;ALERT(1)//419", "1");
        WMSMapContent map = new WMSMapContent();
        map.getViewport().setBounds(new ReferencedEnvelope((Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.setRequest(request);
        StyleInfo styleByName = catalog.getStyleByName("Default");
        Style basicStyle = styleByName.getStyle();
        FeatureLayer layer = new FeatureLayer(fs, basicStyle);
        layer.setTitle("Title");
        map.addLayer((Layer)layer);
        request.setFormat("application/openlayers3");
        String htmlDoc = this.getAsHTMLOL3(map);
        int index = htmlDoc.replace("\\n", "").replace("\\r", "").indexOf("\"</script\\><script\\>alert(\\'x-scripted\\');</script\\><script\\>\": 'foo'");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
        index = htmlDoc.replace("\\n", "").replace("\\r", "").indexOf("\"25064;ALERT(1)//419\": '1'");
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
    }
}

