/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.ServiceException;
import org.geoserver.security.decorators.DecoratingFeatureSource;
import org.geoserver.wms.CachedGridReaderLayer;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSPartialMapException;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.map.DelayedFeatureCollection;
import org.geoserver.wms.map.IdentityCoverageFunction;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geoserver.wms.map.RenderedImageTimeDecorator;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.filter.IllegalFilterException;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.image.util.ImageUtilities;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.styling.ChannelSelectionImpl;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.util.NumberRange;
import org.geotools.util.URLs;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.logging.Logging;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.LineString;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.style.ChannelSelection;
import org.springframework.mock.web.MockHttpServletResponse;

public class RenderedImageMapOutputFormatTest
extends WMSTestSupport {
    public static QName TAZ_BYTE = new QName(MockData.WCS_URI, "tazbyte", MockData.WCS_PREFIX);
    public static QName SIX_BANDS = new QName(MockData.WCS_URI, "sixbands", MockData.WCS_PREFIX);
    static final QName STRAIGHT_VERTICAL_LINE = new QName(MockData.CITE_URI, "STRAIGHT_VERTICAL_LINE", MockData.CITE_PREFIX);
    static final String STRAIGHT_VERTICAL_LINE_STYLE = "verticalline";
    static final QName NORMALIZED = new QName(MockData.CITE_URI, "NORMALIZED", MockData.CITE_PREFIX);
    static final String NORMALIZED_STYLE = "normalized";
    static final QName CROSS_DATELINE = new QName(MockData.CITE_URI, "CROSS_DATELINE", MockData.CITE_PREFIX);
    static final String CROSS_DATELINE_STYLE = "crossline";
    static final QName TIFF_3035 = new QName(MockData.SF_URI, "3035", MockData.SF_PREFIX);
    private static final Logger LOGGER = Logging.getLogger((String)RenderedImageMapOutputFormatTest.class.getPackage().getName());
    private RenderedImageMapOutputFormat rasterMapProducer;
    private String mapFormat = "image/gif";
    private static final ThreadLocal<Boolean> usedCustomLabelCache = new ThreadLocal();

    @Before
    public void setRasterMapProducer() throws Exception {
        Logging.getLogger((String)"org.geotools.rendering").setLevel(Level.OFF);
        this.rasterMapProducer = this.getProducerInstance();
        ((SystemTestData)this.getTestData()).addDefaultRasterLayer(SystemTestData.MULTIBAND, this.getCatalog());
    }

    protected RenderedImageMapOutputFormat getProducerInstance() {
        return new DummyRasterMapProducer(this.getWMS());
    }

    @After
    public void unsetRasterMapProducer() throws Exception {
        this.rasterMapProducer = null;
    }

    public String getMapFormat() {
        return this.mapFormat;
    }

    @Test
    public void testSimpleGetMapQuery() throws Exception {
        Catalog catalog = this.getCatalog();
        FeatureSource fs = catalog.getFeatureTypeByName(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = fs.getBounds();
        LOGGER.info("about to create map ctx for BasicPolygons with bounds " + env);
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        map.getViewport().setBounds(new ReferencedEnvelope((org.locationtech.jts.geom.Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.setRequest(request);
        StyleInfo styleByName = catalog.getStyleByName("Default");
        Style basicStyle = styleByName.getStyle();
        map.addLayer((Layer)new FeatureLayer(fs, basicStyle));
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        this.assertNotBlank("testSimpleGetMapQuery", image);
    }

    @Test
    public void testAdvancedProjectionDensification() throws Exception {
        WMS wms = this.getWMS();
        WMSInfo info = wms.getServiceInfo();
        info.getMetadata().put(WMS.ADVANCED_PROJECTION_DENSIFICATION_KEY, (Serializable)Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)info);
        Graphics2D graphics = (Graphics2D)Mockito.mock(Graphics2D.class);
        this.rasterMapProducer = new DummyRasterMapProducer(wms);
        ((DummyRasterMapProducer)this.rasterMapProducer).setGraphics(graphics);
        Catalog catalog = this.getCatalog();
        FeatureSource fs = catalog.getFeatureTypeByName(STRAIGHT_VERTICAL_LINE.getPrefix(), STRAIGHT_VERTICAL_LINE.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = new ReferencedEnvelope(10.0, 15.0, 0.0, 50.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        CoordinateReferenceSystem utm32 = CRS.decode((String)"EPSG:32632");
        ReferencedEnvelope targetEnv = env.transform(utm32, true);
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        map.getViewport().setBounds(targetEnv);
        map.getViewport().setCoordinateReferenceSystem(utm32);
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.setRequest(request);
        StyleInfo styleByName = catalog.getStyleByName(STRAIGHT_VERTICAL_LINE_STYLE);
        Style basicStyle = styleByName.getStyle();
        map.addLayer((Layer)new FeatureLayer(fs, basicStyle));
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        this.assertNotBlank("densify", image);
        ArgumentCaptor shape = ArgumentCaptor.forClass(Shape.class);
        ((Graphics2D)Mockito.verify((Object)graphics)).draw((Shape)shape.capture());
        LiteShape2 drawnShape = (LiteShape2)shape.getValue();
        Assert.assertEquals((long)64L, (long)drawnShape.getGeometry().getCoordinates().length);
    }

    @Test
    public void testAdvancedProjectionDensificationWithFormatOption() throws Exception {
        Graphics2D graphics = (Graphics2D)Mockito.mock(Graphics2D.class);
        this.rasterMapProducer = new DummyRasterMapProducer(this.getWMS());
        ((DummyRasterMapProducer)this.rasterMapProducer).setGraphics(graphics);
        Catalog catalog = this.getCatalog();
        FeatureSource fs = catalog.getFeatureTypeByName(STRAIGHT_VERTICAL_LINE.getPrefix(), STRAIGHT_VERTICAL_LINE.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = new ReferencedEnvelope(10.0, 15.0, 0.0, 50.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        CoordinateReferenceSystem utm32 = CRS.decode((String)"EPSG:32632");
        ReferencedEnvelope targetEnv = env.transform(utm32, true);
        GetMapRequest request = new GetMapRequest();
        request.getFormatOptions().put("advancedProjectionHandlingDensification", "true");
        WMSMapContent map = new WMSMapContent();
        map.getViewport().setBounds(targetEnv);
        map.getViewport().setCoordinateReferenceSystem(utm32);
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.setRequest(request);
        StyleInfo styleByName = catalog.getStyleByName(STRAIGHT_VERTICAL_LINE_STYLE);
        Style basicStyle = styleByName.getStyle();
        map.addLayer((Layer)new FeatureLayer(fs, basicStyle));
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        this.assertNotBlank("densify", image);
        ArgumentCaptor shape = ArgumentCaptor.forClass(Shape.class);
        ((Graphics2D)Mockito.verify((Object)graphics)).draw((Shape)shape.capture());
        LiteShape2 drawnShape = (LiteShape2)shape.getValue();
        Assert.assertEquals((long)64L, (long)drawnShape.getGeometry().getCoordinates().length);
    }

    @Test
    public void testWrappingHeuristic() throws Exception {
        WMS wms = this.getWMS();
        WMSInfo info = wms.getServiceInfo();
        info.getMetadata().put(WMS.DATELINE_WRAPPING_HEURISTIC_KEY, (Serializable)Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)info);
        Graphics2D graphics = (Graphics2D)Mockito.mock(Graphics2D.class);
        this.rasterMapProducer = new DummyRasterMapProducer(wms);
        ((DummyRasterMapProducer)this.rasterMapProducer).setGraphics(graphics);
        Catalog catalog = this.getCatalog();
        FeatureSource fs = catalog.getFeatureTypeByName(CROSS_DATELINE.getPrefix(), CROSS_DATELINE.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = new ReferencedEnvelope(-150.0, 150.0, -30.0, 30.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        map.getViewport().setBounds(env);
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.setRequest(request);
        StyleInfo styleByName = catalog.getStyleByName(STRAIGHT_VERTICAL_LINE_STYLE);
        Style basicStyle = styleByName.getStyle();
        map.addLayer((Layer)new FeatureLayer(fs, basicStyle));
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        this.assertNotBlank("dateline_heuristic", image);
        ArgumentCaptor shape = ArgumentCaptor.forClass(Shape.class);
        ((Graphics2D)Mockito.verify((Object)graphics)).draw((Shape)shape.capture());
        LiteShape2 drawnShape = (LiteShape2)shape.getValue();
        Assert.assertTrue((boolean)(drawnShape.getGeometry() instanceof LineString));
    }

    @Test
    public void testDisabledWrappingHeuristic() throws Exception {
        WMS wms = this.getWMS();
        WMSInfo info = wms.getServiceInfo();
        info.getMetadata().put(WMS.DATELINE_WRAPPING_HEURISTIC_KEY, (Serializable)Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)info);
        Graphics2D graphics = (Graphics2D)Mockito.mock(Graphics2D.class);
        this.rasterMapProducer = new DummyRasterMapProducer(wms);
        ((DummyRasterMapProducer)this.rasterMapProducer).setGraphics(graphics);
        Catalog catalog = this.getCatalog();
        FeatureSource fs = catalog.getFeatureTypeByName(CROSS_DATELINE.getPrefix(), CROSS_DATELINE.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = new ReferencedEnvelope(-150.0, 150.0, -30.0, 30.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        map.getViewport().setBounds(env);
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.setRequest(request);
        StyleInfo styleByName = catalog.getStyleByName(STRAIGHT_VERTICAL_LINE_STYLE);
        Style basicStyle = styleByName.getStyle();
        map.addLayer((Layer)new FeatureLayer(fs, basicStyle));
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        this.assertNotBlank("dateline_heuristic", image);
        ArgumentCaptor shape = ArgumentCaptor.forClass(Shape.class);
        ((Graphics2D)Mockito.verify((Object)graphics)).draw((Shape)shape.capture());
        LiteShape2 drawnShape = (LiteShape2)shape.getValue();
        Assert.assertTrue((boolean)(drawnShape.getGeometry() instanceof LineString));
    }

    @Test
    public void testDisabledWrappingHeuristicWithFormatOption() throws Exception {
        Graphics2D graphics = (Graphics2D)Mockito.mock(Graphics2D.class);
        this.rasterMapProducer = new DummyRasterMapProducer(this.getWMS());
        ((DummyRasterMapProducer)this.rasterMapProducer).setGraphics(graphics);
        Catalog catalog = this.getCatalog();
        FeatureSource fs = catalog.getFeatureTypeByName(CROSS_DATELINE.getPrefix(), CROSS_DATELINE.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = new ReferencedEnvelope(-150.0, 150.0, -30.0, 30.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GetMapRequest request = new GetMapRequest();
        request.getFormatOptions().put("disableDatelineWrappingHeuristic", "true");
        WMSMapContent map = new WMSMapContent();
        map.getViewport().setBounds(env);
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.setRequest(request);
        StyleInfo styleByName = catalog.getStyleByName(STRAIGHT_VERTICAL_LINE_STYLE);
        Style basicStyle = styleByName.getStyle();
        map.addLayer((Layer)new FeatureLayer(fs, basicStyle));
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        this.assertNotBlank("dateline_heuristic", image);
        ArgumentCaptor shape = ArgumentCaptor.forClass(Shape.class);
        ((Graphics2D)Mockito.verify((Object)graphics)).draw((Shape)shape.capture());
        LiteShape2 drawnShape = (LiteShape2)shape.getValue();
        Assert.assertTrue((boolean)(drawnShape.getGeometry() instanceof LineString));
    }

    @Test
    public void testAdvancedProjectionWithoutDensification() throws Exception {
        WMS wms = this.getWMS();
        WMSInfo info = wms.getServiceInfo();
        info.getMetadata().put(WMS.ADVANCED_PROJECTION_DENSIFICATION_KEY, (Serializable)Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)info);
        Graphics2D graphics = (Graphics2D)Mockito.mock(Graphics2D.class);
        this.rasterMapProducer = new DummyRasterMapProducer(wms);
        ((DummyRasterMapProducer)this.rasterMapProducer).setGraphics(graphics);
        Catalog catalog = this.getCatalog();
        FeatureSource fs = catalog.getFeatureTypeByName(STRAIGHT_VERTICAL_LINE.getPrefix(), STRAIGHT_VERTICAL_LINE.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = new ReferencedEnvelope(10.0, 15.0, 0.0, 50.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        CoordinateReferenceSystem utm32 = CRS.decode((String)"EPSG:32632");
        ReferencedEnvelope targetEnv = env.transform(utm32, true);
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        map.getViewport().setBounds(targetEnv);
        map.getViewport().setCoordinateReferenceSystem(utm32);
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.setRequest(request);
        StyleInfo styleByName = catalog.getStyleByName(STRAIGHT_VERTICAL_LINE_STYLE);
        Style basicStyle = styleByName.getStyle();
        map.addLayer((Layer)new FeatureLayer(fs, basicStyle));
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        this.assertNotBlank("densify", image);
        ArgumentCaptor shape = ArgumentCaptor.forClass(Shape.class);
        ((Graphics2D)Mockito.verify((Object)graphics)).draw((Shape)shape.capture());
        LiteShape2 drawnShape = (LiteShape2)shape.getValue();
        Assert.assertEquals((long)2L, (long)drawnShape.getGeometry().getCoordinates().length);
    }

    @Test
    public void testDisableGutter() throws Exception {
        this.setDisableGutter(true);
        WMS wms = this.getWMS();
        WMSInfo info = wms.getServiceInfo();
        info.getMetadata().put(WMS.ADVANCED_PROJECTION_KEY, (Serializable)Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)info);
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(SystemTestData.WORLD.getPrefix(), SystemTestData.WORLD.getLocalPart());
        GetMapRequest request = new GetMapRequest();
        CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:3857");
        DefaultGeographicCRS wgs84 = DefaultGeographicCRS.WGS84;
        GeneralEnvelope env = GeneralEnvelope.toGeneralEnvelope((Envelope)new Envelope2D((CoordinateReferenceSystem)wgs84, -40.0, 0.0, 40.0, 80.0));
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)wgs84, (CoordinateReferenceSystem)crs);
        env = CRS.transform((MathTransform)transform, (Envelope)env);
        ReferencedEnvelope bbox = new ReferencedEnvelope(env.getMinimum(0), env.getMaximum(0), env.getMinimum(1), env.getMaximum(1), crs);
        request.setBbox((org.locationtech.jts.geom.Envelope)bbox);
        request.setInterpolations(Collections.singletonList(Interpolation.getInstance((int)1)));
        request.setSRS("EPSG:3857");
        request.setFormat("image/png");
        WMSMapContent map = new WMSMapContent(request);
        int width = 300;
        int height = 300;
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.getViewport().setBounds(bbox);
        StyleBuilder builder = new StyleBuilder();
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        reader.getCoordinateReferenceSystem();
        CachedGridReaderLayer l = new CachedGridReaderLayer(reader, builder.createStyle((Symbolizer)builder.createRasterSymbolizer()));
        map.addLayer((Layer)l);
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        RenderedImage image = imageMap.getImage();
        RenderedImage[] warp = new RenderedImage[1];
        this.lookForOp("Warp", image, warp);
        Assert.assertEquals((long)300L, (long)image.getWidth());
        Assert.assertEquals((long)300L, (long)image.getHeight());
        imageMap.dispose();
        this.setDisableGutter(false);
        wms = this.getWMS();
        info = wms.getServiceInfo();
        info.getMetadata().put(WMS.ADVANCED_PROJECTION_KEY, (Serializable)Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)info);
    }

    private void lookForOp(String opName, RenderedImage image, RenderedImage[] returnedOp) {
        if (image instanceof RenderedOp) {
            RenderedOp op = (RenderedOp)image;
            String operationName = op.getOperationName();
            if (opName.equalsIgnoreCase(operationName)) {
                returnedOp[0] = op;
                return;
            }
            Vector sources = op.getSources();
            if (sources != null && !sources.isEmpty()) {
                Iterator iterator = sources.iterator();
                while (iterator.hasNext() && returnedOp[0] == null) {
                    Object next = iterator.next();
                    if (!(next instanceof RenderedImage)) continue;
                    this.lookForOp(opName, (RenderedImage)next, returnedOp);
                }
            }
        }
    }

    private void setDisableGutter(boolean value) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = RenderedImageMapOutputFormat.class.getDeclaredField("DISABLE_GUTTER");
        field.setAccessible(true);
        field.set(null, value);
    }

    @Test
    public void testDirectVsNonDirectRasterRender() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(SystemTestData.MULTIBAND.getPrefix(), SystemTestData.MULTIBAND.getLocalPart());
        ReferencedEnvelope env = ci.boundingBox();
        LOGGER.info("about to create map ctx for BasicPolygons with bounds " + env);
        GetMapRequest request = new GetMapRequest();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope bbox = new ReferencedEnvelope(new org.locationtech.jts.geom.Envelope(-116.90673461649858, -114.30988665660261, 32.070937282184026, 33.8903284734844), (CoordinateReferenceSystem)crs);
        request.setBbox((org.locationtech.jts.geom.Envelope)bbox);
        request.setSRS("urn:x-ogc:def:crs:EPSG:4326");
        request.setFormat("image/png");
        WMSMapContent map = new WMSMapContent(request);
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.getViewport().setBounds(bbox);
        StyleBuilder builder = new StyleBuilder();
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        reader.getCoordinateReferenceSystem();
        CachedGridReaderLayer l = new CachedGridReaderLayer(reader, builder.createStyle((Symbolizer)builder.createRasterSymbolizer()));
        map.addLayer((Layer)l);
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        ImageAssert.assertEquals((File)new File("src/test/resources/org/geoserver/wms/map/direct-raster-expected.tif"), (RenderedImage)imageMap.getImage(), (int)0);
        imageMap.dispose();
    }

    @Test
    public void testTimeoutOption() throws Exception {
        Catalog catalog = this.getCatalog();
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        StyleInfo styleByName = catalog.getStyleByName("Default");
        Style basicStyle = styleByName.getStyle();
        SimpleFeatureSource fs = (SimpleFeatureSource)catalog.getFeatureTypeByName(MockData.BASIC_POLYGONS.getPrefix(), MockData.BASIC_POLYGONS.getLocalPart()).getFeatureSource(null, null);
        ReferencedEnvelope env = fs.getBounds();
        SimpleFeatureCollection features = fs.getFeatures();
        DelayedFeatureCollection delayedCollection = new DelayedFeatureCollection(features, 50L);
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)delayedCollection, basicStyle));
        LOGGER.info("about to create map ctx for " + map.layers().size() + " layers with bounds " + env);
        map.getViewport().setBounds(new ReferencedEnvelope((org.locationtech.jts.geom.Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        map.setMapWidth(1000);
        map.setMapHeight(1000);
        map.setRequest(request);
        request.setFormat(this.getMapFormat());
        HashMap<String, Integer> formatOptions = new HashMap<String, Integer>();
        formatOptions.put("timeout", 1);
        request.setFormatOptions(formatOptions);
        try {
            RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
            Assert.fail((String)"Timeout was not reached");
        }
        catch (ServiceException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("This request used more time than allowed"));
        }
        HashMap<String, String> rawKvp = new HashMap<String, String>();
        rawKvp.put("EXCEPTIONS", "PARTIALMAP");
        request.setRawKvp(rawKvp);
        try {
            RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
            Assert.fail((String)"Timeout was not reached");
        }
        catch (ServiceException e) {
            Assert.assertTrue((boolean)(e instanceof WMSPartialMapException));
            Assert.assertTrue((boolean)e.getCause().getMessage().startsWith("This request used more time than allowed"));
            RenderedImageMap partialMap = (RenderedImageMap)((WMSPartialMapException)e).getMap();
            Assert.assertNotNull((Object)partialMap);
            Assert.assertNotNull((Object)partialMap.getImage());
        }
    }

    @Test
    public void testDefaultStyle() throws Exception {
        List typeInfos = this.getCatalog().getFeatureTypes();
        for (FeatureTypeInfo info : typeInfos) {
            if (!info.getQualifiedName().getNamespaceURI().equals(MockData.CITE_URI) || info.getFeatureType().getGeometryDescriptor() == null) continue;
            this.testDefaultStyle(info.getFeatureSource(null, null));
        }
    }

    @Test
    public void testBlueLake() throws IOException, IllegalFilterException, Exception {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo typeInfo = catalog.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        ReferencedEnvelope env = typeInfo.getFeatureSource(null, null).getBounds();
        double shift = env.getWidth() / 6.0;
        env = new org.locationtech.jts.geom.Envelope(env.getMinX() - shift, env.getMaxX() + shift, env.getMinY() - shift, env.getMaxY() + shift);
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        int w = 400;
        int h = (int)Math.round(env.getHeight() * (double)w / env.getWidth());
        map.setMapWidth(w);
        map.setMapHeight(h);
        map.setBgColor(BG_COLOR);
        map.setTransparent(true);
        map.setRequest(request);
        this.addToMap(map, MockData.FORESTS);
        this.addToMap(map, MockData.LAKES);
        this.addToMap(map, MockData.STREAMS);
        this.addToMap(map, MockData.NAMED_PLACES);
        this.addToMap(map, MockData.ROAD_SEGMENTS);
        this.addToMap(map, MockData.PONDS);
        this.addToMap(map, MockData.BUILDINGS);
        this.addToMap(map, MockData.DIVIDED_ROUTES);
        this.addToMap(map, MockData.BRIDGES);
        this.addToMap(map, MockData.MAP_NEATLINE);
        map.getViewport().setBounds(new ReferencedEnvelope((org.locationtech.jts.geom.Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        this.assertNotBlank("testBlueLake", image);
    }

    @Test
    public void testCustomLabelCache() throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo typeInfo = catalog.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        ReferencedEnvelope env = typeInfo.getFeatureSource(null, null).getBounds();
        double shift = env.getWidth() / 6.0;
        env = new org.locationtech.jts.geom.Envelope(env.getMinX() - shift, env.getMaxX() + shift, env.getMinY() - shift, env.getMaxY() + shift);
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        int w = 400;
        int h = (int)Math.round(env.getHeight() * (double)w / env.getWidth());
        map.setMapWidth(w);
        map.setMapHeight(h);
        map.setBgColor(BG_COLOR);
        map.setTransparent(true);
        map.setRequest(request);
        this.addToMap(map, MockData.FORESTS);
        this.addToMap(map, MockData.LAKES);
        this.addToMap(map, MockData.STREAMS);
        this.addToMap(map, MockData.NAMED_PLACES);
        this.addToMap(map, MockData.ROAD_SEGMENTS);
        this.addToMap(map, MockData.PONDS);
        this.addToMap(map, MockData.BUILDINGS);
        this.addToMap(map, MockData.DIVIDED_ROUTES);
        this.addToMap(map, MockData.BRIDGES);
        this.addToMap(map, MockData.MAP_NEATLINE);
        map.getViewport().setBounds(new ReferencedEnvelope((org.locationtech.jts.geom.Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        request.setFormat(this.getMapFormat());
        this.rasterMapProducer.setLabelCache((Function)new Function<WMSMapContent, LabelCache>(){

            @Override
            public LabelCache apply(WMSMapContent mapContent) {
                return new CustomLabelCache();
            }
        });
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        Assert.assertTrue((boolean)usedCustomLabelCache.get());
        this.assertNotBlank("testBlueLake", image);
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addDefaultRasterLayer(MockData.TASMANIA_DEM, this.getCatalog());
        testData.addRasterLayer(TAZ_BYTE, "tazbyte.tiff", null, this.getCatalog());
        testData.addRasterLayer(SIX_BANDS, "6b.tiff", null, this.getCatalog());
        testData.addStyle(NORMALIZED_STYLE, "normalized.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addRasterLayer(TIFF_3035, "3035.zip", "tif", null, RenderedImageMapOutputFormatTest.class, this.getCatalog());
        testData.addStyle(STRAIGHT_VERTICAL_LINE_STYLE, "verticalline.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("style", STRAIGHT_VERTICAL_LINE_STYLE);
        testData.addVectorLayer(STRAIGHT_VERTICAL_LINE, properties, "VerticalLine.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
        testData.addStyle(CROSS_DATELINE_STYLE, "crossline.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        properties = new HashMap();
        properties.put("style", CROSS_DATELINE_STYLE);
        testData.addVectorLayer(CROSS_DATELINE, properties, "CrossLine.properties", ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Test
    public void testInterpolations() throws IOException, IllegalFilterException, Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo coverageInfo = catalog.getCoverageByName(MockData.TASMANIA_DEM.getNamespaceURI(), MockData.TASMANIA_DEM.getLocalPart());
        ReferencedEnvelope env = coverageInfo.boundingBox();
        double shift = env.getWidth() / 6.0;
        env = new org.locationtech.jts.geom.Envelope(env.getMinX() - shift, env.getMaxX() + shift, env.getMinY() - shift, env.getMaxY() + shift);
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        int w = 400;
        int h = (int)Math.round(env.getHeight() * (double)w / env.getWidth());
        map.setMapWidth(w);
        map.setMapHeight(h);
        map.setBgColor(BG_COLOR);
        map.setTransparent(true);
        map.setRequest(request);
        this.addRasterToMap(map, MockData.TASMANIA_DEM);
        map.getViewport().setBounds(new ReferencedEnvelope((org.locationtech.jts.geom.Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        request.setInterpolations(Arrays.asList(Interpolation.getInstance((int)0)));
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        RenderedOp op = (RenderedOp)((RenderedImageTimeDecorator)imageMap.getImage()).getDelegate();
        BufferedImage imageNearest = op.getAsBufferedImage();
        imageMap.dispose();
        this.assertNotBlank("testInterpolationsNearest", imageNearest);
        request = new GetMapRequest();
        map = new WMSMapContent();
        map.setMapWidth(w);
        map.setMapHeight(h);
        map.setBgColor(BG_COLOR);
        map.setTransparent(true);
        map.setRequest(request);
        this.addRasterToMap(map, MockData.TASMANIA_DEM);
        map.getViewport().setBounds(new ReferencedEnvelope((org.locationtech.jts.geom.Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        request.setInterpolations(Arrays.asList(Interpolation.getInstance((int)2)));
        request.setFormat(this.getMapFormat());
        imageMap = this.rasterMapProducer.produceMap(map);
        op = (RenderedOp)((RenderedImageTimeDecorator)imageMap.getImage()).getDelegate();
        BufferedImage imageBicubic = op.getAsBufferedImage();
        imageMap.dispose();
        this.assertNotBlank("testInterpolationsBicubic", imageBicubic);
        Assert.assertNotEquals((long)this.getPixelColor(imageNearest, 160, 160).getRGB(), (long)this.getPixelColor(imageBicubic, 160, 160).getRGB());
        Assert.assertNotEquals((long)this.getPixelColor(imageNearest, 300, 450).getRGB(), (long)this.getPixelColor(imageBicubic, 300, 450).getRGB());
    }

    @Test
    public void testInterpolationFromLayerConfig() throws IOException, IllegalFilterException, Exception {
        Catalog catalog = this.getCatalog();
        LayerInfo layerInfo = catalog.getLayerByName(MockData.TASMANIA_DEM.getLocalPart());
        MapLayerInfo mapLayer = new MapLayerInfo(layerInfo);
        Assert.assertNull((Object)layerInfo.getDefaultWMSInterpolationMethod());
        ReferencedEnvelope env = layerInfo.getResource().boundingBox();
        double shift = env.getWidth() / 6.0;
        env = new org.locationtech.jts.geom.Envelope(env.getMinX() - shift, env.getMaxX() + shift, env.getMinY() - shift, env.getMaxY() + shift);
        GetMapRequest request = new GetMapRequest();
        request.setFormat(this.getMapFormat());
        request.setLayers(Arrays.asList(mapLayer));
        layerInfo.setDefaultWMSInterpolationMethod(LayerInfo.WMSInterpolation.Nearest);
        Assert.assertEquals((Object)LayerInfo.WMSInterpolation.Nearest, (Object)((MapLayerInfo)request.getLayers().get(0)).getLayerInfo().getDefaultWMSInterpolationMethod());
        Assert.assertTrue((boolean)request.getInterpolations().isEmpty());
        WMSMapContent map = this.createWMSMap((org.locationtech.jts.geom.Envelope)env);
        map.setRequest(request);
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        RenderedOp op = (RenderedOp)((RenderedImageTimeDecorator)imageMap.getImage()).getDelegate();
        BufferedImage imageNearest = op.getAsBufferedImage();
        imageMap.dispose();
        this.assertNotBlank("testInterpolationsNearest", imageNearest);
        request = new GetMapRequest();
        request.setFormat(this.getMapFormat());
        request.setLayers(Arrays.asList(mapLayer));
        layerInfo.setDefaultWMSInterpolationMethod(LayerInfo.WMSInterpolation.Bicubic);
        Assert.assertEquals((Object)LayerInfo.WMSInterpolation.Bicubic, (Object)((MapLayerInfo)request.getLayers().get(0)).getLayerInfo().getDefaultWMSInterpolationMethod());
        Assert.assertTrue((boolean)request.getInterpolations().isEmpty());
        map = this.createWMSMap((org.locationtech.jts.geom.Envelope)env);
        map.setRequest(request);
        imageMap = this.rasterMapProducer.produceMap(map);
        op = (RenderedOp)((RenderedImageTimeDecorator)imageMap.getImage()).getDelegate();
        BufferedImage imageBicubic = op.getAsBufferedImage();
        imageMap.dispose();
        this.assertNotBlank("testInterpolationsBicubic", imageBicubic);
        Assert.assertNotEquals((long)this.getPixelColor(imageNearest, 160, 160).getRGB(), (long)this.getPixelColor(imageBicubic, 160, 160).getRGB());
        Assert.assertNotEquals((long)this.getPixelColor(imageNearest, 300, 450).getRGB(), (long)this.getPixelColor(imageBicubic, 300, 450).getRGB());
        request = new GetMapRequest();
        request.setFormat(this.getMapFormat());
        request.setLayers(Arrays.asList(mapLayer, mapLayer));
        layerInfo.setDefaultWMSInterpolationMethod(LayerInfo.WMSInterpolation.Bicubic);
        Assert.assertEquals((Object)LayerInfo.WMSInterpolation.Bicubic, (Object)((MapLayerInfo)request.getLayers().get(0)).getLayerInfo().getDefaultWMSInterpolationMethod());
        Assert.assertTrue((boolean)request.getInterpolations().isEmpty());
        map = this.createWMSMap((org.locationtech.jts.geom.Envelope)env);
        map.setRequest(request);
        this.addRasterToMap(map, MockData.TASMANIA_DEM);
        imageMap = this.rasterMapProducer.produceMap(map);
        this.checkByLayerInterpolation(imageMap, Interpolation.getInstance((int)2));
        request = new GetMapRequest();
        request.setInterpolations(Arrays.asList(Interpolation.getInstance((int)2)));
        request.setFormat(this.getMapFormat());
        request.setLayers(Arrays.asList(mapLayer, mapLayer));
        layerInfo.setDefaultWMSInterpolationMethod(LayerInfo.WMSInterpolation.Bilinear);
        Assert.assertEquals((Object)LayerInfo.WMSInterpolation.Bilinear, (Object)((MapLayerInfo)request.getLayers().get(0)).getLayerInfo().getDefaultWMSInterpolationMethod());
        Assert.assertEquals((Object)WMSInfo.WMSInterpolation.Nearest, (Object)this.getWMS().getServiceInfo().getInterpolation());
        map = this.createWMSMap((org.locationtech.jts.geom.Envelope)env);
        map.setRequest(request);
        this.addRasterToMap(map, MockData.TASMANIA_DEM);
        imageMap = this.rasterMapProducer.produceMap(map);
        this.checkByLayerInterpolation(imageMap, Interpolation.getInstance((int)2));
        request = new GetMapRequest();
        request.setFormat(this.getMapFormat());
        request.setLayers(Arrays.asList(mapLayer));
        layerInfo.setDefaultWMSInterpolationMethod(null);
        Assert.assertEquals(null, (Object)((MapLayerInfo)request.getLayers().get(0)).getLayerInfo().getDefaultWMSInterpolationMethod());
        Assert.assertTrue((boolean)request.getInterpolations().isEmpty());
        Assert.assertEquals((Object)WMSInfo.WMSInterpolation.Nearest, (Object)this.getWMS().getServiceInfo().getInterpolation());
        map = this.createWMSMap((org.locationtech.jts.geom.Envelope)env);
        map.setRequest(request);
        imageMap = this.rasterMapProducer.produceMap(map);
        op = (RenderedOp)((RenderedImageTimeDecorator)imageMap.getImage()).getDelegate();
        BufferedImage imageServiceDefault = op.getAsBufferedImage();
        imageMap.dispose();
        this.assertNotBlank("testInterpolationServiceDefault", imageServiceDefault);
        Assert.assertEquals((long)this.getPixelColor(imageNearest, 200, 200).getRGB(), (long)this.getPixelColor(imageServiceDefault, 200, 200).getRGB());
        Assert.assertEquals((long)this.getPixelColor(imageNearest, 300, 300).getRGB(), (long)this.getPixelColor(imageServiceDefault, 300, 300).getRGB());
        Assert.assertEquals((long)this.getPixelColor(imageNearest, 250, 250).getRGB(), (long)this.getPixelColor(imageServiceDefault, 250, 250).getRGB());
        Assert.assertEquals((long)this.getPixelColor(imageNearest, 150, 150).getRGB(), (long)this.getPixelColor(imageServiceDefault, 150, 150).getRGB());
    }

    private void checkByLayerInterpolation(RenderedImageMap imageMap, Interpolation expected) {
        Layer layer = (Layer)imageMap.getMapContext().layers().get(0);
        Interpolation actual = (Interpolation)layer.getUserData().get("byLayerInterpolation");
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private WMSMapContent createWMSMap(org.locationtech.jts.geom.Envelope bounds) throws Exception {
        WMSMapContent map = new WMSMapContent();
        int w = 400;
        int h = (int)Math.round(bounds.getHeight() * (double)w / bounds.getWidth());
        map.setMapWidth(w);
        map.setMapHeight(h);
        map.setBgColor(BG_COLOR);
        map.setTransparent(true);
        this.addRasterToMap(map, MockData.TASMANIA_DEM);
        map.getViewport().setBounds(new ReferencedEnvelope(bounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        return map;
    }

    private void addRasterToMap(WMSMapContent map, QName typeName) throws IOException, FactoryRegistryException, TransformException, SchemaException {
        this.addRasterToMap(map, typeName, null);
    }

    private void addRasterToMap(WMSMapContent map, QName typeName, Style style) throws IOException, FactoryRegistryException, TransformException, SchemaException {
        CoverageInfo coverageInfo = this.getCatalog().getCoverageByName(typeName.getNamespaceURI(), typeName.getLocalPart());
        List layers = this.getCatalog().getLayers((ResourceInfo)coverageInfo);
        if (style == null) {
            StyleInfo defaultStyle = ((LayerInfo)layers.get(0)).getDefaultStyle();
            style = defaultStyle.getStyle();
        }
        SimpleFeatureCollection fc = FeatureUtilities.wrapGridCoverageReader((GridCoverage2DReader)((GridCoverage2DReader)coverageInfo.getGridCoverageReader(null, null)), (GeneralParameterValue[])new GeneralParameterValue[0]);
        map.addLayer((Layer)new FeatureLayer((FeatureCollection)fc, style));
    }

    private void addToMap(WMSMapContent map, QName typeName) throws IOException {
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
        List layers = this.getCatalog().getLayers((ResourceInfo)ftInfo);
        StyleInfo defaultStyle = ((LayerInfo)layers.get(0)).getDefaultStyle();
        Style style = defaultStyle.getStyle();
        map.addLayer((Layer)new FeatureLayer(ftInfo.getFeatureSource(null, null), style));
    }

    private void testDefaultStyle(FeatureSource fSource) throws Exception {
        Catalog catalog = this.getCatalog();
        Style style = catalog.getStyleByName("Default").getStyle();
        FeatureTypeInfo typeInfo = catalog.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        ReferencedEnvelope env = typeInfo.getFeatureSource(null, null).getBounds();
        env.expandToInclude((org.locationtech.jts.geom.Envelope)fSource.getBounds());
        int w = 400;
        int h = (int)Math.round(env.getHeight() * (double)w / env.getWidth());
        double shift = env.getWidth() / 6.0;
        env = new org.locationtech.jts.geom.Envelope(env.getMinX() - shift, env.getMaxX() + shift, env.getMinY() - shift, env.getMaxY() + shift);
        WMSMapContent map = new WMSMapContent();
        GetMapRequest request = new GetMapRequest();
        map.setRequest(request);
        map.addLayer((Layer)new FeatureLayer(fSource, style));
        map.getViewport().setBounds(new ReferencedEnvelope((org.locationtech.jts.geom.Envelope)env, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        map.setMapWidth(w);
        map.setMapHeight(h);
        map.setBgColor(BG_COLOR);
        map.setTransparent(false);
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        RenderedImage image = imageMap.getImage();
        imageMap.dispose();
        Assert.assertNotNull((Object)image);
        String typeName = fSource.getSchema().getName().getLocalPart();
        this.assertNotBlank("testDefaultStyle " + typeName, (BufferedImage)image);
    }

    @Test
    public void testRenderingErrorsHandling() throws Exception {
        Assert.assertNotNull((Object)this.forceRenderingError((Exception)((Object)new TransformException("fake transform exception"))));
        Assert.assertNotNull((Object)this.forceRenderingError(new NoninvertibleTransformException("fake non invertible exception")));
        Assert.assertNotNull((Object)this.forceRenderingError((Exception)new IllegalAttributeException("non illegal attribute exception")));
        Assert.assertNotNull((Object)this.forceRenderingError((Exception)((Object)new FactoryException("fake factory exception"))));
        try {
            this.forceRenderingError(new RuntimeException("fake runtime exception"));
            Assert.fail((String)"Expected WMSException");
        }
        catch (ServiceException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            this.forceRenderingError(new IOException("fake IO exception"));
            Assert.fail((String)"Expected WMSException");
        }
        catch (ServiceException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            this.forceRenderingError(new IllegalArgumentException("fake IAE exception"));
            Assert.fail((String)"Expected WMSException");
        }
        catch (ServiceException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testStyleUsingChannelsFromCoverageView() throws Exception {
        GetMapRequest request = new GetMapRequest();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope bbox = new ReferencedEnvelope(new org.locationtech.jts.geom.Envelope(-116.90673461649858, -114.30988665660261, 32.070937282184026, 33.8903284734844), (CoordinateReferenceSystem)crs);
        request.setBbox((org.locationtech.jts.geom.Envelope)bbox);
        request.setSRS("urn:x-ogc:def:crs:EPSG:4326");
        request.setFormat("image/png");
        WMSMapContent map = new WMSMapContent(request);
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setTransparent(false);
        map.getViewport().setBounds(bbox);
        StyleBuilder styleBuilder = new StyleBuilder();
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(SystemTestData.MULTIBAND.getPrefix(), SystemTestData.MULTIBAND.getLocalPart());
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        reader.getCoordinateReferenceSystem();
        CachedGridReaderLayer sl = new CachedGridReaderLayer(reader, styleBuilder.createStyle((Symbolizer)styleBuilder.createRasterSymbolizer()));
        map.addLayer((Layer)sl);
        RenderedImageMap srcImageMap = this.rasterMapProducer.produceMap(map);
        RenderedImage srcImage = srcImageMap.getImage();
        CoverageView.InputCoverageBand ib0 = new CoverageView.InputCoverageBand("multiband", "2");
        CoverageView.CoverageBand b0 = new CoverageView.CoverageBand(Collections.singletonList(ib0), "multiband@2", 0, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.InputCoverageBand ib1 = new CoverageView.InputCoverageBand("multiband", "1");
        CoverageView.CoverageBand b1 = new CoverageView.CoverageBand(Collections.singletonList(ib1), "multiband@1", 1, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.InputCoverageBand ib2 = new CoverageView.InputCoverageBand("multiband", "0");
        CoverageView.CoverageBand b2 = new CoverageView.CoverageBand(Collections.singletonList(ib2), "multiband@0", 2, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.InputCoverageBand ib3 = new CoverageView.InputCoverageBand("multiband", "0");
        CoverageView.CoverageBand b3 = new CoverageView.CoverageBand(Collections.singletonList(ib3), "multiband@0", 0, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.InputCoverageBand ib4 = new CoverageView.InputCoverageBand("multiband", "1");
        CoverageView.CoverageBand b4 = new CoverageView.CoverageBand(Collections.singletonList(ib4), "multiband@1", 1, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.InputCoverageBand ib5 = new CoverageView.InputCoverageBand("multiband", "2");
        CoverageView.CoverageBand b5 = new CoverageView.CoverageBand(Collections.singletonList(ib5), "multiband@2", 2, CoverageView.CompositionType.BAND_SELECT);
        ArrayList<CoverageView.CoverageBand> coverageBands = new ArrayList<CoverageView.CoverageBand>(1);
        coverageBands.add(b0);
        coverageBands.add(b1);
        coverageBands.add(b2);
        coverageBands.add(b3);
        coverageBands.add(b4);
        coverageBands.add(b5);
        CoverageView multiBandCoverageView = new CoverageView("multiband_select", coverageBands);
        CoverageStoreInfo storeInfo = catalog.getCoverageStoreByName("multiband");
        CatalogBuilder builder = new CatalogBuilder(catalog);
        CoverageInfo coverageInfo = multiBandCoverageView.createCoverageInfo("multiband_select", storeInfo, builder);
        coverageInfo.getParameters().put("USE_JAI_IMAGEREAD", "false");
        catalog.add((ResourceInfo)coverageInfo);
        LayerInfo layerInfoView = builder.buildLayer(coverageInfo);
        catalog.add(layerInfoView);
        ReferencedEnvelope env = ci.boundingBox();
        LOGGER.info("about to create map ctx for BasicPolygons with bounds " + env);
        RasterSymbolizer symbolizer = styleBuilder.createRasterSymbolizer();
        ChannelSelectionImpl cs = new ChannelSelectionImpl();
        SelectedChannelTypeImpl red = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl green = new SelectedChannelTypeImpl();
        SelectedChannelTypeImpl blue = new SelectedChannelTypeImpl();
        red.setChannelName("3");
        green.setChannelName("2");
        blue.setChannelName("1");
        cs.setRGBChannels(new SelectedChannelType[]{red, green, blue});
        symbolizer.setChannelSelection((ChannelSelection)cs);
        reader = (GridCoverage2DReader)coverageInfo.getGridCoverageReader(null, null);
        reader.getCoordinateReferenceSystem();
        CachedGridReaderLayer dl = new CachedGridReaderLayer(reader, styleBuilder.createStyle((Symbolizer)symbolizer));
        map.removeLayer((Layer)sl);
        map.addLayer((Layer)dl);
        RenderedImageMap dstImageMap = this.rasterMapProducer.produceMap(map);
        RenderedImage destImage = dstImageMap.getImage();
        int dWidth = destImage.getWidth();
        int dHeight = destImage.getHeight();
        int[] destImageRowBand0 = new int[dWidth * dHeight];
        int[] destImageRowBand1 = new int[destImageRowBand0.length];
        int[] destImageRowBand2 = new int[destImageRowBand0.length];
        destImage.getData().getSamples(0, 0, dWidth, dHeight, 0, destImageRowBand0);
        destImage.getData().getSamples(0, 0, dWidth, dHeight, 1, destImageRowBand1);
        destImage.getData().getSamples(0, 0, dWidth, dHeight, 2, destImageRowBand2);
        int sWidth = srcImage.getWidth();
        int sHeight = srcImage.getHeight();
        int[] srcImageRowBand0 = new int[sWidth * sHeight];
        int[] srcImageRowBand2 = new int[srcImageRowBand0.length];
        srcImage.getData().getSamples(0, 0, sWidth, sHeight, 0, srcImageRowBand0);
        Assert.assertTrue((boolean)Arrays.equals(destImageRowBand0, srcImageRowBand0));
        Assert.assertFalse((boolean)Arrays.equals(destImageRowBand0, srcImageRowBand2));
        srcImageMap.dispose();
        dstImageMap.dispose();
        map.dispose();
    }

    @Test
    public void testBandSelectionToNormalCoverage() throws Exception {
        GetMapRequest request = new GetMapRequest();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope bbox = new ReferencedEnvelope(new org.locationtech.jts.geom.Envelope(-116.90673461649858, -114.30988665660261, 32.070937282184026, 33.8903284734844), (CoordinateReferenceSystem)crs);
        request.setBbox((org.locationtech.jts.geom.Envelope)bbox);
        request.setSRS("urn:x-ogc:def:crs:EPSG:4326");
        request.setFormat("image/png");
        WMSMapContent map = new WMSMapContent(request);
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        map.getViewport().setBounds(bbox);
        StyleBuilder styleBuilder = new StyleBuilder();
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(SystemTestData.MULTIBAND.getPrefix(), SystemTestData.MULTIBAND.getLocalPart());
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        reader.getCoordinateReferenceSystem();
        ReferencedEnvelope env = ci.boundingBox();
        int[] bandIndices = new int[]{1, 2, 0, 2, 1};
        Parameter bandIndicesParam = (Parameter)AbstractGridFormat.BANDS.createValue();
        bandIndicesParam.setValue((Object)bandIndices);
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        paramList.add(bandIndicesParam);
        GeneralParameterValue[] readParams = paramList.toArray(new GeneralParameterValue[paramList.size()]);
        CachedGridReaderLayer sl = new CachedGridReaderLayer(reader, styleBuilder.createStyle((Symbolizer)styleBuilder.createRasterSymbolizer()), readParams);
        map.addLayer((Layer)sl);
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        ImageAssert.assertEquals((File)new File("src/test/resources/org/geoserver/wms/map/direct-raster-expected.tif"), (RenderedImage)imageMap.getImage(), (int)0);
        imageMap.dispose();
    }

    @Test
    public void testGetMapOnByteNodataGrayScale() throws Exception {
        GetMapRequest request = new GetMapRequest();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope bbox = new ReferencedEnvelope(new org.locationtech.jts.geom.Envelope(145.0, 146.0, -43.0, -41.0), (CoordinateReferenceSystem)crs);
        request.setBbox((org.locationtech.jts.geom.Envelope)bbox);
        request.setHeight(768);
        request.setWidth(384);
        request.setSRS("urn:x-ogc:def:crs:EPSG:4326");
        request.setFormat("image/png");
        request.setTransparent(true);
        WMSMapContent map = new WMSMapContent(request);
        map.setMapHeight(768);
        map.setMapWidth(384);
        map.setBgColor(BG_COLOR);
        map.setTransparent(true);
        map.getViewport().setBounds(bbox);
        this.addRasterToMap(map, TAZ_BYTE);
        map.getViewport().setBounds(bbox);
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        RenderedOp op = (RenderedOp)((RenderedImageTimeDecorator)imageMap.getImage()).getDelegate();
        BufferedImage image = op.getAsBufferedImage();
        imageMap.dispose();
        Assert.assertEquals((long)0L, (long)image.getRaster().getSample(40, 400, 0));
        Assert.assertEquals((long)0L, (long)image.getRaster().getSample(40, 400, 1));
    }

    @Test
    public void testGetMapOnByteNodataChannelSelectAndContrastEnhancement() throws Exception {
        GetMapRequest request = new GetMapRequest();
        CoverageInfo coverageInfo = this.getCatalog().getCoverageByName(SIX_BANDS.getPrefix(), SIX_BANDS.getLocalPart());
        ReferencedEnvelope bbox = coverageInfo.getNativeBoundingBox();
        GridEnvelope gridRange = coverageInfo.getGrid().getGridRange();
        int width = gridRange.getHigh(0) + 1;
        int height = gridRange.getHigh(1) + 1;
        request.setBbox((org.locationtech.jts.geom.Envelope)bbox);
        request.setWidth(width);
        request.setHeight(height);
        request.setSRS("urn:x-ogc:def:crs:EPSG:4326");
        request.setFormat("image/png");
        request.setTransparent(true);
        WMSMapContent map = new WMSMapContent(request);
        map.setMapWidth(width);
        map.setMapHeight(height);
        map.setTransparent(true);
        map.getViewport().setBounds(bbox);
        Style normalized = this.getCatalog().getStyleByName(NORMALIZED_STYLE).getStyle();
        this.addRasterToMap(map, SIX_BANDS, normalized);
        map.getViewport().setBounds(bbox);
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        RenderedOp op = (RenderedOp)((RenderedImageTimeDecorator)imageMap.getImage()).getDelegate();
        BufferedImage image = op.getAsBufferedImage();
        imageMap.dispose();
        int[] pixel = new int[4];
        WritableRaster raster = image.getRaster();
        raster.getPixel(0, 0, pixel);
        Assert.assertArrayEquals((int[])new int[]{0, 0, 0, 0}, (int[])pixel);
        raster.getPixel(6, 7, pixel);
        Assert.assertEquals((long)255L, (long)pixel[3]);
    }

    private RenderedImage forceRenderingError(final Exception renderExceptionToThrow) throws Exception {
        GetMapRequest request = new GetMapRequest();
        WMSMapContent map = new WMSMapContent();
        map.setMapWidth(100);
        map.setMapHeight(100);
        map.setRequest(request);
        ReferencedEnvelope bounds = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        map.getViewport().setBounds(bounds);
        FeatureTypeInfo ftInfo = this.getCatalog().getFeatureTypeByName(CiteTestData.STREAMS.getNamespaceURI(), CiteTestData.STREAMS.getLocalPart());
        SimpleFeatureSource featureSource = (SimpleFeatureSource)ftInfo.getFeatureSource(null, null);
        DecoratingFeatureSource source = new DecoratingFeatureSource((FeatureSource)featureSource){

            public SimpleFeatureCollection getFeatures(Query query) throws IOException {
                throw new RuntimeException(renderExceptionToThrow);
            }
        };
        StyleInfo someStyle = this.getCatalog().getStyleByName("line");
        map.addLayer((Layer)new FeatureLayer((FeatureSource)source, someStyle.getStyle()));
        request.setFormat(this.getMapFormat());
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        BufferedImage image = (BufferedImage)imageMap.getImage();
        imageMap.dispose();
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMosaicExpansion() throws Exception {
        File red1 = URLs.urlToFile((URL)((Object)((Object)this)).getClass().getResource("red_footprint_test/red1.tif"));
        File source = red1.getParentFile();
        File testDataDir = this.getResourceLoader().getBaseDirectory();
        File directory1 = new File(testDataDir, "redHarvest1");
        File directory2 = new File(testDataDir, "redHarvest2");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        directory2.mkdirs();
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("red[^3].*"), null)) {
            Assert.assertTrue((boolean)file.renameTo(new File(directory2, file.getName())));
        }
        URL harvestSingleURL = URLs.fileToUrl((File)directory1);
        ImageMosaicReader reader = new ImageMosaicReader((Object)directory1, null);
        ImageMosaicReader reader2 = new ImageMosaicReader((Object)directory1, null);
        try {
            for (File file : directory2.listFiles()) {
                Assert.assertTrue((boolean)file.renameTo(new File(directory1, file.getName())));
            }
            reader.harvest(null, (Object)directory1, null);
            ReferencedEnvelope renderEnvelope = new ReferencedEnvelope(991000.0, 992000.0, 216000.0, 217000.0, reader2.getCoordinateReferenceSystem());
            Rectangle rasterArea = new Rectangle(0, 0, 10, 10);
            GetMapRequest request = new GetMapRequest();
            request.setBbox((org.locationtech.jts.geom.Envelope)renderEnvelope);
            request.setSRS("EPSG:6539");
            request.setFormat("image/png");
            WMSMapContent map = new WMSMapContent(request);
            map.setMapWidth(10);
            map.setMapHeight(10);
            map.setBgColor(Color.BLACK);
            map.setTransparent(false);
            map.getViewport().setBounds(renderEnvelope);
            StyleBuilder builder = new StyleBuilder();
            Style style = builder.createStyle((Symbolizer)builder.createRasterSymbolizer());
            CachedGridReaderLayer l = new CachedGridReaderLayer((GridCoverage2DReader)reader2, style);
            map.addLayer((Layer)l);
            RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
            File reference = new File("src/test/resources/org/geoserver/wms/map/red10.png");
            ImageAssert.assertEquals((File)reference, (RenderedImage)imageMap.getImage(), (int)0);
            ((FeatureTypeStyle)style.featureTypeStyles().get(0)).setTransformation((Expression)new IdentityCoverageFunction());
            RenderedImageMap imageMap2 = this.rasterMapProducer.produceMap(map);
            ImageAssert.assertEquals((File)reference, (RenderedImage)imageMap2.getImage(), (int)0);
            imageMap.dispose();
        }
        finally {
            reader.dispose();
            reader2.dispose();
        }
    }

    @Test
    public void testGetMapUntiledBigSize() throws Exception {
        int mapWidth = 8192;
        int mapHeight = 8192;
        GetMapRequest request = new GetMapRequest();
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope bbox = new ReferencedEnvelope(new org.locationtech.jts.geom.Envelope(145.0, 146.0, -43.0, -41.0), (CoordinateReferenceSystem)crs);
        request.setBbox((org.locationtech.jts.geom.Envelope)bbox);
        request.setHeight(8192);
        request.setWidth(8192);
        request.setSRS("urn:x-ogc:def:crs:EPSG:4326");
        request.setFormat("image/png");
        request.setTransparent(true);
        WMSMapContent map = new WMSMapContent(request);
        map.setMapHeight(8192);
        map.setMapWidth(8192);
        map.setBgColor(BG_COLOR);
        map.setTransparent(true);
        map.getViewport().setBounds(bbox);
        this.addRasterToMap(map, TAZ_BYTE);
        map.getViewport().setBounds(bbox);
        RenderedImageMap imageMap = this.rasterMapProducer.produceMap(map);
        RenderedOp op = (RenderedOp)((RenderedImageTimeDecorator)imageMap.getImage()).getDelegate();
        Point[] tileIndices = op.getTileIndices(new Rectangle(0, 0, 8192, 8192));
        Assert.assertTrue((tileIndices.length > 1 ? 1 : 0) != 0);
        Raster tile = op.getTile(0, 0);
        Assert.assertNotNull((Object)tile);
        Assert.assertTrue((tile.getWidth() < 8192 ? 1 : 0) != 0);
        Assert.assertTrue((tile.getHeight() < 8192 ? 1 : 0) != 0);
        ImageUtilities.disposePlanarImageChain((PlanarImage)op);
        imageMap.dispose();
    }

    @Test
    public void testReprojectionHasNoWhiteLine() throws IOException, IllegalFilterException, Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?BBOX=-1137115.798172220821,2084204.190127906622,6183796.336430944502,4720584.184010294266&styles=&layers=sf:3035&Format=image/png&request=GetMap&width=1943&height=700&srs=EPSG:3857");
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertNotNull((Object)image);
        int minX = 1025;
        boolean minY = false;
        int width = 2;
        int height = 256;
        Raster r = image.getData(new Rectangle(1025, 0, 2, 256));
        int validPixel = 237;
        int validPixelsCount = 0;
        for (int i = 1025; i < 1027; ++i) {
            for (int j = 0; j < 256; ++j) {
                if (r.getSample(i, j, 0) != 237) continue;
                ++validPixelsCount;
            }
        }
        Assert.assertEquals((long)512L, (long)validPixelsCount);
    }

    @Test
    public void testFaultyStyleDoesntBreak() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?BBOX=-180,-90,180,90&styles=raster&layers=cdf:Fifteen&Format=image/png&request=GetMap&width=256&height=256&srs=EPSG%3A4326");
        BufferedImage image = ImageIO.read(this.getBinaryInputStream(response));
        Assert.assertNotNull((Object)image);
        this.assertBlank("testFaultyStyleDoesntBreak", image);
    }

    static class DummyRasterMapProducer
    extends RenderedImageMapOutputFormat {
        Graphics2D graphics = null;

        public DummyRasterMapProducer(WMS wms) {
            super("image/gif", new String[]{"image/gif"}, wms);
        }

        public void setGraphics(Graphics2D graphics) {
            this.graphics = graphics;
        }

        protected Graphics2D getGraphics(boolean transparent, Color bgColor, RenderedImage preparedImage, Map<RenderingHints.Key, Object> hintsMap) {
            if (this.graphics != null) {
                return this.graphics;
            }
            return super.getGraphics(transparent, bgColor, preparedImage, hintsMap);
        }
    }

    public static class CustomLabelCache
    implements LabelCache {
        public void clear() {
        }

        public void clear(String arg0) {
        }

        public void disableLayer(String arg0) {
        }

        public void enableLayer(String arg0) {
        }

        public void end(Graphics2D arg0, Rectangle arg1) {
            usedCustomLabelCache.set(true);
        }

        public void endLayer(String arg0, Graphics2D arg1, Rectangle arg2) {
        }

        public List orderedLabels() {
            return null;
        }

        public void put(Rectangle2D arg0) {
        }

        public void put(String arg0, TextSymbolizer arg1, Feature arg2, LiteShape2 arg3, NumberRange<Double> arg4) {
        }

        public void start() {
        }

        public void startLayer(String arg0) {
        }

        public void stop() {
        }
    }
}

