/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.xml.namespace.QName;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geoserver.wms.map.RenderedImageTimeDecorator;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.util.ImageUtilities;
import org.geotools.map.GridReaderLayer;
import org.geotools.map.Layer;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class TinyRasterBoundingBoxTest
extends WMSTestSupport {
    private WMSMapContent map;
    private BufferedImage image;
    private RenderedOp op;

    @BeforeClass
    public static void disableAdvancedProjection() {
        System.setProperty("ENABLE_ADVANCED_PROJECTION", "false");
    }

    @Before
    public void setUp() {
        GetMapRequest request = new GetMapRequest();
        request.setFormat("image/png");
        this.map = new WMSMapContent();
        this.map.setMapWidth(256);
        this.map.setMapHeight(256);
        this.map.setTransparent(true);
        this.map.setRequest(request);
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addDefaultRasterLayer(MockData.TASMANIA_DEM, this.getCatalog());
        testData.addStyle("rainfall", "rainfall.sld", MockData.class, this.getCatalog());
    }

    @After
    public void tearDown() {
        ImageUtilities.disposeImage((RenderedImage)this.op);
        this.map.dispose();
        this.map = null;
        this.image = null;
        this.op = null;
    }

    @Test
    public void testTinyRasterBboxContained() throws Exception {
        CoverageInfo coverageInfo = this.addRasterToMap(MockData.TASMANIA_DEM);
        ReferencedEnvelope env = coverageInfo.boundingBox();
        Coordinate center = env.centre();
        GridEnvelope range = coverageInfo.getGrid().getGridRange();
        double offset = (env.getMaxX() - env.getMinX()) / (double)range.getSpan(0) / 10.0;
        Rectangle imageBounds = this.produceMap(center.x + offset, center.x + 2.0 * offset, center.y + offset, center.y + 2.0 * offset);
        this.assertNotBlank("testTinyRasterBboxContained", this.image);
        Assert.assertEquals((Object)"Mosaic", (Object)this.op.getOperationName());
        Rectangle roiBounds = this.getRoiBounds();
        Assert.assertTrue((String)("Expected " + imageBounds + " to contain " + roiBounds), (boolean)imageBounds.contains(roiBounds));
    }

    @Test
    public void testTinyRasterBboxIntersection() throws Exception {
        CoverageInfo coverageInfo = this.addRasterToMap(MockData.TASMANIA_DEM);
        ReferencedEnvelope env = coverageInfo.boundingBox();
        GridEnvelope range = coverageInfo.getGrid().getGridRange();
        double offset = (env.getMaxX() - env.getMinX()) / (double)range.getSpan(0) / 20.0;
        Rectangle imageBounds = this.produceMap(env.getMinX() - offset, env.getMinX() + offset, env.getMaxY() - offset, env.getMaxY() + offset);
        this.assertNotBlank("testTinyRasterBboxIntersection", this.image);
        Assert.assertEquals((Object)"Mosaic", (Object)this.op.getOperationName());
        Rectangle roiBounds = this.getRoiBounds();
        Assert.assertTrue((String)("Expected " + imageBounds + " to contain " + roiBounds), (boolean)imageBounds.contains(roiBounds));
    }

    @Test
    public void testTinyRasterBboxNoIntersection() throws Exception {
        CoverageInfo coverageInfo = this.addRasterToMap(MockData.TASMANIA_DEM);
        ReferencedEnvelope env = coverageInfo.boundingBox();
        GridEnvelope range = coverageInfo.getGrid().getGridRange();
        double offset = (env.getMaxX() - env.getMinX()) / (double)range.getSpan(0) / 10.0;
        Rectangle imageBounds = this.produceMap(env.getMaxX() + offset, env.getMaxX() + 2.0 * offset, env.getMinY() - 2.0 * offset, env.getMinY() - offset);
        this.assertNotBlank("testTinyRasterBboxNoIntersection", this.image);
        Assert.assertEquals((Object)"Mosaic", (Object)this.op.getOperationName());
        Rectangle roiBounds = this.getRoiBounds();
        Assert.assertTrue((String)("Expected " + imageBounds + " to contain " + roiBounds), (boolean)imageBounds.contains(roiBounds));
    }

    private CoverageInfo addRasterToMap(QName typeName) throws Exception {
        CoverageInfo coverageInfo = this.getCatalog().getCoverageByName(typeName.getNamespaceURI(), typeName.getLocalPart());
        GridCoverage2DReader reader = (GridCoverage2DReader)coverageInfo.getGridCoverageReader(null, null);
        Style style = this.getCatalog().getStyleByName("rainfall").getStyle();
        this.map.addLayer((Layer)new GridReaderLayer(reader, style));
        return coverageInfo;
    }

    private Rectangle getRoiBounds() {
        ParameterBlock pb = this.op.getParameterBlock();
        ROI[] rois = (ROI[])pb.getObjectParameter(2);
        return rois[0].getBounds();
    }

    private Rectangle produceMap(double minX, double maxX, double minY, double maxY) {
        this.map.getViewport().setBounds(new ReferencedEnvelope(minX, maxX, minY, maxY, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        RenderedImageMapOutputFormat rasterMapProducer = new RenderedImageMapOutputFormat(this.getWMS());
        RenderedImageMap imageMap = rasterMapProducer.produceMap(this.map);
        this.op = (RenderedOp)((RenderedImageTimeDecorator)imageMap.getImage()).getDelegate();
        this.image = this.op.getAsBufferedImage();
        imageMap.dispose();
        return new Rectangle(0, 0, this.image.getWidth(), this.image.getHeight());
    }
}

