/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import javax.imageio.ImageIO;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.StyleGenerator;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Styles;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.data.test.TestData;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.image.test.ImageAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GetMapIntegrationTest
extends WMSTestSupport {
    String bbox = "-130,24,-66,50";
    String styles = "states";
    String layers = "sf:states";
    private static final QName RAIN = new QName(MockData.SF_URI, "rain", MockData.SF_PREFIX);
    private static final String RAIN_RT_STYLE = "filteredRain";
    public static final String STATES_SLD10 = "<StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\" version=\"1.0.0\"> <NamedLayer>  <Name>sf:states</Name>  <UserStyle>   <Name>UserSelection</Name>   <FeatureTypeStyle>    <Rule>     <ogc:Filter xmlns:ogc=\"http://www.opengis.net/ogc\">      <ogc:PropertyIsEqualTo>       <ogc:PropertyName>STATE_ABBR</ogc:PropertyName>       <ogc:Literal>IL</ogc:Literal>      </ogc:PropertyIsEqualTo>     </ogc:Filter>     <PolygonSymbolizer>      <Fill>       <CssParameter name=\"fill\">#FF0000</CssParameter>      </Fill>     </PolygonSymbolizer>    </Rule>    <Rule>     <LineSymbolizer>      <Stroke/>     </LineSymbolizer>    </Rule>   </FeatureTypeStyle>  </UserStyle> </NamedLayer></StyledLayerDescriptor>";
    public static final String STATES_SLD10_INVALID = "<StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\" version=\"1.0.0\"> <NamedLayer>  <Name>sf:states</Name>  <UserStyle>   <Name>UserSelection</Name>   <FeatureTypeStyle>    <Rule>     <ogc:Filter xmlns:ogc=\"http://www.opengis.net/ogc\">      <ogc:PropertyIsEqualTo>       <ogc:PropertyName>STATE_ABBR</ogc:PropertyName>       <ogc:Literal>IL</ogc:Literal>      </ogc:PropertyIsEqualTo>     </ogc:Filter>     <PolygonSymbolizer>      <Font/> <!-- invalid! -->      <Fill>       <CssParameter name=\"fill\">#FF0000</CssParameter>      </Fill>     </PolygonSymbolizer>    </Rule>    <Rule>     <LineSymbolizer>      <Stroke/>     </LineSymbolizer>    </Rule>   </FeatureTypeStyle>  </UserStyle> </NamedLayer></StyledLayerDescriptor>";
    public static final String STATES_SLD11 = "<StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\"        xmlns:se=\"http://www.opengis.net/se\" version=\"1.1.0\">  <NamedLayer>   <se:Name>sf:states</se:Name>   <UserStyle>    <se:Name>UserSelection</se:Name>    <se:FeatureTypeStyle>     <se:Rule>      <ogc:Filter xmlns:ogc=\"http://www.opengis.net/ogc\">       <ogc:PropertyIsEqualTo>        <ogc:PropertyName>STATE_ABBR</ogc:PropertyName>        <ogc:Literal>IL</ogc:Literal>       </ogc:PropertyIsEqualTo>      </ogc:Filter>      <se:PolygonSymbolizer>       <se:Fill>        <se:SvgParameter name=\"fill\">#FF0000</se:SvgParameter>       </se:Fill>      </se:PolygonSymbolizer>     </se:Rule>     <se:Rule>      <se:LineSymbolizer>       <se:Stroke/>      </se:LineSymbolizer>     </se:Rule>    </se:FeatureTypeStyle>   </UserStyle>  </NamedLayer> </StyledLayerDescriptor>";
    public static final String STATES_SLD11_INVALID = "<StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\"        xmlns:se=\"http://www.opengis.net/se\" version=\"1.1.0\">  <NamedLayer>   <se:Name>sf:states</se:Name>   <UserStyle>    <se:Name>UserSelection</se:Name>    <se:FeatureTypeStyle>     <se:Rule>      <ogc:Filter xmlns:ogc=\"http://www.opengis.net/ogc\">       <ogc:PropertyIsEqualTo>        <ogc:PropertyName>STATE_ABBR</ogc:PropertyName>        <ogc:Literal>IL</ogc:Literal>       </ogc:PropertyIsEqualTo>      </ogc:Filter>      <se:PolygonSymbolizer>       <se:Fill>        <se:SvgParameter name=\"fill\">#FF0000</se:SvgParameter>       </se:Fill>       <se:Font/> <!-- invalid -->     </se:PolygonSymbolizer>     </se:Rule>     <se:Rule>      <se:LineSymbolizer>       <se:Stroke/>      </se:LineSymbolizer>     </se:Rule>    </se:FeatureTypeStyle>   </UserStyle>  </NamedLayer> </StyledLayerDescriptor>";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle("Population", "Population.sld", org.geoserver.wms.wms_1_1_1.GetMapIntegrationTest.class, catalog);
        testData.addVectorLayer(new QName(MockData.SF_URI, "states", MockData.SF_PREFIX), Collections.EMPTY_MAP, "states.properties", org.geoserver.wms.wms_1_1_1.GetMapIntegrationTest.class, catalog);
        testData.addRasterLayer(RAIN, "rain.zip", "asc", this.getCatalog());
        testData.addStyle(RAIN_RT_STYLE, "filteredRain.sld", GetMapIntegrationTest.class, catalog);
    }

    @Test
    public void testRepeatedValues() throws Exception {
        String baseRequest = "wms?service=wms&version=1.3.0&bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326";
        MockHttpServletResponse response = this.getAsServletResponse(baseRequest + "&format=image/png");
        this.checkImage(response);
        response = this.getAsServletResponse(baseRequest + "&format=image/png&format=image/png");
        this.checkImage(response);
        Document dom = this.getAsDOM(baseRequest + "&format=image/jpeg");
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        Element serviceException = (Element)dom.getDocumentElement().getElementsByTagName("ServiceException").item(0);
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)serviceException.getAttribute("code"));
        Assert.assertEquals((Object)"FORMAT", (Object)serviceException.getAttribute("locator"));
    }

    @Test
    public void testSldBody10() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&SLD_VERSION=1.0.0&SLD_BODY=" + STATES_SLD10.replaceAll("=", "%3D"));
        this.checkImage(response);
    }

    @Test
    public void testSldBody10Validate() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&SLD_VERSION=1.0.0&SLD_BODY=" + STATES_SLD10.replaceAll("=", "%3D") + "&VALIDATESCHEMA=true");
        this.checkImage(response);
        Document dom = this.getAsDOM("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&SLD_VERSION=1.0.0&SLD_BODY=" + STATES_SLD10_INVALID.replaceAll("=", "%3D") + "&VALIDATESCHEMA=true", Charset.defaultCharset().displayName());
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        dom = this.getAsDOM("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&SLD_VERSION=1.0.0&SLD_BODY=" + STATES_SLD11.replaceAll("=", "%3D") + "&VALIDATESCHEMA=true", Charset.defaultCharset().displayName());
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testSldBody11() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&SLD_VERSION=1.1.0&SLD_BODY=" + STATES_SLD11.replaceAll("=", "%3D"));
        this.checkImage(response);
    }

    @Test
    public void testSldBody11Validate() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&SLD_VERSION=1.1.0&SLD_BODY=" + STATES_SLD11.replaceAll("=", "%3D") + "&VALIDATESCHEMA=true");
        this.checkImage(response);
        Document dom = this.getAsDOM("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&SLD_VERSION=1.1.0&SLD_BODY=" + STATES_SLD11_INVALID.replaceAll("=", "%3D") + "&VALIDATESCHEMA=true", Charset.defaultCharset().displayName());
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
    }

    @Test
    public void testSldBody11NoVersion() throws Exception {
        Document dom = this.getAsDOM("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&SLD_VERSION=1.0.0&SLD_BODY=" + STATES_SLD11.replaceAll("=", "%3D") + "&VALIDATESCHEMA=true", Charset.defaultCharset().displayName());
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&SLD_BODY=" + STATES_SLD11.replaceAll("=", "%3D") + "&VALIDATESCHEMA=true");
        this.checkImage(response);
    }

    @Test
    public void testSldGenerateRaster() throws Exception {
        Catalog catalog = this.getCatalog();
        StyleGenerator generator = new StyleGenerator(catalog);
        CoverageInfo coverage = catalog.getCoverageByName(MockData.WORLD.getLocalPart());
        StyleInfo style = generator.createStyle(Styles.handler((String)"SLD"), coverage);
        catalog.add(style);
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=-120,35,-100,45&styles=" + style.getName() + "&layers=" + coverage.getName() + "&format=image/png&request=GetMap&width=80&height=40&srs=EPSG:4326");
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(response.getContentAsByteArray()));
        Color rgb = new Color(image.getRGB(5, 5));
        Assert.assertEquals((Object)rgb, (Object)new Color(170, 170, 170));
        this.checkImage(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerGroupSingle() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = this.createLakesPlacesLayerGroup(catalog, LayerGroupInfo.Mode.SINGLE, null);
        try {
            String url = "wms?LAYERS=" + group.getName() + "&STYLES=&FORMAT=image%2Fpng&REQUEST=GetMap&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=0.0000,-0.0020,0.0035,0.0010";
            BufferedImage image = this.getAsImage(url, "image/png");
            this.assertPixel(image, 150, 160, Color.WHITE);
            this.assertPixel(image, 180, 16, COLOR_PLACES_GRAY);
            this.assertPixel(image, 90, 200, COLOR_LAKES_BLUE);
        }
        finally {
            catalog.remove(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerGroupNamed() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = this.createLakesPlacesLayerGroup(catalog, LayerGroupInfo.Mode.NAMED, null);
        try {
            String url = "wms?LAYERS=" + group.getName() + "&STYLES=&FORMAT=image%2Fpng&REQUEST=GetMap&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=0.0000,-0.0020,0.0035,0.0010";
            BufferedImage image = this.getAsImage(url, "image/png");
            this.assertPixel(image, 150, 160, Color.WHITE);
            this.assertPixel(image, 180, 16, COLOR_PLACES_GRAY);
            this.assertPixel(image, 90, 200, COLOR_LAKES_BLUE);
        }
        finally {
            catalog.remove(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerGroupContainer() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = this.createLakesPlacesLayerGroup(catalog, LayerGroupInfo.Mode.CONTAINER, null);
        try {
            String url = "wms?LAYERS=" + group.getName() + "&STYLES=&FORMAT=image%2Fpng&REQUEST=GetMap&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=0.0000,-0.0020,0.0035,0.0010";
            MockHttpServletResponse resp = this.getAsServletResponse(url);
            Assert.assertEquals((Object)"text/xml", (Object)resp.getContentType());
            Document dom = this.getAsDOM(url);
            Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
            Element serviceException = (Element)dom.getDocumentElement().getElementsByTagName("ServiceException").item(0);
            Assert.assertEquals((Object)"LayerNotDefined", (Object)serviceException.getAttribute("code"));
            Assert.assertEquals((Object)"layers", (Object)serviceException.getAttribute("locator"));
            Assert.assertEquals((Object)("Could not find layer " + group.getName()), (Object)serviceException.getTextContent().trim());
        }
        finally {
            catalog.remove(group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLayerGroupModeEo() throws Exception {
        Catalog catalog = this.getCatalog();
        LayerGroupInfo group = this.createLakesPlacesLayerGroup(catalog, LayerGroupInfo.Mode.EO, catalog.getLayerByName(this.getLayerId(MockData.LAKES)));
        try {
            String url = "wms?LAYERS=" + group.getName() + "&STYLES=&FORMAT=image%2Fpng&REQUEST=GetMap&SRS=EPSG%3A4326&WIDTH=256&HEIGHT=256&BBOX=0.0000,-0.0020,0.0035,0.0010";
            BufferedImage image = this.getAsImage(url, "image/png");
            this.assertPixel(image, 150, 160, Color.WHITE);
            this.assertPixel(image, 180, 16, Color.WHITE);
            this.assertPixel(image, 90, 200, COLOR_LAKES_BLUE);
        }
        finally {
            catalog.remove(group);
        }
    }

    @Test
    public void testWorkspaceQualifiedNoLayersError() throws Exception {
        Document dom = this.getAsDOM("sf/wms?bbox=" + this.bbox + "&styles=&layers=&format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326", Charset.defaultCharset().displayName());
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertTrue((boolean)dom.getDocumentElement().getTextContent().contains("No LAYERS has been requested"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSldExternalEntities() throws Exception {
        URL sldUrl = TestData.class.getResource("externalEntities.sld");
        String url = "wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&sld=" + sldUrl.toString();
        WMS wms = new WMS(this.getGeoServer());
        GeoServerInfo geoserverInfo = wms.getGeoServer().getGlobal();
        try {
            geoserverInfo.setXmlExternalEntitiesEnabled(Boolean.valueOf(true));
            this.getGeoServer().save(geoserverInfo);
            String response = this.getAsString(url);
            Assert.assertTrue((response.indexOf("Error while getting SLD.") > -1 ? 1 : 0) != 0);
            geoserverInfo.setXmlExternalEntitiesEnabled(Boolean.valueOf(false));
            this.getGeoServer().save(geoserverInfo);
            response = this.getAsString(url);
            Assert.assertTrue((response.indexOf("Entity resolution disallowed") > -1 ? 1 : 0) != 0);
            geoserverInfo.setXmlExternalEntitiesEnabled(null);
            this.getGeoServer().save(geoserverInfo);
            response = this.getAsString(url);
            Assert.assertTrue((response.indexOf("Entity resolution disallowed") > -1 ? 1 : 0) != 0);
        }
        finally {
            geoserverInfo.setXmlExternalEntitiesEnabled(null);
            this.getGeoServer().save(geoserverInfo);
        }
    }

    @Test
    public void testAllowedMimeTypes() throws Exception {
        WMSInfo wms = this.getWMS().getServiceInfo();
        RenderedImageMapOutputFormat format = new RenderedImageMapOutputFormat(this.getWMS());
        wms.getGetMapMimeTypes().add(format.getMimeType());
        wms.setGetMapMimeTypeCheckingEnabled(true);
        this.getGeoServer().save((ServiceInfo)wms);
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&version=1.3.0");
        this.checkImage(response);
        String result = this.getAsString("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=" + "text/html; subtype=openlayers" + "&request=GetMap&width=550&height=250&srs=EPSG:4326&version=1.3.0");
        Assert.assertTrue((result.indexOf("ForbiddenFormat") > 0 ? 1 : 0) != 0);
        wms.getGetMapMimeTypes().clear();
        wms.setGetMapMimeTypeCheckingEnabled(false);
        this.getGeoServer().save((ServiceInfo)wms);
        result = this.getAsString("wms?bbox=" + this.bbox + "&styles=&layers=" + this.layers + "&Format=" + "text/html; subtype=openlayers" + "&request=GetMap&width=550&height=250&srs=EPSG:4326&version=1.3.0");
        Assert.assertTrue((result.indexOf("OpenLayers") > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVendorOptionClipVector() throws Exception {
        String bbox130 = "24,-130,50,-66";
        URL exptectedResponse = ((Object)((Object)this)).getClass().getResource("../wms_clip_vector.png");
        BufferedImage expectedImage = ImageIO.read(exptectedResponse);
        String polygonWkt = "POLYGON((-103.81153231351766%2038.73789567417218,-105.74512606351766%2031.78525172547746,-95.28614168851766%2028.053665204466157,-91.33106356351766%2031.260810654461146,-96.42871981351766%2038.66930662128952,-103.81153231351766%2038.73789567417218))";
        BufferedImage response = this.getAsImage("wms?bbox=" + bbox130 + "&styles=polygon&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&version=1.3.0&clip=" + polygonWkt, "image/png");
        ImageAssert.assertEquals((RenderedImage)expectedImage, (RenderedImage)response, (int)100);
        String polygonWkt900913 = "srid=900913;POLYGON ((-11556246.91561025 4684196.6150700655, -11771493.587261306 3735154.4718813156, -10607204.772421502 3255741.4304766906, -10166927.489498887 3666666.8945377995, -10734395.987488035 4674412.675449564, -11556246.91561025 4684196.6150700655))";
        response = this.getAsImage("wms?bbox=" + bbox130 + "&styles=polygon&layers=" + this.layers + "&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326&version=1.3.0&clip=" + polygonWkt900913, "image/png");
        ImageAssert.assertEquals((RenderedImage)expectedImage, (RenderedImage)response, (int)100);
    }

    @Test
    public void testVendorOptionClipRaster() throws Exception {
        URL exptectedResponse = ((Object)((Object)this)).getClass().getResource("../wms_clip_raster.png");
        BufferedImage expectedImage = ImageIO.read(exptectedResponse);
        String rasterMask = "POLYGON((-0.4455465239619838 49.03915485780325,27.679453476038034 48.692256255310134,34.53492222603802 32.400173313532584,5.355234726038036 37.161881019039605,-0.4455465239619838 49.03915485780325))";
        String worldBbox130 = "4.769752,-53.384768,57.719733,80.121092";
        BufferedImage response = this.getAsImage("wms?bbox=" + worldBbox130 + "&styles=&layers=wcs:World&Format=image/png&request=GetMap&width=550&height=250&crs=EPSG:4326&version=1.3.0&clip=" + rasterMask, "image/png");
        ImageAssert.assertEquals((RenderedImage)expectedImage, (RenderedImage)response, (int)100);
        String rasterMask900913 = "srid=900913;POLYGON ((-49598.01217216109 6281507.767506711, 3081262.66638866 6222804.1297836965, 3844409.956787858 3815954.983140064, 596142.0027810101 4461694.998093233, -49598.01217216109 6281507.767506711))";
        response = this.getAsImage("wms?bbox=" + worldBbox130 + "&styles=&layers=wcs:World&Format=image/png&request=GetMap&width=550&height=250&crs=EPSG:4326&version=1.3.0&clip=" + rasterMask900913, "image/png");
        ImageAssert.assertEquals((RenderedImage)expectedImage, (RenderedImage)response, (int)100);
    }

    @Test
    public void testPolarWithRenderingTransformation() throws Exception {
        GeoServer gs = this.getGeoServer();
        WMSInfo wms = (WMSInfo)gs.getService(WMSInfo.class);
        wms.getMetadata().put(WMS.ADVANCED_PROJECTION_KEY, (Serializable)Boolean.valueOf(true));
        gs.save((ServiceInfo)wms);
        String request = "wms?SERVICE=WMS&VERSION=1.3.0&REQUEST=GetMap&FORMAT=image%2Fpng&TRANSPARENT=true&LAYERS=" + this.getLayerId(RAIN) + "&STYLES=" + RAIN_RT_STYLE + "&WIDTH=512&HEIGHT=512&CRS=EPSG%3A3995&BBOX=-1128800,-1128800,10442400,10442400";
        BufferedImage response = this.getAsImage(request, "image/png");
        File expectedImage = new File("./src/test/resources/org/geoserver/wms/wms_1_3/filteredRainPolar.png");
        ImageAssert.assertEquals((File)expectedImage, (RenderedImage)response, (int)100);
    }
}

