/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.wms_1_1_1.CapabilitiesTest;
import org.geotools.styling.StyleImpl;
import org.junit.Test;
import org.w3c.dom.Document;

public class StyleCapabilitiesTest
extends WMSTestSupport {
    private static final String CAPABILITIES_REQUEST = "wms?request=getCapabilities&version=1.3.0";
    private static final String LAYER_NAME_WITH_STYLE_TITLE = "states_with_style_title";
    private static final String LAYER_NAME_WITHOUT_STYLE_TITLE = "states_without_style_title";
    private static final String LAYER_NAME_WITHOUT_STYLE_DESCRIPTION = "states_without_style_description";
    private static final String STYLE_NAME_WITH_TITLE = "style_with_style_title";
    private static final String STYLE_NAME_WITHOUT_TITLE = "style_without_style_title";
    private static final String STYLE_NAME_WITHOUT_DESCRIPTION = "style_without_style_description";
    private static final QName LAYER_WITH_SYTLE_TITLE = new QName(MockData.DEFAULT_URI, "states_with_style_title", MockData.DEFAULT_PREFIX);
    private static final QName LAYER_WITHOUT_STYLE_TITLE = new QName(MockData.DEFAULT_URI, "states_without_style_title", MockData.DEFAULT_PREFIX);
    private static final QName LAYER_WITHOUT_STYLE_DESCRIPTION = new QName(MockData.DEFAULT_URI, "states_without_style_description", MockData.DEFAULT_PREFIX);
    private static final String BASE = "src/test/resources/geoserver";

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle(STYLE_NAME_WITH_TITLE, "styleWithTitle.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(STYLE_NAME_WITHOUT_TITLE, "styleWithoutTitle.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle(STYLE_NAME_WITHOUT_DESCRIPTION, "styleWithoutDescription.sld", ((Object)((Object)this)).getClass(), catalog);
        HashMap<SystemTestData.LayerProperty, String> properties = new HashMap<SystemTestData.LayerProperty, String>();
        properties.put(SystemTestData.LayerProperty.STYLE, STYLE_NAME_WITH_TITLE);
        testData.addVectorLayer(LAYER_WITH_SYTLE_TITLE, properties, "states.properties", CapabilitiesTest.class, catalog);
        properties = new HashMap();
        properties.put(SystemTestData.LayerProperty.STYLE, STYLE_NAME_WITHOUT_TITLE);
        testData.addVectorLayer(LAYER_WITHOUT_STYLE_TITLE, properties, "states.properties", CapabilitiesTest.class, catalog);
        properties = new HashMap();
        properties.put(SystemTestData.LayerProperty.STYLE, STYLE_NAME_WITHOUT_DESCRIPTION);
        testData.addVectorLayer(LAYER_WITHOUT_STYLE_DESCRIPTION, properties, "states.properties", CapabilitiesTest.class, catalog);
        StyleImpl style = (StyleImpl)catalog.getStyleByName(STYLE_NAME_WITHOUT_DESCRIPTION).getStyle();
        style.setDescription(null);
        GeoServerInfo global = this.getGeoServer().getGlobal();
        global.getSettings().setProxyBaseUrl(BASE);
        this.getGeoServer().save(global);
        WMSInfo wms = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wms.getSRS().add("EPSG:4326");
        this.getGeoServer().save((ServiceInfo)wms);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("", "http://www.opengis.net/wms");
        namespaces.put("wms", "http://www.opengis.net/wms");
        SystemTestData cfr_ignored_0 = (SystemTestData)this.getTestData();
        SystemTestData.registerNamespaces(namespaces);
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
    }

    @Test
    public void testLayerStyleWithTitle() throws Exception {
        Document dom = this.dom(this.get(CAPABILITIES_REQUEST), false);
        XMLAssert.assertXpathEvaluatesTo((String)"Population in the United States", (String)this.getLayerStyleTitleXPath(LAYER_NAME_WITH_STYLE_TITLE), (Document)dom);
    }

    @Test
    public void testLayerStyleWithoutTitle() throws Exception {
        Document dom = this.dom(this.get(CAPABILITIES_REQUEST), false);
        XMLAssert.assertXpathEvaluatesTo((String)STYLE_NAME_WITHOUT_TITLE, (String)this.getLayerStyleTitleXPath(LAYER_NAME_WITHOUT_STYLE_TITLE), (Document)dom);
    }

    @Test
    public void testLayerStyleWithoutDescription() throws Exception {
        Document dom = this.dom(this.get(CAPABILITIES_REQUEST), false);
        XMLAssert.assertXpathEvaluatesTo((String)STYLE_NAME_WITHOUT_DESCRIPTION, (String)this.getLayerStyleTitleXPath(LAYER_NAME_WITHOUT_STYLE_DESCRIPTION), (Document)dom);
    }

    private String getLayerStyleTitleXPath(String layerName) {
        return "//wms:Layer[wms:Name='" + MockData.DEFAULT_PREFIX + ":" + layerName + "']/wms:Style/wms:Title";
    }
}

