/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.http.MockHttpResponse;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSCascadeTestSupport;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.test.ImageAssert;
import org.geotools.ows.wms.WebMapServer;
import org.geotools.ows.wms.request.GetLegendGraphicRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

@RunWith(value=Parameterized.class)
public class WMSCascadeTest
extends WMSCascadeTestSupport {
    private final boolean aphEnabled;

    @Parameterized.Parameters(name="{index} APH enabled: {0}")
    public static Collection<Object[]> getParameters() {
        return Arrays.asList({true}, {false});
    }

    public WMSCascadeTest(boolean aphEnabled) {
        this.aphEnabled = aphEnabled;
    }

    @Before
    public void setupAdvancedProjectionHandling() {
        GeoServer gs = this.getGeoServer();
        WMSInfo wms = (WMSInfo)gs.getService(WMSInfo.class);
        wms.getMetadata().put(WMS.ADVANCED_PROJECTION_KEY, (Serializable)Boolean.valueOf(this.aphEnabled));
        wms.setFeaturesReprojectionDisabled(false);
        gs.save((ServiceInfo)wms);
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        URL pngImage = WMSTestSupport.class.getResource("world.png");
        this.wms13Client.expectGet(new URL(this.wms13BaseURL + "?service=WMS&version=1.3.0&request=GetMap&layers=world4326&styles&bbox=-110.0,-200.0,110.0,200.0&crs=EPSG:4326&bgcolor=0xFFFFFF&transparent=FALSE&format=image/png&width=190&height=100"), (HTTPResponse)new MockHttpResponse(pngImage, "image/png", new String[0]));
        this.wms11Client.expectGet(new URL(this.wms11BaseURL + "?service=WMS&version=1.1.1&request=GetMap&layers=world4326&styles&bbox=-200.0,-110.0,200.0,110.0&srs=EPSG:4326&bgcolor=0xFFFFFF&transparent=FALSE&format=image/png&width=190&height=100"), (HTTPResponse)new MockHttpResponse(pngImage, "image/png", new String[0]));
        URL featureInfo = WMSTestSupport.class.getResource("wms-features.xml");
        this.wms13Client.expectGet(new URL(this.wms13BaseURL + "?SERVICE=WMS&INFO_FORMAT=application/vnd.ogc.gml&LAYERS=world4326&CRS=EPSG:4326&FEATURE_COUNT=50&FORMAT=image%2Fpng&HEIGHT=101&TRANSPARENT=TRUE&J=-609621&REQUEST=GetFeatureInfo&I=-875268&WIDTH=101&BBOX=-103.829117187,44.3898919295,-103.804563429,44.4069939679&STYLES=&QUERY_LAYERS=world4326&VERSION=1.3.0"), (HTTPResponse)new MockHttpResponse(featureInfo, "application/vnd.ogc.gml", new String[0]));
        this.wms13Client.expectGet(new URL(this.wms13BaseURL + "?SERVICE=WMS&INFO_FORMAT=application/vnd.ogc.gml&LAYERS=world4326&CRS=EPSG:4326&FEATURE_COUNT=50&FORMAT=image%2Fpng&HEIGHT=101&TRANSPARENT=TRUE&J=50&REQUEST=GetFeatureInfo&I=50&WIDTH=101&BBOX=-103.829117187,44.3898919295,-103.804563429,44.4069939679&STYLES=&QUERY_LAYERS=world4326&VERSION=1.3.0"), (HTTPResponse)new MockHttpResponse(featureInfo, "application/vnd.ogc.gml", new String[0]));
    }

    @Test
    public void testCascadeGetMapOnto13() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=-90,-180,90,180&styles=&layers=world4326_130&Format=image/png&request=GetMap&version=1.3.0&service=wms&width=180&height=90&crs=EPSG:4326");
        this.checkImage(response, "image/png", 180, 90);
    }

    @Test
    public void testCascadeGetMapOnto11() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=-90,-180,90,180&styles=&layers=world4326_110&Format=image/png&request=GetMap&version=1.3.0&service=wms&width=180&height=90&crs=EPSG:4326");
        this.checkImage(response, "image/png", 180, 90);
    }

    @Test
    public void testCascadeCapabilitiesClientNoGetFeatureInfo() throws Exception {
        Document dom = this.getAsDOM("wms?request=GetCapabilities&version=1.3.0&service=wms");
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("wms", "http://www.opengis.net/wms");
        namespaces.put("link", "http://www.w3.org/1999/xlink");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        SimpleNamespaceContext newNsCtxt = new SimpleNamespaceContext(namespaces);
        this.xpath.setNamespaceContext((NamespaceContext)newNsCtxt);
        this.xpath.evaluate("//wms:Layer[name='world4326_110_NFI']", dom);
    }

    @Test
    public void testGetFeatureInfoReprojection() throws Exception {
        String url = "wms?SERVICE=WMS&VERSION=1.3.0&REQUEST=GetFeatureInfo&FORMAT=image/png&TRANSPARENT=true&QUERY_LAYERS=world4326_130&STYLES&LAYERS=world4326_130&INFO_FORMAT=text/xml; subtype=gml/3.1.1&FEATURE_COUNT=50&X=50&Y=50&SRS=EPSG:4326&WIDTH=101&HEIGHT=101&BBOX=-103.829117187,44.3898919295,-103.804563429,44.4069939679";
        Document result = this.getAsDOM(url);
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("gml", "http://www.opengis.net/gml");
        namespaces.put("gs", "http://geoserver.org");
        namespaces.put("ogc", "http://www.opengis.net/ogc");
        namespaces.put("ows", "http://www.opengis.net/ows");
        namespaces.put("wfs", "http://www.opengis.net/wfs");
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("xs", "http://www.w3.org/2001/XMLSchema");
        namespaces.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        String srs = this.xpath.evaluate("//wfs:FeatureCollection/gml:featureMembers/gs:world4326_130[@gml:id='bugsites.55']/gs:the_geom/gml:Point/@srsName", result);
        Assert.assertThat((Object)srs, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)srs.contains("4326"), (Matcher)CoreMatchers.is((Object)true));
        String rawCoordinates = this.xpath.evaluate("//wfs:FeatureCollection/gml:featureMembers/gs:world4326_130[@gml:id='bugsites.55']/gs:the_geom/gml:Point/gml:pos/text()", result);
        Assert.assertThat((Object)rawCoordinates, (Matcher)CoreMatchers.notNullValue());
        String[] coordinates = rawCoordinates.split(" ");
        Assert.assertThat((Object)coordinates.length, (Matcher)CoreMatchers.is((Object)2));
        WMSCascadeTest.checkNumberSimilar(coordinates[0], 44.39832008, 1.0E-4);
        WMSCascadeTest.checkNumberSimilar(coordinates[1], -103.81711048, 1.0E-4);
        WMSInfo wms = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wms.setFeaturesReprojectionDisabled(true);
        this.getGeoServer().save((ServiceInfo)wms);
        result = this.getAsDOM(url);
        srs = this.xpath.evaluate("//wfs:FeatureCollection/gml:featureMembers/gs:world4326_130[@gml:id='bugsites.55']/gs:the_geom/gml:Point/@srsName", result);
        Assert.assertThat((Object)srs, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)srs.contains("3857"), (Matcher)CoreMatchers.is((Object)true));
        rawCoordinates = this.xpath.evaluate("//wfs:FeatureCollection/gml:featureMembers/gs:world4326_130[@gml:id='bugsites.55']/gs:the_geom/gml:Point/gml:pos/text()", result);
        Assert.assertThat((Object)rawCoordinates, (Matcher)CoreMatchers.notNullValue());
        coordinates = rawCoordinates.split(" ");
        Assert.assertThat((Object)coordinates.length, (Matcher)CoreMatchers.is((Object)2));
        WMSCascadeTest.checkNumberSimilar(coordinates[0], -1.1556867874E7, 1.0E-4);
        WMSCascadeTest.checkNumberSimilar(coordinates[1], 5527291.47718493, 1.0E-4);
    }

    @Test
    public void testCascadedSettings() throws Exception {
        LayerInfo info = this.getCatalog().getLayerByName("roads_wms_130");
        info.toString();
        String getMapRequest = "wms?bbox=589434.85646865,4914006.33783702,609527.21021496,4928063.39801461&styles=line1&layers=" + info.getName() + "&Format=image/png&request=GetMap&version=1.3.0&service=wms&width=180&height=90&crs=EPSG:26713";
        BufferedImage response = this.getAsImage(getMapRequest, "image/png");
        Assert.assertNotNull((Object)response);
        String getMapUnsupportedRequest = "wms?bbox=589434.85646865,4914006.33783702,609527.21021496,4928063.39801461&styles=line1&layers=" + info.getName() + "&Format=image/gif&request=GetMap&version=1.3.0&service=wms&width=180&height=90&crs=EPSG:26713";
        response = this.getAsImage(getMapUnsupportedRequest, "image/gif");
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testCascadeGetLegendRequest() throws Exception {
        URL exptectedResponse = ((Object)((Object)this)).getClass().getResource("../cascadedLegend.png");
        URL rasterLegendresource = ((Object)((Object)this)).getClass().getResource("../rasterLegend.png");
        BufferedImage expected = ImageIO.read(exptectedResponse);
        WMSLayerInfo layerInfo = (WMSLayerInfo)this.getCatalog().getLayerByName("world4326_110").getResource();
        WebMapServer webMapServer = layerInfo.getStore().getWebMapServer(null);
        webMapServer.getCapabilities().getRequest().getGetLegendGraphic().setGet(rasterLegendresource);
        GetLegendGraphicRequest getLegend = webMapServer.createGetLegendGraphicRequest();
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.3.0&request=GetLegendGraphic&layer=world4326_110&format=image/png&width=20&height=20&transparent=true", "image/png");
        Assert.assertNotNull((Object)image);
        ImageAssert.assertEquals((RenderedImage)expected, (RenderedImage)image, (int)0);
        Assert.assertNotEquals((long)20L, (long)image.getHeight());
        Assert.assertNotEquals((long)20L, (long)image.getWidth());
    }

    @Test
    public void testCascadeGetLegendRequestJSON() throws Exception {
        JSON dom = this.getAsJSON("wms?service=WMS&version=1.3.0&request=GetLegendGraphic&layer=roads_wms_130&format=application/json", 200);
        JSONObject responseJson = JSONObject.fromObject((Object)dom.toString());
        Assert.assertFalse((boolean)responseJson.isEmpty());
    }

    @Test
    public void testCascadeLayerGroup() throws Exception {
        String getMapRequest = "wms?service=WMS&version=1.3.0&request=GetMap&layers=roads_group_130&bbox=589434.85646865,4914006.33783702,609527.21021496,4928063.39801461&width=768&height=537&srs=EPSG:26713&Format=image/png";
        BufferedImage response = this.getAsImage(getMapRequest, "image/png");
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testLegacyCascadeLayerGroup() throws Exception {
        String getMapRequest = "wms?bbox=-90,-180,90,180&styles=&layers=cascaded_legacy_group_130&Format=image/png&request=GetMap&version=1.3.0&service=wms&width=180&height=90&crs=EPSG:4326";
        BufferedImage response = this.getAsImage(getMapRequest, "image/png");
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testCascadedBounds() throws Exception {
        LayerGroupInfo info = this.getCatalog().getLayerGroupByName("cascaded_group_130");
        LayerInfo groupLayer2 = this.getCatalog().getLayerByName("group_lyr_230");
        Assert.assertNotNull((Object)info);
        Assert.assertNotNull((Object)groupLayer2);
        ReferencedEnvelope request1 = new ReferencedEnvelope(groupLayer2.getResource().getNativeBoundingBox());
        String lyrBBox = request1.getMinX() + "," + request1.getMinY() + "," + request1.getMaxX() + "," + request1.getMaxY();
        String getMapRequest = "wms?service=WMS&version=1.3.0&request=GetMap&layers=" + info.getName() + "&bbox=" + lyrBBox + "&width=768&height=537&srs=EPSG:4326&Format=image/png";
        BufferedImage response = this.getAsImage(getMapRequest, "image/png");
        Assert.assertNotNull((Object)response);
        String lyrBBoxOutSideNativeBounds = "-10.0,0,-5.0,5";
        getMapRequest = "wms?service=WMS&version=1.3.0&request=GetMap&layers=" + info.getName() + "&bbox=" + lyrBBoxOutSideNativeBounds + "&width=768&height=537&srs=EPSG:4326&Format=image/png";
        response = this.getAsImage(getMapRequest, "image/png");
        Assert.assertNotNull((Object)response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScaleDenominator() throws Exception {
        LayerGroupInfo info = this.getCatalog().getLayerGroupByName("cascaded_group_130");
        LayerInfo groupLayer2 = this.getCatalog().getLayerByName("group_lyr_230");
        Assert.assertNotNull((Object)info);
        Assert.assertNotNull((Object)groupLayer2);
        ReferencedEnvelope request1 = new ReferencedEnvelope(groupLayer2.getResource().getNativeBoundingBox());
        String lyrBBox = request1.getMinX() + "," + request1.getMinY() + "," + request1.getMaxX() + "," + request1.getMaxY();
        WMSLayerInfo groupLayer1WMSResource = (WMSLayerInfo)this.getCatalog().getLayerByName("group_lyr_130").getResource();
        groupLayer1WMSResource.setMinScale(Double.valueOf(1.0));
        groupLayer1WMSResource.setMaxScale(Double.valueOf(1000.0));
        this.getCatalog().save((ResourceInfo)groupLayer1WMSResource);
        String getMapRequest = "wms?service=WMS&version=1.3.0&request=GetMap&layers=" + info.getName() + "&bbox=" + lyrBBox + "&width=768&height=537&srs=EPSG:4326&Format=image/png";
        try {
            BufferedImage response = this.getAsImage(getMapRequest, "image/png");
            Assert.assertNotNull((Object)response);
        }
        finally {
            groupLayer1WMSResource.setMinScale(null);
            groupLayer1WMSResource.setMaxScale(null);
            this.getCatalog().save((ResourceInfo)groupLayer1WMSResource);
        }
    }

    @Test
    public void testVendorOptionClip() throws Exception {
        URL exptectedResponse = ((Object)((Object)this)).getClass().getResource("../wms_clip_cascaded.png");
        BufferedImage expectedImage = ImageIO.read(exptectedResponse);
        String rasterMask = "POLYGON((-14.50804652396198 55.579454354599356,34.53492222603802 55.579454354599356,34.53492222603802 32.400173313532584,-14.50804652396198 32.400173313532584,-14.50804652396198 55.579454354599356))";
        BufferedImage response = this.getAsImage("wms?bbox=-90,-180,90,180&styles=&layers=world4326_110&Format=image/png&request=GetMap&version=1.3.0&service=wms&width=180&height=90&crs=EPSG:4326&clip=" + rasterMask, "image/png");
        ImageAssert.assertEquals((RenderedImage)expectedImage, (RenderedImage)response, (int)100);
        String rasterMask900913 = "srid=900913;POLYGON ((-1615028.3514525702 7475148.401208023, 3844409.956787858 7475148.401208023, 3844409.956787858 3815954.983140064, -1615028.3514525702 3815954.983140064, -1615028.3514525702 7475148.401208023))";
        response = this.getAsImage("wms?bbox=-90,-180,90,180&styles=&layers=world4326_110&Format=image/png&request=GetMap&version=1.3.0&service=wms&width=180&height=90&crs=EPSG:4326&clip=" + rasterMask900913, "image/png");
        ImageAssert.assertEquals((RenderedImage)expectedImage, (RenderedImage)response, (int)100);
    }

    @Test
    public void testGetFeatureInfoClipParam() throws Exception {
        String wkt = "POLYGON((-103.81422590870386 44.406335162406855,-103.81645750660425 44.39480642272217,-103.78839087147242 44.39210787899582,-103.78718924183374 44.40443430323224,-103.80598616261011 44.4091556783195,-103.81422590870386 44.406335162406855))";
        String url = "wms?SERVICE=WMS&VERSION=1.1.0&REQUEST=GetFeatureInfo&FORMAT=image/png&TRANSPARENT=true&QUERY_LAYERS=world4326_110&STYLES&LAYERS=world4326_110&INFO_FORMAT=application/json&FEATURE_COUNT=50&X=50&Y=50&SRS=EPSG:4326&WIDTH=101&HEIGHT=101&BBOX=-103.829117187,44.3898919295,-103.804563429,44.4069939679&CLIP=" + wkt;
        String json = this.getAsString(url);
        Assert.assertNotNull((Object)json);
        JSONObject responseJson = JSONObject.fromObject((Object)json);
        Assert.assertTrue((boolean)responseJson.getJSONArray("features").isEmpty());
    }
}

