/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.impl.LegendInfoImpl;
import org.geoserver.catalog.impl.WMSLayerInfoImpl;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geotools.data.ows.HTTPClient;
import org.geotools.data.ows.HTTPResponse;
import org.geotools.data.ows.Response;
import org.geotools.ows.wms.request.AbstractGetLegendGraphicRequest;
import org.geotools.ows.wms.response.GetLegendGraphicResponse;

public final class CascadedLegendRequest
extends GetLegendGraphicRequest.LegendRequest {
    private static final Logger LOGGER = Logger.getLogger(CascadedLegendRequest.class.getName());
    private final GetLegendGraphicRequest request;
    private org.geotools.ows.wms.request.GetLegendGraphicRequest remoteLegendGraphicRequest;

    public CascadedLegendRequest(GetLegendGraphicRequest request) {
        this.request = request;
        LegendInfoImpl info = new LegendInfoImpl();
        info.setFormat(this.request.getFormat());
        info.setWidth(this.request.getWidth());
        info.setHeight(this.request.getHeight());
        super.setLegendInfo((LegendInfo)info);
    }

    public org.geotools.ows.wms.request.GetLegendGraphicRequest getRemoteLegendGraphicRequest() {
        return this.remoteLegendGraphicRequest;
    }

    public void setRemoteLegendGraphicRequest(org.geotools.ows.wms.request.GetLegendGraphicRequest remoteLegendGraphicRequest) {
        this.remoteLegendGraphicRequest = remoteLegendGraphicRequest;
        Map<String, String> params = this.request.getRawKvp();
        params.keySet().forEach(k -> {
            if (!k.equalsIgnoreCase("layer")) {
                this.remoteLegendGraphicRequest.setProperty(k, String.valueOf(params.get(k)));
            }
        });
        super.getLegendInfo().setOnlineResource(this.remoteLegendGraphicRequest.getFinalURL().toExternalForm());
        LOGGER.fine("Cascaded GetLegend Request URL: " + super.getLegendInfo().getOnlineResource());
    }

    public GetLegendGraphicRequest getDelegate() {
        return this.request;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public JSONArray getCascadedJSONRules() {
        try {
            WMSLayerInfo wmsLayerInfo = (WMSLayerInfo)this.getLayerInfo().getResource();
            StyleInfo defaultRemoteStyle = this.getLayerInfo().getDefaultStyle();
            if (defaultRemoteStyle == WMSLayerInfoImpl.DEFAULT_ON_REMOTE) {
                return null;
            }
            HTTPClient client = wmsLayerInfo.getStore().getWebMapServer(null).getHTTPClient();
            HTTPResponse jsonResponse = client.get(new URL(super.getLegendInfo().getOnlineResource()));
            try (InputStream is = jsonResponse.getResponseStream();){
                JSONArray jSONArray;
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));){
                    JSONArray cascadedRules;
                    int cp;
                    StringBuilder sb = new StringBuilder();
                    while ((cp = bufferedReader.read()) != -1) {
                        sb.append((char)cp);
                    }
                    String jsonText = sb.toString();
                    LOGGER.fine("Cascaded GetLegend Request JSON Response: " + jsonText);
                    JSONObject jsonLegend = JSONObject.fromObject((Object)jsonText);
                    JSONArray layerLegends = jsonLegend.getJSONArray("Legend");
                    jSONArray = cascadedRules = layerLegends.getJSONObject(0).getJSONArray("rules");
                }
                return jSONArray;
            }
        }
        catch (Exception e) {
            throw new ServiceException("Unable to cascade Legend");
        }
    }

    public static class GetLegendGraphicRequestV1_3_0
    extends AbstractGetLegendGraphicRequest {
        public GetLegendGraphicRequestV1_3_0(URL onlineResource, String version) {
            super(onlineResource);
            this.setProperty("VERSION", version);
        }

        protected void initVersion() {
            this.setProperty("VERSION", "1.3.0");
        }

        public Response createResponse(HTTPResponse httpResponse) throws org.geotools.ows.ServiceException, IOException {
            return new GetLegendGraphicResponse(httpResponse);
        }
    }
}

