/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;

class MaxAnimationTimeHelper {
    private int maxRenderingTime;
    private long requestStart;

    public MaxAnimationTimeHelper(WMS wms, GetMapRequest request) {
        this.maxRenderingTime = wms.getMaxAnimationRenderingTime(request);
        if (this.maxRenderingTime > 0) {
            this.requestStart = System.currentTimeMillis();
        }
    }

    public void checkTimeout() throws ServiceException {
        if (this.maxRenderingTime <= 0) {
            return;
        }
        int elapsed = (int)(System.currentTimeMillis() - this.requestStart);
        int residual = this.maxRenderingTime - elapsed;
        if (residual <= 0) {
            throw new ServiceException("This animation request used more time than allowed and has been forcefully stopped. The max animation rendering time is " + (double)this.maxRenderingTime / 1000.0 + "s");
        }
    }
}

