/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.wms.WMSMapContent;
import org.geotools.filter.function.EnvFunction;
import org.geotools.util.logging.Logging;

public class RenderingVariables {
    static final Logger LOGGER = Logging.getLogger(RenderingVariables.class);

    public static void setupEnvironmentVariables(WMSMapContent mapContent) {
        EnvFunction.setLocalValue((String)"wms_bbox", (Object)mapContent.getRenderingArea());
        EnvFunction.setLocalValue((String)"wms_crs", (Object)mapContent.getRenderingArea().getCoordinateReferenceSystem());
        EnvFunction.setLocalValue((String)"wms_srs", (Object)mapContent.getRequest().getSRS());
        EnvFunction.setLocalValue((String)"wms_width", (Object)mapContent.getMapWidth());
        EnvFunction.setLocalValue((String)"wms_height", (Object)mapContent.getMapHeight());
        try {
            double scaleDenominator = mapContent.getScaleDenominator(true);
            EnvFunction.setLocalValue((String)"wms_scale_denominator", (Object)scaleDenominator);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to compute the scale denominator, wms_scale_denominator env variable is unset", e);
        }
    }
}

