/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.geoserver.threadlocals.ThreadLocalsTransfer;

class ThreadLocalTransferExecutor
extends ThreadPoolExecutor {
    public ThreadLocalTransferExecutor() {
        super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    @Override
    public Future<?> submit(Runnable task) {
        ThreadLocalsTransfer threadLocalTransfer = new ThreadLocalsTransfer();
        return super.submit(() -> {
            threadLocalTransfer.apply();
            try {
                task.run();
            }
            finally {
                threadLocalTransfer.cleanup();
            }
        });
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        ThreadLocalsTransfer threadLocalTransfer = new ThreadLocalsTransfer();
        return super.submit(() -> {
            threadLocalTransfer.apply();
            try {
                Object v = task.call();
                return v;
            }
            finally {
                threadLocalTransfer.cleanup();
            }
        });
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        ThreadLocalsTransfer threadLocalTransfer = new ThreadLocalsTransfer();
        return super.submit(() -> {
            threadLocalTransfer.apply();
            try {
                task.run();
                Object object = result;
                return object;
            }
            finally {
                threadLocalTransfer.cleanup();
            }
        });
    }
}

