/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import org.geoserver.catalog.AuthorityURLInfo;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.util.AuthorityURLInfoInfoListConverter;
import org.geoserver.config.util.LayerIdentifierInfoListConverter;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.wms.CacheConfiguration;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSInfoImpl;
import org.geoserver.wms.WatermarkInfo;
import org.geoserver.wms.WatermarkInfoImpl;
import org.geotools.util.Version;

public class WMSXStreamLoader
extends XStreamServiceLoader<WMSInfo> {
    public WMSXStreamLoader(GeoServerResourceLoader resourceLoader) {
        super(resourceLoader, "wms");
    }

    public Class<WMSInfo> getServiceClass() {
        return WMSInfo.class;
    }

    protected WMSInfo createServiceFromScratch(GeoServer gs) {
        WMSInfoImpl wms = new WMSInfoImpl();
        wms.setName("WMS");
        return wms;
    }

    protected void initXStreamPersister(XStreamPersister xp, GeoServer gs) {
        super.initXStreamPersister(xp, gs);
        WMSXStreamLoader.initXStreamPersister(xp);
    }

    public static void initXStreamPersister(XStreamPersister xp) {
        XStream xs = xp.getXStream();
        xs.alias("wms", WMSInfo.class, WMSInfoImpl.class);
        xs.registerConverter((Converter)new WMSInfoConverter(xp));
        xs.addDefaultImplementation(WatermarkInfoImpl.class, WatermarkInfo.class);
        xs.allowTypes(new Class[]{WatermarkInfo.class, WatermarkInfoImpl.class, CacheConfiguration.class});
    }

    protected WMSInfo initialize(WMSInfo service) {
        super.initialize((ServiceInfo)service);
        Version version_1_1_1 = WMS.VERSION_1_1_1;
        Version version_1_3_0 = WMS.VERSION_1_3_0;
        if (!service.getVersions().contains(version_1_1_1)) {
            service.getVersions().add(version_1_1_1);
        }
        if (!service.getVersions().contains(version_1_3_0)) {
            service.getVersions().add(version_1_3_0);
        }
        if (service.getSRS() == null) {
            ((WMSInfoImpl)service).setSRS(new ArrayList<String>());
        }
        if (service.getGetFeatureInfoMimeTypes() == null) {
            ((WMSInfoImpl)service).setGetFeatureInfoMimeTypes(new HashSet<String>());
        }
        if (service.getGetMapMimeTypes() == null) {
            ((WMSInfoImpl)service).setGetMapMimeTypes(new HashSet<String>());
        }
        if (service.getInterpolation() == null) {
            service.setInterpolation(WMSInfo.WMSInterpolation.Nearest);
        }
        return service;
    }

    static class WMSInfoConverter
    extends XStreamPersister.ServiceInfoConverter {
        public WMSInfoConverter(XStreamPersister xp) {
            XStreamPersister xStreamPersister = xp;
            Objects.requireNonNull(xStreamPersister);
            super(xStreamPersister, WMSInfo.class);
        }

        public boolean canConvert(Class type) {
            return WMSInfo.class.isAssignableFrom(type);
        }

        protected void doMarshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            super.doMarshal(source, writer, context);
        }

        public Object doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
            String serialized;
            WMSInfoImpl service = (WMSInfoImpl)super.doUnmarshal(result, reader, context);
            MetadataMap metadata = service.getMetadata();
            if (service.getAuthorityURLs() == null && metadata != null) {
                serialized = (String)metadata.get("authorityURLs", String.class);
                ArrayList<AuthorityURLInfo> authorities = serialized == null ? new ArrayList<AuthorityURLInfo>(1) : AuthorityURLInfoInfoListConverter.fromString((String)serialized);
                service.setAuthorityURLs(authorities);
            }
            if (service.getIdentifiers() == null && metadata != null) {
                serialized = (String)metadata.get("identifiers", String.class);
                ArrayList<LayerIdentifierInfo> identifiers = serialized == null ? new ArrayList<LayerIdentifierInfo>(1) : LayerIdentifierInfoListConverter.fromString((String)serialized);
                service.setIdentifiers(identifiers);
            }
            return service;
        }
    }
}

