/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.ExtendedCapabilitiesProvider;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.AuthorityURLInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataLinkInfo;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.ows.URLMangler;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.json.JSONType;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.capabilities.CapabilitiesTransformerProjectionHandler;
import org.geoserver.wms.capabilities.CapabilityUtil;
import org.geoserver.wms.capabilities.DimensionHelper;
import org.geoserver.wms.capabilities.LayerTree;
import org.geoserver.wms.capabilities.LegendSample;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.locationtech.jts.geom.Envelope;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;
import org.springframework.util.Assert;
import org.vfny.geoserver.util.ResponseUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class Capabilities_1_3_0_Transformer
extends TransformerBase {
    private static final String NAMESPACE = "http://www.opengis.net/wms";
    public static final String WMS_CAPS_MIME = "text/xml";
    static final String[] EXCEPTION_FORMATS = new String[]{"XML", "INIMAGE", "BLANK", "JSON"};
    private String schemaBaseURL;
    private Collection<GetMapOutputFormat> getMapFormats;
    private Collection<ExtendedCapabilitiesProvider> extCapsProviders;
    private WMS wmsConfig;
    private Boolean includeRootLayer = null;

    public Capabilities_1_3_0_Transformer(WMS wms, String schemaBaseUrl, Collection<GetMapOutputFormat> getMapFormats, Collection<ExtendedCapabilitiesProvider> extCapsProviders) {
        Assert.notNull((Object)wms, (String)"The WMS reference cannot be null");
        Assert.notNull((Object)schemaBaseUrl, (String)"baseURL");
        Assert.notNull(getMapFormats, (String)"getMapFormats");
        this.wmsConfig = wms;
        this.getMapFormats = getMapFormats;
        this.extCapsProviders = extCapsProviders;
        this.schemaBaseURL = schemaBaseUrl;
        this.setNamespaceDeclarationEnabled(true);
        this.setIndentation(2);
        Charset encoding = wms.getCharSet();
        this.setEncoding(encoding);
    }

    public void setIncludeRootLayer(Boolean includeRootLayer) {
        this.includeRootLayer = includeRootLayer;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new Capabilities_1_3_0_Translator(handler, this.wmsConfig, this.getMapFormats, this.extCapsProviders, this.schemaBaseURL, this.includeRootLayer);
    }

    private static class Capabilities_1_3_0_Translator
    extends TransformerBase.TranslatorSupport {
        private static final String XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
        private static final Logger LOGGER = Logging.getLogger(Capabilities_1_3_0_Translator.class);
        private static final String EPSG = "EPSG:";
        private static final String XLINK_NS = "http://www.w3.org/1999/xlink";
        private GetCapabilitiesRequest request;
        private Collection<GetMapOutputFormat> getMapFormats;
        private Collection<ExtendedCapabilitiesProvider> extCapsProviders;
        private WMS wmsConfig;
        private String schemaBaseURL;
        DimensionHelper dimensionHelper;
        private boolean skipping;
        private WMSInfo serviceInfo;
        private LegendSample legendSample;
        private Boolean includeRootLayer;

        public Capabilities_1_3_0_Translator(ContentHandler handler, WMS wmsConfig, Collection<GetMapOutputFormat> getMapFormats, Collection<ExtendedCapabilitiesProvider> extCapsProviders, String schemaBaseURL, Boolean includeRootLayer) {
            super(handler, null, null);
            this.wmsConfig = wmsConfig;
            this.getMapFormats = getMapFormats;
            this.extCapsProviders = extCapsProviders;
            this.schemaBaseURL = schemaBaseURL;
            this.serviceInfo = wmsConfig.getServiceInfo();
            this.dimensionHelper = new DimensionHelper(DimensionHelper.Mode.WMS13, wmsConfig){

                @Override
                protected void element(String element, String content, Attributes atts) {
                    this.element(element, content, atts);
                }

                @Override
                protected void element(String element, String content) {
                    this.element(element, content);
                }
            };
            this.legendSample = (LegendSample)GeoServerExtensions.bean(LegendSample.class);
            this.skipping = ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS.equals((Object)wmsConfig.getGeoServer().getGlobal().getResourceErrorHandling());
            for (ExtendedCapabilitiesProvider cp : extCapsProviders) {
                cp.registerNamespaces(this.getNamespaceSupport());
            }
            this.includeRootLayer = includeRootLayer;
        }

        private AttributesImpl attributes(String ... kvp) {
            String[] atts = kvp;
            AttributesImpl attributes = new AttributesImpl();
            for (int i = 0; i < atts.length; i += 2) {
                String name = atts[i];
                String value = atts[i + 1];
                attributes.addAttribute("", name, name, "", value);
            }
            return attributes;
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof GetCapabilitiesRequest)) {
                throw new IllegalArgumentException();
            }
            this.request = (GetCapabilitiesRequest)o;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("producing a capabilities document for ").append(this.request).toString());
            }
            String schemaLocation = this.buildSchemaLocation();
            String updateSequence = String.valueOf(this.wmsConfig.getUpdateSequence());
            AttributesImpl rootAtts = this.attributes("version", "1.3.0", "updateSequence", updateSequence, "xmlns", Capabilities_1_3_0_Transformer.NAMESPACE, "xmlns:xlink", XLINK_NS, "xmlns:xsi", XML_SCHEMA_INSTANCE, "xsi:schemaLocation", schemaLocation);
            this.start("WMS_Capabilities", rootAtts);
            this.handleService();
            this.handleCapability();
            this.end("WMS_Capabilities");
        }

        private String buildSchemaLocation() {
            StringBuffer schemaLocation = new StringBuffer();
            schemaLocation.append(this.schemaLocation(Capabilities_1_3_0_Transformer.NAMESPACE, "wms/1.3.0/capabilities_1_3_0.xsd"));
            for (ExtendedCapabilitiesProvider cp : this.extCapsProviders) {
                String[] locations = cp.getSchemaLocations(this.schemaBaseURL);
                try {
                    for (int i = 0; i < locations.length - 1; i += 2) {
                        schemaLocation.append(" ");
                        schemaLocation.append(this.schemaLocation(locations[i], locations[i + 1]));
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new ServiceException("Extended capabilities provider returned improper set of namespace,location pairs from getSchemaLocations()", (Throwable)e);
                }
            }
            return schemaLocation.toString();
        }

        String schemaLocation(String namespace, String uri) {
            String location = null;
            try {
                new URL(uri);
                location = uri;
            }
            catch (MalformedURLException e) {
                location = org.geoserver.ows.util.ResponseUtils.buildSchemaURL((String)this.schemaBaseURL, (String)uri);
            }
            return namespace + " " + location;
        }

        private void handleService() {
            this.start("Service");
            this.element("Name", "WMS");
            this.element("Title", this.serviceInfo.getTitle());
            this.element("Abstract", this.serviceInfo.getAbstract());
            this.handleKeywordList(this.serviceInfo.getKeywords());
            String onlineResource = this.serviceInfo.getOnlineResource();
            if (onlineResource == null || onlineResource.trim().length() == 0) {
                String requestBaseUrl = this.request.getBaseUrl();
                onlineResource = org.geoserver.ows.util.ResponseUtils.buildURL((String)requestBaseUrl, null, null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            } else {
                try {
                    new URL(onlineResource);
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.WARNING, "WMS online resource seems to be an invalid URL: '" + onlineResource + "'");
                }
            }
            AttributesImpl attributes = this.attributes("xlink:type", "simple", "xlink:href", onlineResource);
            this.element("OnlineResource", null, attributes);
            GeoServer geoServer = this.wmsConfig.getGeoServer();
            ContactInfo contact = geoServer.getSettings().getContact();
            this.handleContactInfo(contact);
            String fees = this.serviceInfo.getFees();
            this.element("Fees", fees == null ? "none" : fees);
            String constraints = this.serviceInfo.getAccessConstraints();
            this.element("AccessConstraints", constraints == null ? "none" : constraints);
            this.end("Service");
        }

        public void handleContactInfo(ContactInfo contact) {
            this.start("ContactInformation");
            this.start("ContactPersonPrimary");
            this.element("ContactPerson", contact.getContactPerson());
            this.element("ContactOrganization", contact.getContactOrganization());
            this.end("ContactPersonPrimary");
            this.element("ContactPosition", contact.getContactPosition());
            this.start("ContactAddress");
            this.element("AddressType", contact.getAddressType());
            this.element("Address", contact.getAddress());
            this.element("City", contact.getAddressCity());
            this.element("StateOrProvince", contact.getAddressState());
            this.element("PostCode", contact.getAddressPostalCode());
            this.element("Country", contact.getAddressCountry());
            this.end("ContactAddress");
            this.element("ContactVoiceTelephone", contact.getContactVoice());
            this.element("ContactFacsimileTelephone", contact.getContactFacsimile());
            this.element("ContactElectronicMailAddress", contact.getContactEmail());
            this.end("ContactInformation");
        }

        private void handleKeywordList(List<KeywordInfo> keywords) {
            this.start("KeywordList");
            if (keywords != null) {
                for (KeywordInfo kw : keywords) {
                    AttributesImpl atts = new AttributesImpl();
                    if (kw.getVocabulary() != null) {
                        atts.addAttribute("", "vocabulary", "vocabulary", "", kw.getVocabulary());
                    }
                    this.element("Keyword", kw.getValue(), atts);
                }
            }
            this.end("KeywordList");
        }

        private void handleMetadataList(Collection<MetadataLinkInfo> metadataURLs) {
            if (metadataURLs == null) {
                return;
            }
            for (MetadataLinkInfo link : metadataURLs) {
                AttributesImpl lnkAtts = new AttributesImpl();
                lnkAtts.addAttribute("", "type", "type", "", link.getMetadataType());
                this.start("MetadataURL", lnkAtts);
                this.element("Format", link.getType());
                String content = ResponseUtils.proxifyMetadataLink((MetadataLinkInfo)link, (String)this.request.getBaseUrl());
                AttributesImpl orAtts = this.attributes("xlink:type", "simple", "xlink:href", content);
                this.element("OnlineResource", null, orAtts);
                this.end("MetadataURL");
            }
        }

        private void handleDataList(Collection<DataLinkInfo> dataURLs) {
            if (dataURLs == null) {
                return;
            }
            for (DataLinkInfo link : dataURLs) {
                this.start("DataURL");
                this.element("Format", link.getType());
                String content = ResponseUtils.proxifyDataLink((DataLinkInfo)link, (String)this.request.getBaseUrl());
                AttributesImpl orAtts = this.attributes("xlink:type", "simple", "xlink:href", content);
                this.element("OnlineResource", null, orAtts);
                this.end("DataURL");
            }
        }

        private void handleCapability() {
            this.start("Capability");
            this.handleRequest();
            this.handleException();
            this.handleExtendedCapabilities();
            this.handleLayers();
            this.end("Capability");
        }

        private void handleRequest() {
            this.start("Request");
            this.start("GetCapabilities");
            this.element("Format", Capabilities_1_3_0_Transformer.WMS_CAPS_MIME);
            String serviceUrl = org.geoserver.ows.util.ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"ows", (Map)org.geoserver.ows.util.ResponseUtils.params((String[])new String[]{"SERVICE", "WMS"}), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            serviceUrl = org.geoserver.ows.util.ResponseUtils.appendQueryString((String)serviceUrl, (String)"");
            this.handleDcpType(serviceUrl, serviceUrl);
            this.end("GetCapabilities");
            this.start("GetMap");
            LinkedHashSet<String> formats = new LinkedHashSet<String>();
            for (GetMapOutputFormat format : this.getMapFormats) {
                if (format.getOutputFormatNames().contains(format.getMimeType())) {
                    formats.add(format.getMimeType());
                    continue;
                }
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.warning("Map output format " + format.getMimeType() + " (" + format.getClass() + ") does not include mime type in output format names. Will be excluded from capabilities document.");
            }
            ArrayList<String> sortedFormats = new ArrayList<String>(formats);
            Collections.sort(sortedFormats);
            if (sortedFormats.contains("image/png")) {
                sortedFormats.remove("image/png");
                sortedFormats.add(0, "image/png");
            }
            for (String format : sortedFormats) {
                this.element("Format", format);
            }
            this.handleDcpType(serviceUrl, null);
            this.end("GetMap");
            this.start("GetFeatureInfo");
            for (String format : this.wmsConfig.getAllowedFeatureInfoFormats()) {
                this.element("Format", format);
            }
            this.handleDcpType(serviceUrl, null);
            this.end("GetFeatureInfo");
            this.end("Request");
        }

        private void handleDcpType(String getUrl, String postUrl) {
            AttributesImpl orAtts = new AttributesImpl();
            orAtts.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
            orAtts.addAttribute(XLINK_NS, "href", "xlink:href", "", getUrl);
            this.start("DCPType");
            this.start("HTTP");
            if (getUrl != null) {
                this.start("Get");
                this.element("OnlineResource", null, orAtts);
                this.end("Get");
            }
            if (postUrl != null) {
                orAtts.setAttribute(1, "", "href", "xlink:href", "", postUrl);
                this.start("Post");
                this.element("OnlineResource", null, orAtts);
                this.end("Post");
            }
            this.end("HTTP");
            this.end("DCPType");
        }

        private void handleException() {
            this.start("Exception");
            for (String exceptionFormat : EXCEPTION_FORMATS) {
                this.element("Format", exceptionFormat);
            }
            if (JSONType.isJsonpEnabled()) {
                this.element("Format", "JSONP");
            }
            this.end("Exception");
        }

        private void handleExtendedCapabilities() {
            for (ExtendedCapabilitiesProvider cp : this.extCapsProviders) {
                try {
                    cp.encode(new ExtendedCapabilitiesProvider.Translator(){

                        public void start(String element) {
                            this.start(element);
                        }

                        public void start(String element, Attributes attributes) {
                            this.start(element, attributes);
                        }

                        public void chars(String text) {
                            this.chars(text);
                        }

                        public void end(String element) {
                            this.end(element);
                        }
                    }, this.serviceInfo, this.request);
                }
                catch (Exception e) {
                    throw new ServiceException("Extended capabilities provider threw error", (Throwable)e);
                }
            }
        }

        private void handleLayers() {
            ArrayList layers;
            ArrayList layerGroups;
            SortBy lgOrder = Predicates.asc((String)"name");
            SortBy order = Predicates.asc((String)"name");
            Catalog catalog = this.wmsConfig.getCatalog();
            Filter enabled = Predicates.equal((String)"enabled", (Object)Boolean.TRUE);
            Filter advertised = Predicates.equal((String)"advertised", (Object)Boolean.TRUE);
            Filter filter = Predicates.and((Filter)enabled, (Filter)advertised);
            filter = this.addNameSpaceFilterIfNeed(filter, "resource.namespace.prefix");
            Filter lgFilter = Predicates.acceptAll();
            lgFilter = this.addNameSpaceFilterIfNeed(lgFilter, "workspace.name");
            try (CloseableIterator lgIter = catalog.list(LayerGroupInfo.class, lgFilter, null, null, lgOrder);
                 CloseableIterator iter = catalog.list(LayerInfo.class, filter, null, null, order);){
                layerGroups = Lists.newArrayList((Iterator)lgIter);
                layers = Lists.newArrayList((Iterator)iter);
            }
            Set<LayerInfo> layersAlreadyProcessed = this.getLayersInGroups(new ArrayList<LayerGroupInfo>(layerGroups));
            if (this.includeRootLayer(layers, layerGroups, layersAlreadyProcessed)) {
                this.start("Layer");
                if (StringUtils.isBlank((CharSequence)this.serviceInfo.getRootLayerTitle())) {
                    this.element("Title", this.serviceInfo.getTitle());
                } else {
                    this.element("Title", this.serviceInfo.getRootLayerTitle());
                }
                if (StringUtils.isBlank((CharSequence)this.serviceInfo.getRootLayerAbstract())) {
                    this.element("Abstract", this.serviceInfo.getAbstract());
                } else {
                    this.element("Abstract", this.serviceInfo.getRootLayerAbstract());
                }
                Set<String> srs = this.getServiceSRSList();
                this.handleRootCrsList(srs);
                this.handleRootBbox(layers, layerGroups);
                this.handleAuthorityURL(this.serviceInfo.getAuthorityURLs());
                this.handleLayerIdentifiers(this.serviceInfo.getIdentifiers());
                try {
                    this.handleLayerGroups(layerGroups, false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't obtain Envelope of Layer-Groups: " + e.getMessage(), e);
                }
                this.handleLayerTree(layers, layersAlreadyProcessed, false);
                this.end("Layer");
            } else if (layerGroups.size() > 0) {
                try {
                    this.handleLayerGroups(new ArrayList<LayerGroupInfo>(layerGroups), true);
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't obtain Envelope of Layer-Groups: " + e.getMessage(), e);
                }
            } else {
                this.handleLayerTree(layers, layersAlreadyProcessed, true);
            }
        }

        private Set<String> getServiceSRSList() {
            List<String> srsList = this.serviceInfo.getSRS();
            LinkedHashSet<String> srs = new LinkedHashSet<String>();
            if (srsList != null) {
                srs.addAll(srsList);
            }
            for (ExtendedCapabilitiesProvider provider : this.extCapsProviders) {
                provider.customizeRootCrsList(srs);
            }
            return srs;
        }

        private boolean includeRootLayer(List<LayerInfo> layers, List<LayerGroupInfo> layerGroups, Set<LayerInfo> layersAlreadyProcessed) {
            PublishedInfo singleRoot = this.getSingleRoot(layers, layerGroups, layersAlreadyProcessed);
            if (singleRoot != null) {
                if (this.includeRootLayer != null) {
                    return this.includeRootLayer;
                }
                Boolean layerIncludeRoot = (Boolean)singleRoot.getMetadata().get("rootInCapabilities", Boolean.class);
                if (layerIncludeRoot != null) {
                    return layerIncludeRoot;
                }
                return this.wmsConfig.isRootLayerInCapabilitesEnabled();
            }
            return true;
        }

        private PublishedInfo getSingleRoot(List<LayerInfo> layers, List<LayerGroupInfo> layerGroups, Set<LayerInfo> layersAlreadyProcessed) {
            List rootLayers = layers.stream().filter(layer -> this.includeLayer(layersAlreadyProcessed, (LayerInfo)layer)).collect(Collectors.toList());
            List<LayerGroupInfo> rootGroups = this.filterNestedGroups(layerGroups);
            if (rootLayers.size() == 1 && rootGroups.size() == 0) {
                return (PublishedInfo)rootLayers.get(0);
            }
            if (rootLayers.size() == 0 && rootGroups.size() == 1) {
                return (PublishedInfo)rootGroups.get(0);
            }
            return null;
        }

        private Filter addNameSpaceFilterIfNeed(Filter filter, String nameSpaceProperty) {
            String nameSpacePrefix = this.request.getNamespace();
            if (nameSpacePrefix == null) {
                return filter;
            }
            Filter equals = Predicates.equal((String)nameSpaceProperty, (Object)nameSpacePrefix);
            return Predicates.and((Filter)filter, (Filter)equals);
        }

        private void handleRootCrsList(Set<String> epsgCodes) {
            LinkedHashSet<Object> capabilitiesCrsIdentifiers;
            if (epsgCodes.isEmpty()) {
                this.comment("All supported EPSG projections:");
                capabilitiesCrsIdentifiers = new LinkedHashSet();
                for (String code : CRS.getSupportedCodes((String)"AUTO")) {
                    if ("WGS84(DD)".equals(code)) continue;
                    capabilitiesCrsIdentifiers.add("AUTO:" + code);
                }
                capabilitiesCrsIdentifiers.addAll(CRS.getSupportedCodes((String)"EPSG"));
            } else {
                this.comment("Limited list of EPSG projections:");
                capabilitiesCrsIdentifiers = new LinkedHashSet<String>(epsgCodes);
            }
            try {
                for (String string : capabilitiesCrsIdentifiers) {
                    if ("WGS84(DD)".equals(string)) continue;
                    String currentSRS = this.qualifySRS(string);
                    this.element("CRS", currentSRS);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            this.element("CRS", "CRS:84");
        }

        private String qualifySRS(String srs) {
            if (srs.indexOf(58) == -1) {
                srs = EPSG + srs;
            }
            return srs;
        }

        private void handleRootBbox(List<LayerInfo> layers, List<LayerGroupInfo> layersGroups) {
            Envelope world = new Envelope(-180.0, 180.0, -90.0, 90.0);
            Envelope latlonBbox = new Envelope();
            LOGGER.finer("Collecting summarized latlonbbox and common SRS...");
            for (LayerInfo layer : layers) {
                if (this.expandEnvelopeToContain(world, latlonBbox, (Envelope)layer.getResource().getLatLonBoundingBox())) break;
            }
            for (LayerGroupInfo layerGroup : layersGroups) {
                ReferencedEnvelope referencedEnvelope = layerGroup.getBounds();
                if (referencedEnvelope == null) continue;
                if (!CRS.equalsIgnoreMetadata((Object)referencedEnvelope, (Object)DefaultGeographicCRS.WGS84)) {
                    try {
                        referencedEnvelope = referencedEnvelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.WARNING, String.format("Failed to transform layer group '%s' bounds to WGS84.", layerGroup.getName()), exception);
                    }
                }
                if (!this.expandEnvelopeToContain(world, latlonBbox, (Envelope)referencedEnvelope)) continue;
                break;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Summarized LatLonBBox is " + latlonBbox);
            }
            this.handleGeographicBoundingBox(latlonBbox);
            this.handleBBox(latlonBbox, "CRS:84");
            this.handleAdditionalBBox(new ReferencedEnvelope(latlonBbox, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), null, null);
        }

        private boolean expandEnvelopeToContain(Envelope world, Envelope envelope, Envelope resourceEnvelope) {
            if (resourceEnvelope != null) {
                envelope.expandToInclude(resourceEnvelope);
            }
            return envelope.contains(world);
        }

        private boolean includeLayer(Set<LayerInfo> layersAlreadyProcessed, LayerInfo layer) {
            return layer.enabled() && !layersAlreadyProcessed.contains(layer) && this.isExposable(layer);
        }

        private void handleLayerTree(List<LayerInfo> layers, Set<LayerInfo> layersAlreadyProcessed, boolean isRoot) {
            LayerTree nestedLayers = new LayerTree();
            for (LayerInfo layer : layers) {
                if (!this.includeLayer(layersAlreadyProcessed, layer)) continue;
                String path = layer.getPath();
                if (path != null && path.length() > 0 && !"/".equals(path)) {
                    nestedLayers.add(layer);
                    continue;
                }
                this.doHandleLayer(layer, isRoot);
            }
            this.handleLayerTree(nestedLayers, isRoot);
        }

        private void handleLayerTree(LayerTree layerTree, boolean isRoot) {
            ArrayList<LayerInfo> data = new ArrayList<LayerInfo>(layerTree.getData());
            Collection<LayerTree> children = layerTree.getChildrens();
            Collections.sort(data, new Comparator<LayerInfo>(){

                @Override
                public int compare(LayerInfo o1, LayerInfo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (LayerInfo layer : data) {
                boolean wmsExposable = this.isExposable(layer);
                if (!wmsExposable) continue;
                this.doHandleLayer(layer, isRoot);
            }
            for (LayerTree childLayerTree : children) {
                this.start("Layer");
                this.element("Name", childLayerTree.getName());
                this.element("Title", childLayerTree.getName());
                this.handleLayerTree(childLayerTree, false);
                this.end("Layer");
            }
        }

        private void doHandleLayer(LayerInfo layer, boolean isRoot) {
            try {
                this.mark();
                this.handleLayer(layer, isRoot);
                this.commit();
            }
            catch (Exception e) {
                if (this.skipping) {
                    LOGGER.log(Level.WARNING, "Error writing metadata; skipping layer: " + layer.getName(), e);
                    this.reset();
                }
                throw new ServiceException("Error occurred trying to write out metadata for layer: " + layer.getName(), (Throwable)e);
            }
        }

        private boolean isExposable(LayerInfo layer) {
            if (!layer.enabled()) {
                return false;
            }
            boolean wmsExposable = WMS.isWmsExposable(layer);
            return wmsExposable;
        }

        protected void handleLayer(LayerInfo layer, boolean isRoot) throws IOException {
            ReferencedEnvelope bbox;
            boolean queryable = this.wmsConfig.isQueryable(layer);
            AttributesImpl qatts = this.attributes("queryable", queryable ? "1" : "0");
            boolean opaque = this.wmsConfig.isOpaque(layer);
            qatts.addAttribute("", "opaque", "opaque", "", opaque ? "1" : "0");
            Integer cascadedHopCount = this.wmsConfig.getCascadedHopCount(layer);
            if (cascadedHopCount != null) {
                qatts.addAttribute("", "cascaded", "cascaded", "", String.valueOf(cascadedHopCount));
            }
            String layerName = layer.prefixedName();
            this.start("Layer", qatts);
            this.element("Name", layerName);
            this.element("Title", layer.getResource().getTitle());
            this.element("Abstract", layer.getResource().getAbstract());
            this.handleKeywordList(layer.getResource().getKeywords());
            String crs = layer.getResource().getSRS();
            if (isRoot) {
                Set<String> srsList = this.getServiceSRSList();
                this.handleRootCrsList(srsList);
            } else {
                this.element("CRS", crs);
                this.element("CRS", "CRS:84");
            }
            ReferencedEnvelope llbbox = layer.getResource().getLatLonBoundingBox();
            this.handleGeographicBoundingBox((Envelope)llbbox);
            this.handleBBox((Envelope)llbbox, "CRS:84");
            try {
                bbox = layer.getResource().boundingBox();
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error obtaining bounding box for layer " + layer.getName(), e);
            }
            if (bbox != null) {
                this.handleBBox((Envelope)bbox, crs);
                this.handleAdditionalBBox(bbox, crs, (PublishedInfo)layer);
            }
            if (layer.getType() == PublishedType.VECTOR) {
                this.dimensionHelper.handleVectorLayerDimensions(layer);
            } else if (layer.getType() == PublishedType.RASTER) {
                this.dimensionHelper.handleRasterLayerDimensions(layer);
            } else if (layer.getType() == PublishedType.WMTS) {
                this.dimensionHelper.handleWMTSLayerDimensions(layer);
            }
            this.handleAttribution((PublishedInfo)layer);
            if (isRoot) {
                this.handleAuthorityURL(this.serviceInfo.getAuthorityURLs());
            }
            this.handleAuthorityURL(layer.getAuthorityURLs());
            this.handleLayerIdentifiers(layer.getIdentifiers());
            this.handleMetadataList(layer.getResource().getMetadataLinks());
            this.handleDataList(layer.getResource().getDataLinks());
            this.handleLayerStyles(layerName, layer.getDefaultStyle(), layer.getStyles());
            this.handleScaleDenominator((PublishedInfo)layer);
            this.end("Layer");
        }

        private void handleScaleDenominator(PublishedInfo layer) {
            try {
                NumberRange<Double> scaleDenominators = CapabilityUtil.searchMinMaxScaleDenominator(layer);
                for (ExtendedCapabilitiesProvider provider : this.extCapsProviders) {
                    scaleDenominators = provider.overrideScaleDenominators(layer, scaleDenominators);
                }
                if (scaleDenominators.getMinimum() != 0.0) {
                    this.element("MinScaleDenominator", String.valueOf(scaleDenominators.getMinimum()));
                }
                if (scaleDenominators.getMaximum() != Double.POSITIVE_INFINITY) {
                    this.element("MaxScaleDenominator", String.valueOf(scaleDenominators.getMaximum()));
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }

        private void handleLayerStyles(String layerName, StyleInfo defaultStyle, Set<StyleInfo> styles) {
            if (defaultStyle == null) {
                throw new NullPointerException("Layer " + layerName + " has no default style");
            }
            this.start("Style");
            this.handleCommonStyleElements(defaultStyle);
            this.handleLegendURL(layerName, defaultStyle.getLegend(), null, defaultStyle);
            this.end("Style");
            if (styles != null) {
                for (StyleInfo styleInfo : styles) {
                    this.start("Style");
                    this.handleCommonStyleElements(styleInfo);
                    this.handleLegendURL(layerName, styleInfo.getLegend(), styleInfo, styleInfo);
                    this.end("Style");
                }
            }
        }

        private void handleLayerGroupStyles(String layerName) {
            this.start("Style");
            this.element("Name", "");
            this.element("Title", "".concat(layerName).concat(" style"));
            this.element("Abstract", "Default style for ".concat(layerName).concat(" layer"));
            this.handleLegendURL(layerName, null, null, null);
            this.end("Style");
        }

        private void handleCommonStyleElements(StyleInfo defaultStyle) {
            Style ftStyle;
            try {
                ftStyle = defaultStyle.getStyle();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.element("Name", defaultStyle.prefixedName());
            if (ftStyle.getDescription() != null) {
                if (ftStyle.getDescription().getTitle() != null) {
                    this.element("Title", ftStyle.getDescription().getTitle());
                } else {
                    this.element("Title", defaultStyle.prefixedName());
                }
                this.element("Abstract", ftStyle.getDescription().getAbstract());
            } else {
                this.element("Title", defaultStyle.prefixedName());
            }
        }

        private void element(String element, InternationalString is) {
            if (is != null) {
                this.element(element, is.toString());
            }
        }

        protected Set<LayerInfo> getLayersInGroups(List<LayerGroupInfo> layerGroups) {
            HashSet<LayerInfo> layersAlreadyProcessed = new HashSet<LayerInfo>();
            if (layerGroups == null || layerGroups.size() == 0) {
                return layersAlreadyProcessed;
            }
            List<LayerGroupInfo> topLevelGroups = this.filterNestedGroups(layerGroups);
            for (LayerGroupInfo layerGroup : topLevelGroups) {
                this.getLayersInGroup(layerGroup, layersAlreadyProcessed);
            }
            return layersAlreadyProcessed;
        }

        private void getLayersInGroup(LayerGroupInfo layerGroup, Set<LayerInfo> layersAlreadyProcessed) {
            if (LayerGroupInfo.Mode.EO.equals((Object)layerGroup.getMode())) {
                layersAlreadyProcessed.add(layerGroup.getRootLayer());
            }
            if (LayerGroupInfo.Mode.OPAQUE_CONTAINER.equals((Object)layerGroup.getMode())) {
                layersAlreadyProcessed.addAll(layerGroup.layers());
            } else if (!LayerGroupInfo.Mode.SINGLE.equals((Object)layerGroup.getMode())) {
                for (PublishedInfo child : layerGroup.getLayers()) {
                    if (child instanceof LayerInfo) {
                        LayerInfo layer = (LayerInfo)child;
                        if (!this.isExposable(layer)) continue;
                        layersAlreadyProcessed.add((LayerInfo)child);
                        continue;
                    }
                    this.getLayersInGroup((LayerGroupInfo)child, layersAlreadyProcessed);
                }
            }
        }

        protected void handleLayerGroups(List<LayerGroupInfo> layerGroups, boolean isRoot) throws FactoryException, TransformException, IOException {
            if (layerGroups != null) {
                List<LayerGroupInfo> topLevelGroups = this.filterNestedGroups(layerGroups);
                for (LayerGroupInfo group : topLevelGroups) {
                    try {
                        this.mark();
                        this.handleLayerGroup(group, isRoot);
                        this.commit();
                    }
                    catch (Exception e) {
                        if (this.skipping) {
                            if (group != null) {
                                LOGGER.log(Level.WARNING, "Skipping layer group " + group.getName() + " as its caps document element failed to generate", e);
                            } else {
                                LOGGER.log(Level.WARNING, "Skipping a null layer group during caps document generation", e);
                            }
                            this.reset();
                            continue;
                        }
                        throw new ServiceException("Error occurred trying to write out metadata for layer group: " + group.getName(), (Throwable)e);
                    }
                }
            }
        }

        private List<LayerGroupInfo> filterNestedGroups(List<LayerGroupInfo> allGroups) {
            LinkedHashSet<LayerGroupInfo> result = new LinkedHashSet<LayerGroupInfo>(allGroups);
            for (LayerGroupInfo group : allGroups) {
                for (PublishedInfo pi : group.getLayers()) {
                    if (!(pi instanceof LayerGroupInfo)) continue;
                    result.remove(pi);
                }
            }
            return new ArrayList<LayerGroupInfo>(result);
        }

        protected void handleLayerGroup(LayerGroupInfo layerGroup, boolean isRoot) throws TransformException, FactoryException, IOException {
            String layerName = layerGroup.prefixedName();
            AttributesImpl qatts = new AttributesImpl();
            boolean queryable = this.wmsConfig.isQueryable(layerGroup);
            qatts.addAttribute("", "queryable", "queryable", "", queryable ? "1" : "0");
            this.start("Layer", qatts);
            if (!LayerGroupInfo.Mode.CONTAINER.equals((Object)layerGroup.getMode())) {
                this.element("Name", layerName);
            }
            if (StringUtils.isEmpty((CharSequence)layerGroup.getTitle())) {
                this.element("Title", layerName);
            } else {
                this.element("Title", layerGroup.getTitle());
            }
            if (StringUtils.isEmpty((CharSequence)layerGroup.getAbstract())) {
                this.element("Abstract", "Layer-Group type layer: " + layerName);
            } else {
                this.element("Abstract", layerGroup.getAbstract());
            }
            this.handleKeywordList(layerGroup.getKeywords());
            ReferencedEnvelope layerGroupBounds = layerGroup.getBounds();
            ReferencedEnvelope latLonBounds = layerGroupBounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
            String authority = layerGroupBounds.getCoordinateReferenceSystem().getIdentifiers().toArray()[0].toString();
            if (isRoot) {
                Set<String> srsList = this.getServiceSRSList();
                this.handleRootCrsList(srsList);
            } else {
                this.element("CRS", authority);
            }
            this.handleGeographicBoundingBox((Envelope)latLonBounds);
            this.handleBBox((Envelope)latLonBounds, "CRS:84");
            this.handleBBox((Envelope)layerGroupBounds, authority);
            this.handleAdditionalBBox(layerGroupBounds, authority, (PublishedInfo)layerGroup);
            if (LayerGroupInfo.Mode.EO.equals((Object)layerGroup.getMode())) {
                LayerInfo rootLayer = layerGroup.getRootLayer();
                if (rootLayer.getType() == PublishedType.VECTOR) {
                    this.dimensionHelper.handleVectorLayerDimensions(rootLayer);
                } else if (rootLayer.getType() == PublishedType.RASTER) {
                    this.dimensionHelper.handleRasterLayerDimensions(rootLayer);
                }
            }
            this.handleAttribution((PublishedInfo)layerGroup);
            if (isRoot) {
                this.handleAuthorityURL(this.serviceInfo.getAuthorityURLs());
            }
            this.handleAuthorityURL(layerGroup.getAuthorityURLs());
            this.handleLayerIdentifiers(layerGroup.getIdentifiers());
            Collection metadataLinks = layerGroup.getMetadataLinks();
            if (metadataLinks == null || metadataLinks.isEmpty()) {
                HashSet aggregatedLinks = new HashSet();
                for (LayerInfo layer : Iterables.filter((Iterable)layerGroup.getLayers(), LayerInfo.class)) {
                    List metadataLinksLayer = layer.getResource().getMetadataLinks();
                    if (metadataLinksLayer == null) continue;
                    aggregatedLinks.addAll(metadataLinksLayer);
                }
                metadataLinks = aggregatedLinks;
            }
            this.handleMetadataList(metadataLinks);
            this.handleLayerGroupStyles(layerName);
            this.handleScaleDenominator((PublishedInfo)layerGroup);
            if (!LayerGroupInfo.Mode.OPAQUE_CONTAINER.equals((Object)layerGroup.getMode()) && !LayerGroupInfo.Mode.SINGLE.equals((Object)layerGroup.getMode())) {
                for (PublishedInfo child : layerGroup.getLayers()) {
                    if (child instanceof LayerInfo) {
                        LayerInfo layer;
                        layer = (LayerInfo)child;
                        if (!this.isExposable(layer)) continue;
                        this.handleLayer((LayerInfo)child, false);
                        continue;
                    }
                    this.handleLayerGroup((LayerGroupInfo)child, false);
                }
            }
            this.end("Layer");
        }

        protected void handleAttribution(PublishedInfo layer) {
            AttributionInfo attribution = layer.getAttribution();
            if (attribution != null) {
                boolean logoGood;
                String title = attribution.getTitle();
                String url = attribution.getHref();
                String logoURL = attribution.getLogoURL();
                String logoType = attribution.getLogoType();
                int logoWidth = attribution.getLogoWidth();
                int logoHeight = attribution.getLogoHeight();
                boolean titleGood = title != null;
                boolean urlGood = url != null;
                boolean bl = logoGood = logoURL != null && logoType != null && logoWidth > 0 && logoHeight > 0;
                if (titleGood || urlGood || logoGood) {
                    this.start("Attribution");
                    if (titleGood) {
                        this.element("Title", title);
                    }
                    if (urlGood) {
                        AttributesImpl urlAttributes = new AttributesImpl();
                        urlAttributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                        urlAttributes.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                        urlAttributes.addAttribute(XLINK_NS, "href", "xlink:href", "", url);
                        this.element("OnlineResource", null, urlAttributes);
                    }
                    if (logoGood) {
                        AttributesImpl logoAttributes = new AttributesImpl();
                        logoAttributes.addAttribute("", "", "height", "", "" + logoHeight);
                        logoAttributes.addAttribute("", "", "width", "", "" + logoWidth);
                        this.start("LogoURL", logoAttributes);
                        this.element("Format", logoType);
                        AttributesImpl urlAttributes = new AttributesImpl();
                        urlAttributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                        urlAttributes.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                        urlAttributes.addAttribute(XLINK_NS, "href", "xlink:href", "", logoURL);
                        this.element("OnlineResource", null, urlAttributes);
                        this.end("LogoURL");
                    }
                    this.end("Attribution");
                }
            }
        }

        protected void handleLegendURL(String layerName, LegendInfo legend, StyleInfo style, StyleInfo sampleStyle) {
            int legendWidth = 20;
            int legendHeight = 20;
            String defaultFormat = "image/png";
            if (CapabilityUtil.validateLegendInfo(legend)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("using user supplied legend URL");
                }
                legendWidth = legend.getWidth();
                legendHeight = legend.getHeight();
                defaultFormat = legend.getFormat().replaceFirst(";charset=utf-8", "");
            } else if (sampleStyle != null) {
                try {
                    Dimension dimension = this.legendSample.getLegendURLSize(sampleStyle);
                    if (dimension != null) {
                        legendWidth = (int)dimension.getWidth();
                        legendHeight = (int)dimension.getHeight();
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error getting LegendURL dimensions from sample", e);
                }
            }
            if (null == this.wmsConfig.getLegendGraphicOutputFormat(defaultFormat)) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning(new StringBuffer("Default legend format (").append(defaultFormat).append(")is not supported (jai not available?), can't add LegendURL element").toString());
                }
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Adding GetLegendGraphic call as LegendURL");
            }
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "width", "width", "", String.valueOf(legendWidth));
            attrs.addAttribute("", "height", "height", "", String.valueOf(legendHeight));
            this.start("LegendURL", attrs);
            this.element("Format", defaultFormat);
            attrs.clear();
            Map params = org.geoserver.ows.util.ResponseUtils.params((String[])new String[]{"service", "WMS", "request", "GetLegendGraphic", "format", defaultFormat, "width", String.valueOf(20), "height", String.valueOf(20), "layer", layerName});
            if (style != null) {
                params.put("style", style.getName());
            }
            String legendURL = org.geoserver.ows.util.ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"ows", (Map)params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            CapabilityUtil.addGetLegendAttributes(attrs, legendURL, XLINK_NS);
            this.element("OnlineResource", null, attrs);
            this.end("LegendURL");
        }

        private void handleGeographicBoundingBox(Envelope bbox) {
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            this.start("EX_GeographicBoundingBox");
            this.element("westBoundLongitude", minx);
            this.element("eastBoundLongitude", maxx);
            this.element("southBoundLatitude", miny);
            this.element("northBoundLatitude", maxy);
            this.end("EX_GeographicBoundingBox");
        }

        private void handleBBox(Envelope bbox, String srs) {
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            CoordinateReferenceSystem crs = null;
            try {
                crs = CRS.decode((String)WMS.toInternalSRS(srs, WMS.VERSION_1_3_0));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unable to decode " + srs, e);
            }
            if (crs != null && CRS.getAxisOrder((CoordinateReferenceSystem)crs) == CRS.AxisOrder.NORTH_EAST) {
                String tmp = minx;
                minx = miny;
                miny = tmp;
                tmp = maxx;
                maxx = maxy;
                maxy = tmp;
            }
            AttributesImpl bboxAtts = this.attributes("CRS", srs, "minx", minx, "miny", miny, "maxx", maxx, "maxy", maxy);
            this.element("BoundingBox", null, bboxAtts);
        }

        private void handleAdditionalBBox(ReferencedEnvelope bbox, String crs, PublishedInfo layer) {
            if (this.serviceInfo.isBBOXForEachCRS().booleanValue() && !this.serviceInfo.getSRS().isEmpty()) {
                for (String srs : this.serviceInfo.getSRS()) {
                    srs = this.qualifySRS(srs);
                    if (crs != null && crs.equals(srs)) continue;
                    CoordinateReferenceSystem targetCrs = null;
                    try {
                        targetCrs = CRS.decode((String)srs);
                        ReferencedEnvelope tbbox = bbox.transform(targetCrs, true);
                        this.handleBBox((Envelope)tbbox, srs);
                    }
                    catch (Exception e) {
                        try {
                            CapabilitiesTransformerProjectionHandler handler = CapabilitiesTransformerProjectionHandler.create(targetCrs, bbox.getCoordinateReferenceSystem());
                            if (handler == null) {
                                LOGGER.warning(String.format("Unable to transform bounding box for '%s' layer to %s", layer != null ? layer.getName() : "root", srs));
                                if (!LOGGER.isLoggable(Level.FINE)) continue;
                                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                continue;
                            }
                            ReferencedEnvelope tbbox = handler.transformEnvelope(bbox, targetCrs);
                            this.handleBBox((Envelope)tbbox, srs);
                        }
                        catch (FactoryException | TransformException e1) {
                            LOGGER.warning(String.format("Unable to transform bounding box for '%s' layer to %s", layer != null ? layer.getName() : "root", srs));
                            if (!LOGGER.isLoggable(Level.FINE)) continue;
                            LOGGER.log(Level.FINE, e1.getLocalizedMessage(), e1);
                        }
                    }
                }
            }
        }

        private void handleAuthorityURL(List<AuthorityURLInfo> authorityURLs) {
            if (authorityURLs == null || authorityURLs.isEmpty()) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            for (AuthorityURLInfo url : authorityURLs) {
                String name = url.getName();
                String href = url.getHref();
                if (name == null || href == null) {
                    LOGGER.warning("Ignoring AuthorityURL, name: " + name + ", href: " + href);
                    continue;
                }
                atts.clear();
                atts.addAttribute("", "name", "name", "", name);
                this.start("AuthorityURL", atts);
                atts.clear();
                atts.addAttribute("", "xlink:type", "xlink:type", "", "simple");
                atts.addAttribute("", "xlink:href", "xlink:href", "", href);
                this.element("OnlineResource", null, atts);
                this.end("AuthorityURL");
            }
        }

        private void handleLayerIdentifiers(List<LayerIdentifierInfo> identifiers) {
            if (identifiers == null || identifiers.isEmpty()) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            for (LayerIdentifierInfo identifier : identifiers) {
                String authority = identifier.getAuthority();
                String id = identifier.getIdentifier();
                if (authority == null || id == null) {
                    LOGGER.warning("Ignoring layer Identifier, authority: " + authority + ", identifier: " + id);
                    continue;
                }
                atts.clear();
                atts.addAttribute("", "authority", "authority", "", authority);
                this.element("Identifier", id, atts);
            }
        }
    }
}

