/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.platform.ServiceException;
import org.geoserver.util.ISO8601Formatter;
import org.geoserver.wms.WMS;
import org.geoserver.wms.dimension.DimensionDefaultValueSelectionStrategy;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.ows.wms.xml.Dimension;
import org.geotools.ows.wms.xml.Extent;
import org.geotools.ows.wmts.model.WMTSLayer;
import org.geotools.temporal.object.DefaultPeriodDuration;
import org.geotools.util.Converters;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

abstract class DimensionHelper {
    static final Logger LOGGER = Logging.getLogger(DimensionHelper.class);
    public static final String NEAREST_VALUE = "nearestValue";
    public static final String NAME = "name";
    public static final String DEFAULT = "default";
    public static final String UNITS = "units";
    public static final String TIME = "time";
    public static final String ELEVATION = "elevation";
    public static final String UNIT_SYMBOL = "unitSymbol";
    Mode mode;
    WMS wms;

    public DimensionHelper(Mode mode, WMS wms) {
        this.mode = mode;
        this.wms = wms;
    }

    protected abstract void element(String var1, String var2);

    protected abstract void element(String var1, String var2, Attributes var3);

    void handleVectorLayerDimensions(LayerInfo layer) {
        boolean hasElevation;
        FeatureTypeInfo typeInfo = (FeatureTypeInfo)layer.getResource();
        Map<String, DimensionInfo> customDims = this.getCustomDimensions(typeInfo);
        DimensionInfo timeInfo = (DimensionInfo)typeInfo.getMetadata().get(TIME, DimensionInfo.class);
        DimensionInfo elevInfo = (DimensionInfo)typeInfo.getMetadata().get(ELEVATION, DimensionInfo.class);
        boolean hasTime = timeInfo != null && timeInfo.isEnabled();
        boolean bl = hasElevation = elevInfo != null && elevInfo.isEnabled();
        if (!hasTime && !hasElevation && customDims.isEmpty()) {
            return;
        }
        if (this.mode == Mode.WMS11) {
            String elevUnits = hasElevation ? elevInfo.getUnits() : "";
            String elevUnitSymbol = hasElevation ? elevInfo.getUnitSymbol() : "";
            this.declareWMS11Dimensions(hasTime, hasElevation, elevUnits, elevUnitSymbol, customDims.isEmpty() ? null : customDims);
        }
        if (hasTime) {
            try {
                this.handleTimeDimensionVector(typeInfo);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to handle time attribute for layer", e);
            }
        }
        if (hasElevation) {
            try {
                this.handleElevationDimensionVector(typeInfo);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!customDims.isEmpty()) {
            this.handleCustomDimensionsVector(typeInfo, customDims);
        }
    }

    void handleCustomDimensionsVector(FeatureTypeInfo featureTypeInfo, Map<String, DimensionInfo> customDims) {
        for (Map.Entry<String, DimensionInfo> entry : customDims.entrySet()) {
            this.handleCustomDimensionVector(featureTypeInfo, entry);
        }
    }

    void handleCustomDimensionVector(FeatureTypeInfo featureTypeInfo, Map.Entry<String, DimensionInfo> customDim) {
        try {
            String metadata;
            TreeSet<Object> values = this.wms.getDimensionValues(featureTypeInfo, customDim.getValue());
            String units = customDim.getValue().getUnits();
            String unitSymbol = customDim.getValue().getUnitSymbol();
            Optional<Class> dataTypeOpt = this.getDataType(values);
            if (dataTypeOpt.isPresent()) {
                Class type = dataTypeOpt.get();
                if (Date.class.isAssignableFrom(type)) {
                    metadata = this.getTemporalDomainRepresentation(customDim.getValue(), values);
                } else if (Number.class.isAssignableFrom(type)) {
                    metadata = this.getNumberRepresentation(customDim.getValue(), values);
                } else {
                    List<String> valuesList = values.stream().filter(x -> x != null).map(x -> x.toString()).collect(Collectors.toList());
                    metadata = this.getCustomDomainRepresentation(customDim.getValue(), valuesList);
                }
            } else {
                metadata = "";
            }
            String defaultValue = this.getDefaultValueRepresentation((ResourceInfo)featureTypeInfo, "dim_" + customDim.getKey(), "");
            this.writeCustomDimensionVector(customDim.getKey(), values, metadata, units, unitSymbol, defaultValue);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    Optional<Class> getDataType(Set<Object> values) {
        return values.stream().filter(x -> x != null).findFirst().map(Object::getClass);
    }

    private Map<String, DimensionInfo> getCustomDimensions(FeatureTypeInfo typeInfo) {
        return typeInfo.getMetadata().entrySet().stream().filter(e -> e.getValue() instanceof DimensionInfo && e.getKey() != null && ((String)e.getKey()).startsWith("dim_") && !ELEVATION.equals(e.getKey()) && !TIME.equals(e.getKey())).map(e -> Pair.of((Object)((String)e.getKey()).replaceFirst("dim_", ""), (Object)((DimensionInfo)e.getValue()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (DimensionInfo)e.getValue()));
    }

    void handleWMTSLayerDimensions(LayerInfo layerInfo) {
        try {
            WMTSLayerInfo wli = (WMTSLayerInfo)layerInfo.getResource();
            WMTSLayer wl = wli.getWMTSLayer(null);
            for (String dimName : wl.getDimensions().keySet()) {
                if (TIME.equalsIgnoreCase(dimName)) {
                    Dimension timeDimension = wl.getDimension(dimName);
                    if (this.mode == Mode.WMS11) {
                        this.declareWMS11Dimensions(true, false, null, null, null);
                    }
                    Extent extent = timeDimension.getExtent();
                    this.writeTimeDimension(extent.getValue(), extent.getDefaultValue(), extent.getNearestValue());
                    continue;
                }
                LOGGER.log(Level.WARNING, "Skipping custom dimension " + dimName + " in layer " + layerInfo.getName());
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Error handling WMTS time dimension", ex);
        }
    }

    void handleRasterLayerDimensions(LayerInfo layer) throws RuntimeException, IOException {
        boolean hasCustomDimensions;
        CoverageInfo cvInfo = (CoverageInfo)layer.getResource();
        if (cvInfo == null) {
            throw new ServiceException("Unable to acquire coverage resource for layer: " + layer.getName());
        }
        DimensionInfo timeInfo = null;
        DimensionInfo elevInfo = null;
        HashMap<String, DimensionInfo> customDimensions = new HashMap<String, DimensionInfo>();
        GridCoverage2DReader reader = null;
        for (Map.Entry e : cvInfo.getMetadata().entrySet()) {
            DimensionInfo dimInfo;
            String key = (String)e.getKey();
            Object value = e.getValue();
            if (key.equals(TIME)) {
                timeInfo = (DimensionInfo)Converters.convert(value, DimensionInfo.class);
                continue;
            }
            if (key.equals(ELEVATION)) {
                elevInfo = (DimensionInfo)Converters.convert(value, DimensionInfo.class);
                continue;
            }
            if (!(value instanceof DimensionInfo) || !(dimInfo = (DimensionInfo)value).isEnabled()) continue;
            if (key.startsWith("custom_dimension_")) {
                String dimensionName = key.substring("custom_dimension_".length());
                customDimensions.put(dimensionName, dimInfo);
                continue;
            }
            LOGGER.log(Level.SEVERE, "Skipping custom  dimension with key " + key + " since it does not start with " + "custom_dimension_");
        }
        boolean hasTime = timeInfo != null && timeInfo.isEnabled();
        boolean hasElevation = elevInfo != null && elevInfo.isEnabled();
        boolean bl = hasCustomDimensions = !customDimensions.isEmpty();
        if (!(hasTime || hasElevation || hasCustomDimensions)) {
            return;
        }
        Catalog catalog = cvInfo.getCatalog();
        if (catalog == null) {
            throw new ServiceException("Unable to acquire catalog resource for layer: " + layer.getName());
        }
        CoverageStoreInfo csinfo = cvInfo.getStore();
        if (csinfo == null) {
            throw new ServiceException("Unable to acquire coverage store resource for layer: " + layer.getName());
        }
        try {
            reader = (GridCoverage2DReader)cvInfo.getGridCoverageReader(null, null);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName(), t);
        }
        if (reader == null) {
            throw new ServiceException("Unable to acquire a reader for this coverage with format: " + csinfo.getFormat().getName());
        }
        ReaderDimensionsAccessor dimensions = new ReaderDimensionsAccessor(reader);
        if (hasCustomDimensions) {
            for (String key : new HashSet(customDimensions.keySet())) {
                if (dimensions.hasDomain(key)) continue;
                customDimensions.remove(key);
            }
        }
        if (this.mode == Mode.WMS11) {
            String elevUnits = hasElevation ? elevInfo.getUnits() : "";
            String elevUnitSymbol = hasElevation ? elevInfo.getUnitSymbol() : "";
            this.declareWMS11Dimensions(hasTime, hasElevation, elevUnits, elevUnitSymbol, customDimensions);
        }
        if (hasTime && dimensions.hasTime()) {
            this.handleTimeDimensionRaster(cvInfo, timeInfo, dimensions);
        }
        if (hasElevation && dimensions.hasElevation()) {
            this.handleElevationDimensionRaster(cvInfo, elevInfo, dimensions);
        }
        if (hasCustomDimensions) {
            for (String key : customDimensions.keySet()) {
                DimensionInfo dimensionInfo = (DimensionInfo)customDimensions.get(key);
                this.handleCustomDimensionRaster(cvInfo, key, dimensionInfo, dimensions);
            }
        }
    }

    private void handleElevationDimensionRaster(CoverageInfo cvInfo, DimensionInfo elevInfo, ReaderDimensionsAccessor dimensions) throws IOException {
        TreeSet<Double> elevations = null;
        try {
            Double minValue;
            if (elevInfo.getPresentation() != DimensionPresentation.LIST && (minValue = dimensions.getMinElevation()) != null) {
                elevations = new TreeSet<Double>();
                elevations.add(minValue);
                elevations.add(dimensions.getMaxElevation());
            }
            if (elevations == null) {
                throw new Exception("The \"List\" presentation of the elevation dimension has been selected");
            }
        }
        catch (Exception ex) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Dimension has not been extracted. The reason: ", ex);
            }
            elevations = dimensions.getElevationDomain();
        }
        String elevationMetadata = this.getNumberRepresentation(elevInfo, (TreeSet<? extends Object>)elevations);
        String defaultValue = this.getDefaultValueRepresentation((ResourceInfo)cvInfo, ELEVATION, "0");
        this.writeElevationDimension(elevations, elevationMetadata, elevInfo.getUnits(), elevInfo.getUnitSymbol(), defaultValue);
    }

    private String getDefaultValueRepresentation(ResourceInfo resource, String dimensionName, String fallback) {
        DimensionInfo dimensionInfo = this.wms.getDimensionInfo(resource, dimensionName);
        DimensionDefaultValueSelectionStrategy strategy = this.wms.getDefaultValueStrategy(resource, dimensionName, dimensionInfo);
        String defaultValue = strategy.getCapabilitiesRepresentation(resource, dimensionName, dimensionInfo);
        if (defaultValue == null) {
            defaultValue = fallback;
        }
        return defaultValue;
    }

    private void handleTimeDimensionRaster(CoverageInfo cvInfo, DimensionInfo timeInfo, ReaderDimensionsAccessor dimension) throws IOException {
        TreeSet<Date> temporalDomain = null;
        try {
            Date minValue;
            if (timeInfo.getPresentation() != DimensionPresentation.LIST && (minValue = dimension.getMinTime()) != null) {
                temporalDomain = new TreeSet<Date>();
                temporalDomain.add(minValue);
                temporalDomain.add(dimension.getMaxTime());
            }
            if (temporalDomain == null) {
                throw new Exception("The \"List\" presentation of the temporal dimension has been selected");
            }
        }
        catch (Exception ex) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Dimension has not been extracted. The reason: ", ex);
            }
            temporalDomain = dimension.getTimeDomain();
        }
        String timeMetadata = this.getTemporalDomainRepresentation(timeInfo, (TreeSet<? extends Object>)temporalDomain);
        String defaultValue = this.getDefaultValueRepresentation((ResourceInfo)cvInfo, TIME, DimensionDefaultValueSetting.TIME_CURRENT);
        this.writeTimeDimension(timeMetadata, defaultValue, timeInfo.isNearestMatchEnabled());
    }

    private void handleCustomDimensionRaster(CoverageInfo cvInfo, String dimName, DimensionInfo dimension, ReaderDimensionsAccessor dimAccessor) throws IOException {
        List values = dimAccessor.getDomain(dimName);
        String metadata = this.getCustomDomainRepresentation(dimension, values);
        String defaultValue = this.wms.getDefaultCustomDimensionValue(dimName, (ResourceInfo)cvInfo, String.class);
        this.writeCustomDimensionRaster(dimName, metadata, defaultValue, dimension.getUnits(), dimension.getUnitSymbol());
    }

    private void declareWMS11Dimensions(boolean hasTime, boolean hasElevation, String elevUnits, String elevUnitSymbol, Map<String, DimensionInfo> customDimensions) {
        if (hasTime) {
            AttributesImpl timeDim = new AttributesImpl();
            timeDim.addAttribute("", NAME, NAME, "", TIME);
            timeDim.addAttribute("", UNITS, UNITS, "", "ISO8601");
            this.element("Dimension", null, timeDim);
        }
        if (hasElevation) {
            this.writeElevationDimensionElement(null, null, elevUnits, elevUnitSymbol);
        }
        if (customDimensions != null) {
            for (String dim : customDimensions.keySet()) {
                DimensionInfo di = customDimensions.get(dim);
                AttributesImpl custDim = new AttributesImpl();
                custDim.addAttribute("", NAME, NAME, "", dim);
                String units = di.getUnits();
                String unitSymbol = di.getUnitSymbol();
                custDim.addAttribute("", UNITS, UNITS, "", units != null ? units : "");
                if (unitSymbol != null) {
                    custDim.addAttribute("", UNIT_SYMBOL, UNIT_SYMBOL, "", unitSymbol);
                }
                this.element("Dimension", null, custDim);
            }
        }
    }

    protected String getNumberRepresentation(DimensionInfo dimension, TreeSet<? extends Object> values) {
        String elevationMetadata = null;
        StringBuilder buff = new StringBuilder();
        if (DimensionPresentation.LIST == dimension.getPresentation()) {
            for (Object object : values) {
                if (object instanceof Number) {
                    buff.append(object);
                } else {
                    NumberRange range = (NumberRange)object;
                    buff.append(range.getMinimum()).append("/").append(range.getMaximum()).append("/0");
                }
                buff.append(",");
            }
            elevationMetadata = buff.substring(0, buff.length() - 1).replaceAll("\\[", "").replaceAll("\\]", "").replaceAll(" ", "");
        } else if (DimensionPresentation.CONTINUOUS_INTERVAL == dimension.getPresentation()) {
            NumberRange<Double> range = this.getMinMaxZInterval(values);
            buff.append(range.getMinimum());
            buff.append("/");
            buff.append(range.getMaximum());
            buff.append("/0");
            elevationMetadata = buff.toString();
        } else if (DimensionPresentation.DISCRETE_INTERVAL == dimension.getPresentation()) {
            String maxStr;
            String minStr;
            NumberRange<Double> range = this.getMinMaxZInterval(values);
            Class<?> clazz = values.first().getClass();
            boolean isDecimal = this.isDecimal(clazz);
            if (isDecimal) {
                minStr = String.valueOf(range.getMinimum());
                maxStr = String.valueOf(range.getMaximum());
            } else {
                minStr = String.valueOf(Double.valueOf(range.getMinimum()).longValue());
                maxStr = String.valueOf(Double.valueOf(range.getMaximum()).longValue());
            }
            buff.append(minStr);
            buff.append("/");
            buff.append(maxStr);
            buff.append("/");
            BigDecimal resolution = dimension.getResolution();
            if (resolution != null) {
                buff.append(resolution.doubleValue());
            } else if (values.size() >= 2 && this.allNumbers(values)) {
                int count = 2;
                int i = 2;
                Number[] zPositions = new Number[count];
                List numberValues = values.stream().map(x -> (Number)x).collect(Collectors.toList());
                for (Object val : numberValues) {
                    zPositions[count - i--] = (Number)val;
                    if (i != 0) continue;
                    break;
                }
                if (isDecimal) {
                    buff.append(zPositions[count - 1].doubleValue() - zPositions[count - 2].doubleValue());
                } else {
                    buff.append(zPositions[count - 1].longValue() - zPositions[count - 2].longValue());
                }
            } else {
                buff.append(0);
            }
            elevationMetadata = buff.toString();
        }
        return elevationMetadata;
    }

    private boolean isDecimal(Class<?> typeBinding) {
        return Float.class.isAssignableFrom(typeBinding) || Double.class.isAssignableFrom(typeBinding) || BigDecimal.class.isAssignableFrom(typeBinding);
    }

    String getTemporalDomainRepresentation(DimensionInfo dimension, TreeSet<? extends Object> values) {
        String timeMetadata = null;
        StringBuilder buff = new StringBuilder();
        ISO8601Formatter df = new ISO8601Formatter();
        if (DimensionPresentation.LIST == dimension.getPresentation()) {
            for (Object object : values) {
                buff.append(df.format(object));
                buff.append(",");
            }
            timeMetadata = buff.substring(0, buff.length() - 1).replaceAll("\\[", "").replaceAll("\\]", "").replaceAll(" ", "");
        } else if (DimensionPresentation.CONTINUOUS_INTERVAL == dimension.getPresentation()) {
            DateRange interval = this.getMinMaxTimeInterval(values);
            buff.append(df.format(interval.getMinValue()));
            buff.append("/");
            buff.append(df.format(interval.getMaxValue()));
            buff.append("/PT1S");
            timeMetadata = buff.toString();
        } else if (DimensionPresentation.DISCRETE_INTERVAL == dimension.getPresentation()) {
            DateRange interval = this.getMinMaxTimeInterval(values);
            buff.append(df.format(interval.getMinValue()));
            buff.append("/");
            buff.append(df.format(interval.getMaxValue()));
            buff.append("/");
            BigDecimal bigDecimal = dimension.getResolution();
            if (bigDecimal != null) {
                buff.append(new DefaultPeriodDuration(bigDecimal.longValue()).toString());
            } else if (values.size() >= 2 && this.allDates(values)) {
                int count = 2;
                int i = 2;
                Date[] timePositions = new Date[count];
                for (Object object : values) {
                    timePositions[count - i--] = (Date)object;
                    if (i != 0) continue;
                    break;
                }
                long durationInMilliSeconds = timePositions[count - 1].getTime() - timePositions[count - 2].getTime();
                buff.append(new DefaultPeriodDuration(durationInMilliSeconds).toString());
            } else {
                buff.append("PT1S");
            }
            timeMetadata = buff.toString();
        }
        return timeMetadata;
    }

    private DateRange getMinMaxTimeInterval(TreeSet<? extends Object> values) {
        Object minValue = values.first();
        Object maxValue = values.last();
        Date min = minValue instanceof DateRange ? ((DateRange)minValue).getMinValue() : (Date)minValue;
        Date max = maxValue instanceof DateRange ? ((DateRange)maxValue).getMaxValue() : (Date)maxValue;
        return new DateRange(min, max);
    }

    private NumberRange<Double> getMinMaxZInterval(TreeSet<? extends Object> values) {
        Object minValue = values.first();
        Object maxValue = values.last();
        Number min = minValue instanceof NumberRange ? (Number)((Number)((Object)((NumberRange)minValue).getMinValue())) : (Number)((Number)minValue);
        Number max = maxValue instanceof NumberRange ? (Number)((Number)((Object)((NumberRange)maxValue).getMaxValue())) : (Number)((Number)maxValue);
        return new NumberRange(min.getClass(), min, max);
    }

    private boolean allDates(TreeSet<? extends Object> values) {
        for (Object object : values) {
            if (object instanceof Date) continue;
            return false;
        }
        return true;
    }

    private boolean allNumbers(TreeSet<? extends Object> values) {
        for (Object object : values) {
            if (object instanceof Number) continue;
            return false;
        }
        return true;
    }

    String getCustomDomainRepresentation(DimensionInfo dimension, List<String> values) {
        String metadata = null;
        StringBuilder buff = new StringBuilder();
        if (DimensionPresentation.LIST == dimension.getPresentation()) {
            for (String value : values) {
                buff.append(value.trim());
                buff.append(",");
            }
            metadata = buff.substring(0, buff.length() - 1);
        } else if (DimensionPresentation.DISCRETE_INTERVAL == dimension.getPresentation()) {
            buff.append(values.get(0));
            buff.append("/");
            buff.append(values.get(0));
            buff.append("/");
            BigDecimal resolution = dimension.getResolution();
            if (resolution != null) {
                buff.append(resolution);
            }
            metadata = buff.toString();
        }
        return metadata;
    }

    private void handleTimeDimensionVector(FeatureTypeInfo typeInfo) throws IOException {
        String timeMetadata;
        TreeSet<Date> values = this.wms.getFeatureTypeTimes(typeInfo);
        boolean nearest = false;
        if (values != null && !values.isEmpty()) {
            DimensionInfo timeInfo = (DimensionInfo)typeInfo.getMetadata().get(TIME, DimensionInfo.class);
            timeMetadata = this.getTemporalDomainRepresentation(timeInfo, values);
            nearest = timeInfo.isNearestMatchEnabled();
        } else {
            timeMetadata = "";
        }
        String defaultValue = this.getDefaultValueRepresentation((ResourceInfo)typeInfo, TIME, DimensionDefaultValueSetting.TIME_CURRENT);
        this.writeTimeDimension(timeMetadata, defaultValue, nearest);
    }

    private void handleElevationDimensionVector(FeatureTypeInfo typeInfo) throws IOException {
        TreeSet<Double> elevations = this.wms.getFeatureTypeElevations(typeInfo);
        DimensionInfo di = (DimensionInfo)typeInfo.getMetadata().get(ELEVATION, DimensionInfo.class);
        String units = di.getUnits();
        String unitSymbol = di.getUnitSymbol();
        String elevationMetadata = elevations != null && !elevations.isEmpty() ? this.getNumberRepresentation(di, elevations) : "";
        String defaultValue = this.getDefaultValueRepresentation((ResourceInfo)typeInfo, ELEVATION, "0");
        this.writeElevationDimension(elevations, elevationMetadata, units, unitSymbol, defaultValue);
    }

    private void writeTimeDimension(String timeMetadata, String defaultTimeStr, boolean nearestMatch) {
        AttributesImpl timeDim = new AttributesImpl();
        if (defaultTimeStr == null) {
            defaultTimeStr = DimensionDefaultValueSetting.TIME_CURRENT;
        }
        if (this.mode == Mode.WMS11) {
            timeDim.addAttribute("", NAME, NAME, "", TIME);
            timeDim.addAttribute("", DEFAULT, DEFAULT, "", defaultTimeStr);
            if (nearestMatch) {
                timeDim.addAttribute("", NEAREST_VALUE, NEAREST_VALUE, "", "1");
            }
            this.element("Extent", timeMetadata, timeDim);
        } else {
            timeDim.addAttribute("", NAME, NAME, "", TIME);
            timeDim.addAttribute("", DEFAULT, DEFAULT, "", defaultTimeStr);
            timeDim.addAttribute("", UNITS, UNITS, "", "ISO8601");
            if (nearestMatch) {
                timeDim.addAttribute("", NEAREST_VALUE, NEAREST_VALUE, "", "1");
            }
            this.element("Dimension", timeMetadata, timeDim);
        }
    }

    private void writeElevationDimension(TreeSet<? extends Object> elevations, String elevationMetadata, String units, String unitSymbol, String defaultValue) {
        if (this.mode == Mode.WMS11) {
            AttributesImpl elevDim = new AttributesImpl();
            elevDim.addAttribute("", NAME, NAME, "", ELEVATION);
            elevDim.addAttribute("", DEFAULT, DEFAULT, "", defaultValue);
            this.element("Extent", elevationMetadata, elevDim);
        } else {
            this.writeElevationDimensionElement(elevationMetadata, defaultValue, units, unitSymbol);
        }
    }

    private void writeElevationDimensionElement(String elevationMetadata, String defaultValue, String units, String unitSymbol) {
        String unitSymNotNull;
        AttributesImpl elevDim = new AttributesImpl();
        String unitsNotNull = units;
        String string = unitSymNotNull = unitSymbol == null ? "" : unitSymbol;
        if (units == null) {
            unitsNotNull = "EPSG:5030";
            unitSymNotNull = "m";
        }
        elevDim.addAttribute("", NAME, NAME, "", ELEVATION);
        if (defaultValue != null) {
            elevDim.addAttribute("", DEFAULT, DEFAULT, "", defaultValue);
        }
        elevDim.addAttribute("", UNITS, UNITS, "", unitsNotNull);
        if (!"".equals(unitsNotNull) && !"".equals(unitSymNotNull)) {
            elevDim.addAttribute("", UNIT_SYMBOL, UNIT_SYMBOL, "", unitSymNotNull);
        }
        this.element("Dimension", elevationMetadata, elevDim);
    }

    private void writeCustomDimensionRaster(String name, String metadata, String defaultValue, String unit, String unitSymbol) {
        AttributesImpl dim = new AttributesImpl();
        dim.addAttribute("", NAME, NAME, "", name);
        if (this.mode == Mode.WMS11) {
            if (defaultValue != null) {
                dim.addAttribute("", DEFAULT, DEFAULT, "", defaultValue);
            }
            this.element("Extent", metadata, dim);
        } else {
            if (defaultValue != null) {
                dim.addAttribute("", DEFAULT, DEFAULT, "", defaultValue);
            }
            dim.addAttribute("", UNITS, UNITS, "", unit != null ? unit : "");
            if (unitSymbol != null && !"".equals(unitSymbol)) {
                dim.addAttribute("", UNIT_SYMBOL, UNIT_SYMBOL, "", unitSymbol);
            }
            this.element("Dimension", metadata, dim);
        }
    }

    private void writeCustomDimensionVector(String name, TreeSet<? extends Object> elevations, String metadata, String units, String unitSymbol, String defaultValue) {
        if (this.mode == Mode.WMS11) {
            AttributesImpl elevDim = new AttributesImpl();
            elevDim.addAttribute("", NAME, NAME, "", name);
            elevDim.addAttribute("", DEFAULT, DEFAULT, "", defaultValue);
            this.element("Extent", metadata, elevDim);
        } else {
            this.writeCustomDimensionElement(name, metadata, defaultValue, units, unitSymbol);
        }
    }

    private void writeCustomDimensionElement(String name, String metadata, String defaultValue, String units, String unitSymbol) {
        String unitSymNotNull;
        AttributesImpl elevDim = new AttributesImpl();
        String unitsNotNull = units;
        String string = unitSymNotNull = unitSymbol == null ? "" : unitSymbol;
        if (units == null) {
            unitsNotNull = "EPSG:5030";
            unitSymNotNull = "m";
        }
        elevDim.addAttribute("", NAME, NAME, "", name);
        if (defaultValue != null) {
            elevDim.addAttribute("", DEFAULT, DEFAULT, "", defaultValue);
        }
        elevDim.addAttribute("", UNITS, UNITS, "", unitsNotNull);
        if (!"".equals(unitsNotNull) && !"".equals(unitSymNotNull)) {
            elevDim.addAttribute("", UNIT_SYMBOL, UNIT_SYMBOL, "", unitSymNotNull);
        }
        this.element("Dimension", metadata, elevDim);
    }

    static enum Mode {
        WMS11,
        WMS13;

    }
}

