/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.ExtendedCapabilitiesProvider;
import org.geoserver.catalog.AttributionInfo;
import org.geoserver.catalog.AuthorityURLInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataLinkInfo;
import org.geoserver.catalog.KeywordInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ResourceErrorHandling;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.json.JSONType;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.capabilities.CapabilitiesTransformerProjectionHandler;
import org.geoserver.wms.capabilities.CapabilityUtil;
import org.geoserver.wms.capabilities.DimensionHelper;
import org.geoserver.wms.capabilities.LayerTree;
import org.geoserver.wms.capabilities.LegendSample;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.Style;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.locationtech.jts.geom.Envelope;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;
import org.springframework.util.Assert;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class GetCapabilitiesTransformer
extends TransformerBase {
    public static final String WMS_CAPS_DEFAULT_MIME = "application/vnd.ogc.wms_xml";
    public static final String[] WMS_CAPS_AVAIL_MIME = new String[]{"application/vnd.ogc.wms_xml", "text/xml"};
    static final String[] EXCEPTION_FORMATS = new String[]{"application/vnd.ogc.se_xml", "application/vnd.ogc.se_inimage", "application/vnd.ogc.se_blank", "application/json"};
    private static final Set<String> SUPPORTED_MDLINK_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("FGDC", "TC211")));
    private String baseURL;
    private Set<String> getMapFormats;
    private Set<String> getLegendGraphicFormats;
    private WMS wmsConfig;
    private Collection<ExtendedCapabilitiesProvider> extCapsProviders;
    private Boolean includeRootLayer = null;

    public GetCapabilitiesTransformer(WMS wms, String baseURL, Set<String> getMapFormats, Set<String> getLegendGraphicFormats, Collection<ExtendedCapabilitiesProvider> extCapsProviders) {
        Assert.notNull((Object)wms, (String)"wms");
        Assert.notNull((Object)baseURL, (String)"baseURL");
        Assert.notNull(getMapFormats, (String)"getMapFormats");
        Assert.notNull(getLegendGraphicFormats, (String)"getLegendGraphicFormats");
        this.wmsConfig = wms;
        this.getMapFormats = getMapFormats;
        this.getLegendGraphicFormats = getLegendGraphicFormats;
        this.baseURL = baseURL;
        this.extCapsProviders = extCapsProviders == null ? Collections.EMPTY_LIST : extCapsProviders;
        this.setNamespaceDeclarationEnabled(false);
        this.setIndentation(2);
        Charset encoding = wms.getCharSet();
        this.setEncoding(encoding);
    }

    public void setIncludeRootLayer(Boolean includeRootLayer) {
        this.includeRootLayer = includeRootLayer;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new CapabilitiesTranslator(handler, this.wmsConfig, this.getMapFormats, this.getLegendGraphicFormats, this.extCapsProviders, this.includeRootLayer);
    }

    public Transformer createTransformer() throws TransformerException {
        Transformer transformer = super.createTransformer();
        String dtdUrl = ResponseUtils.buildSchemaURL((String)this.baseURL, (String)"wms/1.1.1/WMS_MS_Capabilities.dtd");
        transformer.setOutputProperty("doctype-system", dtdUrl);
        return transformer;
    }

    private static class CapabilitiesTranslator
    extends TransformerBase.TranslatorSupport {
        private static final Logger LOGGER = Logging.getLogger((String)CapabilitiesTranslator.class.getPackage().getName());
        private static final String MIN_DENOMINATOR_ATTR = "min";
        private static final String MAX_DENOMINATOR_ATTR = "max";
        private static final String EPSG = "EPSG:";
        private static AttributesImpl wmsVersion = new AttributesImpl();
        private static final String XLINK_NS = "http://www.w3.org/1999/xlink";
        DimensionHelper dimensionHelper;
        private LegendSample legendSample;
        private GetCapabilitiesRequest request;
        private Set<String> getMapFormats;
        private Set<String> getLegendGraphicFormats;
        private WMS wmsConfig;
        private Collection<ExtendedCapabilitiesProvider> extCapsProviders;
        private final boolean skipping;
        private WMSInfo serviceInfo;
        private Boolean includeRootLayer;

        public CapabilitiesTranslator(ContentHandler handler, WMS wmsConfig, Set<String> getMapFormats, Set<String> getLegendGraphicFormats, Collection<ExtendedCapabilitiesProvider> extCapsProviders, Boolean includeRootlayer) {
            super(handler, null, null);
            this.wmsConfig = wmsConfig;
            this.getMapFormats = getMapFormats;
            this.getLegendGraphicFormats = getLegendGraphicFormats;
            this.extCapsProviders = extCapsProviders;
            this.serviceInfo = wmsConfig.getServiceInfo();
            this.dimensionHelper = new DimensionHelper(DimensionHelper.Mode.WMS11, wmsConfig){

                @Override
                protected void element(String element, String content, Attributes atts) {
                    this.element(element, content, atts);
                }

                @Override
                protected void element(String element, String content) {
                    this.element(element, content);
                }
            };
            this.legendSample = (LegendSample)GeoServerExtensions.bean(LegendSample.class);
            this.skipping = ResourceErrorHandling.SKIP_MISCONFIGURED_LAYERS.equals((Object)wmsConfig.getGeoServer().getGlobal().getResourceErrorHandling());
            this.includeRootLayer = includeRootlayer;
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof GetCapabilitiesRequest)) {
                throw new IllegalArgumentException();
            }
            this.request = (GetCapabilitiesRequest)o;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(new StringBuffer("producing a capabilities document for ").append(this.request).toString());
            }
            AttributesImpl rootAtts = new AttributesImpl(wmsVersion);
            rootAtts.addAttribute("", "updateSequence", "updateSequence", "", this.wmsConfig.getUpdateSequence() + "");
            this.start("WMT_MS_Capabilities", rootAtts);
            this.handleService();
            this.handleCapability();
            this.end("WMT_MS_Capabilities");
        }

        private void handleService() {
            this.start("Service");
            this.element("Name", "OGC:WMS");
            this.element("Title", this.serviceInfo.getTitle());
            this.element("Abstract", this.serviceInfo.getAbstract());
            this.handleKeywordList(this.serviceInfo.getKeywords());
            AttributesImpl orAtts = new AttributesImpl();
            orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
            orAtts.addAttribute(XLINK_NS, "xlink:type", "xlink:type", "", "simple");
            String onlineResource = this.serviceInfo.getOnlineResource();
            if (onlineResource == null || onlineResource.trim().length() == 0) {
                String requestBaseUrl = this.request.getBaseUrl();
                onlineResource = ResponseUtils.buildURL((String)requestBaseUrl, null, null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            } else {
                try {
                    new URL(onlineResource);
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.WARNING, "WMS online resource seems to be an invalid URL: '" + onlineResource + "'");
                }
            }
            orAtts.addAttribute("", "xlink:href", "xlink:href", "", onlineResource);
            this.element("OnlineResource", null, orAtts);
            GeoServer geoServer = this.wmsConfig.getGeoServer();
            ContactInfo contact = geoServer.getSettings().getContact();
            this.handleContactInfo(contact);
            String fees = this.serviceInfo.getFees();
            this.element("Fees", fees == null ? "none" : fees);
            String constraints = this.serviceInfo.getAccessConstraints();
            this.element("AccessConstraints", constraints == null ? "none" : constraints);
            this.end("Service");
        }

        public void handleContactInfo(ContactInfo contact) {
            this.start("ContactInformation");
            this.start("ContactPersonPrimary");
            this.element("ContactPerson", contact.getContactPerson());
            this.element("ContactOrganization", contact.getContactOrganization());
            this.end("ContactPersonPrimary");
            this.element("ContactPosition", contact.getContactPosition());
            this.start("ContactAddress");
            this.element("AddressType", contact.getAddressType());
            this.element("Address", contact.getAddress());
            this.element("City", contact.getAddressCity());
            this.element("StateOrProvince", contact.getAddressState());
            this.element("PostCode", contact.getAddressPostalCode());
            this.element("Country", contact.getAddressCountry());
            this.end("ContactAddress");
            this.element("ContactVoiceTelephone", contact.getContactVoice());
            this.element("ContactFacsimileTelephone", contact.getContactFacsimile());
            this.element("ContactElectronicMailAddress", contact.getContactEmail());
            this.end("ContactInformation");
        }

        private void handleKeywordList(List<KeywordInfo> keywords) {
            this.start("KeywordList");
            if (keywords != null) {
                Iterator<KeywordInfo> it = keywords.iterator();
                while (it.hasNext()) {
                    this.element("Keyword", it.next().getValue());
                }
            }
            this.end("KeywordList");
        }

        private void handleMetadataList(Collection<MetadataLinkInfo> metadataURLs) {
            if (metadataURLs == null) {
                return;
            }
            for (MetadataLinkInfo link : metadataURLs) {
                if (!SUPPORTED_MDLINK_TYPES.contains(link.getMetadataType())) continue;
                AttributesImpl lnkAtts = new AttributesImpl();
                lnkAtts.addAttribute("", "type", "type", "", link.getMetadataType());
                this.start("MetadataURL", lnkAtts);
                this.element("Format", link.getType());
                String content = org.vfny.geoserver.util.ResponseUtils.proxifyMetadataLink((MetadataLinkInfo)link, (String)this.request.getBaseUrl());
                AttributesImpl orAtts = new AttributesImpl();
                orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                orAtts.addAttribute(XLINK_NS, "xlink:type", "xlink:type", "", "simple");
                orAtts.addAttribute("", "xlink:href", "xlink:href", "", content);
                this.element("OnlineResource", null, orAtts);
                this.end("MetadataURL");
            }
        }

        private void handleDataList(Collection<DataLinkInfo> dataURLs) {
            if (dataURLs == null) {
                return;
            }
            for (DataLinkInfo link : dataURLs) {
                this.start("DataURL");
                this.element("Format", link.getType());
                String content = org.vfny.geoserver.util.ResponseUtils.proxifyDataLink((DataLinkInfo)link, (String)this.request.getBaseUrl());
                AttributesImpl orAtts = new AttributesImpl();
                orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                orAtts.addAttribute(XLINK_NS, "xlink:type", "xlink:type", "", "simple");
                orAtts.addAttribute("", "xlink:href", "xlink:href", "", content);
                this.element("OnlineResource", null, orAtts);
                this.end("DataURL");
            }
        }

        private void handleCapability() {
            this.start("Capability");
            this.handleRequest();
            this.handleException();
            this.handleVendorSpecificCapabilities();
            this.handleSLD();
            this.handleLayers();
            this.end("Capability");
        }

        private void handleRequest() {
            this.start("Request");
            this.start("GetCapabilities");
            for (String mimeType : WMS_CAPS_AVAIL_MIME) {
                this.element("Format", mimeType);
            }
            String serviceUrl = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wms", (Map)ResponseUtils.params((String[])new String[]{"SERVICE", "WMS"}), (URLMangler.URLType)URLMangler.URLType.SERVICE);
            serviceUrl = ResponseUtils.appendQueryString((String)serviceUrl, (String)"");
            this.handleDcpType(serviceUrl, serviceUrl);
            this.end("GetCapabilities");
            this.start("GetMap");
            ArrayList<String> sortedFormats = new ArrayList<String>(this.getMapFormats);
            Collections.sort(sortedFormats);
            if (sortedFormats.contains("image/png")) {
                sortedFormats.remove("image/png");
                sortedFormats.add(0, "image/png");
            }
            Iterator it = sortedFormats.iterator();
            while (it.hasNext()) {
                this.element("Format", String.valueOf(it.next()));
            }
            this.handleDcpType(serviceUrl, null);
            this.end("GetMap");
            this.start("GetFeatureInfo");
            for (String format : this.wmsConfig.getAllowedFeatureInfoFormats()) {
                this.element("Format", format);
            }
            this.handleDcpType(serviceUrl, serviceUrl);
            this.end("GetFeatureInfo");
            this.start("DescribeLayer");
            this.element("Format", GetCapabilitiesTransformer.WMS_CAPS_DEFAULT_MIME);
            this.handleDcpType(serviceUrl, null);
            this.end("DescribeLayer");
            this.start("GetLegendGraphic");
            for (String format : this.getLegendGraphicFormats) {
                this.element("Format", format);
            }
            this.handleDcpType(serviceUrl, null);
            this.end("GetLegendGraphic");
            this.start("GetStyles");
            this.element("Format", "application/vnd.ogc.sld+xml");
            this.handleDcpType(serviceUrl, null);
            this.end("GetStyles");
            this.end("Request");
        }

        private void handleDcpType(String getUrl, String postUrl) {
            AttributesImpl orAtts = new AttributesImpl();
            orAtts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
            orAtts.addAttribute("", "xlink:type", "xlink:type", "", "simple");
            orAtts.addAttribute("", "xlink:href", "xlink:href", "", getUrl);
            this.start("DCPType");
            this.start("HTTP");
            if (getUrl != null) {
                this.start("Get");
                this.element("OnlineResource", null, orAtts);
                this.end("Get");
            }
            if (postUrl != null) {
                orAtts.setAttribute(2, "", "xlink:href", "xlink:href", "", postUrl);
                this.start("Post");
                this.element("OnlineResource", null, orAtts);
                this.end("Post");
            }
            this.end("HTTP");
            this.end("DCPType");
        }

        private void handleException() {
            this.start("Exception");
            for (String exceptionFormat : EXCEPTION_FORMATS) {
                this.element("Format", exceptionFormat);
            }
            if (JSONType.isJsonpEnabled()) {
                this.element("Format", "text/javascript");
            }
            this.end("Exception");
        }

        private void handleSLD() {
            AttributesImpl sldAtts = new AttributesImpl();
            String supportsSLD = this.wmsConfig.supportsSLD() ? "1" : "0";
            String supportsUserLayer = this.wmsConfig.supportsUserLayer() ? "1" : "0";
            String supportsUserStyle = this.wmsConfig.supportsUserStyle() ? "1" : "0";
            String supportsRemoteWFS = this.wmsConfig.supportsRemoteWFS() ? "1" : "0";
            sldAtts.addAttribute("", "SupportSLD", "SupportSLD", "", supportsSLD);
            sldAtts.addAttribute("", "UserLayer", "UserLayer", "", supportsUserLayer);
            sldAtts.addAttribute("", "UserStyle", "UserStyle", "", supportsUserStyle);
            sldAtts.addAttribute("", "RemoteWFS", "RemoteWFS", "", supportsRemoteWFS);
            this.start("UserDefinedSymbolization", sldAtts);
            this.end("UserDefinedSymbolization");
        }

        private void handleVendorSpecificCapabilities() {
            int numberRoots = 0;
            for (ExtendedCapabilitiesProvider cp : this.extCapsProviders) {
                List<String> roots = cp.getVendorSpecificCapabilitiesRoots(this.request);
                if (roots == null) continue;
                numberRoots += roots.size();
            }
            if (numberRoots == 0) {
                return;
            }
            this.start("VendorSpecificCapabilities");
            for (ExtendedCapabilitiesProvider cp : this.extCapsProviders) {
                try {
                    cp.encode(new ExtendedCapabilitiesProvider.Translator(){

                        public void start(String element) {
                            this.start(element);
                        }

                        public void start(String element, Attributes attributes) {
                            this.start(element, attributes);
                        }

                        public void chars(String text) {
                            this.chars(text);
                        }

                        public void end(String element) {
                            this.end(element);
                        }
                    }, this.serviceInfo, this.request);
                }
                catch (Exception e) {
                    throw new ServiceException("Extended capabilities provider threw error", (Throwable)e);
                }
            }
            this.end("VendorSpecificCapabilities");
        }

        private void handleLayers() {
            Set<LayerInfo> layersAlreadyProcessed;
            List<LayerGroupInfo> layerGroups;
            List<LayerInfo> layers = this.getOrderedLayers();
            if (this.includeRootLayer(layers, layerGroups = this.getOrderedLayerGroups(), layersAlreadyProcessed = this.getLayersInGroups(new ArrayList<LayerGroupInfo>(layerGroups)))) {
                this.start("Layer");
                if (StringUtils.isBlank((CharSequence)this.serviceInfo.getRootLayerTitle())) {
                    this.element("Title", this.serviceInfo.getTitle());
                } else {
                    this.element("Title", this.serviceInfo.getRootLayerTitle());
                }
                if (StringUtils.isBlank((CharSequence)this.serviceInfo.getRootLayerAbstract())) {
                    this.element("Abstract", this.serviceInfo.getAbstract());
                } else {
                    this.element("Abstract", this.serviceInfo.getRootLayerAbstract());
                }
                Set<String> srs = this.getServiceSRSList();
                this.handleRootCrsList(srs);
                this.handleRootBbox(layers);
                this.handleAuthorityURL(this.serviceInfo.getAuthorityURLs());
                this.handleLayerIdentifiers(this.serviceInfo.getIdentifiers());
                try {
                    this.handleLayerGroups(new ArrayList<LayerGroupInfo>(layerGroups), false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't obtain Envelope of Layer-Groups: " + e.getMessage(), e);
                }
                LayerTree featuresLayerTree = new LayerTree(layers);
                this.handleLayerTree(featuresLayerTree, layersAlreadyProcessed, false);
                this.end("Layer");
            } else if (layerGroups.size() > 0) {
                try {
                    this.handleLayerGroups(new ArrayList<LayerGroupInfo>(layerGroups), true);
                }
                catch (Exception e) {
                    throw new RuntimeException("Can't obtain Envelope of Layer-Groups: " + e.getMessage(), e);
                }
            } else {
                LayerTree featuresLayerTree = new LayerTree(layers);
                this.handleLayerTree(featuresLayerTree, layersAlreadyProcessed, true);
            }
        }

        private boolean includeRootLayer(List<LayerInfo> layers, List<LayerGroupInfo> layerGroups, Set<LayerInfo> layersAlreadyProcessed) {
            PublishedInfo singleRoot = this.getSingleRoot(layers, layerGroups, layersAlreadyProcessed);
            if (singleRoot != null) {
                if (this.includeRootLayer != null) {
                    return this.includeRootLayer;
                }
                Boolean layerIncludeRoot = (Boolean)singleRoot.getMetadata().get("rootInCapabilities", Boolean.class);
                if (layerIncludeRoot != null) {
                    return layerIncludeRoot;
                }
                return this.wmsConfig.isRootLayerInCapabilitesEnabled();
            }
            return true;
        }

        private PublishedInfo getSingleRoot(List<LayerInfo> layers, List<LayerGroupInfo> layerGroups, Set<LayerInfo> layersAlreadyProcessed) {
            List rootLayers = layers.stream().filter(layer -> this.includeLayer(layersAlreadyProcessed, (LayerInfo)layer)).collect(Collectors.toList());
            List<LayerGroupInfo> rootGroups = this.filterNestedGroups(layerGroups);
            if (rootLayers.size() == 1 && rootGroups.size() == 0) {
                return (PublishedInfo)rootLayers.get(0);
            }
            if (rootLayers.size() == 0 && rootGroups.size() == 1) {
                return (PublishedInfo)rootGroups.get(0);
            }
            return null;
        }

        private Set<String> getServiceSRSList() {
            List<String> srsList = this.serviceInfo.getSRS();
            LinkedHashSet<String> srs = new LinkedHashSet<String>();
            if (srsList != null) {
                srs.addAll(srsList);
            }
            for (ExtendedCapabilitiesProvider provider : this.extCapsProviders) {
                provider.customizeRootCrsList(srs);
            }
            return srs;
        }

        private List<LayerGroupInfo> getOrderedLayerGroups() {
            Catalog catalog = this.wmsConfig.getCatalog();
            Filter filter = Predicates.acceptAll();
            this.addNameSpaceFilterIfNeed(filter, "workspace.name");
            SortBy order = Predicates.asc((String)"name");
            try (CloseableIterator iter = catalog.list(LayerGroupInfo.class, filter, null, null, order);){
                ArrayList arrayList = Lists.newArrayList((Iterator)iter);
                return arrayList;
            }
        }

        private List<LayerInfo> getOrderedLayers() {
            Catalog catalog = this.wmsConfig.getCatalog();
            Filter filter = Predicates.equal((String)"enabled", (Object)Boolean.TRUE);
            this.addNameSpaceFilterIfNeed(filter, "resource.namespace.prefix");
            SortBy order = Predicates.asc((String)"name");
            try (CloseableIterator iter = catalog.list(LayerInfo.class, filter, null, null, order);){
                ArrayList arrayList = Lists.newArrayList((Iterator)iter);
                return arrayList;
            }
        }

        private Filter addNameSpaceFilterIfNeed(Filter filter, String nameSpaceProperty) {
            String nameSpacePrefix = this.request.getNamespace();
            if (nameSpacePrefix == null) {
                return filter;
            }
            Filter equals = Predicates.equal((String)nameSpaceProperty, (Object)nameSpacePrefix);
            return Predicates.and((Filter)filter, (Filter)equals);
        }

        private void handleRootCrsList(Set<String> epsgCodes) {
            LinkedHashSet<Object> capabilitiesCrsIdentifiers;
            if (epsgCodes.isEmpty()) {
                this.comment("All supported EPSG projections:");
                capabilitiesCrsIdentifiers = new LinkedHashSet();
                for (String code : CRS.getSupportedCodes((String)"AUTO")) {
                    if ("WGS84(DD)".equals(code)) continue;
                    capabilitiesCrsIdentifiers.add("AUTO:" + code);
                }
                capabilitiesCrsIdentifiers.addAll(CRS.getSupportedCodes((String)"EPSG"));
            } else {
                this.comment("Limited list of EPSG projections:");
                capabilitiesCrsIdentifiers = new LinkedHashSet<String>(epsgCodes);
            }
            try {
                for (String string : capabilitiesCrsIdentifiers) {
                    if ("WGS84(DD)".equals(string)) continue;
                    String currentSRS = this.qualifySRS(string);
                    this.element("SRS", currentSRS);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }

        private void handleRootBbox(Collection<LayerInfo> layers) {
            Envelope latlonBbox = new Envelope();
            ReferencedEnvelope layerBbox = null;
            LOGGER.finer("Collecting summarized latlonbbox and common SRS...");
            for (LayerInfo layer : layers) {
                ResourceInfo resource = layer.getResource();
                layerBbox = resource.getLatLonBoundingBox();
                if (layerBbox == null) continue;
                latlonBbox.expandToInclude((Envelope)layerBbox);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Summarized LatLonBBox is " + latlonBbox);
            }
            this.handleLatLonBBox(latlonBbox);
            this.handleAdditionalBBox(new ReferencedEnvelope(latlonBbox, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), null, null);
        }

        private boolean isExposable(LayerInfo layer) {
            if (!layer.isEnabled()) {
                return false;
            }
            return WMS.isWmsExposable(layer);
        }

        private void handleLayerTree(LayerTree layerTree, Set<LayerInfo> layersAlreadyProcessed, boolean isRoot) {
            ArrayList<LayerInfo> data = new ArrayList<LayerInfo>(layerTree.getData());
            Collection<LayerTree> children = layerTree.getChildrens();
            Collections.sort(data, new Comparator<LayerInfo>(){

                @Override
                public int compare(LayerInfo o1, LayerInfo o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (LayerInfo layer : data) {
                if (!this.includeLayer(layersAlreadyProcessed, layer)) continue;
                try {
                    this.mark();
                    this.handleLayer(layer, isRoot);
                    this.commit();
                }
                catch (Exception e) {
                    if (this.skipping) {
                        this.reset();
                        LOGGER.log(Level.WARNING, "Error writing metadata; skipping layer: " + layer.getName(), e);
                        continue;
                    }
                    throw new ServiceException("Error occurred trying to write out metadata for layer: " + layer.getName(), (Throwable)e);
                }
            }
            for (LayerTree childLayerTree : children) {
                this.start("Layer");
                this.element("Name", childLayerTree.getName());
                this.element("Title", childLayerTree.getName());
                this.handleLayerTree(childLayerTree, layersAlreadyProcessed, false);
                this.end("Layer");
            }
        }

        private boolean includeLayer(Set<LayerInfo> layersAlreadyProcessed, LayerInfo layer) {
            return layer.enabled() && !layersAlreadyProcessed.contains(layer) && this.isExposable(layer);
        }

        protected void handleLayer(LayerInfo layer, boolean isRoot) throws IOException {
            ReferencedEnvelope bbox;
            String layerName = layer.prefixedName();
            AttributesImpl qatts = new AttributesImpl();
            boolean queryable = this.wmsConfig.isQueryable(layer);
            qatts.addAttribute("", "queryable", "queryable", "", queryable ? "1" : "0");
            boolean opaque = this.wmsConfig.isOpaque(layer);
            qatts.addAttribute("", "opaque", "opaque", "", opaque ? "1" : "0");
            Integer cascaded = this.wmsConfig.getCascadedHopCount(layer);
            if (cascaded != null) {
                qatts.addAttribute("", "cascaded", "cascaded", "", String.valueOf(cascaded));
            }
            this.start("Layer", qatts);
            this.element("Name", layerName);
            this.element("Title", layer.getResource().getTitle());
            this.element("Abstract", layer.getResource().getAbstract());
            this.handleKeywordList(layer.getResource().getKeywords());
            String srs = layer.getResource().getSRS();
            if (isRoot) {
                Set<String> srsList = this.getServiceSRSList();
                this.handleRootCrsList(srsList);
            } else {
                this.element("SRS", srs);
            }
            try {
                bbox = layer.getResource().boundingBox();
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected error obtaining bounding box for layer " + layer.getName(), e);
            }
            ReferencedEnvelope llbbox = layer.getResource().getLatLonBoundingBox();
            this.handleLatLonBBox((Envelope)llbbox);
            if (bbox != null) {
                this.handleBBox((Envelope)bbox, srs);
                this.handleAdditionalBBox(bbox, srs, (PublishedInfo)layer);
            }
            if (layer.getType() == PublishedType.VECTOR) {
                this.dimensionHelper.handleVectorLayerDimensions(layer);
            } else if (layer.getType() == PublishedType.RASTER) {
                this.dimensionHelper.handleRasterLayerDimensions(layer);
            } else if (layer.getType() == PublishedType.WMTS) {
                this.dimensionHelper.handleWMTSLayerDimensions(layer);
            }
            this.handleAttribution((PublishedInfo)layer);
            if (isRoot) {
                this.handleAuthorityURL(this.serviceInfo.getAuthorityURLs());
            }
            this.handleAuthorityURL(layer.getAuthorityURLs());
            this.handleLayerIdentifiers(layer.getIdentifiers());
            this.handleMetadataList(layer.getResource().getMetadataLinks());
            this.handleDataList(layer.getResource().getDataLinks());
            if (!(layer.getResource() instanceof WMTSLayerInfo)) {
                this.handleStyles(layerName, layer.getDefaultStyle(), layer.getStyles());
            }
            this.handleScaleHint((PublishedInfo)layer);
            this.end("Layer");
        }

        private void handleCommonStyleElements(StyleInfo styleInfo) {
            Style ftStyle;
            try {
                ftStyle = styleInfo.getStyle();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.element("Name", styleInfo.prefixedName());
            if (ftStyle.getDescription() != null) {
                if (ftStyle.getDescription().getTitle() != null) {
                    this.element("Title", ftStyle.getDescription().getTitle());
                } else {
                    this.element("Title", styleInfo.prefixedName());
                }
                this.element("Abstract", ftStyle.getDescription().getAbstract());
            }
        }

        private void element(String element, InternationalString is) {
            if (is != null) {
                this.element(element, is.toString());
            }
        }

        private void handleScaleHint(PublishedInfo layer) {
            try {
                Double maxScaleHint;
                Double minScaleHint;
                boolean scaleUnitPixel;
                NumberRange<Double> scaleDenominators = CapabilityUtil.searchMinMaxScaleDenominator(layer);
                for (ExtendedCapabilitiesProvider provider : this.extCapsProviders) {
                    scaleDenominators = provider.overrideScaleDenominators(layer, scaleDenominators);
                }
                if (scaleDenominators.getMinimum() == 0.0 && scaleDenominators.getMaximum() == Double.POSITIVE_INFINITY) {
                    return;
                }
                boolean bl = scaleUnitPixel = this.wmsConfig.getScalehintUnitPixel() != null && this.wmsConfig.getScalehintUnitPixel() != false;
                if (scaleUnitPixel) {
                    minScaleHint = CapabilityUtil.computeScaleHint((Double)scaleDenominators.getMinValue());
                    maxScaleHint = CapabilityUtil.computeScaleHint((Double)scaleDenominators.getMaxValue());
                } else {
                    minScaleHint = (Double)scaleDenominators.getMinValue();
                    maxScaleHint = (Double)scaleDenominators.getMaxValue();
                }
                AttributesImpl attrs = new AttributesImpl();
                attrs.addAttribute("", MIN_DENOMINATOR_ATTR, MIN_DENOMINATOR_ATTR, "", String.valueOf(minScaleHint));
                attrs.addAttribute("", MAX_DENOMINATOR_ATTR, MAX_DENOMINATOR_ATTR, "", String.valueOf(maxScaleHint));
                this.element("ScaleHint", null, attrs);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }

        private String qualifySRS(String srs) {
            if (srs.indexOf(58) == -1) {
                srs = EPSG + srs;
            }
            return srs;
        }

        protected void handleLayerGroup(LayerGroupInfo layerGroup, boolean isRoot) throws TransformException, FactoryException, IOException {
            String layerName = layerGroup.prefixedName();
            AttributesImpl qatts = new AttributesImpl();
            boolean queryable = this.wmsConfig.isQueryable(layerGroup);
            qatts.addAttribute("", "queryable", "queryable", "", queryable ? "1" : "0");
            this.start("Layer", qatts);
            if (!LayerGroupInfo.Mode.CONTAINER.equals((Object)layerGroup.getMode())) {
                this.element("Name", layerName);
            }
            if (StringUtils.isEmpty((CharSequence)layerGroup.getTitle())) {
                this.element("Title", layerName);
            } else {
                this.element("Title", layerGroup.getTitle());
            }
            if (StringUtils.isEmpty((CharSequence)layerGroup.getAbstract())) {
                this.element("Abstract", "Layer-Group type layer: " + layerName);
            } else {
                this.element("Abstract", layerGroup.getAbstract());
            }
            this.handleKeywordList(layerGroup.getKeywords());
            ReferencedEnvelope layerGroupBounds = layerGroup.getBounds();
            ReferencedEnvelope latLonBounds = layerGroupBounds.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
            String authority = layerGroupBounds.getCoordinateReferenceSystem().getIdentifiers().toArray()[0].toString();
            if (isRoot) {
                Set<String> srsList = this.getServiceSRSList();
                this.handleRootCrsList(srsList);
            } else {
                this.element("SRS", authority);
            }
            this.handleLatLonBBox((Envelope)latLonBounds);
            this.handleBBox((Envelope)layerGroupBounds, authority);
            this.handleAdditionalBBox(layerGroupBounds, authority, (PublishedInfo)layerGroup);
            if (LayerGroupInfo.Mode.EO.equals((Object)layerGroup.getMode())) {
                LayerInfo rootLayer = layerGroup.getRootLayer();
                if (rootLayer.getType() == PublishedType.VECTOR) {
                    this.dimensionHelper.handleVectorLayerDimensions(rootLayer);
                } else if (rootLayer.getType() == PublishedType.RASTER) {
                    this.dimensionHelper.handleRasterLayerDimensions(rootLayer);
                }
            }
            this.handleAttribution((PublishedInfo)layerGroup);
            if (isRoot) {
                this.handleAuthorityURL(this.serviceInfo.getAuthorityURLs());
            }
            this.handleAuthorityURL(layerGroup.getAuthorityURLs());
            this.handleLayerIdentifiers(layerGroup.getIdentifiers());
            Collection metadataLinks = layerGroup.getMetadataLinks();
            if (metadataLinks == null || metadataLinks.isEmpty()) {
                HashSet aggregatedLinks = new HashSet();
                for (LayerInfo layer : Iterables.filter((Iterable)layerGroup.getLayers(), LayerInfo.class)) {
                    List metadataLinksLayer = layer.getResource().getMetadataLinks();
                    if (metadataLinksLayer == null) continue;
                    aggregatedLinks.addAll(metadataLinksLayer);
                }
                metadataLinks = aggregatedLinks;
            }
            this.handleMetadataList(metadataLinks);
            if (!LayerGroupInfo.Mode.OPAQUE_CONTAINER.equals((Object)layerGroup.getMode()) && !LayerGroupInfo.Mode.SINGLE.equals((Object)layerGroup.getMode())) {
                for (PublishedInfo child : layerGroup.getLayers()) {
                    if (child instanceof LayerInfo) {
                        LayerInfo layer;
                        layer = (LayerInfo)child;
                        if (!this.isExposable(layer)) continue;
                        this.handleLayer((LayerInfo)child, false);
                        continue;
                    }
                    this.handleLayerGroup((LayerGroupInfo)child, false);
                }
            }
            this.handleLayerGroupStyles(layerName);
            this.handleScaleHint((PublishedInfo)layerGroup);
            this.end("Layer");
        }

        protected Set<LayerInfo> getLayersInGroups(List<LayerGroupInfo> layerGroups) {
            HashSet<LayerInfo> layersAlreadyProcessed = new HashSet<LayerInfo>();
            if (layerGroups == null || layerGroups.size() == 0) {
                return layersAlreadyProcessed;
            }
            List<LayerGroupInfo> topLevelGroups = this.filterNestedGroups(layerGroups);
            for (LayerGroupInfo layerGroup : topLevelGroups) {
                this.getLayersInGroup(layerGroup, layersAlreadyProcessed);
            }
            return layersAlreadyProcessed;
        }

        private void getLayersInGroup(LayerGroupInfo layerGroup, Set<LayerInfo> layersAlreadyProcessed) {
            if (LayerGroupInfo.Mode.EO.equals((Object)layerGroup.getMode())) {
                layersAlreadyProcessed.add(layerGroup.getRootLayer());
            }
            if (LayerGroupInfo.Mode.OPAQUE_CONTAINER.equals((Object)layerGroup.getMode())) {
                layersAlreadyProcessed.addAll(layerGroup.layers());
            } else if (!LayerGroupInfo.Mode.SINGLE.equals((Object)layerGroup.getMode())) {
                for (PublishedInfo child : layerGroup.getLayers()) {
                    if (child instanceof LayerInfo) {
                        LayerInfo layer = (LayerInfo)child;
                        if (!this.isExposable(layer)) continue;
                        layersAlreadyProcessed.add((LayerInfo)child);
                        continue;
                    }
                    this.getLayersInGroup((LayerGroupInfo)child, layersAlreadyProcessed);
                }
            }
        }

        protected void handleLayerGroups(List<LayerGroupInfo> layerGroups, boolean isRoot) throws FactoryException, TransformException, IOException {
            if (layerGroups != null) {
                List<LayerGroupInfo> topLevelGropus = this.filterNestedGroups(layerGroups);
                for (LayerGroupInfo layerGroup : topLevelGropus) {
                    try {
                        this.mark();
                        this.handleLayerGroup(layerGroup, isRoot);
                        this.commit();
                    }
                    catch (Exception e) {
                        if (this.skipping) {
                            if (layerGroup != null) {
                                LOGGER.log(Level.WARNING, "Skipping layer group " + layerGroup.getName() + " as its caps document element failed to generate", e);
                            } else {
                                LOGGER.log(Level.WARNING, "Skipping a null layer group during caps document generation", e);
                            }
                            this.reset();
                            continue;
                        }
                        throw new ServiceException("Error occurred trying to write out metadata for layer group: " + layerGroup.getName(), (Throwable)e);
                    }
                }
            }
        }

        private List<LayerGroupInfo> filterNestedGroups(List<LayerGroupInfo> allGroups) {
            LinkedHashSet<LayerGroupInfo> result = new LinkedHashSet<LayerGroupInfo>(allGroups);
            for (LayerGroupInfo group : allGroups) {
                for (PublishedInfo pi : group.getLayers()) {
                    if (!(pi instanceof LayerGroupInfo)) continue;
                    result.remove(pi);
                }
            }
            return new ArrayList<LayerGroupInfo>(result);
        }

        protected void handleAttribution(PublishedInfo layer) {
            AttributionInfo attribution = layer.getAttribution();
            if (attribution != null) {
                boolean logoGood;
                String title = attribution.getTitle();
                String url = attribution.getHref();
                String logoURL = attribution.getLogoURL();
                String logoType = attribution.getLogoType();
                int logoWidth = attribution.getLogoWidth();
                int logoHeight = attribution.getLogoHeight();
                boolean titleGood = title != null;
                boolean urlGood = url != null;
                boolean bl = logoGood = logoURL != null && logoType != null && logoWidth > 0 && logoHeight > 0;
                if (titleGood || urlGood || logoGood) {
                    this.start("Attribution");
                    if (titleGood) {
                        this.element("Title", title);
                    }
                    if (urlGood) {
                        AttributesImpl urlAttributes = new AttributesImpl();
                        urlAttributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                        urlAttributes.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                        urlAttributes.addAttribute(XLINK_NS, "href", "xlink:href", "", url);
                        this.element("OnlineResource", null, urlAttributes);
                    }
                    if (logoGood) {
                        AttributesImpl logoAttributes = new AttributesImpl();
                        logoAttributes.addAttribute("", "", "height", "", "" + logoHeight);
                        logoAttributes.addAttribute("", "", "width", "", "" + logoWidth);
                        this.start("LogoURL", logoAttributes);
                        this.element("Format", logoType);
                        AttributesImpl urlAttributes = new AttributesImpl();
                        urlAttributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                        urlAttributes.addAttribute(XLINK_NS, "type", "xlink:type", "", "simple");
                        urlAttributes.addAttribute(XLINK_NS, "href", "xlink:href", "", logoURL);
                        this.element("OnlineResource", null, urlAttributes);
                        this.end("LogoURL");
                    }
                    this.end("Attribution");
                }
            }
        }

        protected void handleLegendURL(String layerName, LegendInfo legend, StyleInfo style, StyleInfo sampleStyle) {
            int legendWidth = 20;
            int legendHeight = 20;
            String defaultFormat = "image/png";
            if (CapabilityUtil.validateLegendInfo(legend)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("using user supplied legend URL");
                }
                legendWidth = legend.getWidth();
                legendHeight = legend.getHeight();
                defaultFormat = legend.getFormat().replaceFirst(";charset=utf-8", "");
            } else if (sampleStyle != null) {
                try {
                    Dimension dimension = this.legendSample.getLegendURLSize(sampleStyle);
                    if (dimension != null) {
                        legendWidth = (int)dimension.getWidth();
                        legendHeight = (int)dimension.getHeight();
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error getting LegendURL dimensions from sample", e);
                }
            }
            if (null == this.wmsConfig.getLegendGraphicOutputFormat(defaultFormat)) {
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning(new StringBuffer("Default legend format (").append(defaultFormat).append(")is not supported (jai not available?), can't add LegendURL element").toString());
                }
                return;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Adding GetLegendGraphic call as LegendURL");
            }
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "width", "width", "", String.valueOf(legendWidth));
            attrs.addAttribute("", "height", "height", "", String.valueOf(legendHeight));
            this.start("LegendURL", attrs);
            this.element("Format", defaultFormat);
            attrs.clear();
            Map params = ResponseUtils.params((String[])new String[]{"request", "GetLegendGraphic", "format", defaultFormat, "width", String.valueOf(20), "height", String.valueOf(20), "layer", layerName});
            if (style != null) {
                params.put("style", style.getName());
            }
            String legendURL = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wms", (Map)params, (URLMangler.URLType)URLMangler.URLType.SERVICE);
            CapabilityUtil.addGetLegendAttributes(attrs, legendURL, XLINK_NS);
            this.element("OnlineResource", null, attrs);
            this.end("LegendURL");
        }

        private void handleLatLonBBox(Envelope bbox) {
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            AttributesImpl bboxAtts = new AttributesImpl();
            bboxAtts.addAttribute("", "minx", "minx", "", minx);
            bboxAtts.addAttribute("", "miny", "miny", "", miny);
            bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
            bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
            this.element("LatLonBoundingBox", null, bboxAtts);
        }

        private void handleBBox(Envelope bbox, String SRS) {
            String minx = String.valueOf(bbox.getMinX());
            String miny = String.valueOf(bbox.getMinY());
            String maxx = String.valueOf(bbox.getMaxX());
            String maxy = String.valueOf(bbox.getMaxY());
            AttributesImpl bboxAtts = new AttributesImpl();
            bboxAtts.addAttribute("", "SRS", "SRS", "", SRS);
            bboxAtts.addAttribute("", "minx", "minx", "", minx);
            bboxAtts.addAttribute("", "miny", "miny", "", miny);
            bboxAtts.addAttribute("", "maxx", "maxx", "", maxx);
            bboxAtts.addAttribute("", "maxy", "maxy", "", maxy);
            this.element("BoundingBox", null, bboxAtts);
        }

        private void handleAdditionalBBox(ReferencedEnvelope bbox, String srs, PublishedInfo layer) {
            if (this.serviceInfo.isBBOXForEachCRS().booleanValue() && !this.serviceInfo.getSRS().isEmpty()) {
                for (String crs : this.serviceInfo.getSRS()) {
                    crs = this.qualifySRS(crs);
                    if (srs != null && srs.equals(crs)) continue;
                    CoordinateReferenceSystem targetCrs = null;
                    try {
                        targetCrs = CRS.decode((String)crs);
                        ReferencedEnvelope tbbox = bbox.transform(targetCrs, true);
                        this.handleBBox((Envelope)tbbox, crs);
                    }
                    catch (Exception e) {
                        try {
                            CapabilitiesTransformerProjectionHandler handler = CapabilitiesTransformerProjectionHandler.create(targetCrs, bbox.getCoordinateReferenceSystem());
                            if (handler == null) {
                                LOGGER.warning(String.format("Unable to transform bounding box for '%s' layer to %s", layer != null ? layer.getName() : "root", crs));
                                if (!LOGGER.isLoggable(Level.FINE)) continue;
                                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                                continue;
                            }
                            ReferencedEnvelope tbbox = handler.transformEnvelope(bbox, targetCrs);
                            this.handleBBox((Envelope)tbbox, crs);
                        }
                        catch (FactoryException | TransformException e1) {
                            LOGGER.warning(String.format("Unable to transform bounding box for '%s' layer to %s", layer != null ? layer.getName() : "root", crs));
                            if (!LOGGER.isLoggable(Level.FINE)) continue;
                            LOGGER.log(Level.FINE, e1.getLocalizedMessage(), e1);
                        }
                    }
                }
            }
        }

        private void handleAuthorityURL(List<AuthorityURLInfo> authorityURLs) {
            if (authorityURLs == null || authorityURLs.isEmpty()) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            for (AuthorityURLInfo url : authorityURLs) {
                String name = url.getName();
                String href = url.getHref();
                if (name == null || href == null) {
                    LOGGER.warning("Ignoring AuthorityURL, name: " + name + ", href: " + href);
                    continue;
                }
                atts.clear();
                atts.addAttribute("", "name", "name", "", name);
                this.start("AuthorityURL", atts);
                atts.clear();
                atts.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", XLINK_NS);
                atts.addAttribute("", "xlink:href", "xlink:href", "", href);
                this.element("OnlineResource", null, atts);
                this.end("AuthorityURL");
            }
        }

        private void handleLayerIdentifiers(List<LayerIdentifierInfo> identifiers) {
            if (identifiers == null || identifiers.isEmpty()) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            for (LayerIdentifierInfo identifier : identifiers) {
                String authority = identifier.getAuthority();
                String id = identifier.getIdentifier();
                if (authority == null || id == null) {
                    LOGGER.warning("Ignoring layer Identifier, authority: " + authority + ", identifier: " + id);
                    continue;
                }
                atts.clear();
                atts.addAttribute("", "authority", "authority", "", authority);
                this.element("Identifier", id, atts);
            }
        }

        private void handleStyles(String prefixedLayerName, StyleInfo defaultStyle, Set<StyleInfo> styles) {
            if (defaultStyle == null) {
                throw new NullPointerException("Layer " + prefixedLayerName + " has no default style");
            }
            this.start("Style");
            this.handleCommonStyleElements(defaultStyle);
            this.handleLegendURL(prefixedLayerName, defaultStyle.getLegend(), null, defaultStyle);
            this.end("Style");
            if (styles != null) {
                for (StyleInfo styleInfo : styles) {
                    this.start("Style");
                    this.handleCommonStyleElements(styleInfo);
                    this.handleLegendURL(prefixedLayerName, styleInfo.getLegend(), styleInfo, styleInfo);
                    this.end("Style");
                }
            }
        }

        private void handleLayerGroupStyles(String layerName) {
            this.start("Style");
            this.element("Name", "");
            this.element("Title", "".concat(layerName).concat(" style"));
            this.element("Abstract", "Default style for ".concat(layerName).concat(" layer"));
            this.handleLegendURL(layerName, null, null, null);
            this.end("Style");
        }

        static {
            wmsVersion.addAttribute("", "version", "version", "", "1.1.1");
        }
    }
}

