/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.wms.dimension.AbstractDefaultValueSelectionStrategy;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;

public class CoverageMaximumValueSelectionStrategyImpl
extends AbstractDefaultValueSelectionStrategy {
    private static Logger LOGGER = Logging.getLogger(CoverageMaximumValueSelectionStrategyImpl.class);

    @Override
    public Object getDefaultValue(ResourceInfo resource, String dimensionName, DimensionInfo dimension, Class clz) {
        Object retval = null;
        try {
            GridCoverage2DReader reader = (GridCoverage2DReader)((CoverageInfo)resource).getGridCoverageReader(null, null);
            ReaderDimensionsAccessor dimAccessor = new ReaderDimensionsAccessor(reader);
            if (dimensionName.equals("time")) {
                retval = dimAccessor.getMaxTime();
            } else if (dimensionName.equals("elevation")) {
                retval = dimAccessor.getMaxElevation();
            } else if (dimensionName.startsWith("custom_dimension_")) {
                String custDimName = dimensionName.substring("custom_dimension_".length());
                String maximum = reader.getMetadataValue(custDimName.toUpperCase() + "_DOMAIN_MAXIMUM");
                if (maximum != null) {
                    retval = maximum;
                } else {
                    List domain = dimAccessor.getDomain(custDimName);
                    if (domain.isEmpty()) {
                        retval = null;
                    } else {
                        Collections.sort(domain);
                        retval = domain.get(domain.size() - 1);
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
        }
        return Converters.convert(retval, (Class)clz);
    }
}

