/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.dimension.AbstractDefaultValueSelectionStrategy;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.feature.type.DateUtil;
import org.geotools.util.Converters;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;

public class CoverageNearestValueSelectionStrategyImpl
extends AbstractDefaultValueSelectionStrategy {
    private static Logger LOGGER = Logging.getLogger(CoverageNearestValueSelectionStrategyImpl.class);
    private Object toMatch;
    private String fixedCapabilitiesValue;

    public CoverageNearestValueSelectionStrategyImpl(Object toMatch) {
        this(toMatch, null);
    }

    public CoverageNearestValueSelectionStrategyImpl(Object toMatch, String capabilitiesValue) {
        this.toMatch = toMatch;
        this.fixedCapabilitiesValue = capabilitiesValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getDefaultValue(ResourceInfo resource, String dimensionName, DimensionInfo dimension, Class clz) {
        Object retval = null;
        try {
            GridCoverage2DReader reader = (GridCoverage2DReader)((CoverageInfo)resource).getGridCoverageReader(null, null);
            ReaderDimensionsAccessor dimAccessor = new ReaderDimensionsAccessor(reader);
            if (dimensionName.equals("time")) {
                Date dateToMatch = null;
                if (this.toMatch instanceof Date) {
                    dateToMatch = (Date)this.toMatch;
                } else if (this.toMatch instanceof Long) {
                    dateToMatch = new Date((Long)this.toMatch);
                } else {
                    try {
                        dateToMatch = new Date(DateUtil.parseDateTime((String)this.toMatch.toString()));
                    }
                    catch (IllegalArgumentException e) {
                        throw new ServiceException("Error parsing value to match against while trying to find the default time value for the layer " + resource.getName(), (Throwable)e);
                    }
                }
                retval = this.findNearestTime(dimAccessor, dateToMatch);
                return Converters.convert(retval, (Class)clz);
            }
            if (dimensionName.equals("elevation")) {
                if (!(this.toMatch instanceof Number)) throw new ServiceException("The default value for elevation dimension is not a number. Cannot find a default elevation value for the layer " + resource.getName());
                Double doubleToMatch = ((Number)this.toMatch).doubleValue();
                retval = this.findNearestElevation(dimAccessor, doubleToMatch);
                return Converters.convert(retval, (Class)clz);
            } else {
                if (!dimensionName.startsWith("custom_dimension_")) return Converters.convert(retval, (Class)clz);
                retval = this.findNearestCustomDimensionValue(dimensionName.substring("custom_dimension_".length()), dimAccessor, this.toMatch.toString());
            }
            return Converters.convert(retval, (Class)clz);
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
        }
        return Converters.convert(retval, (Class)clz);
    }

    private Date findNearestTime(ReaderDimensionsAccessor dimAccessor, Date toMatch) throws IOException {
        Date candidate = null;
        TreeSet timeDomain = dimAccessor.getTimeDomain();
        long shortestDistance = Long.MAX_VALUE;
        long currentDistance = 0L;
        for (Object dateOrRange : timeDomain) {
            Date d;
            if (dateOrRange instanceof Date) {
                d = (Date)dateOrRange;
                if (d.before(toMatch)) {
                    currentDistance = toMatch.getTime() - d.getTime();
                    if (currentDistance >= shortestDistance) continue;
                    shortestDistance = currentDistance;
                    candidate = d;
                    continue;
                }
                if (d.after(toMatch)) {
                    currentDistance = d.getTime() - toMatch.getTime();
                    if (currentDistance >= shortestDistance) break;
                    candidate = d;
                    break;
                }
                if (!d.equals(toMatch)) continue;
                candidate = d;
                break;
            }
            if (!(dateOrRange instanceof DateRange)) continue;
            d = (DateRange)dateOrRange;
            if (d.getMaxValue().before(toMatch)) {
                currentDistance = toMatch.getTime() - d.getMaxValue().getTime();
                if (currentDistance >= shortestDistance) continue;
                shortestDistance = currentDistance;
                candidate = d.getMaxValue();
                continue;
            }
            if (d.getMinValue().after(toMatch)) {
                currentDistance = d.getMinValue().getTime() - toMatch.getTime();
                if (currentDistance >= shortestDistance) break;
                candidate = d.getMinValue();
                break;
            }
            candidate = toMatch;
            break;
        }
        return candidate;
    }

    private Double findNearestElevation(ReaderDimensionsAccessor dimAccessor, Double toMatch) throws IOException {
        Double candidate = null;
        TreeSet elevDomain = dimAccessor.getElevationDomain();
        double shortestDistance = Double.MAX_VALUE;
        double currentDistance = 0.0;
        for (Object doubleOrRange : elevDomain) {
            Double d;
            if (doubleOrRange instanceof Double) {
                d = (Double)doubleOrRange;
                int comp = d.compareTo(toMatch);
                if (comp < 0) {
                    currentDistance = toMatch - d;
                    if (!(currentDistance < shortestDistance)) continue;
                    shortestDistance = currentDistance;
                    candidate = d;
                    continue;
                }
                if (comp > 0) {
                    currentDistance = d - toMatch;
                    if (!(currentDistance < shortestDistance)) break;
                    candidate = d;
                    break;
                }
                candidate = d;
                break;
            }
            if (!(doubleOrRange instanceof NumberRange)) continue;
            d = null;
            NumberRange maybeD = (NumberRange)doubleOrRange;
            d = maybeD.getElementClass().equals(Double.class) ? maybeD : maybeD.castTo(Double.class);
            if ((Double)d.getMaxValue() < toMatch) {
                currentDistance = toMatch - (Double)d.getMaxValue();
                if (!(currentDistance < shortestDistance)) continue;
                shortestDistance = currentDistance;
                candidate = (Double)d.getMaxValue();
                continue;
            }
            if ((Double)d.getMinValue() > toMatch) {
                currentDistance = (Double)d.getMinValue() - toMatch;
                if (!(currentDistance < shortestDistance)) break;
                candidate = (Double)d.getMinValue();
                break;
            }
            candidate = toMatch;
            break;
        }
        return candidate;
    }

    private String findNearestCustomDimensionValue(String dimensionName, ReaderDimensionsAccessor dimAccessor, String toMatch) throws IOException {
        String candidate = null;
        List domain = dimAccessor.getDomain(dimensionName);
        Comparator comp = String.CASE_INSENSITIVE_ORDER;
        Collections.sort(domain, comp);
        long shortestDistance = Long.MAX_VALUE;
        long currentDistance = 0L;
        for (String toCompare : domain) {
            int compValue = comp.compare(toCompare, toMatch);
            if (compValue < 0) {
                currentDistance = -compValue;
                if (currentDistance >= shortestDistance) continue;
                shortestDistance = currentDistance;
                candidate = toCompare;
                continue;
            }
            currentDistance = compValue;
            if (currentDistance >= shortestDistance) continue;
            candidate = toCompare;
            break;
        }
        return candidate;
    }

    @Override
    public String getCapabilitiesRepresentation(ResourceInfo resource, String dimensionName, DimensionInfo dimensionInfo) {
        if (this.fixedCapabilitiesValue != null) {
            return this.fixedCapabilitiesValue;
        }
        return super.getCapabilitiesRepresentation(resource, dimensionName, dimensionInfo);
    }

    public Object getTargetValue() {
        return this.toMatch;
    }
}

