/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geoserver.wms.SymbolizerFilteringVisitor;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.RuleImpl;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.style.Fill;

class FeatureInfoStylePreprocessor
extends SymbolizerFilteringVisitor {
    StyleBuilder sb = new StyleBuilder();
    FeatureType schema;
    Set<Expression> geometriesOnPolygonSymbolizer = new HashSet<Expression>();
    Set<Expression> geometriesOnLineSymbolizer = new HashSet<Expression>();
    Set<Expression> geometriesOnPointSymbolizer = new HashSet<Expression>();
    Set<Expression> geometriesOnTextSymbolizer = new HashSet<Expression>();
    Set<Rule> extraRules = new HashSet<Rule>();
    private PropertyName defaultGeometryExpression;
    private boolean addSolidLineSymbolier;

    public FeatureInfoStylePreprocessor(FeatureType schema) {
        this.schema = schema;
        this.defaultGeometryExpression = this.ff.property("");
    }

    public void visit(TextSymbolizer ts) {
        this.pages.push(null);
        this.addGeometryExpression(ts.getGeometry(), this.geometriesOnTextSymbolizer);
    }

    public void visit(org.geotools.styling.Fill fill) {
        super.visit(fill);
        org.geotools.styling.Fill copy = (org.geotools.styling.Fill)this.pages.peek();
        if (copy.getGraphicFill() != null) {
            copy.setGraphicFill(null);
            copy.setColor(this.sb.colorExpression(Color.BLACK));
        }
    }

    public void visit(PolygonSymbolizer poly) {
        super.visit(poly);
        PolygonSymbolizer copy = (PolygonSymbolizer)this.pages.peek();
        org.geotools.styling.Fill fill = copy.getFill();
        if (fill == null || this.isStaticTransparentFill(fill)) {
            copy.setFill((Fill)this.sb.createFill());
        }
        Stroke stroke = copy.getStroke();
        this.addStrokeSymbolizerIfNecessary(stroke);
        this.addGeometryExpression(poly.getGeometry(), this.geometriesOnPolygonSymbolizer);
    }

    private boolean isStaticTransparentFill(org.geotools.styling.Fill fill) {
        Double staticOpacity;
        return fill.getOpacity() instanceof Literal && ((staticOpacity = (Double)fill.getOpacity().evaluate(null, Double.class)) == null || staticOpacity == 0.0);
    }

    public void visit(LineSymbolizer line) {
        super.visit(line);
        LineSymbolizer copy = (LineSymbolizer)this.pages.peek();
        Stroke stroke = copy.getStroke();
        this.addStrokeSymbolizerIfNecessary(stroke);
        this.addGeometryExpression(line.getGeometry(), this.geometriesOnLineSymbolizer);
    }

    public void visit(PointSymbolizer ps) {
        super.visit(ps);
        this.addGeometryExpression(ps.getGeometry(), this.geometriesOnPointSymbolizer);
    }

    private void addGeometryExpression(Expression geometry, Set<Expression> expressions) {
        if (this.isDefaultGeometry(geometry)) {
            expressions.add((Expression)this.defaultGeometryExpression);
        } else {
            expressions.add(geometry);
        }
    }

    private boolean isDefaultGeometry(Expression geometry) {
        if (geometry == null) {
            return true;
        }
        if (!(geometry instanceof PropertyName)) {
            return false;
        }
        PropertyName pn = (PropertyName)geometry;
        if ("".equals(pn.getPropertyName())) {
            return true;
        }
        GeometryDescriptor gd = this.schema.getGeometryDescriptor();
        if (gd == null) {
            return false;
        }
        return gd.getLocalName().equals(pn.getPropertyName());
    }

    public void visit(Style style) {
        super.visit(style);
        Style copy = (Style)this.pages.peek();
        List featureTypeStyles = copy.featureTypeStyles();
        ArrayList<FeatureTypeStyle> reduced = new ArrayList<FeatureTypeStyle>();
        FeatureTypeStyle current = null;
        for (FeatureTypeStyle fts : featureTypeStyles) {
            if (current == null || !this.sameTranformation(current.getTransformation(), fts.getTransformation())) {
                current = fts;
                reduced.add(current);
                continue;
            }
            current.rules().addAll(fts.rules());
        }
        copy.featureTypeStyles().clear();
        copy.featureTypeStyles().addAll(reduced);
    }

    private boolean sameTranformation(Expression t1, Expression t2) {
        return t1 == null && t2 == null || t1 != null && t1.equals(t2);
    }

    public void visit(FeatureTypeStyle fts) {
        this.extraRules.clear();
        super.visit(fts);
        if (this.extraRules.size() > 0) {
            FeatureTypeStyle copy = (FeatureTypeStyle)this.pages.peek();
            copy.rules().addAll(this.extraRules);
        }
    }

    @Override
    public void visit(Rule rule) {
        RuleImpl extra;
        Class geometryType;
        Object result;
        this.geometriesOnLineSymbolizer.clear();
        this.geometriesOnPolygonSymbolizer.clear();
        this.geometriesOnPointSymbolizer.clear();
        this.geometriesOnTextSymbolizer.clear();
        this.addSolidLineSymbolier = false;
        super.visit(rule);
        Rule copy = (Rule)this.pages.peek();
        if (this.addSolidLineSymbolier) {
            LineSymbolizer ls = this.sb.createLineSymbolizer(Color.BLACK);
            copy.symbolizers().add(ls);
        }
        this.geometriesOnLineSymbolizer.removeAll(this.geometriesOnPolygonSymbolizer);
        for (Expression geom : this.geometriesOnLineSymbolizer) {
            result = geom.evaluate((Object)this.schema);
            geometryType = this.getTargetGeometryType(result);
            if (Polygon.class.isAssignableFrom(geometryType) || MultiPolygon.class.isAssignableFrom(geometryType)) {
                copy.symbolizers().add(this.sb.createPolygonSymbolizer());
                continue;
            }
            if (!geometryType.equals(Geometry.class)) continue;
            extra = this.buildDynamicGeometryRule(copy, geom, (Symbolizer)this.sb.createPolygonSymbolizer(), "Polygon", "MultiPolygon");
            this.extraRules.add((Rule)extra);
        }
        this.geometriesOnTextSymbolizer.removeAll(this.geometriesOnPolygonSymbolizer);
        this.geometriesOnTextSymbolizer.removeAll(this.geometriesOnLineSymbolizer);
        this.geometriesOnTextSymbolizer.removeAll(this.geometriesOnPointSymbolizer);
        for (Expression geom : this.geometriesOnTextSymbolizer) {
            result = geom.evaluate((Object)this.schema);
            geometryType = this.getTargetGeometryType(result);
            if (Polygon.class.isAssignableFrom(geometryType) || MultiPolygon.class.isAssignableFrom(geometryType)) {
                copy.symbolizers().add(this.sb.createPolygonSymbolizer());
                continue;
            }
            if (LineString.class.isAssignableFrom(geometryType) || MultiLineString.class.isAssignableFrom(geometryType)) {
                copy.symbolizers().add(this.sb.createLineSymbolizer());
                continue;
            }
            if (Point.class.isAssignableFrom(geometryType) || MultiPoint.class.isAssignableFrom(geometryType)) {
                copy.symbolizers().add(this.sb.createPointSymbolizer());
                continue;
            }
            extra = this.buildDynamicGeometryRule(copy, geom, (Symbolizer)this.sb.createPolygonSymbolizer(), "Polygon", "MultiPolygon");
            this.extraRules.add((Rule)extra);
            extra = this.buildDynamicGeometryRule(copy, geom, (Symbolizer)this.sb.createLineSymbolizer(), "LineString", "LinearRing", "MultiLineString");
            this.extraRules.add((Rule)extra);
            extra = this.buildDynamicGeometryRule(copy, geom, (Symbolizer)this.sb.createPointSymbolizer(), "Point", "MultiPoint");
            this.extraRules.add((Rule)extra);
        }
    }

    private RuleImpl buildDynamicGeometryRule(Rule base, Expression geom, Symbolizer symbolizer, String ... geometryTypes) {
        ArrayList<PropertyIsEqualTo> typeChecks = new ArrayList<PropertyIsEqualTo>();
        for (String geometryType : geometryTypes) {
            typeChecks.add(this.ff.equal((Expression)this.ff.function("geometryType", new Expression[]{geom}), (Expression)this.ff.literal((Object)geometryType), false));
        }
        Or geomCheck = this.ff.or(typeChecks);
        Filter ruleFilter = base.getFilter();
        Or filter = ruleFilter == null || ruleFilter == Filter.INCLUDE ? geomCheck : this.ff.and((Filter)geomCheck, ruleFilter);
        RuleImpl extra = new RuleImpl((org.opengis.style.Rule)base);
        extra.setFilter((Filter)filter);
        extra.symbolizers().clear();
        extra.symbolizers().add(symbolizer);
        return extra;
    }

    private Class getTargetGeometryType(Object descriptor) {
        if (!(descriptor instanceof GeometryDescriptor)) {
            return Geometry.class;
        }
        return ((GeometryDescriptor)descriptor).getType().getBinding();
    }

    private void addStrokeSymbolizerIfNecessary(Stroke stroke) {
        if (stroke != null) {
            List dashArray = stroke.dashArray();
            Graphic graphicStroke = stroke.getGraphicStroke();
            if (graphicStroke != null || dashArray != null && dashArray.size() > 0) {
                this.addSolidLineSymbolier = true;
            }
        }
    }
}

