/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.lang.model.SourceVersion;
import org.apache.log4j.Logger;

class FreemarkerStaticsAccessRule {
    private static final FreemarkerStaticsAccessRule UNRESTRICTED = new FreemarkerStaticsAccessRule(true);
    private static final FreemarkerStaticsAccessRule DISABLED = new FreemarkerStaticsAccessRule(false);
    private static Logger logger = Logger.getLogger(FreemarkerStaticsAccessRule.class);
    private boolean unrestricted;
    private List<RuleItem> rulesItems = Collections.emptyList();

    public static FreemarkerStaticsAccessRule fromPattern(String aPattern) {
        if (aPattern == null || aPattern.trim().isEmpty()) {
            return DISABLED;
        }
        if ("*".equals(aPattern)) {
            return UNRESTRICTED;
        }
        ArrayList tmpClasses = new ArrayList();
        StringTokenizer tmpTokenizer = new StringTokenizer(aPattern, ",");
        while (tmpTokenizer.hasMoreTokens()) {
            String tmpCandidate = tmpTokenizer.nextToken().trim();
            if (SourceVersion.isName(tmpCandidate)) {
                try {
                    tmpClasses.add(Class.forName(tmpCandidate));
                }
                catch (ClassNotFoundException e) {
                    logger.warn((Object)("Denying access to static members of '" + tmpCandidate + "': Class not found."));
                }
                continue;
            }
            logger.warn((Object)("Denying access to static members of '" + tmpCandidate + "': Not a valid class name."));
        }
        if (tmpClasses.isEmpty()) {
            return DISABLED;
        }
        ArrayList<RuleItem> tmpItems = new ArrayList<RuleItem>();
        HashMap<String, Integer> tmpCounts = new HashMap<String, Integer>();
        for (Class clazz : tmpClasses) {
            String tmpSimpleAlias = clazz.getSimpleName();
            Integer tmpCount = (Integer)tmpCounts.get(tmpSimpleAlias);
            if (tmpCount == null) {
                tmpCount = 1;
                tmpItems.add(new RuleItem(clazz, clazz.getSimpleName(), false));
            } else {
                tmpCount = tmpCount + 1;
                tmpItems.add(new RuleItem(clazz, clazz.getSimpleName() + tmpCount, true));
            }
            tmpCounts.put(tmpSimpleAlias, tmpCount);
        }
        return new FreemarkerStaticsAccessRule(tmpItems);
    }

    public FreemarkerStaticsAccessRule(boolean anUnRestricted) {
        this.unrestricted = anUnRestricted;
    }

    public FreemarkerStaticsAccessRule(List<RuleItem> someItems) {
        this(false);
        this.rulesItems = someItems;
    }

    public List<RuleItem> getAllowedItems() {
        return this.rulesItems;
    }

    public boolean isUnrestricted() {
        return this.unrestricted;
    }

    public String toString() {
        return "FreemarkerStaticsAccessRule [unrestricted=" + this.unrestricted + ", rulesItems=" + this.rulesItems + "]";
    }

    public static final class RuleItem {
        private Class<?> clazz;
        private String alias;
        private boolean numberedAlias;

        public RuleItem(Class<?> clazz, String alias, boolean numberedAlias) {
            this.clazz = clazz;
            this.alias = alias;
            this.numberedAlias = numberedAlias;
        }

        public String getClassName() {
            return this.clazz.getName();
        }

        public String getAlias() {
            return this.alias;
        }

        public boolean isNumberedAlias() {
            return this.numberedAlias;
        }
    }
}

