/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.ows.KvpRequestReader;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetFeatureInfoRequest;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSErrorCode;
import org.geoserver.wms.kvp.MapLayerInfoKvpParser;
import org.geoserver.wms.map.GetMapKvpRequestReader;
import org.geotools.util.Version;

public class GetFeatureInfoKvpReader
extends KvpRequestReader {
    private GetMapKvpRequestReader getMapReader;
    private WMS wms;

    public GetFeatureInfoKvpReader(WMS wms) {
        super(GetFeatureInfoRequest.class);
        this.getMapReader = new GetFeatureInfoKvpRequestReader(wms);
        this.setWMS(wms);
    }

    public void setWMS(WMS wms) {
        this.wms = wms;
    }

    public WMS getWMS() {
        return this.wms;
    }

    public Object read(Object req, Map kvp, Map rawKvp) throws Exception {
        String rowPixel;
        String colPixel;
        GetFeatureInfoRequest request = (GetFeatureInfoRequest)super.read(req, kvp, rawKvp);
        request.setRawKvp(rawKvp);
        GetMapRequest getMapPart = new GetMapRequest();
        try {
            getMapPart = this.getMapReader.read(getMapPart, kvp, rawKvp);
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
        request.setGetMapRequest(getMapPart);
        List<MapLayerInfo> getMapLayers = getMapPart.getLayers();
        if ((getMapPart.getSldBody() != null || getMapPart.getSld() != null) && this.wms.isDynamicStylingDisabled()) {
            throw new ServiceException("Dynamic style usage is forbidden");
        }
        if (!(getMapPart.getSldBody() == null && getMapPart.getSld() == null || rawKvp.get("QUERY_LAYERS") != null && !"".equals(rawKvp.get("QUERY_LAYERS")))) {
            request.setQueryLayers(getMapLayers);
        } else {
            request.setQueryLayers((List<MapLayerInfo>)new GetFeatureInfoKvpParser("QUERY_LAYERS", this.wms).parse((String)rawKvp.get("QUERY_LAYERS")));
        }
        if (request.getQueryLayers().isEmpty()) {
            throw new ServiceException("Either no layer was queryable, or no layers were specified using QUERY_LAYERS", WMSErrorCode.LAYER_NOT_QUERYABLE.get(request.getVersion()), "QUERY_LAYERS");
        }
        if (kvp.containsKey("propertyName")) {
            List propertyNames = (List)kvp.get("propertyName");
            if (propertyNames.size() == 1 && request.getQueryLayers().size() > 1) {
                while (propertyNames.size() < request.getQueryLayers().size()) {
                    propertyNames.add((List)propertyNames.get(0));
                }
            }
            if (propertyNames.size() != request.getQueryLayers().size()) {
                throw new ServiceException("Mismatch between the property name set count " + propertyNames.size() + " and the query layers count " + request.getQueryLayers().size(), "InvalidParameter", "propertyName");
            }
            request.setPropertyNames(propertyNames);
        }
        ArrayList<MapLayerInfo> queryLayers = new ArrayList<MapLayerInfo>(request.getQueryLayers());
        queryLayers.removeAll(getMapLayers);
        if (queryLayers.size() > 0) {
            throw new ServiceException("QUERY_LAYERS contains layers not cited in LAYERS. It should be a proper subset of those instead");
        }
        String format = kvp.containsKey("INFO_FORMAT") ? kvp.get("INFO_FORMAT") : null;
        if (format == null) {
            format = "text/plain";
        } else {
            List<String> infoFormats = this.wms.getAvailableFeatureInfoFormats();
            if (!infoFormats.contains(format)) {
                throw new ServiceException("Invalid format '" + format + "', supported formats are " + infoFormats, "InvalidFormat", "info_format");
            }
            if (!this.wms.getAllowedFeatureInfoFormats().contains(format)) {
                throw this.wms.unallowedGetFeatureInfoFormatException(format);
            }
        }
        request.setInfoFormat(format);
        request.setFeatureCount(1);
        try {
            int maxFeatures = Integer.parseInt(String.valueOf(kvp.get("FEATURE_COUNT")));
            request.setFeatureCount(maxFeatures);
        }
        catch (NumberFormatException maxFeatures) {
            // empty catch block
        }
        Version version = WMS.negotiateVersion(request.getVersion());
        request.setVersion(version.toString());
        if (version.compareTo(WMS.VERSION_1_3_0) >= 0) {
            colPixel = "I";
            rowPixel = "J";
            if (!kvp.containsKey(colPixel) && !kvp.containsKey(rowPixel) && !this.wms.getServiceInfo().isCiteCompliant() && kvp.containsKey("X") && kvp.containsKey("Y")) {
                colPixel = "X";
                rowPixel = "Y";
            }
        } else {
            colPixel = "X";
            rowPixel = "Y";
        }
        try {
            String colParam = String.valueOf(kvp.get(colPixel));
            String rowParam = String.valueOf(kvp.get(rowPixel));
            int x = Integer.parseInt(colParam);
            int y = Integer.parseInt(rowParam);
            if (x < 0 || x > getMapPart.getWidth() || y < 0 || y > getMapPart.getHeight()) {
                throw new ServiceException(String.format("%d, %d not in dimensions of image: %d, %d", x, y, getMapPart.getWidth(), getMapPart.getHeight()), "InvalidPoint");
            }
            request.setXPixel(x);
            request.setYPixel(y);
        }
        catch (NumberFormatException ex) {
            String msg = colPixel + " and " + rowPixel + " incorrectly specified";
            throw new ServiceException(msg, "InvalidPoint");
        }
        String excludeNodata = kvp.containsKey("EXCLUDE_NODATA_RESULT") ? kvp.get("EXCLUDE_NODATA_RESULT") : null;
        if (excludeNodata != null) {
            boolean excludeNodataResults = Boolean.parseBoolean(excludeNodata);
            request.setExcludeNodataResults(excludeNodataResults);
        }
        return request;
    }

    class GetFeatureInfoKvpParser
    extends MapLayerInfoKvpParser {
        public GetFeatureInfoKvpParser(String key, WMS wms) {
            super(key, wms);
        }

        @Override
        protected boolean skipResource(Object theResource) {
            if (theResource instanceof LayerGroupInfo) {
                LayerGroupInfo groupInfo = (LayerGroupInfo)theResource;
                if (groupInfo.isQueryDisabled()) {
                    return true;
                }
            } else if (theResource instanceof LayerInfo) {
                LayerInfo layerInfo = (LayerInfo)theResource;
                if (!GetFeatureInfoKvpReader.this.wms.isQueryable(layerInfo)) {
                    return true;
                }
            } else if (theResource instanceof MapLayerInfo) {
                LayerInfo layerInfo = ((MapLayerInfo)theResource).getLayerInfo();
                if (!GetFeatureInfoKvpReader.this.wms.isQueryable(layerInfo)) {
                    return true;
                }
            }
            return super.skipResource(theResource);
        }
    }

    class GetFeatureInfoKvpRequestReader
    extends GetMapKvpRequestReader {
        public GetFeatureInfoKvpRequestReader(WMS wms) {
            super(wms);
        }

        @Override
        protected boolean skipResource(Object theResource) {
            if (theResource instanceof LayerGroupInfo) {
                LayerGroupInfo groupInfo = (LayerGroupInfo)theResource;
                if (groupInfo.isQueryDisabled()) {
                    return true;
                }
            } else if (theResource instanceof LayerInfo) {
                LayerInfo layerInfo = (LayerInfo)theResource;
                if (!GetFeatureInfoKvpReader.this.wms.isQueryable(layerInfo)) {
                    return true;
                }
            } else if (theResource instanceof MapLayerInfo) {
                LayerInfo layerInfo = ((MapLayerInfo)theResource).getLayerInfo();
                if (!GetFeatureInfoKvpReader.this.wms.isQueryable(layerInfo)) {
                    return true;
                }
            }
            return super.skipResource(theResource);
        }
    }
}

