/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.FeatureInfoRequestParameters;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.featureinfo.AbstractVectorLayerIdentifier;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.store.FilteringFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.Filters;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Or;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class VectorBasicLayerIdentifier
extends AbstractVectorLayerIdentifier {
    static final Logger LOGGER = Logging.getLogger(VectorBasicLayerIdentifier.class);
    public static final String FEATUREINFO_DEFAULT_BUFFER = "org.geoserver.wms.featureinfo.minBuffer";
    protected static final int MIN_BUFFER_SIZE = Integer.getInteger("org.geoserver.wms.featureinfo.minBuffer", 5);
    private WMS wms;

    public VectorBasicLayerIdentifier(WMS wms) {
        this.wms = wms;
    }

    @Override
    public List<FeatureCollection> identify(FeatureInfoRequestParameters params, int maxFeatures) throws Exception {
        LOGGER.log(Level.FINER, "Appliying bbox based feature info identifier");
        MapLayerInfo layer = params.getLayer();
        Filter filter = params.getFilter();
        Style style = params.getStyle();
        List<Rule> rules = this.getActiveRules(style, params.getScaleDenominator());
        if (rules.size() == 0) {
            return null;
        }
        double radius = this.getSearchRadius(params, layer, rules);
        Object queryEnvelope = this.getEnvelopeFilter(params, radius);
        CoordinateReferenceSystem requestedCRS = params.getRequestedCRS();
        CoordinateReferenceSystem dataCRS = layer.getCoordinateReferenceSystem();
        if (requestedCRS != null && !CRS.equalsIgnoreMetadata((Object)dataCRS, (Object)requestedCRS)) {
            queryEnvelope = dataCRS.getCoordinateSystem().getDimension() == 3 && requestedCRS.getCoordinateSystem().getDimension() == 2 ? JTS.transformTo3D((ReferencedEnvelope)queryEnvelope, (CoordinateReferenceSystem)dataCRS, (boolean)true, (int)10) : queryEnvelope.transform(dataCRS, true);
        }
        FeatureSource<? extends FeatureType, ? extends Feature> featureSource = super.handleClipParam(params, layer.getFeatureSource(false, requestedCRS));
        FeatureType schema = featureSource.getSchema();
        Intersects getFInfoFilter = null;
        FilterFactory2 ff = params.getFilterFactory();
        try {
            GeometryDescriptor geometryDescriptor = schema.getGeometryDescriptor();
            String localName = geometryDescriptor.getLocalName();
            Polygon queryPolygon = JTS.toGeometry((ReferencedEnvelope)queryEnvelope);
            getFInfoFilter = ff.intersects((Expression)ff.property(localName), (Expression)ff.literal((Object)queryPolygon));
        }
        catch (IllegalFilterException e) {
            e.printStackTrace();
            throw new ServiceException("Internal error : " + e.getMessage(), (Throwable)e);
        }
        if (filter != null) {
            getFInfoFilter = ff.and((Filter)getFInfoFilter, filter);
        }
        IncludeFilter postFilter = Filter.INCLUDE;
        Filter rulesFilters = this.buildRulesFilter((FilterFactory)ff, rules);
        if (!(featureSource.getSchema() instanceof SimpleFeatureType) || !(rulesFilters instanceof Or) || rulesFilters instanceof Or && ((Or)rulesFilters).getChildren().size() <= 20) {
            getFInfoFilter = ff.and((Filter)getFInfoFilter, rulesFilters);
        } else {
            postFilter = rulesFilters;
        }
        Filter timeElevationFilter = this.wms.getTimeElevationToFilter(params.getTimes(), params.getElevations(), layer.getFeature());
        getFInfoFilter = Filters.and((FilterFactory)ff, (Filter)getFInfoFilter, (Filter)timeElevationFilter);
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        getFInfoFilter = (Filter)getFInfoFilter.accept((FilterVisitor)simplifier, null);
        String typeName = schema.getName().getLocalPart();
        Query q = new Query(typeName, null, (Filter)getFInfoFilter, maxFeatures, params.getPropertyNames(), null);
        q.setSortBy(params.getSort());
        Map<String, String> viewParams = params.getViewParams();
        if (viewParams != null && viewParams.size() > 0) {
            q.setHints(new Hints((RenderingHints.Key)Hints.VIRTUAL_TABLE_PARAMETERS, viewParams));
        }
        LOGGER.log(Level.FINE, q.toString());
        if (!this.wms.isFeaturesReprojectionDisabled()) {
            q.setCoordinateSystemReproject(requestedCRS);
        }
        FeatureCollection match = featureSource.getFeatures(q);
        if (!Filter.INCLUDE.equals(postFilter)) {
            match = new FilteringFeatureCollection(match, (Filter)postFilter);
        }
        return Collections.singletonList(match);
    }

    private double getSearchRadius(FeatureInfoRequestParameters params, MapLayerInfo layer, List<Rule> rules) {
        double radius;
        int buffer = params.getBuffer();
        if (buffer <= 0) {
            Integer layerBuffer = null;
            LayerInfo layerInfo = layer.getLayerInfo();
            if (layerInfo != null) {
                layerBuffer = (Integer)layerInfo.getMetadata().get("buffer", Integer.class);
            }
            if (layerBuffer != null && layerBuffer > 0) {
                radius = layerBuffer.intValue();
            } else {
                MetaBufferEstimator estimator = new MetaBufferEstimator();
                for (Rule rule : rules) {
                    rule.accept((StyleVisitor)estimator);
                }
                int estimatedRadius = estimator.getBuffer() / 2;
                radius = estimatedRadius < MIN_BUFFER_SIZE ? (double)MIN_BUFFER_SIZE : (double)estimatedRadius;
            }
        } else {
            radius = buffer;
        }
        int maxRadius = this.wms.getMaxBuffer();
        if (maxRadius > 0 && radius > (double)maxRadius) {
            radius = maxRadius;
        }
        return radius;
    }

    private Filter buildRulesFilter(FilterFactory ff, List<Rule> rules) {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        for (Rule rule : rules) {
            if (rule.getFilter() == null || rule.isElseFilter()) {
                return Filter.INCLUDE;
            }
            filters.add(rule.getFilter());
        }
        Or or = ff.or(filters);
        SimplifyingFilterVisitor simplifier = new SimplifyingFilterVisitor();
        return (Filter)or.accept((FilterVisitor)simplifier, null);
    }

    private ReferencedEnvelope getEnvelopeFilter(FeatureInfoRequestParameters params, double radius) {
        int x = params.getX();
        int y = params.getY();
        ReferencedEnvelope bbox = params.getRequestedBounds();
        int width = params.getWidth();
        int height = params.getHeight();
        Coordinate upperLeft = WMS.pixelToWorld((double)x - radius, (double)y - radius, bbox, width, height);
        Coordinate lowerRight = WMS.pixelToWorld((double)x + radius, (double)y + radius, bbox, width, height);
        return new ReferencedEnvelope(upperLeft.x, lowerRight.x, lowerRight.y, upperLeft.y, bbox.getCoordinateReferenceSystem());
    }
}

