/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.legendgraphic.FeatureCountProcessor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.DataUtilities;
import org.geotools.data.Parameter;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.GeometryDescriptorImpl;
import org.geotools.feature.type.GeometryTypeImpl;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.process.Processors;
import org.geotools.process.function.ProcessFunction;
import org.geotools.renderer.lite.MetaBufferEstimator;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.visitor.DpiRescaleStyleVisitor;
import org.geotools.styling.visitor.RescaleStyleVisitor;
import org.geotools.styling.visitor.UomRescaleStyleVisitor;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.Feature;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;

public abstract class LegendGraphicBuilder {
    Logger LOGGER = Logger.getLogger("org.geoserver.wms.legendgraphic");
    public static final double TOLERANCE = 1.0E-6;
    protected static final GeometryFactory geomFac = new GeometryFactory();
    private LiteShape2 sampleLine;
    protected LiteShape2 samplePoint;
    protected final double MINIMUM_SYMBOL_SIZE = 3.0;
    protected int w;
    protected int h;
    boolean forceLabelsOn = false;
    boolean forceLabelsOff = false;
    boolean forceTitlesOff = false;
    FeatureCountProcessor countProcessor = null;
    List<GetLegendGraphicRequest.LegendRequest> layers;
    boolean hasVectorTransformation = false;
    boolean hasRasterTransformation = false;

    public void setup(GetLegendGraphicRequest request) {
        String forceTitlesOpt;
        this.w = request.getWidth();
        this.h = request.getHeight();
        if (request.getLegendOptions().get("forceLabels") instanceof String) {
            String forceLabelsOpt = (String)request.getLegendOptions().get("forceLabels");
            if (forceLabelsOpt.equalsIgnoreCase("on")) {
                this.forceLabelsOn = true;
            } else if (forceLabelsOpt.equalsIgnoreCase("off")) {
                this.forceLabelsOff = true;
            }
        }
        if (request.getLegendOptions().get("forceTitles") instanceof String && (forceTitlesOpt = (String)request.getLegendOptions().get("forceTitles")).equalsIgnoreCase("off")) {
            this.forceTitlesOff = true;
        }
        if (Boolean.TRUE.equals(request.getLegendOption("countMatched", Boolean.class)) || Boolean.TRUE.equals(request.getLegendOption("hideEmptyRules", Boolean.class))) {
            this.countProcessor = new FeatureCountProcessor(request);
        }
        this.layers = request.getLegends();
    }

    public Symbolizer rescaleSymbolizer(Symbolizer symbolizer, double size, double newSize) {
        final double scaleFactor = newSize / size;
        RescaleStyleVisitor rescaleVisitor = new RescaleStyleVisitor(scaleFactor){

            protected Expression rescale(Expression expr) {
                if (expr == null) {
                    return null;
                }
                if (expr instanceof Literal) {
                    Double value = (Double)expr.evaluate(null, Double.class);
                    return this.ff.literal(value * scaleFactor);
                }
                return this.ff.multiply(expr, (Expression)this.ff.literal(scaleFactor));
            }
        };
        symbolizer.accept((StyleVisitor)rescaleVisitor);
        symbolizer = (Symbolizer)rescaleVisitor.getCopy();
        return symbolizer;
    }

    protected Style resizeForDPI(GetLegendGraphicRequest request, Style gt2Style) {
        double standardDpi;
        double dpi = RendererUtilities.getDpi(request.getLegendOptions());
        if (dpi != (standardDpi = RendererUtilities.getDpi(Collections.emptyMap()))) {
            double scaleFactor = dpi / standardDpi;
            this.w = (int)Math.round((double)this.w * scaleFactor);
            this.h = (int)Math.round((double)this.h * scaleFactor);
            DpiRescaleStyleVisitor dpiVisitor = new DpiRescaleStyleVisitor(scaleFactor);
            dpiVisitor.visit(gt2Style);
            gt2Style = (Style)dpiVisitor.getCopy();
        }
        if (request.getScale() > 0.0) {
            double pixelsPerMeters = RendererUtilities.calculatePixelsPerMeterRatio((double)request.getScale(), request.getLegendOptions());
            UomRescaleStyleVisitor rescaleVisitor = new UomRescaleStyleVisitor(pixelsPerMeters);
            rescaleVisitor.visit(gt2Style);
            gt2Style = (Style)rescaleVisitor.getCopy();
        }
        return gt2Style;
    }

    protected double[] calcSymbolSize(double defaultMaxSize, double defaultMinSize, FeatureType featureType, Feature feature, Rule[] rules) {
        double minSize = defaultMaxSize;
        double maxSize = defaultMinSize;
        int ruleCount = rules.length;
        for (int i = 0; i < ruleCount; ++i) {
            Feature sample = this.getSampleFeatureForRule(featureType, feature, rules[i]);
            MetaBufferEstimator estimator = new MetaBufferEstimator(sample);
            for (Symbolizer symbolizer : rules[i].symbolizers()) {
                if (!(symbolizer instanceof PointSymbolizer) && !(symbolizer instanceof LineSymbolizer)) continue;
                double size = this.getSymbolizerSize(estimator, symbolizer, defaultMaxSize);
                if (size < minSize && !(symbolizer instanceof LineSymbolizer)) {
                    minSize = size;
                }
                if (!(size > maxSize)) continue;
                maxSize = size;
            }
        }
        return new double[]{minSize, maxSize};
    }

    protected double getSymbolizerSize(MetaBufferEstimator estimator, Symbolizer symbolizer, double defaultSize) {
        estimator.reset();
        symbolizer.accept((StyleVisitor)estimator);
        int buffer = estimator.getBuffer();
        if (buffer > 0) {
            return buffer;
        }
        return defaultSize;
    }

    protected Feature getSampleFeatureForRule(FeatureType featureType, Feature sample, Rule rule) {
        if (sample == null) {
            int dimensionality = 1;
            for (Symbolizer symbolizer : rule.symbolizers()) {
                if (LineSymbolizer.class.isAssignableFrom(symbolizer.getClass())) {
                    dimensionality = 2;
                }
                if (!PolygonSymbolizer.class.isAssignableFrom(symbolizer.getClass())) continue;
                dimensionality = 3;
            }
            return this.createSampleFeature(featureType, dimensionality);
        }
        return sample;
    }

    protected LiteShape2 getSampleShape(Symbolizer symbolizer, int legendWidth, int legendHeight, int areaWidth, int areaHeight) {
        LiteShape2 sampleShape;
        float hpad = (float)areaWidth * 0.15f + (float)(areaWidth - legendWidth) / 2.0f;
        float vpad = (float)areaHeight * 0.15f + (float)(areaHeight - legendHeight) / 2.0f;
        if (symbolizer instanceof LineSymbolizer) {
            if (this.sampleLine == null) {
                Coordinate[] coords = new Coordinate[]{new Coordinate((double)hpad, (double)((float)legendHeight - vpad - 1.0f)), new Coordinate((double)((float)legendWidth - hpad - 1.0f), (double)vpad)};
                LineString geom = geomFac.createLineString(coords);
                try {
                    this.sampleLine = new LiteShape2((Geometry)geom, null, null, false);
                }
                catch (Exception e) {
                    this.sampleLine = null;
                }
            }
            sampleShape = this.sampleLine;
        } else {
            if (symbolizer instanceof PolygonSymbolizer || symbolizer instanceof RasterSymbolizer) {
                float w = (float)areaWidth - 2.0f * hpad - 1.0f;
                float h = (float)areaHeight - 2.0f * vpad - 1.0f;
                Coordinate[] coords = new Coordinate[]{new Coordinate((double)hpad, (double)vpad), new Coordinate((double)hpad, (double)(vpad + h)), new Coordinate((double)(hpad + w), (double)(vpad + h)), new Coordinate((double)(hpad + w), (double)vpad), new Coordinate((double)hpad, (double)vpad)};
                LinearRing shell = geomFac.createLinearRing(coords);
                Polygon geom = geomFac.createPolygon(shell, null);
                try {
                    return new LiteShape2((Geometry)geom, null, null, false);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (symbolizer instanceof PointSymbolizer || symbolizer instanceof TextSymbolizer) {
                if (this.samplePoint == null) {
                    Coordinate coord = new Coordinate((double)legendWidth / 2.0, (double)legendHeight / 2.0);
                    try {
                        this.samplePoint = new LiteShape2((Geometry)geomFac.createPoint(coord), null, null, false);
                    }
                    catch (Exception e) {
                        this.samplePoint = null;
                    }
                }
                sampleShape = this.samplePoint;
            } else {
                throw new IllegalArgumentException("Unknown symbolizer: " + symbolizer);
            }
        }
        return sampleShape;
    }

    protected SimpleFeature createSampleFeature() {
        SimpleFeatureType type;
        try {
            type = DataUtilities.createType((String)"Sample", (String)"the_geom:Geometry");
        }
        catch (SchemaException e) {
            throw new RuntimeException(e);
        }
        return SimpleFeatureBuilder.template((SimpleFeatureType)type, null);
    }

    private Feature createSampleFeature(FeatureType schema, int dimensionality) throws ServiceException {
        if (schema instanceof SimpleFeatureType) {
            schema = this.cloneWithDimensionality(schema, dimensionality);
        }
        return this.createSampleFeature(schema);
    }

    private FeatureType cloneWithDimensionality(FeatureType schema, int dimensionality) {
        SimpleFeatureType simpleFt = (SimpleFeatureType)schema;
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(schema.getName());
        builder.setCRS(schema.getCoordinateReferenceSystem());
        for (AttributeDescriptor desc : simpleFt.getAttributeDescriptors()) {
            if (this.isMixedGeometry(desc)) {
                GeometryDescriptor geomDescriptor = (GeometryDescriptor)desc;
                GeometryType geomType = geomDescriptor.getType();
                Class<?> geometryClass = this.getGeometryForDimensionality(dimensionality);
                GeometryTypeImpl gt = new GeometryTypeImpl(geomType.getName(), geometryClass, geomType.getCoordinateReferenceSystem(), geomType.isIdentified(), geomType.isAbstract(), geomType.getRestrictions(), geomType.getSuper(), geomType.getDescription());
                builder.add((AttributeDescriptor)new GeometryDescriptorImpl((GeometryType)gt, geomDescriptor.getName(), geomDescriptor.getMinOccurs(), geomDescriptor.getMaxOccurs(), geomDescriptor.isNillable(), geomDescriptor.getDefaultValue()));
                continue;
            }
            builder.add(desc);
        }
        schema = builder.buildFeatureType();
        return schema;
    }

    private Class<?> getGeometryForDimensionality(int dimensionality) {
        if (dimensionality == 1) {
            return Point.class;
        }
        if (dimensionality == 2) {
            return LineString.class;
        }
        return Polygon.class;
    }

    protected Feature createSampleFeature(FeatureType schema) throws ServiceException {
        Object sampleFeature;
        try {
            sampleFeature = schema instanceof SimpleFeatureType ? (this.hasMixedGeometry((SimpleFeatureType)schema) ? null : SimpleFeatureBuilder.template((SimpleFeatureType)((SimpleFeatureType)schema), null)) : DataUtilities.templateFeature((FeatureType)schema);
        }
        catch (IllegalAttributeException e) {
            throw new ServiceException((Throwable)e);
        }
        return sampleFeature;
    }

    private boolean hasMixedGeometry(SimpleFeatureType schema) {
        for (AttributeDescriptor attDesc : schema.getAttributeDescriptors()) {
            if (!this.isMixedGeometry(attDesc)) continue;
            return true;
        }
        return false;
    }

    private boolean isMixedGeometry(AttributeDescriptor attDesc) {
        return attDesc instanceof GeometryDescriptor && attDesc.getType().getBinding() == Geometry.class;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public abstract Object buildLegendGraphic(GetLegendGraphicRequest var1);

    protected void checkForRenderingTransformations(Style gt2Style) {
        List ftsList = gt2Style.featureTypeStyles();
        for (int i = 0; i < ftsList.size(); ++i) {
            ProcessFunction processFunction;
            Name processName;
            Map outputs;
            FeatureTypeStyle fts = (FeatureTypeStyle)ftsList.get(i);
            Expression exp = fts.getTransformation();
            if (exp == null || (outputs = Processors.getResultInfo((Name)(processName = (processFunction = (ProcessFunction)exp).getProcessName()), null)).isEmpty()) continue;
            Parameter output = (Parameter)outputs.values().iterator().next();
            if (SimpleFeatureCollection.class.isAssignableFrom(output.getType())) {
                this.hasVectorTransformation = true;
                break;
            }
            if (!GridCoverage2D.class.isAssignableFrom(output.getType())) continue;
            this.hasRasterTransformation = true;
            break;
        }
    }
}

