/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfGraphics2D;
import com.lowagie.text.pdf.PdfPatternPainter;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.decoration.MapDecorationLayout;
import org.geoserver.wms.map.AbstractMapResponse;
import org.geoserver.wms.map.MaxErrorEnforcer;
import org.geoserver.wms.map.PDFMapOutputFormat;
import org.geoserver.wms.map.PDFMaxSizeEnforcer;
import org.geoserver.wms.map.RenderExceptionStrategy;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.renderer.lite.ParallelLinesFiller;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.style.IconStyle2D;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.Style2D;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.springframework.util.Assert;

public class PDFMapResponse
extends AbstractMapResponse {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.map.pdf");
    static boolean ENCODE_TILING_PATTERNS = Boolean.parseBoolean(System.getProperty("org.geoserver.pdf.encodeTilingPatterns", "true"));
    private static final int KB = 1024;
    private WMS wms;

    public PDFMapResponse(WMS wms) {
        super(PDFMapOutputFormat.PDFMap.class, "application/pdf");
        this.wms = wms;
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        Assert.isInstanceOf(PDFMapOutputFormat.PDFMap.class, (Object)value);
        PDFMapOutputFormat.PDFMap pdfMap = (PDFMapOutputFormat.PDFMap)value;
        WMSMapContent mapContent = ((PDFMapOutputFormat.PDFMap)value).getContext();
        int width = mapContent.getMapWidth();
        int height = mapContent.getMapHeight();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting up " + width + "x" + height + " image");
        }
        try {
            Rectangle pageSize = new Rectangle((float)width, (float)height);
            Document document = new Document(pageSize);
            document.setMargins(0.0f, 0.0f, 0.0f, 0.0f);
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)output);
            document.open();
            DefaultFontMapper mapper = new DefaultFontMapper();
            FontFactory.registerDirectories();
            PdfContentByte cb = writer.getDirectContent();
            PdfTemplate tp = cb.createTemplate((float)width, (float)height);
            PdfGraphics2D graphic = (PdfGraphics2D)tp.createGraphics((float)width, (float)height, (FontMapper)mapper);
            if (!mapContent.isTransparent()) {
                graphic.setColor(mapContent.getBgColor());
                graphic.fillRect(0, 0, width, height);
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("setting to transparent");
                }
                int type = 2;
                graphic.setComposite((Composite)AlphaComposite.getInstance(type));
                Color c = new Color(mapContent.getBgColor().getRed(), mapContent.getBgColor().getGreen(), mapContent.getBgColor().getBlue(), 0);
                graphic.setBackground(mapContent.getBgColor());
                graphic.setColor(c);
                graphic.fillRect(0, 0, width, height);
                type = 3;
                graphic.setComposite((Composite)AlphaComposite.getInstance(type));
            }
            java.awt.Rectangle paintArea = new java.awt.Rectangle(width, height);
            PDFStreamingRenderer renderer = ENCODE_TILING_PATTERNS ? new PDFStreamingRenderer() : new StreamingRenderer();
            renderer.setMapContent(mapContent);
            RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            renderer.setJava2DHints(hints);
            HashMap<String, Object> rendererParams = new HashMap<String, Object>();
            rendererParams.put("optimizedDataLoadingEnabled", Boolean.TRUE);
            rendererParams.put("renderingBuffer", mapContent.getBuffer());
            rendererParams.put("optimizeFTSRendering", Boolean.FALSE);
            rendererParams.put("vectorRenderingEnabled", Boolean.TRUE);
            if (DefaultWebMapService.isLineWidthOptimizationEnabled()) {
                rendererParams.put("lineWidthOptimization", true);
            }
            rendererParams.put("scaleComputationMethod", mapContent.getRendererScaleMethod());
            renderer.setRendererHints(rendererParams);
            int maxErrors = this.wms.getMaxRenderingErrors();
            MaxErrorEnforcer errorChecker = new MaxErrorEnforcer((GTRenderer)renderer, maxErrors);
            RenderExceptionStrategy nonIgnorableExceptionListener = new RenderExceptionStrategy((GTRenderer)renderer);
            renderer.addRenderListener(nonIgnorableExceptionListener);
            int maxMemory = this.wms.getMaxRequestMemory() * 1024;
            PDFMaxSizeEnforcer memoryChecker = new PDFMaxSizeEnforcer((GTRenderer)renderer, graphic, maxMemory);
            renderer.paint((Graphics2D)graphic, paintArea, mapContent.getRenderingArea(), mapContent.getRenderingTransform());
            MapDecorationLayout.Block watermark = RenderedImageMapOutputFormat.getWatermark(this.wms.getServiceInfo());
            if (pdfMap.layout != null) {
                pdfMap.layout.paint((Graphics2D)graphic, paintArea, mapContent);
            } else if (watermark != null) {
                MapDecorationLayout layout = new MapDecorationLayout();
                layout.paint((Graphics2D)graphic, paintArea, mapContent);
            }
            if (nonIgnorableExceptionListener.exceptionOccurred()) {
                Exception renderError = nonIgnorableExceptionListener.getException();
                throw new ServiceException("Rendering process failed", (Throwable)renderError, "internalError");
            }
            if (errorChecker.exceedsMaxErrors()) {
                throw new ServiceException("More than " + maxErrors + " rendering errors occurred, bailing out", (Throwable)errorChecker.getLastException(), "internalError");
            }
            if (memoryChecker.exceedsMaxSize()) {
                long kbMax = maxMemory / 1024;
                throw new ServiceException("Rendering request used more memory than the maximum allowed:" + kbMax + "KB");
            }
            graphic.dispose();
            cb.addTemplate(tp, 0.0f, 0.0f);
            document.close();
            writer.flush();
            writer.close();
        }
        catch (DocumentException t) {
            throw new ServiceException("Error setting up the PDF", (Throwable)t, "internalError");
        }
    }

    private static class PDFStyledPainter
    extends StyledShapePainter {
        WeakHashMap<Style2D, PdfPatternPainter> patternCache = new WeakHashMap();

        public PDFStyledPainter(LabelCache labelCache) {
            super(labelCache);
        }

        protected void paintGraphicFill(Graphics2D graphics, Shape shape, Style2D graphicFill, double scale) {
            if (graphics instanceof PdfGraphics2D && (graphicFill instanceof IconStyle2D || this.isMarkNonHatchFill(graphicFill))) {
                this.fillShapeAsPattern((PdfGraphics2D)graphics, shape, graphicFill, scale);
            } else {
                super.paintGraphicFill(graphics, shape, graphicFill, scale);
            }
        }

        private boolean isMarkNonHatchFill(Style2D graphicFill) {
            MarkStyle2D ms;
            ParallelLinesFiller filler;
            if (!(graphicFill instanceof MarkStyle2D)) {
                return false;
            }
            return !OPTIMIZE_VECTOR_HATCH_FILLS || (filler = ParallelLinesFiller.fromStipple((Shape)(ms = (MarkStyle2D)graphicFill).getShape())) == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fillShapeAsPattern(PdfGraphics2D graphics, Shape shape, Style2D graphicFill, double scale) {
            PdfContentByte content = graphics.getContent();
            Paint oldPaint = graphics.getPaint();
            try {
                PdfPatternPainter pattern = this.getPatternPainter(graphicFill, content, scale);
                PdfContentByte cb = graphics.getContent();
                content.setPatternFill(pattern);
                AffineTransform tx = new AffineTransform(graphics.getTransform());
                float documentHeight = cb.getPdfDocument().getPageSize().getHeight();
                tx.concatenate(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, documentHeight));
                PathIterator pathIterator = shape.getPathIterator(tx);
                float[] coords = new float[6];
                if (!pathIterator.isDone()) {
                    while (!pathIterator.isDone()) {
                        int segtype = pathIterator.currentSegment(coords);
                        switch (segtype) {
                            case 0: {
                                cb.moveTo(coords[0], coords[1]);
                                break;
                            }
                            case 1: {
                                cb.lineTo(coords[0], coords[1]);
                                break;
                            }
                            case 2: {
                                cb.curveTo(coords[0], coords[1], coords[2], coords[3]);
                                break;
                            }
                            case 3: {
                                cb.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                                break;
                            }
                            case 4: {
                                cb.closePath();
                            }
                        }
                        pathIterator.next();
                    }
                    if (pathIterator.getWindingRule() == 0) {
                        cb.eoFill();
                    } else {
                        cb.fill();
                    }
                }
            }
            finally {
                graphics.setPaint(oldPaint);
            }
        }

        private PdfPatternPainter getPatternPainter(Style2D graphicFill, PdfContentByte content, double scale) {
            PdfPatternPainter pattern = this.patternCache.get(graphicFill);
            if (pattern == null) {
                pattern = this.buildPattern(graphicFill, content, scale);
                this.patternCache.put(graphicFill, pattern);
            }
            return pattern;
        }

        private PdfPatternPainter buildPattern(Style2D graphicFill, PdfContentByte content, double scale) {
            PdfPatternPainter pattern;
            if (graphicFill instanceof IconStyle2D) {
                Icon icon = ((IconStyle2D)graphicFill).getIcon();
                int width = icon.getIconWidth();
                int height = icon.getIconHeight();
                pattern = content.createPattern((float)width, (float)height);
                Graphics2D patternGraphic = pattern.createGraphics((float)width, (float)height);
                icon.paintIcon(null, patternGraphic, 0, 0);
                patternGraphic.dispose();
            } else if (graphicFill instanceof MarkStyle2D) {
                MarkStyle2D mark = (MarkStyle2D)graphicFill;
                int size = (int)Math.round(mark.getSize());
                pattern = content.createPattern((float)size, (float)size);
                Graphics2D patternGraphic = pattern.createGraphics((float)size, (float)size);
                GeometryFactory geomFactory = new GeometryFactory();
                Coordinate stippleCoord = new Coordinate((double)size / 2.0, (double)size / 2.0);
                Point stipplePoint = geomFactory.createPoint(stippleCoord);
                Decimator nullDecimator = new Decimator(-1.0, -1.0);
                AffineTransform2D identityTransf = new AffineTransform2D(new AffineTransform());
                try {
                    this.paint(patternGraphic, new LiteShape2((Geometry)stipplePoint, (MathTransform)identityTransf, nullDecimator, false), (Style2D)mark, scale);
                }
                catch (FactoryException | TransformException e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new IllegalArgumentException("Unsupported style " + graphicFill);
            }
            return pattern;
        }
    }

    private static class PDFStreamingRenderer
    extends StreamingRenderer {
        public PDFStreamingRenderer() {
            this.painter = new PDFStyledPainter(this.labelCache);
        }
    }
}

