/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.JAIInfo;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.RasterCleaner;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.RenderedImageMapResponse;
import org.geoserver.wms.map.png.PNGJWriter;
import org.geotools.image.ImageWorker;
import org.geotools.util.logging.Logging;

public class PNGMapResponse
extends RenderedImageMapResponse {
    private static final Logger LOGGER = Logging.getLogger(PNGMapResponse.class);
    private static final String MIME_TYPE = "image/png";
    private static final String MIME_TYPE_8BIT = "image/png; mode=8bit";
    private static final String[] OUTPUT_FORMATS = new String[]{"image/png", "image/png; mode=8bit", "image/png8"};
    private static MapProducerCapabilities CAPABILITIES = new MapProducerCapabilities(true, false, true, true, null);

    public PNGMapResponse(WMS wms) {
        super(OUTPUT_FORMATS, wms);
    }

    @Override
    public String getMimeType(Object value, Operation operation) throws ServiceException {
        GetMapRequest request = (GetMapRequest)operation.getParameters()[0];
        if (request.getFormat().contains("8")) {
            return MIME_TYPE_8BIT;
        }
        return MIME_TYPE;
    }

    @Override
    public void formatImageOutputStream(RenderedImage image, OutputStream outStream, WMSMapContent mapContent) throws ServiceException, IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing png image ...");
        }
        image = this.applyPalette(image, mapContent, (String f) -> f != null && f.contains("png8"), true);
        float quality = (float)(100 - this.wms.getPngCompression()) / 100.0f;
        JAIInfo.PngEncoderType encoder = this.wms.getPNGEncoderType();
        if (encoder == JAIInfo.PngEncoderType.PNGJ) {
            image = new PNGJWriter().writePNG(image, outStream, quality, mapContent);
            RasterCleaner.addImage(image);
        } else {
            Boolean PNGNativeAcc = encoder == JAIInfo.PngEncoderType.NATIVE;
            SampleModel sm = image.getSampleModel();
            int numBits = sm.getSampleSize(0);
            boolean nativeAcceleration = PNGNativeAcc != false && (numBits <= 1 || numBits >= 8);
            ImageWorker iw = new ImageWorker(image);
            iw.writePNG((Object)outStream, "FILTERED", quality, nativeAcceleration, false);
            RasterCleaner.addImage(iw.getRenderedImage());
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing png image ... done!");
        }
    }

    @Override
    public MapProducerCapabilities getCapabilities(String outputFormat) {
        return CAPABILITIES;
    }

    @Override
    public String getExtension(RenderedImage image, WMSMapContent mapContent) {
        return "png";
    }

    public static enum QuantizeMethod {
        Octree,
        MedianCut;

    }
}

