/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.svg;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.DefaultWebMapService;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.MapProducerCapabilities;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.MaxErrorEnforcer;
import org.geoserver.wms.map.RenderExceptionStrategy;
import org.geoserver.wms.svg.BatikSVGMap;
import org.geoserver.wms.svg.SVG;
import org.geotools.map.MapContent;
import org.geotools.renderer.GTRenderer;
import org.geotools.renderer.RenderListener;
import org.geotools.renderer.lite.StreamingRenderer;
import org.w3c.dom.Document;

public final class SVGBatikMapOutputFormat
implements GetMapOutputFormat {
    private static MapProducerCapabilities CAPABILITIES = new MapProducerCapabilities(false, false, false, true, null);
    private final WMS wms;

    public SVGBatikMapOutputFormat(WMS wms) {
        this.wms = wms;
    }

    @Override
    public Set<String> getOutputFormatNames() {
        return SVG.OUTPUT_FORMATS;
    }

    @Override
    public String getMimeType() {
        return "image/svg+xml";
    }

    @Override
    public BatikSVGMap produceMap(WMSMapContent mapContent) throws ServiceException, IOException {
        StreamingRenderer renderer = this.setUpRenderer(mapContent);
        SVGGraphics2D g = this.createSVGMap(renderer, mapContent);
        renderer = null;
        return new BatikSVGMap(mapContent, g);
    }

    private StreamingRenderer setUpRenderer(WMSMapContent mapContent) {
        StreamingRenderer renderer = new StreamingRenderer();
        HashMap<String, Object> rendererParams = new HashMap<String, Object>();
        rendererParams.put("optimizedDataLoadingEnabled", Boolean.TRUE);
        rendererParams.put("optimizeFTSRendering", Boolean.FALSE);
        rendererParams.put("vectorRenderingEnabled", Boolean.TRUE);
        rendererParams.put("renderingBuffer", mapContent.getBuffer());
        if (DefaultWebMapService.isLineWidthOptimizationEnabled()) {
            rendererParams.put("lineWidthOptimization", true);
        }
        rendererParams.put("scaleComputationMethod", mapContent.getRendererScaleMethod());
        renderer.setRendererHints(rendererParams);
        renderer.setMapContent((MapContent)mapContent);
        return renderer;
    }

    public SVGGraphics2D createSVGMap(StreamingRenderer renderer, WMSMapContent mapContent) throws ServiceException, IOException {
        try {
            MapContent map = renderer.getMapContent();
            double width = -1.0;
            double height = -1.0;
            if (map instanceof WMSMapContent) {
                WMSMapContent wmsMap = (WMSMapContent)map;
                width = wmsMap.getMapWidth();
                height = wmsMap.getMapHeight();
            } else {
                Rectangle screenArea = map.getViewport().getScreenArea();
                width = screenArea.getWidth();
                height = screenArea.getHeight();
            }
            if (height == -1.0 || width == -1.0) {
                throw new IOException("Could not determine map dimensions");
            }
            SVGGeneratorContext context = this.setupContext();
            SVGGraphics2D g = new SVGGraphics2D(context, true);
            g.setSVGCanvasSize(new Dimension((int)width, (int)height));
            if (this.wms.isSvgAntiAlias()) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            int maxErrors = this.wms.getMaxRenderingErrors();
            MaxErrorEnforcer errorChecker = new MaxErrorEnforcer((GTRenderer)renderer, maxErrors);
            RenderExceptionStrategy nonIgnorableExceptionListener = new RenderExceptionStrategy((GTRenderer)renderer);
            renderer.addRenderListener((RenderListener)nonIgnorableExceptionListener);
            renderer.paint((Graphics2D)g, new Rectangle(g.getSVGCanvasSize()), mapContent.getRenderingArea(), mapContent.getRenderingTransform());
            if (errorChecker.exceedsMaxErrors()) {
                throw new ServiceException("More than " + maxErrors + " rendering errors occurred, bailing out.", (Throwable)errorChecker.getLastException(), "internalError");
            }
            if (nonIgnorableExceptionListener.exceptionOccurred()) {
                Exception renderError = nonIgnorableExceptionListener.getException();
                throw new ServiceException("Rendering process failed", (Throwable)renderError, "internalError");
            }
            return g;
        }
        catch (ParserConfigurationException e) {
            throw new ServiceException("Unexpected exception", (Throwable)e, "internalError");
        }
    }

    private SVGGeneratorContext setupContext() throws FactoryConfigurationError, ParserConfigurationException {
        Document document = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        String svgNamespaceURI = "http://www.w3.org/2000/svg";
        document = db.getDOMImplementation().createDocument(svgNamespaceURI, "svg", null);
        return SVGGeneratorContext.createDefault((Document)document);
    }

    @Override
    public MapProducerCapabilities getCapabilities(String format) {
        return CAPABILITIES;
    }
}

