/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.LegendInfoImpl;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.ContactInfoImpl;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfoImpl;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.capabilities.LegendSample;
import org.geoserver.wms.capabilities.LegendSampleImpl;
import org.geoserver.wms.wms_1_1_1.GetFeatureInfoTest;
import org.geotools.xml.transform.TransformerBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class GetCapabilitiesLegendURLTest
extends WMSTestSupport {
    protected static final String baseUrl = "http://localhost/geoserver";
    protected static final Set<String> mapFormats = Collections.singleton("image/png");
    protected static final Set<String> legendFormats = Collections.singleton("image/png");
    protected GeoServerImpl geosConfig;
    protected GeoServerInfoImpl geosInfo;
    protected WMSInfoImpl wmsInfo;
    protected Catalog catalog;
    protected GetCapabilitiesRequest req;
    protected WMS wmsConfig;
    protected XpathEngine XPATH;
    public static QName SQUARES = new QName(MockData.CITE_URI, "squares", MockData.CITE_PREFIX);
    public static QName STATES = new QName(MockData.CITE_URI, "states", MockData.CITE_PREFIX);
    public static QName WORLD = new QName("http://www.geo-solutions.it", "world", "gs");

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        this.catalog = this.getCatalog();
        File dataDirRoot = testData.getDataDirectoryRoot();
        new File(dataDirRoot.getAbsolutePath() + File.separator + "legendsamples").mkdir();
        testData.addStyle("squares", "squares.sld", GetFeatureInfoTest.class, this.catalog);
        testData.addVectorLayer(SQUARES, Collections.emptyMap(), "squares.properties", GetCapabilitiesLegendURLTest.class, this.catalog);
        WorkspaceInfo workspaceInfo = this.catalog.getWorkspaceByName(MockData.CITE_PREFIX);
        testData.addStyle(workspaceInfo, "states", "Population.sld", GetCapabilitiesLegendURLTest.class, this.catalog);
        HashMap<SystemTestData.LayerProperty, String> properties = new HashMap<SystemTestData.LayerProperty, String>();
        properties.put(SystemTestData.LayerProperty.STYLE, "states");
        LocalWorkspace.set((WorkspaceInfo)workspaceInfo);
        testData.addVectorLayer(STATES, properties, "states.properties", GetCapabilitiesLegendURLTest.class, this.catalog);
        LocalWorkspace.set(null);
        testData.addStyle("temperature", "temperature.sld", WMSTestSupport.class, this.catalog);
        properties = new HashMap();
        properties.put(SystemTestData.LayerProperty.STYLE, "temperature");
        testData.addRasterLayer(WORLD, "world.tiff", null, properties, SystemTestData.class, this.catalog);
    }

    @Before
    public void internalSetUp() throws IOException {
        this.catalog = this.getCatalog();
        this.geosConfig = new GeoServerImpl();
        this.geosInfo = new GeoServerInfoImpl((GeoServer)this.geosConfig);
        this.geosInfo.setContact((ContactInfo)new ContactInfoImpl());
        this.geosConfig.setGlobal((GeoServerInfo)this.geosInfo);
        this.wmsInfo = new WMSInfoImpl();
        this.geosConfig.add((ServiceInfo)this.wmsInfo);
        this.geosConfig.setCatalog(this.catalog);
        this.wmsConfig = new WMS((GeoServer)this.geosConfig);
        this.wmsConfig.setApplicationContext((ApplicationContext)applicationContext);
        this.req = new GetCapabilitiesRequest();
        this.req.setBaseUrl(baseUrl);
        this.req.setVersion("1.1.1");
        ((SystemTestData)this.getTestData()).copyTo(((Object)((Object)this)).getClass().getResourceAsStream("/legendURL/BasicPolygons.png"), "legendsamples/BasicPolygons.png");
        ((SystemTestData)this.getTestData()).copyTo(((Object)((Object)this)).getClass().getResourceAsStream("/legendURL/Bridges.png"), "legendsamples/Bridges.png");
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        namespaces.put("wms", "http://www.opengis.net/wms");
        namespaces.put("ows", "http://www.opengis.net/ows");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        this.XPATH = XMLUnit.newXpathEngine();
    }

    protected Catalog getCatalog() {
        return (Catalog)applicationContext.getBean("catalog");
    }

    @Test
    public void testCachedLegendURLSize() throws Exception {
        TransformerBase tr = this.createTransformer();
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, tr);
        NodeList legendURLs = this.XPATH.getMatchingNodes(this.getLegendURLXPath("cite:BasicPolygons"), dom);
        Assert.assertEquals((long)1L, (long)legendURLs.getLength());
        Element legendURL = (Element)legendURLs.item(0);
        Assert.assertTrue((boolean)legendURL.hasAttribute("width"));
        Assert.assertEquals((Object)"50", (Object)legendURL.getAttribute("width"));
        Assert.assertTrue((boolean)legendURL.hasAttribute("height"));
        Assert.assertEquals((Object)"10", (Object)legendURL.getAttribute("height"));
    }

    @Test
    public void testCachedLegendURLFolderCreated() throws Exception {
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        File samplesFolder = new File(loader.getBaseDirectory().getAbsolutePath() + File.separator + "legendsamples");
        this.removeFileOrFolder(samplesFolder);
        TransformerBase tr = this.createTransformer();
        tr.setIndentation(2);
        WMSTestSupport.transform(this.req, tr);
        Assert.assertTrue((boolean)samplesFolder.exists());
    }

    @Test
    public void testLayerWorkspaceQualified() throws Exception {
        TransformerBase tr = this.createTransformer();
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, tr);
        String legendURL = this.XPATH.evaluate(this.getLegendURLXPath("cite:squares") + "/" + this.getElementPrefix() + "OnlineResource/@xlink:href", dom);
        Map kvp = KvpUtils.parseQueryString((String)legendURL);
        Assert.assertEquals((Object)"cite:squares", kvp.get("layer"));
    }

    @Test
    public void testCreatedLegendURLSize() throws Exception {
        TransformerBase tr = this.createTransformer();
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, tr);
        NodeList legendURLs = this.XPATH.getMatchingNodes(this.getLegendURLXPath("cite:squares"), dom);
        Assert.assertEquals((long)1L, (long)legendURLs.getLength());
        Element legendURL = (Element)legendURLs.item(0);
        Assert.assertTrue((boolean)legendURL.hasAttribute("width"));
        Assert.assertNotEquals((Object)"20", (Object)legendURL.getAttribute("width"));
        Assert.assertTrue((boolean)legendURL.hasAttribute("height"));
        Assert.assertNotEquals((Object)"20", (Object)legendURL.getAttribute("height"));
        File sampleFile = this.getSampleFile("squares");
        Assert.assertTrue((boolean)sampleFile.exists());
    }

    @Test
    public void testCreatedRasterLegendURLSize() throws Exception {
        TransformerBase tr = this.createTransformer();
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, tr);
        NodeList legendURLs = this.XPATH.getMatchingNodes(this.getLegendURLXPath("gs:world"), dom);
        Assert.assertEquals((long)1L, (long)legendURLs.getLength());
        Element legendURL = (Element)legendURLs.item(0);
        Assert.assertTrue((boolean)legendURL.hasAttribute("width"));
        Assert.assertNotEquals((Object)"20", (Object)legendURL.getAttribute("width"));
        Assert.assertTrue((boolean)legendURL.hasAttribute("height"));
        Assert.assertNotEquals((Object)"20", (Object)legendURL.getAttribute("height"));
        File sampleFile = this.getSampleFile("temperature");
        Assert.assertTrue((boolean)sampleFile.exists());
    }

    private File getSampleFile(String sampleName) {
        return new File(testData.getDataDirectoryRoot().getAbsolutePath() + File.separator + "legendsamples" + File.separator + sampleName + ".png");
    }

    @Test
    public void testCreatedLegendURLFromWorkspaceSize() throws Exception {
        TransformerBase tr = this.createTransformer();
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, tr);
        NodeList legendURLs = this.XPATH.getMatchingNodes(this.getLegendURLXPath("cite:states"), dom);
        Assert.assertEquals((long)1L, (long)legendURLs.getLength());
        Element legendURL = (Element)legendURLs.item(0);
        Assert.assertTrue((boolean)legendURL.hasAttribute("width"));
        Assert.assertNotEquals((Object)"20", (Object)legendURL.getAttribute("width"));
        Assert.assertTrue((boolean)legendURL.hasAttribute("height"));
        Assert.assertNotEquals((Object)"20", (Object)legendURL.getAttribute("height"));
        File sampleFile = this.getSampleFile("cite_states");
        Assert.assertTrue((boolean)sampleFile.exists());
    }

    @Test
    public void testCachedLegendURLUpdatedSize() throws Exception {
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        Resource sldResource = loader.get(Paths.path((String[])new String[]{"styles", "Bridges.sld"}));
        File sampleFile = this.getSampleFile("Bridges");
        long lastTime = sampleFile.lastModified();
        long lastLength = sampleFile.length();
        long previousTime = sldResource.lastmodified();
        sldResource.file().setLastModified(lastTime + 1000L);
        ((LegendSampleImpl)GeoServerExtensions.bean(LegendSample.class)).reloaded();
        TransformerBase tr = this.createTransformer();
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, tr);
        NodeList legendURLs = this.XPATH.getMatchingNodes(this.getLegendURLXPath("cite:Bridges"), dom);
        Assert.assertEquals((long)1L, (long)legendURLs.getLength());
        Element legendURL = (Element)legendURLs.item(0);
        Assert.assertTrue((boolean)legendURL.hasAttribute("width"));
        Assert.assertEquals((Object)"20", (Object)legendURL.getAttribute("width"));
        Assert.assertTrue((boolean)legendURL.hasAttribute("height"));
        Assert.assertEquals((Object)"20", (Object)legendURL.getAttribute("height"));
        Assert.assertNotEquals((long)this.getSampleFile("Bridges").length(), (long)lastLength);
        sldResource.file().setLastModified(previousTime);
    }

    @Test
    public void testCachedLegendURLUpdatedSize2() throws Exception {
        GeoServerResourceLoader loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
        Resource sldResource = loader.get(Paths.path((String[])new String[]{"styles", "Bridges.sld"}));
        File sampleFile = this.getSampleFile("Bridges");
        long lastTime = sampleFile.lastModified();
        long lastLength = sampleFile.length();
        long previousTime = sldResource.lastmodified();
        sldResource.file().setLastModified(lastTime + 1000L);
        this.catalog.firePostModified((CatalogInfo)this.catalog.getStyleByName("Bridges"), new ArrayList(), new ArrayList(), new ArrayList());
        TransformerBase tr = this.createTransformer();
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, tr);
        NodeList legendURLs = this.XPATH.getMatchingNodes(this.getLegendURLXPath("cite:Bridges"), dom);
        Assert.assertEquals((long)1L, (long)legendURLs.getLength());
        Element legendURL = (Element)legendURLs.item(0);
        Assert.assertTrue((boolean)legendURL.hasAttribute("width"));
        Assert.assertEquals((Object)"20", (Object)legendURL.getAttribute("width"));
        Assert.assertTrue((boolean)legendURL.hasAttribute("height"));
        Assert.assertEquals((Object)"20", (Object)legendURL.getAttribute("height"));
        Assert.assertNotEquals((long)this.getSampleFile("Bridges").length(), (long)lastLength);
        sldResource.file().setLastModified(previousTime);
    }

    @Test
    public void testOnlineResourceWidthHeight() throws Exception {
        TransformerBase tr = this.createTransformer();
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, tr);
        NodeList onlineResources = this.XPATH.getMatchingNodes(this.getOnlineResourceXPath("cite:BasicPolygons"), dom);
        Assert.assertEquals((long)1L, (long)onlineResources.getLength());
        Element onlineResource = (Element)onlineResources.item(0);
        String href = onlineResource.getAttribute("xlink:href");
        Assert.assertNotNull((Object)href);
        Assert.assertTrue((boolean)href.contains("width=20"));
        Assert.assertTrue((boolean)href.contains("height=20"));
    }

    @Test
    public void testOnlineResourceLegendURLVersion() throws Exception {
        TransformerBase tr = this.createTransformer();
        tr.setIndentation(2);
        Document dom = WMSTestSupport.transform(this.req, tr);
        NodeList onlineResources = this.XPATH.getMatchingNodes(this.getOnlineResourceXPath("cite:BasicPolygons"), dom);
        Assert.assertEquals((long)1L, (long)onlineResources.getLength());
        Element onlineResource = (Element)onlineResources.item(0);
        String href = onlineResource.getAttribute("xlink:href");
        Assert.assertNotNull((Object)href);
        Assert.assertTrue((boolean)href.contains("GetLegendGraphic"));
        Assert.assertTrue((boolean)href.contains("version"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWidthHeightInHrefConsistentWithLegendURLForStaticLegends() throws Exception {
        LayerInfo li = this.getCatalog().getLayerByName("cite:Bridges");
        StyleInfo styleInfo = li.getDefaultStyle();
        LegendInfoImpl legend = new LegendInfoImpl();
        legend.setOnlineResource(((Object)((Object)this)).getClass().getResource("/legendURL/Bridges.png").toURI().toString());
        legend.setHeight(10);
        legend.setFormat("image/png;charset=utf-8");
        legend.setWidth(50);
        styleInfo.setLegend((LegendInfo)legend);
        this.catalog.save(styleInfo);
        try {
            TransformerBase tr = this.createTransformer();
            tr.setIndentation(2);
            Document dom = WMSTestSupport.transform(this.req, tr);
            NodeList legendURLS = this.XPATH.getMatchingNodes(this.getLegendURLXPath("cite:Bridges"), dom);
            Assert.assertEquals((long)1L, (long)legendURLS.getLength());
            Element legendURL = (Element)legendURLS.item(0);
            Assert.assertTrue((boolean)legendURL.hasAttribute("width"));
            Assert.assertTrue((boolean)legendURL.hasAttribute("height"));
            String legendURLWidth = legendURL.getAttribute("width");
            String legendURLHeight = legendURL.getAttribute("height");
            Assert.assertNotEquals((Object)"20", (Object)legendURLWidth);
            Assert.assertNotEquals((Object)"20", (Object)legendURLHeight);
            NodeList onlineResources = this.XPATH.getMatchingNodes(this.getOnlineResourceXPath("cite:Bridges"), dom);
            Assert.assertEquals((long)1L, (long)onlineResources.getLength());
            Element onlineResource = (Element)onlineResources.item(0);
            String href = onlineResource.getAttribute("xlink:href");
            Assert.assertNotNull((Object)href);
            Assert.assertTrue((boolean)href.contains("width=" + legendURLWidth));
            Assert.assertTrue((boolean)href.contains("height=" + legendURLHeight));
        }
        finally {
            if (styleInfo != null) {
                styleInfo.setLegend(null);
                this.catalog.save(styleInfo);
            }
        }
    }

    private String getLegendURLXPath(String layerName) {
        return "/" + this.getElementPrefix() + this.getRootElement() + "/" + this.getElementPrefix() + "Capability/" + this.getElementPrefix() + "Layer/" + this.getElementPrefix() + "Layer[" + this.getElementPrefix() + "Name/text()='" + layerName + "']/" + this.getElementPrefix() + "Style/" + this.getElementPrefix() + "LegendURL";
    }

    private String getOnlineResourceXPath(String layerName) {
        return "/" + this.getElementPrefix() + this.getRootElement() + "/" + this.getElementPrefix() + "Capability/" + this.getElementPrefix() + "Layer/" + this.getElementPrefix() + "Layer[" + this.getElementPrefix() + "Name/text()='" + layerName + "']/" + this.getElementPrefix() + "Style/" + this.getElementPrefix() + "LegendURL/" + this.getElementPrefix() + "OnlineResource";
    }

    private void removeFileOrFolder(File file) {
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            file.delete();
        } else {
            String[] list;
            for (String s : list = file.list()) {
                this.removeFileOrFolder(new File(file.getAbsolutePath() + File.separator + s));
            }
            file.delete();
        }
    }

    protected abstract TransformerBase createTransformer();

    protected abstract String getRootElement();

    protected abstract String getElementPrefix();
}

