/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.HashSet;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.ServiceInfo;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.capabilities.Capabilities_1_3_0_Transformer;
import org.geotools.xml.transform.TransformerBase;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GetCapabilitiesSRCOrderTest
extends WMSTestSupport {
    private static final String BASE_URL = "http://localhost/geoserver";

    @Test
    public void testRootLayer() throws Exception {
        Document dom = this.findCapabilities(false);
        this.checkWms13ValidationErrors(dom);
        DOMSource domSource = new DOMSource(dom);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.transform(domSource, result);
        Assert.assertTrue((writer.toString().indexOf("22222") < writer.toString().indexOf("11111") ? 1 : 0) != 0);
    }

    private Document findCapabilities(Boolean scaleHintUnitsPerDiaPixel) throws Exception {
        WMS wms = this.getWMS();
        WMSInfo info = wms.getServiceInfo();
        info.getSRS().add("22222");
        info.getSRS().add("11111");
        MetadataMap mm = info.getMetadata();
        mm.put("scalehintMapunitsPixel", (Serializable)scaleHintUnitsPerDiaPixel);
        info.getGeoServer().save((ServiceInfo)info);
        Capabilities_1_3_0_Transformer tr = new Capabilities_1_3_0_Transformer(wms, BASE_URL, wms.getAllowedMapFormats(), new HashSet());
        GetCapabilitiesRequest req = new GetCapabilitiesRequest();
        req.setBaseUrl(BASE_URL);
        req.setVersion(WMS.VERSION_1_3_0.toString());
        Document dom = WMSTestSupport.transform(req, (TransformerBase)tr);
        Element root = dom.getDocumentElement();
        Assert.assertEquals((Object)WMS.VERSION_1_3_0.toString(), (Object)root.getAttribute("version"));
        return dom;
    }
}

