/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.xml.namespace.QName;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.capabilities.GetCapabilitiesTransformer;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.xml.transform.TransformerBase;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GetCapabilitiesScaleHintTest
extends WMSTestSupport {
    private final XpathEngine xpath;
    private static final String BASE_URL = "http://localhost/geoserver";
    private static final Set<String> FORMATS = Collections.singleton("image/png");
    private static final Set<String> LEGEND_FORMAT = Collections.singleton("image/png");
    public static final QName REGIONATED = new QName(MockData.SF_URI, "Regionated", MockData.SF_PREFIX);
    public static final QName ACCIDENT = new QName(MockData.SF_URI, "Accident", MockData.SF_PREFIX);
    public static final QName ACCIDENT2 = new QName(MockData.SF_URI, "Accident2", MockData.SF_PREFIX);
    public static final QName ACCIDENT3 = new QName(MockData.SF_URI, "Accident3", MockData.SF_PREFIX);
    private Catalog catalog;

    public GetCapabilitiesScaleHintTest() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xlink", "http://www.w3.org/1999/xlink");
        XMLUnit.setXpathNamespaceContext((NamespaceContext)new SimpleNamespaceContext(namespaces));
        this.xpath = XMLUnit.newXpathEngine();
    }

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        testData.setUpSecurity();
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        this.catalog = this.getCatalog();
        this.addLayerAndStyle(testData, REGIONATED);
        this.addLayerAndStyle(testData, ACCIDENT);
        this.addLayerAndStyle(testData, ACCIDENT2);
        this.addLayerAndStyle(testData, ACCIDENT3);
        this.addLayerGroups(testData);
    }

    void addLayerAndStyle(SystemTestData testData, QName name) throws IOException {
        testData.addVectorLayer(name, null, name.getLocalPart() + ".properties", ((Object)((Object)this)).getClass(), this.catalog);
        String styleName = name.getLocalPart();
        testData.addStyle(styleName, ((Object)((Object)this)).getClass(), this.catalog);
        StyleInfo defaultStyle = this.catalog.getStyleByName(styleName);
        String layerId = this.getLayerId(name);
        LayerInfo layerInfo = this.catalog.getLayerByName(layerId);
        layerInfo.setDefaultStyle(defaultStyle);
        this.catalog.save(layerInfo);
    }

    void addLayerGroups(SystemTestData testData) throws Exception {
        testData.addStyle("Accident3_2", ((Object)((Object)this)).getClass(), this.catalog);
        CoordinateReferenceSystem nativeCrs = CRS.decode((String)"EPSG:4326", (boolean)true);
        ReferencedEnvelope nativeBounds = new ReferencedEnvelope(-180.0, 180.0, -90.0, 90.0, nativeCrs);
        LayerGroupInfo layerGroup1 = this.catalog.getFactory().createLayerGroup();
        layerGroup1.setName("testLayerGroup1");
        layerGroup1.setBounds(nativeBounds);
        LayerGroupInfo layerGroup2 = this.catalog.getFactory().createLayerGroup();
        layerGroup2.setName("testLayerGroup2");
        layerGroup2.setBounds(nativeBounds);
        LayerGroupInfo layerGroup3 = this.catalog.getFactory().createLayerGroup();
        layerGroup3.setName("testLayerGroup3");
        layerGroup3.setBounds(nativeBounds);
        layerGroup1.getLayers().add(this.catalog.getLayerByName(this.getLayerId(REGIONATED)));
        layerGroup1.getStyles().add(null);
        layerGroup1.getLayers().add(this.catalog.getLayerByName(this.getLayerId(ACCIDENT3)));
        layerGroup1.getStyles().add(this.catalog.getStyleByName("Accident3_2"));
        layerGroup2.getLayers().add(this.catalog.getLayerByName(this.getLayerId(REGIONATED)));
        layerGroup2.getLayers().add(this.catalog.getLayerByName(this.getLayerId(ACCIDENT)));
        layerGroup2.getLayers().add(this.catalog.getLayerByName(this.getLayerId(ACCIDENT2)));
        layerGroup2.getStyles().add(null);
        layerGroup2.getStyles().add(null);
        layerGroup2.getStyles().add(null);
        layerGroup3.getLayers().add(layerGroup2);
        layerGroup3.getLayers().add(this.catalog.getLayerByName(this.getLayerId(ACCIDENT3)));
        layerGroup3.getStyles().add(null);
        layerGroup3.getStyles().add(null);
        this.catalog.add(layerGroup1);
        this.catalog.add(layerGroup2);
        this.catalog.add(layerGroup3);
    }

    @Test
    public void testLayerGroups() throws Exception {
        Document dom = this.findCapabilities(false);
        Element layerElement = this.searchLayerElement("testLayerGroup1", dom);
        NodeList scaleNode = layerElement.getElementsByTagName("ScaleHint");
        Element scaleElement = (Element)scaleNode.item(0);
        Assert.assertEquals((Object)8.0E7, (Object)Double.valueOf(scaleElement.getAttribute("min")));
        Assert.assertEquals((Object)1.0E9, (Object)Double.valueOf(scaleElement.getAttribute("max")));
        layerElement = this.searchLayerElement("testLayerGroup3", dom);
        scaleNode = layerElement.getElementsByTagName("ScaleHint");
        scaleElement = (Element)scaleNode.item(0);
        Assert.assertNull((Object)scaleElement);
    }

    @Test
    public void scaleHintDefaultValues() throws Exception {
        Document dom = this.findCapabilities(false);
        Element layerElement = this.searchLayerElement(this.getLayerId(ACCIDENT), dom);
        NodeList scaleNode = layerElement.getElementsByTagName("ScaleHint");
        Element scaleElement = (Element)scaleNode.item(0);
        Assert.assertNull((Object)scaleElement);
    }

    @Test
    public void scaleHintDefaultMinValue() throws Exception {
        Document dom = this.findCapabilities(false);
        Element layerElement = this.searchLayerElement(this.getLayerId(ACCIDENT2), dom);
        NodeList scaleNode = layerElement.getElementsByTagName("ScaleHint");
        Element scaleElement = (Element)scaleNode.item(0);
        Assert.assertEquals((double)0.0, (double)Double.valueOf(scaleElement.getAttribute("min")), (double)0.0);
        Assert.assertEquals((Object)6.4E8, (Object)Double.valueOf(scaleElement.getAttribute("max")));
    }

    @Test
    public void scaleHintUnitsPerPixelDefaultMinValue() throws Exception {
        Document dom = this.findCapabilities(true);
        Element layerElement = this.searchLayerElement(this.getLayerId(ACCIDENT2), dom);
        NodeList scaleNode = layerElement.getElementsByTagName("ScaleHint");
        Element scaleElement = (Element)scaleNode.item(0);
        Assert.assertEquals((double)0.0, (double)Double.valueOf(scaleElement.getAttribute("min")), (double)0.0);
        Assert.assertEquals((Object)253427.07037725858, (Object)Double.valueOf(scaleElement.getAttribute("max")));
    }

    @Test
    public void scaleHintDefaultMaxValue() throws Exception {
        Document dom = this.findCapabilities(false);
        Element layerElement = this.searchLayerElement(this.getLayerId(ACCIDENT3), dom);
        NodeList scaleNode = layerElement.getElementsByTagName("ScaleHint");
        Element scaleElement = (Element)scaleNode.item(0);
        Assert.assertEquals((Object)3.2E8, (Object)Double.valueOf(scaleElement.getAttribute("min")));
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)Double.valueOf(scaleElement.getAttribute("max")), (double)0.0);
    }

    @Test
    public void scaleHintUnitsPerPixelDefaultMaxValue() throws Exception {
        Document dom = this.findCapabilities(true);
        Element layerElement = this.searchLayerElement(this.getLayerId(ACCIDENT3), dom);
        NodeList scaleNode = layerElement.getElementsByTagName("ScaleHint");
        Element scaleElement = (Element)scaleNode.item(0);
        Assert.assertEquals((Object)126713.53518862929, (Object)Double.valueOf(scaleElement.getAttribute("min")));
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)Double.valueOf(scaleElement.getAttribute("max")), (double)0.0);
    }

    @Test
    public void scaleHintFoundMaxMinDenominators() throws Exception {
        Document dom = this.findCapabilities(false);
        String layerName = this.getLayerId(REGIONATED);
        Element layerElement = this.searchLayerElement(layerName, dom);
        NodeList scaleNode = layerElement.getElementsByTagName("ScaleHint");
        Element scaleElement = (Element)scaleNode.item(0);
        Assert.assertEquals((Object)8.0E7, (Object)Double.valueOf(scaleElement.getAttribute("min")));
        Assert.assertEquals((Object)6.4E8, (Object)Double.valueOf(scaleElement.getAttribute("max")));
    }

    @Test
    public void scaleHintUnitsPerPixelFoundMaxMinDenominators() throws Exception {
        Document dom = this.findCapabilities(true);
        String layerName = this.getLayerId(REGIONATED);
        Element layerElement = this.searchLayerElement(layerName, dom);
        NodeList scaleNode = layerElement.getElementsByTagName("ScaleHint");
        Element scaleElement = (Element)scaleNode.item(0);
        Assert.assertEquals((Object)31678.383797157323, (Object)Double.valueOf(scaleElement.getAttribute("min")));
        Assert.assertEquals((Object)253427.07037725858, (Object)Double.valueOf(scaleElement.getAttribute("max")));
    }

    private Document findCapabilities(Boolean scaleHintUnitsPerDiaPixel) throws Exception {
        WMS wms = this.getWMS();
        WMSInfo info = wms.getServiceInfo();
        MetadataMap mm = info.getMetadata();
        mm.put("scalehintMapunitsPixel", (Serializable)scaleHintUnitsPerDiaPixel);
        info.getGeoServer().save((ServiceInfo)info);
        GetCapabilitiesTransformer tr = new GetCapabilitiesTransformer(wms, BASE_URL, FORMATS, LEGEND_FORMAT, null);
        GetCapabilitiesRequest req = new GetCapabilitiesRequest();
        req.setBaseUrl(BASE_URL);
        req.setVersion(WMS.VERSION_1_1_1.toString());
        Document dom = WMSTestSupport.transform(req, (TransformerBase)tr);
        Element root = dom.getDocumentElement();
        Assert.assertEquals((Object)WMS.VERSION_1_1_1.toString(), (Object)root.getAttribute("version"));
        return dom;
    }

    private Element searchLayerElement(String layerRequired, Document capabilities) throws XpathException {
        NodeList layersNodes = this.xpath.getMatchingNodes("//Layer/Name", capabilities);
        for (int i = 0; i < layersNodes.getLength(); ++i) {
            Element e = (Element)layersNodes.item(i);
            NodeList childNodes = e.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node item = childNodes.item(j);
                String nodeValue = item.getNodeValue();
                if (!layerRequired.equalsIgnoreCase(nodeValue)) continue;
                return (Element)e.getParentNode();
            }
        }
        return null;
    }
}

