/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension;

import java.io.Serializable;
import java.util.Collections;
import javax.xml.namespace.QName;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.DimensionInfoImpl;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.util.Range;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RasterElevationDimensionDefaultValueTest
extends WMSTestSupport {
    static final QName WATTEMP = new QName(MockData.SF_URI, "watertemp", MockData.SF_PREFIX);
    WMS wms;

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
    }

    @Before
    public void setup() throws Exception {
        this.wms = this.getWMS();
        ((SystemTestData)testData).addRasterLayer(WATTEMP, "watertemp.zip", null, Collections.emptyMap(), ((Object)((Object)this)).getClass(), this.getCatalog());
    }

    @Test
    public void testDefaultElevationCoverageSelector() throws Exception {
        this.setupCoverageElevationDimension(WATTEMP, null);
        CoverageInfo elevatedCoverage = this.getCatalog().getCoverageByName(WATTEMP.getLocalPart());
        Double expected = 0.0;
        Double e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevatedCoverage);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)"Default elevation should be the smallest one", (Math.abs(e - expected) < 1.0E-5 ? 1 : 0) != 0);
    }

    @Test
    public void testExplicitMinElevationCoverageSelector() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.MINIMUM);
        this.setupCoverageElevationDimension(WATTEMP, defaultValueSetting);
        CoverageInfo elevatedCoverage = this.getCatalog().getCoverageByName(WATTEMP.getLocalPart());
        Double expected = 0.0;
        Double e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevatedCoverage);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)"Default elevation should be the smallest one", (Math.abs(e - expected) < 1.0E-5 ? 1 : 0) != 0);
    }

    @Test
    public void testExplicitMaxElevationCoverageSelector() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.MAXIMUM);
        this.setupCoverageElevationDimension(WATTEMP, defaultValueSetting);
        CoverageInfo elevatedCoverage = this.getCatalog().getCoverageByName(WATTEMP.getLocalPart());
        Double expected = 100.0;
        Double e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevatedCoverage);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)"Default elevation should be the biggest one", (Math.abs(e - expected) < 1.0E-5 ? 1 : 0) != 0);
    }

    @Test
    public void testExplicitFixedElevationCoverageSelector() throws Exception {
        String fixedElevationStr = "550";
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue(fixedElevationStr);
        Double fixedElevation = Double.parseDouble(fixedElevationStr);
        this.setupCoverageElevationDimension(WATTEMP, defaultValueSetting);
        CoverageInfo elevatedCoverage = this.getCatalog().getCoverageByName(WATTEMP.getLocalPart());
        Double e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevatedCoverage);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)"Default elevation should be the fixed one", (Math.abs(e - fixedElevation) < 1.0E-5 ? 1 : 0) != 0);
    }

    @Test
    public void testExplicitNearestToGivenTimeCoverageSelector() throws Exception {
        String referenceElevationStr = "55";
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.NEAREST);
        defaultValueSetting.setReferenceValue(referenceElevationStr);
        this.setupCoverageElevationDimension(WATTEMP, defaultValueSetting);
        Double expected = 100.0;
        CoverageInfo elevatedCoverage = this.getCatalog().getCoverageByName(WATTEMP.getLocalPart());
        Double e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevatedCoverage);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)"Default elevation should be the fixed one", (Math.abs(e - expected) < 1.0E-5 ? 1 : 0) != 0);
    }

    @Test
    public void testExplicitNearestToGivenTimeCoverageSelector2() throws Exception {
        String referenceElevationStr = "45";
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.NEAREST);
        defaultValueSetting.setReferenceValue(referenceElevationStr);
        this.setupCoverageElevationDimension(WATTEMP, defaultValueSetting);
        Double expected = 0.0;
        CoverageInfo elevatedCoverage = this.getCatalog().getCoverageByName(WATTEMP.getLocalPart());
        Double e = (Double)this.wms.getDefaultElevation((ResourceInfo)elevatedCoverage);
        Assert.assertNotNull((String)"Default elevation is null", (Object)e);
        Assert.assertTrue((String)"Default elevation should be the fixed one", (Math.abs(e - expected) < 1.0E-5 ? 1 : 0) != 0);
    }

    @Test
    public void testFixedRangeElevation() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("-100/0");
        this.setupCoverageElevationDimension(WATTEMP, defaultValueSetting);
        CoverageInfo elevatedCoverage = this.getCatalog().getCoverageByName(WATTEMP.getLocalPart());
        Range defaultRange = (Range)this.wms.getDefaultElevation((ResourceInfo)elevatedCoverage);
        Assert.assertNotNull((String)"Default elevation is null", (Object)defaultRange);
        Assert.assertEquals((double)-100.0, (double)((Double)defaultRange.getMinValue()), (double)0.0);
        Assert.assertEquals((double)0.0, (double)((Double)defaultRange.getMaxValue()), (double)0.0);
    }

    protected void setupCoverageElevationDimension(QName name, DimensionDefaultValueSetting defaultValue) {
        CoverageInfo info = this.getCatalog().getCoverageByName(name.getLocalPart());
        DimensionInfoImpl di = new DimensionInfoImpl();
        di.setEnabled(true);
        di.setPresentation(DimensionPresentation.LIST);
        di.setDefaultValue(defaultValue);
        info.getMetadata().put("elevation", (Serializable)di);
        this.getCatalog().save((ResourceInfo)info);
    }
}

