/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import org.apache.commons.io.IOUtils;
import org.geoserver.data.test.MockData;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.featureinfo.FeatureTemplate;
import org.geoserver.wms.featureinfo.dummy.Dummy;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.junit.Assert;
import org.junit.Test;

public class FeatureTemplateTest
extends WMSTestSupport {
    @Test
    public void testWithDateAndBoolean() throws Exception {
        SimpleFeatureSource source = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        SimpleFeatureCollection fc = source.getFeatures();
        try (SimpleFeatureIterator i = fc.features();){
            SimpleFeature f = (SimpleFeature)i.next();
            FeatureTemplate template = new FeatureTemplate();
            try {
                template.description(f);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "", e);
                Assert.fail((String)("template threw exception on null value. " + e.getMessage()));
            }
        }
    }

    @Test
    public void testRawValue() throws Exception {
        SimpleFeatureSource source = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        SimpleFeatureCollection fc = source.getFeatures();
        try (SimpleFeatureIterator i = fc.features();){
            SimpleFeature f = (SimpleFeature)i.next();
            FeatureTemplate template = new FeatureTemplate();
            try {
                template.template(f, "rawValues.ftl", FeatureTemplateTest.class);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "", e);
                throw e;
            }
        }
    }

    @Test
    public void testWithNull() throws Exception {
        SimpleFeatureSource source = this.getFeatureSource(MockData.BASIC_POLYGONS);
        SimpleFeatureCollection fc = source.getFeatures();
        try (SimpleFeatureIterator i = fc.features();){
            SimpleFeature f = (SimpleFeature)i.next();
            FeatureTemplate template = new FeatureTemplate();
            template.description(f);
            f.setAttribute(1, null);
            try {
                template.description(f);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "", e);
                Assert.fail((String)"template threw exception on null value");
            }
        }
    }

    @Test
    public void testAlternateLookup() throws Exception {
        SimpleFeatureSource source = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        SimpleFeatureCollection fc = source.getFeatures();
        try (SimpleFeatureIterator features = fc.features();){
            SimpleFeature f = (SimpleFeature)features.next();
            FeatureTemplate template = new FeatureTemplate();
            String result = template.template(f, "dummy.ftl", Dummy.class);
            Assert.assertEquals((Object)"dummy", (Object)result);
        }
    }

    @Test
    public void testEmptyTemplate() throws Exception {
        String defaultHeightTemplate;
        SimpleFeatureSource source = this.getFeatureSource(MockData.PRIMITIVEGEOFEATURE);
        FeatureTemplate template = new FeatureTemplate();
        try (InputStream is = FeatureTemplate.class.getResourceAsStream("height.ftl");){
            defaultHeightTemplate = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        Assert.assertTrue((boolean)template.isTemplateEmpty((SimpleFeatureType)source.getSchema(), "height.ftl", FeatureTemplate.class, defaultHeightTemplate));
        Assert.assertTrue((boolean)template.isTemplateEmpty((SimpleFeatureType)source.getSchema(), "time.ftl", FeatureTemplate.class, null));
        Assert.assertFalse((boolean)template.isTemplateEmpty((SimpleFeatureType)source.getSchema(), "title.ftl", FeatureTemplate.class, null));
    }
}

