/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.icons;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.wms.icons.IconService;
import org.geoserver.wms.icons.IconTestSupport;
import org.geotools.api.filter.Filter;
import org.geotools.api.style.Style;
import org.geotools.api.style.Symbolizer;
import org.junit.Test;

public class IconServiceTest
extends IconTestSupport {
    @Test
    public void testHandle() throws Exception {
        Style style = this.style(this.featureTypeStyle(this.rule((Filter)Filter.INCLUDE, new Symbolizer[]{this.grayCircle()})));
        StyleInfo s = (StyleInfo)EasyMock.createNiceMock(StyleInfo.class);
        EasyMock.expect((Object)s.getStyle()).andReturn((Object)style);
        Catalog cat = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)cat.getStyleByName("foo")).andReturn((Object)s);
        EasyMock.replay((Object[])new Object[]{s, cat});
        this.dispatch("/icon/foo", "0.0.0=", cat);
    }

    @Test
    public void testHandleMultipleFTS() throws Exception {
        Style style = this.style(this.featureTypeStyle(this.rule((Filter)Filter.INCLUDE, new Symbolizer[]{this.grayCircle()})), this.featureTypeStyle(this.rule((Filter)Filter.INCLUDE, new Symbolizer[]{this.redStar()})));
        StyleInfo s = (StyleInfo)EasyMock.createNiceMock(StyleInfo.class);
        EasyMock.expect((Object)s.getStyle()).andReturn((Object)style);
        Catalog cat = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)cat.getStyleByName("foo-bar")).andReturn((Object)s);
        EasyMock.replay((Object[])new Object[]{s, cat});
        this.dispatch("/icon/foo-bar", "1.0.0=", cat);
    }

    @Test
    public void testAcceptedNames() throws Exception {
        Style style = this.style(this.featureTypeStyle(this.rule((Filter)Filter.INCLUDE, new Symbolizer[]{this.grayCircle()})));
        StyleInfo s = (StyleInfo)EasyMock.createNiceMock(StyleInfo.class);
        EasyMock.expect((Object)s.getStyle()).andReturn((Object)style);
        Catalog cat = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)cat.getStyleByName("foo-bar")).andReturn((Object)s);
        EasyMock.replay((Object[])new Object[]{s, cat});
        this.dispatch("/icon/foo-bar", "0.0.0=", cat);
    }

    void dispatch(String path, String q, Catalog cat) throws Exception {
        HttpServletRequest req = (HttpServletRequest)EasyMock.createNiceMock(HttpServletRequest.class);
        EasyMock.expect((Object)req.getPathInfo()).andReturn((Object)path);
        EasyMock.expect((Object)req.getQueryString()).andReturn((Object)q);
        ServletOutputStream out = (ServletOutputStream)EasyMock.createNiceMock(ServletOutputStream.class);
        HttpServletResponse res = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
        EasyMock.expect((Object)res.getOutputStream()).andReturn((Object)out).anyTimes();
        res.setContentType("image/png");
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{req, res, out});
        IconService service = new IconService(cat);
        service.handleRequestInternal(req, res);
        EasyMock.verify((Object[])new Object[]{cat});
        EasyMock.verify((Object[])new Object[]{res});
    }
}

