/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import com.google.common.collect.ImmutableMap;
import java.awt.Font;
import java.util.Map;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.legendgraphic.LegendUtils;
import org.geotools.renderer.style.FontCache;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class LegendUtilsTest {
    @Test
    public void testGetLabelFromCache() throws Exception {
        Assume.assumeTrue((FontCache.getDefaultInstance().getFont("Anarchist Mustache") == null ? 1 : 0) != 0);
        GetLegendGraphicRequest req = new GetLegendGraphicRequest();
        req.setLegendOptions((Map)ImmutableMap.builder().put((Object)"fontName", (Object)"Anarchist Mustache").build());
        Font f1 = LegendUtils.getLabelFont((GetLegendGraphicRequest)req);
        Assert.assertEquals((Object)"Dialog", (Object)f1.getFamily());
        Font f = Font.createFont(0, LegendUtilsTest.class.getResourceAsStream("Anarchist_Mustache.ttf"));
        FontCache.getDefaultInstance().registerFont(f);
        Font f2 = LegendUtils.getLabelFont((GetLegendGraphicRequest)req);
        Assert.assertEquals((Object)"Anarchist Mustache", (Object)f2.getName());
    }
}

