/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.media.jai.Interpolation;
import javax.media.jai.RenderedOp;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.data.test.TestData;
import org.geoserver.wms.CachedGridReaderLayer;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.map.RasterSymbolizerVisitorTest;
import org.geoserver.wms.map.RenderedImageMap;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geoserver.wms.map.RenderedImageMapOutputFormatTest;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.xml.styling.SLDParser;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.springframework.mock.web.MockHttpServletResponse;

public class RenderedImageMapOutputFormatExtendedTest
extends WMSTestSupport {
    private static final QName MOSAIC_HOLES = new QName(MockData.SF_URI, "mosaic_holes", MockData.SF_PREFIX);
    private static final String RGB_IR_VIEW = "RgbIrView";
    private static final QName IR_RGB = new QName(MockData.SF_URI, "ir-rgb", MockData.SF_PREFIX);
    private RenderedImageMapOutputFormat rasterMapProducer;

    @Before
    public void setRasterMapProducer() throws Exception {
        this.rasterMapProducer = this.getProducerInstance();
    }

    protected RenderedImageMapOutputFormat getProducerInstance() {
        return new RenderedImageMapOutputFormatTest.DummyRasterMapProducer(this.getWMS());
    }

    @After
    public void unsetRasterMapProducer() throws Exception {
        this.rasterMapProducer = null;
    }

    @BeforeClass
    public static void setup() {
        System.setProperty("ENABLE_ADVANCED_PROJECTION", "false");
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        HashMap<SystemTestData.LayerProperty, String> properties = new HashMap<SystemTestData.LayerProperty, String>();
        properties.put(SystemTestData.LayerProperty.STYLE, "raster");
        Catalog cat = this.getCatalog();
        testData.addRasterLayer(MOSAIC_HOLES, "mosaic_holes.zip", null, properties, RenderedImageMapOutputFormatExtendedTest.class, cat);
        testData.addRasterLayer(IR_RGB, "ir-rgb.zip", null, null, TestData.class, cat);
        CoverageStoreInfo storeInfo = cat.getCoverageStoreByName("ir-rgb");
        CoverageView coverageView = this.buildRgbIRView();
        CatalogBuilder builder = new CatalogBuilder(cat);
        builder.setStore((StoreInfo)storeInfo);
        CoverageInfo coverageInfo = coverageView.createCoverageInfo(RGB_IR_VIEW, storeInfo, builder);
        coverageInfo.getParameters().put("USE_JAI_IMAGEREAD", "false");
        ((CoverageDimensionInfo)coverageInfo.getDimensions().get(0)).setName("Red");
        ((CoverageDimensionInfo)coverageInfo.getDimensions().get(1)).setName("Green");
        ((CoverageDimensionInfo)coverageInfo.getDimensions().get(2)).setName("Blue");
        ((CoverageDimensionInfo)coverageInfo.getDimensions().get(3)).setName("Infrared");
        cat.add((ResourceInfo)coverageInfo);
    }

    private CoverageView buildRgbIRView() {
        CoverageView.CoverageBand rBand = new CoverageView.CoverageBand(Arrays.asList(new CoverageView.InputCoverageBand("rgb", "0")), "rband", 0, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.CoverageBand gBand = new CoverageView.CoverageBand(Arrays.asList(new CoverageView.InputCoverageBand("rgb", "1")), "gband", 1, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.CoverageBand bBand = new CoverageView.CoverageBand(Arrays.asList(new CoverageView.InputCoverageBand("rgb", "2")), "bband", 2, CoverageView.CompositionType.BAND_SELECT);
        CoverageView.CoverageBand irBand = new CoverageView.CoverageBand(Collections.singletonList(new CoverageView.InputCoverageBand("ir", "0")), "irband", 3, CoverageView.CompositionType.BAND_SELECT);
        CoverageView coverageView = new CoverageView(RGB_IR_VIEW, Arrays.asList(rBand, gBand, bBand, irBand));
        return coverageView;
    }

    @Test
    public void testRenderingTransformationChannelsSelectionFromCoverageView() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(RGB_IR_VIEW);
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        ReferencedEnvelope bbox = new ReferencedEnvelope((Bounds)reader.getOriginalEnvelope());
        GetMapRequest request = new GetMapRequest();
        request.setBbox((Envelope)bbox);
        request.setSRS("urn:x-ogc:def:crs:EPSG:32632");
        request.setFormat("image/png");
        WMSMapContent map = new WMSMapContent(request);
        map.setMapWidth(20);
        map.setMapHeight(20);
        map.setTransparent(false);
        map.getViewport().setBounds(bbox);
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory());
        parser.setInput(RasterSymbolizerVisitorTest.class.getResource("CropTransformAndChannelSelect.sld"));
        StyledLayerDescriptor sld = parser.parseSLD();
        NamedLayer ul = (NamedLayer)sld.getStyledLayers()[0];
        Style style = ul.getStyles()[0];
        CachedGridReaderLayer dl = new CachedGridReaderLayer(reader, style);
        map.addLayer((Layer)dl);
        RenderedImageMap dstImageMap = this.rasterMapProducer.produceMap(map);
        RenderedImage destImage = dstImageMap.getImage();
        Assert.assertNotNull((Object)destImage);
        ColorModel cm = destImage.getColorModel();
        SampleModel sm = destImage.getSampleModel();
        Assert.assertEquals((long)1L, (long)cm.getColorSpace().getNumComponents());
        Assert.assertEquals((long)1L, (long)sm.getNumBands());
        dstImageMap.dispose();
        map.dispose();
    }

    @Test
    public void testInterpolationAppliedWithRenderingTransformation() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName(RGB_IR_VIEW);
        GridCoverage2DReader reader = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        ReferencedEnvelope bbox = new ReferencedEnvelope((Bounds)reader.getOriginalEnvelope());
        GetMapRequest request = new GetMapRequest();
        request.setBbox((Envelope)bbox);
        request.setSRS("urn:x-ogc:def:crs:EPSG:32632");
        request.setFormat("image/png");
        request.setInterpolations(Collections.singletonList(Interpolation.getInstance((int)1)));
        WMSMapContent map = new WMSMapContent(request);
        map.setMapWidth(20);
        map.setMapHeight(20);
        map.setTransparent(false);
        map.getViewport().setBounds(bbox);
        SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory());
        parser.setInput(RasterSymbolizerVisitorTest.class.getResource("CropTransformAndChannelSelect.sld"));
        StyledLayerDescriptor sld = parser.parseSLD();
        NamedLayer ul = (NamedLayer)sld.getStyledLayers()[0];
        Style style = ul.getStyles()[0];
        CachedGridReaderLayer dl = new CachedGridReaderLayer(reader, style);
        map.addLayer((Layer)dl);
        RenderedImageMap dstImageMap = this.rasterMapProducer.produceMap(map);
        RenderedImage destImage = dstImageMap.getImage();
        Assert.assertNotNull((Object)destImage);
        Interpolation interpolation = this.getScalingInterpolation(destImage);
        Assert.assertNotNull((Object)interpolation);
        Assert.assertEquals((Object)interpolation, (Object)Interpolation.getInstance((int)1));
        dstImageMap.dispose();
        map.dispose();
    }

    private Interpolation getScalingInterpolation(RenderedImage destImage) {
        RenderedOp scalingOp = this.getScalingOpImage(destImage);
        ParameterBlock parameterBlock = scalingOp.getParameterBlock();
        Interpolation interpolation = null;
        for (int i = 0; i < parameterBlock.getNumParameters(); ++i) {
            Object param = parameterBlock.getObjectParameter(i);
            if (!(param instanceof Interpolation)) continue;
            interpolation = (Interpolation)param;
        }
        return interpolation;
    }

    private RenderedOp getScalingOpImage(RenderedImage destImage) {
        if (destImage != null) {
            Vector<RenderedImage> sources = destImage.getSources();
            for (RenderedImage source : sources) {
                if (!(source instanceof RenderedOp)) continue;
                RenderedOp op = (RenderedOp)source;
                String opName = op.getOperationName();
                if ("Scale".equalsIgnoreCase(opName)) {
                    return op;
                }
                RenderedOp opImage = this.getScalingOpImage(source);
                if (opImage == null) continue;
                return opImage;
            }
        }
        return null;
    }

    @Test
    public void testMosaicNoProjection() throws IOException, IllegalFilterException, Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?BBOX=6.40284375,36.385494140625,12.189662109375,42.444494140625&styles=&layers=sf:mosaic_holes&Format=image/png&request=GetMap&width=550&height=250&srs=EPSG:4326");
        this.checkImage(response);
    }

    @AfterClass
    public static void after() {
        System.setProperty("ENABLE_ADVANCED_PROJECTION", "true");
    }
}

