/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.utfgrid;

import java.awt.Color;
import java.util.Map;
import org.geoserver.wms.utfgrid.UTFGridColorFunction;
import org.geoserver.wms.utfgrid.UTFGridEntries;
import org.geoserver.wms.utfgrid.UTFGridStyleVisitor;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.Symbolizer;
import org.geotools.renderer.composite.BlendComposite;
import org.geotools.styling.StyleBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UTFGridStyleVisitorTest {
    UTFGridStyleVisitor visitor;
    StyleBuilder sb = new StyleBuilder();
    FilterFactory ff = this.sb.getFilterFactory();
    private UTFGridColorFunction colorFunction;

    @Before
    public void setupVisitor() {
        UTFGridEntries entries = new UTFGridEntries();
        this.colorFunction = new UTFGridColorFunction(entries);
        this.visitor = new UTFGridStyleVisitor(this.colorFunction);
    }

    @Test
    public void testOnlyTextSymbolizer() {
        Style style = this.sb.createStyle((Symbolizer)this.sb.createTextSymbolizer(Color.BLACK, this.sb.createFont("Serif", 12.0), "name"));
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        Assert.assertEquals((long)0L, (long)copy.featureTypeStyles().size());
    }

    @Test
    public void testFill() {
        PolygonSymbolizer polygonSymbolizer = this.sb.createPolygonSymbolizer(Color.BLACK, Color.BLACK, 3.0);
        polygonSymbolizer.getFill().setOpacity((Expression)this.ff.literal(0.5));
        polygonSymbolizer.getStroke().setOpacity((Expression)this.ff.literal(0.5));
        Style style = this.sb.createStyle((Symbolizer)polygonSymbolizer);
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        PolygonSymbolizer ls = (PolygonSymbolizer)((Rule)((FeatureTypeStyle)copy.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        Stroke stroke = ls.getStroke();
        Assert.assertEquals((Object)this.colorFunction, (Object)stroke.getColor());
        Assert.assertEquals((Object)3, (Object)stroke.getWidth().evaluate(null, Integer.class));
        Assert.assertNull((Object)stroke.dashArray());
        Assert.assertEquals((Object)1, (Object)stroke.getOpacity().evaluate(null, Integer.class));
        Fill fill = ls.getFill();
        Assert.assertEquals((Object)this.colorFunction, (Object)fill.getColor());
        Assert.assertEquals((Object)1, (Object)fill.getOpacity().evaluate(null, Integer.class));
    }

    @Test
    public void testGraphicStrokeFill() {
        Graphic graphic = this.sb.createGraphic(null, this.sb.createMark("square"), null);
        graphic.setSize((Expression)this.ff.literal(8));
        Stroke stroke = this.sb.createStroke();
        stroke.setGraphicStroke(graphic);
        stroke.setOpacity((Expression)this.ff.literal(0.5));
        Fill fill = this.sb.createFill(null, null, 0.5, graphic);
        PolygonSymbolizer polygonSymbolizer = this.sb.createPolygonSymbolizer(stroke, fill);
        Style style = this.sb.createStyle((Symbolizer)polygonSymbolizer);
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        PolygonSymbolizer ls = (PolygonSymbolizer)((Rule)((FeatureTypeStyle)copy.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        Stroke strokeCopy = ls.getStroke();
        Assert.assertEquals((Object)this.colorFunction, (Object)strokeCopy.getColor());
        Assert.assertEquals((Object)8, (Object)strokeCopy.getWidth().evaluate(null, Integer.class));
        Assert.assertNull((Object)strokeCopy.dashArray());
        Assert.assertEquals((Object)1, (Object)strokeCopy.getOpacity().evaluate(null, Integer.class));
        Fill fillCopy = ls.getFill();
        Assert.assertEquals((Object)this.colorFunction, (Object)fillCopy.getColor());
        Assert.assertEquals((Object)1, (Object)fillCopy.getOpacity().evaluate(null, Integer.class));
    }

    @Test
    public void testLine() {
        Style style = this.sb.createStyle((Symbolizer)this.sb.createLineSymbolizer(this.sb.createStroke(Color.BLACK, 3.0)));
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        LineSymbolizer ls = (LineSymbolizer)((Rule)((FeatureTypeStyle)copy.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        Stroke stroke = ls.getStroke();
        Assert.assertEquals((Object)this.colorFunction, (Object)stroke.getColor());
        Assert.assertEquals((Object)3, (Object)stroke.getWidth().evaluate(null, Integer.class));
        Assert.assertNull((Object)stroke.dashArray());
    }

    @Test
    public void testStrokedLine() {
        Style style = this.sb.createStyle((Symbolizer)this.sb.createLineSymbolizer(this.sb.createStroke(Color.BLACK, 1.0, new float[]{8.0f, 8.0f})));
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        LineSymbolizer ls = (LineSymbolizer)((Rule)((FeatureTypeStyle)copy.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        Stroke stroke = ls.getStroke();
        Assert.assertEquals((Object)this.colorFunction, (Object)stroke.getColor());
        Assert.assertEquals((Object)1, (Object)stroke.getWidth().evaluate(null, Integer.class));
        Assert.assertEquals((long)0L, (long)stroke.dashArray().size());
    }

    @Test
    public void testGraphicStroke() {
        Graphic graphic = this.sb.createGraphic(null, this.sb.createMark("square"), null);
        graphic.setSize((Expression)this.ff.literal(8));
        Stroke stroke = this.sb.createStroke();
        stroke.setGraphicStroke(graphic);
        Style style = this.sb.createStyle((Symbolizer)this.sb.createLineSymbolizer(stroke));
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        LineSymbolizer ls = (LineSymbolizer)((Rule)((FeatureTypeStyle)copy.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        stroke = ls.getStroke();
        Assert.assertEquals((Object)this.colorFunction, (Object)stroke.getColor());
        Assert.assertEquals((Object)8, (Object)stroke.getWidth().evaluate(null, Integer.class));
        Assert.assertNull((Object)stroke.dashArray());
    }

    @Test
    public void testBlendingRemoval() {
        FeatureTypeStyle fts = this.sb.createFeatureTypeStyle((Symbolizer)this.sb.createLineSymbolizer());
        fts.getOptions().put("composite", BlendComposite.BlendingMode.MULTIPLY.getName());
        fts.getOptions().put("composite-base", "true");
        Style style = this.sb.createStyle();
        style.featureTypeStyles().add(fts);
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        Map options = ((FeatureTypeStyle)copy.featureTypeStyles().get(0)).getOptions();
        Assert.assertNull(options.get("composite"));
        Assert.assertNull(options.get("composite-base"));
    }

    @Test
    public void testAlphaCompositePreserved() {
        FeatureTypeStyle fts = this.sb.createFeatureTypeStyle((Symbolizer)this.sb.createLineSymbolizer());
        fts.getOptions().put("composite", "source-over");
        fts.getOptions().put("composite-base", "true");
        Style style = this.sb.createStyle();
        style.featureTypeStyles().add(fts);
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        Map options = ((FeatureTypeStyle)copy.featureTypeStyles().get(0)).getOptions();
        Assert.assertEquals((Object)"source-over", options.get("composite"));
        Assert.assertEquals((Object)"true", options.get("composite-base"));
    }

    @Test
    public void testRasterToVectorTransform() {
        FeatureTypeStyle fts = this.sb.createFeatureTypeStyle((Symbolizer)this.sb.createLineSymbolizer());
        Function data = this.ff.function("parameter", new Expression[]{this.ff.literal((Object)"data")});
        Function levels = this.ff.function("parameter", new Expression[]{this.ff.literal((Object)"levels"), this.ff.literal((Object)"1100"), this.ff.literal((Object)"1200")});
        Function tx = this.ff.function("ras:Contour", new Expression[]{data, levels});
        fts.setTransformation((Expression)tx);
        fts.getOptions().put("composite-base", "true");
        Style style = this.sb.createStyle();
        style.featureTypeStyles().add(fts);
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        Assert.assertTrue((boolean)this.visitor.hasTransformations());
        Assert.assertTrue((boolean)this.visitor.hasVectorTransformations());
        MatcherAssert.assertThat((Object)((FeatureTypeStyle)copy.featureTypeStyles().get(0)).getTransformation(), (Matcher)CoreMatchers.instanceOf(Function.class));
        Function txCopy = (Function)((FeatureTypeStyle)copy.featureTypeStyles().get(0)).getTransformation();
        Assert.assertEquals((Object)"ras:Contour", (Object)txCopy.getName());
    }

    @Test
    public void testVectorToRasterTransform() {
        FeatureTypeStyle fts = this.sb.createFeatureTypeStyle((Symbolizer)this.sb.createLineSymbolizer());
        Function data = this.ff.function("parameter", new Expression[]{this.ff.literal((Object)"data")});
        Function tx = this.ff.function("vec:Heatmap", new Expression[]{data});
        fts.setTransformation((Expression)tx);
        fts.getOptions().put("composite-base", "true");
        Style style = this.sb.createStyle();
        style.featureTypeStyles().add(fts);
        style.accept((StyleVisitor)this.visitor);
        Style copy = (Style)this.visitor.getCopy();
        Assert.assertTrue((boolean)this.visitor.hasTransformations());
        Assert.assertFalse((boolean)this.visitor.hasVectorTransformations());
        Assert.assertEquals((long)0L, (long)copy.featureTypeStyles().size());
    }
}

