/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_3;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.DimensionPresentation;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.TestResourceAccessManager;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.impl.AbstractUserGroupService;
import org.geoserver.wms.WMSDimensionsTestSupport;
import org.geotools.api.filter.Filter;
import org.junit.After;
import org.junit.Test;
import org.w3c.dom.Document;

public class DimensionsVectorCapabilitiesTest
extends WMSDimensionsTestSupport {
    protected void setUpSpring(List<String> springContextLocations) {
        super.setUpSpring(springContextLocations);
        springContextLocations.add("classpath:/org/geoserver/wms/ResourceAccessManagerContext.xml");
    }

    protected List<javax.servlet.Filter> getFilters() {
        return Collections.singletonList((javax.servlet.Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        testData.addVectorLayer(this.V_TIME_ELEVATION_WITH_START_END, Collections.emptyMap(), "TimeElevationWithStartEnd.properties", WMSDimensionsTestSupport.class, this.getCatalog());
        GeoServerUserGroupStore ugStore = this.getSecurityManager().loadUserGroupService(AbstractUserGroupService.DEFAULT_NAME).createStore();
        ugStore.addUser(ugStore.createUserObject("admin2", "geoserver", true));
        ugStore.store();
    }

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        super.setUpTestData(testData);
        File security = new File(testData.getDataDirectoryRoot(), "security");
        security.mkdir();
        File users = new File(security, "users.properties");
        Properties props = new Properties();
        props.put("admin", "geoserver,ROLE_ADMINISTRATOR");
        props.put("admin2", "ROLE_DUMMY");
        props.store(new FileOutputStream(users), "");
    }

    @After
    public void clearVectorDimensions() {
        FeatureTypeInfo info1 = this.getCatalog().getFeatureTypeByName("TimeElevation");
        info1.getMetadata().values().removeIf(DimensionInfo.class::isInstance);
        this.getCatalog().save((ResourceInfo)info1);
        FeatureTypeInfo info2 = this.getCatalog().getFeatureTypeByName("TimeElevationWithStartEnd");
        info2.getMetadata().values().removeIf(DimensionInfo.class::isInstance);
        this.getCatalog().save((ResourceInfo)info2);
    }

    @Test
    public void testNoDimension() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer[wms:Name='sf:TimeElevation'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
    }

    @Test
    public void testDefaultElevationUnits() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"EPSG:5030", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"m", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
    }

    @Test
    public void testEmptyDataSet() throws Exception {
        for (DimensionPresentation p : DimensionPresentation.values()) {
            this.setupVectorDimension(this.V_TIME_ELEVATION_EMPTY.getLocalPart(), "time", "time", p, null, null, null);
            this.checkEmptyTimeDimensionAndExtent();
        }
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(this.V_TIME_ELEVATION_EMPTY.getLocalPart());
        info.getMetadata().remove((Object)"time");
        this.getCatalog().save((ResourceInfo)info);
        for (DimensionPresentation p : DimensionPresentation.values()) {
            this.setupVectorDimension(this.V_TIME_ELEVATION_EMPTY.getLocalPart(), "elevation", "elevation", p, null, "foot", "ft");
            this.checkEmptyElevationDimensionAndExtent();
        }
    }

    void checkEmptyElevationDimensionAndExtent() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    void checkEmptyTimeDimensionAndExtent() throws Exception {
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testElevationList() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0,1.0,2.0,3.0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testElevationContinuous() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.CONTINUOUS_INTERVAL, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0/3.0/0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testElevationContinuousWithEnd() throws Exception {
        this.setupVectorDimensionWithEnd("elevation", "startElevation", "endElevation", DimensionPresentation.CONTINUOUS_INTERVAL, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1.0/3.0/0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testElevationDiscrerteNoResolution() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.DISCRETE_INTERVAL, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0/3.0/1.0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testElevationDiscrerteManualResolution() throws Exception {
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.DISCRETE_INTERVAL, 2.0, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0/3.0/2.0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testElevationDiscreteManualResolutionWithEnd() throws Exception {
        this.setupVectorDimensionWithEnd("elevation", "startElevation", "endElevation", DimensionPresentation.DISCRETE_INTERVAL, 2.0, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1.0/3.0/2.0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testTimeList() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"", (String)"//wms:Layer/wms:Dimension/@nearestValue", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2011-05-01T00:00:00.000Z,2011-05-02T00:00:00.000Z,2011-05-03T00:00:00.000Z,2011-05-04T00:00:00.000Z", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testNearestMatch() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        this.setupNearestMatch(this.V_TIME_ELEVATION, "time", true);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wms:Layer/wms:Dimension/@nearestValue", (Document)dom);
    }

    @Test
    public void testTimeContinuous() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.CONTINUOUS_INTERVAL, null, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2011-05-01T00:00:00.000Z/2011-05-04T00:00:00.000Z/PT1S", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testTimeContinuousWithEnd() throws Exception {
        this.setupVectorDimensionWithEnd("time", "startTime", "endTime", DimensionPresentation.CONTINUOUS_INTERVAL, null, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2012-02-11T00:00:00.000Z/2012-02-14T00:00:00.000Z/PT1S", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testTimeResolution() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.DISCRETE_INTERVAL, 8.64E7, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2011-05-01T00:00:00.000Z/2011-05-04T00:00:00.000Z/P1D", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testTimeResolutionWithEnd() throws Exception {
        this.setupVectorDimensionWithEnd("time", "startTime", "endTime", DimensionPresentation.DISCRETE_INTERVAL, 8.64E7, null, null);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2012-02-11T00:00:00.000Z/2012-02-14T00:00:00.000Z/P1D", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testTimeElevation() throws Exception {
        this.setupVectorDimension("time", "time", DimensionPresentation.LIST, null, null, null);
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"2", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension[@name='elevation']/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension[@name='elevation']/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ISO8601", (String)"//wms:Layer/wms:Dimension[@name='time']/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension[@name='elevation'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wms:Layer/wms:Dimension[@name='elevation']/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0,1.0,2.0,3.0", (String)"//wms:Layer/wms:Dimension[@name='elevation']", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension[@name='time'])", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)DimensionDefaultValueSetting.TIME_CURRENT, (String)"//wms:Layer/wms:Dimension[@name='time']/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2011-05-01T00:00:00.000Z,2011-05-02T00:00:00.000Z,2011-05-03T00:00:00.000Z,2011-05-04T00:00:00.000Z", (String)"//wms:Layer/wms:Dimension[@name='time']", (Document)dom);
    }

    @Test
    public void testDefaultTimeRangeFixed() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("P1M/PRESENT");
        this.setupResourceDimensionDefaultValue(this.V_TIME_ELEVATION, "time", defaultValueSetting, new String[0]);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"P1M/PRESENT", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
    }

    @Test
    public void testDefaultElevationRangeFixed() throws Exception {
        DimensionDefaultValueSetting defaultValueSetting = new DimensionDefaultValueSetting();
        defaultValueSetting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        defaultValueSetting.setReferenceValue("-100/0");
        this.setupResourceDimensionDefaultValue(this.V_TIME_ELEVATION, "elevation", defaultValueSetting, new String[0]);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-100/0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
    }

    @Test
    public void testCustomList() throws Exception {
        this.setupVectorDimension("dim_custom", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName("TimeElevation");
        DimensionInfo dimInfo = (DimensionInfo)info.getMetadata().get((Object)"dim_custom");
        DimensionDefaultValueSetting setting = new DimensionDefaultValueSetting();
        setting.setReferenceValue("2.0");
        setting.setStrategyType(DimensionDefaultValueSetting.Strategy.FIXED);
        dimInfo.setDefaultValue(setting);
        this.getCatalog().save((ResourceInfo)info);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"custom", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0,1.0,2.0,3.0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testCustomContinuous() throws Exception {
        this.setupVectorDimension("dim_custom", "elevation", DimensionPresentation.CONTINUOUS_INTERVAL, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"custom", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"custom", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0/3.0/0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testCustomContinuousWithEnd() throws Exception {
        this.setupVectorDimensionWithEnd("dim_custom", "startElevation", "endElevation", DimensionPresentation.CONTINUOUS_INTERVAL, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"custom", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"custom", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1.0/3.0/0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testCustomDiscreteInterval() throws Exception {
        this.setupVectorDimension("dim_custom", "lwidth", DimensionPresentation.DISCRETE_INTERVAL, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        this.print(dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"custom", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"custom", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1/4/1", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testCustomDiscreteIntervalWithEnd() throws Exception {
        this.setupVectorDimensionWithEnd("dim_custom", "startElevation", "endElevation", DimensionPresentation.DISCRETE_INTERVAL, 1.0, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"custom", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"custom", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"1.0/3.0/1.0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testCustomContinuousDate() throws Exception {
        this.setupVectorDimension("dim_custom", "time", DimensionPresentation.LIST, null, "foot", "ft");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"2011-05-01T00:00:00Z", (String)"//wms:Layer[wms:Name/text() = \"sf:TimeElevation\"]/wms:Dimension/@default", (Document)dom);
        this.print(dom);
    }

    @Test
    public void testElevationListChallenge() throws Exception {
        Catalog catalog = this.getCatalog();
        TestResourceAccessManager tam = this.getResourceAccessManager();
        this.setupVectorDimension("elevation", "elevation", DimensionPresentation.LIST, null, "foot", "ft");
        FeatureTypeInfo featureTypeInfo = catalog.getFeatureTypeByName("sf:TimeElevation");
        tam.putLimits("admin2", (CatalogInfo)featureTypeInfo, (AccessLimits)new VectorAccessLimits(CatalogMode.CHALLENGE, null, (Filter)Filter.EXCLUDE, null, (Filter)Filter.EXCLUDE));
        this.setRequestAuth("admin2", "geoserver");
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0", (String)"//wms:Layer/wms:Dimension/@default", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"0.0,1.0,2.0,3.0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testStaticTimeRange() throws Exception {
        String startValue = "2014-01-24T13:25:00.000Z";
        String endValue = "2021";
        this.setupVectorDimension("time", "time", DimensionPresentation.DISCRETE_INTERVAL, 4.32E7, null, null);
        this.setupVectorStartAndEndValues(this.V_TIME_ELEVATION, "time", startValue, endValue);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2014-01-24T13:25:00.000Z/2021-01-01T00:00:00.000Z/PT12H", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testStaticTimeRangeContinuous() throws Exception {
        String startValue = "2014-01-24T13:25:00.000Z";
        String endValue = "2021";
        this.setupVectorDimension("time", "time", DimensionPresentation.CONTINUOUS_INTERVAL, null, null, null);
        this.setupVectorStartAndEndValues(this.V_TIME_ELEVATION, "time", startValue, endValue);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"time", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2014-01-24T13:25:00.000Z/2021-01-01T00:00:00.000Z/PT1S", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testStaticElevationRange() throws Exception {
        String startValue = "-11034.0";
        String endValue = "8848.86";
        this.setupVectorDimension("elevation", "time", DimensionPresentation.DISCRETE_INTERVAL, 1.0, null, null);
        this.setupVectorStartAndEndValues(this.V_TIME_ELEVATION, "elevation", startValue, endValue);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-11034.0/8848.86/1.0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testStaticElevationRangeContinuous() throws Exception {
        String startValue = "-11034.0";
        String endValue = "8848.86";
        this.setupVectorDimension("elevation", "time", DimensionPresentation.CONTINUOUS_INTERVAL, null, null, null);
        this.setupVectorStartAndEndValues(this.V_TIME_ELEVATION, "elevation", startValue, endValue);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"elevation", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-11034.0/8848.86/0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testStaticCustomRange() throws Exception {
        String startValue = "-3";
        String endValue = "8848.86";
        this.setupVectorDimension("dim_custom", "custom", DimensionPresentation.DISCRETE_INTERVAL, 1.0, "foot", "ft");
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName("TimeElevation");
        ((DimensionInfo)info.getMetadata().get("dim_custom", DimensionInfo.class)).setStartValue(startValue);
        ((DimensionInfo)info.getMetadata().get("dim_custom", DimensionInfo.class)).setEndValue(endValue);
        this.getCatalog().save((ResourceInfo)info);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"custom", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"-3.0/8848.86/1.0", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    @Test
    public void testStaticCustomDateRange() throws Exception {
        String startValue = "2021-01";
        String endValue = "2022-04-05T01:20:00Z";
        this.setupVectorDimension("dim_custom", "custom", DimensionPresentation.DISCRETE_INTERVAL, 8.64E7, "foot", "ft");
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName("TimeElevation");
        ((DimensionInfo)info.getMetadata().get("dim_custom", DimensionInfo.class)).setStartValue(startValue);
        ((DimensionInfo)info.getMetadata().get("dim_custom", DimensionInfo.class)).setEndValue(endValue);
        this.getCatalog().save((ResourceInfo)info);
        Document dom = this.dom(this.get("wms?request=getCapabilities&version=1.3.0"), false);
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wms:Layer/wms:Dimension)", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"custom", (String)"//wms:Layer/wms:Dimension/@name", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"foot", (String)"//wms:Layer/wms:Dimension/@units", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"ft", (String)"//wms:Layer/wms:Dimension/@unitSymbol", (Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"2021-01-01T00:00:00.000Z/2022-04-05T01:20:00.000Z/P1D", (String)"//wms:Layer/wms:Dimension", (Document)dom);
    }

    protected TestResourceAccessManager getResourceAccessManager() {
        return (TestResourceAccessManager)applicationContext.getBean("testResourceAccessManager");
    }
}

