/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

public class MapProducerCapabilities {
    private final boolean tiledRequestsSupported;
    private final boolean paletteSupported;
    private final boolean transparencySupported;

    public MapProducerCapabilities(boolean tiledRequestsSupported, boolean paletteSupported, boolean transparencySupported) {
        this.tiledRequestsSupported = tiledRequestsSupported;
        this.paletteSupported = paletteSupported;
        this.transparencySupported = transparencySupported;
    }

    public boolean isTiledRequestsSupported() {
        return this.tiledRequestsSupported;
    }

    public boolean isPaletteSupported() {
        return this.paletteSupported;
    }

    public boolean isTransparencySupported() {
        return this.transparencySupported;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.paletteSupported ? 1231 : 1237);
        result = 31 * result + (this.tiledRequestsSupported ? 1231 : 1237);
        result = 31 * result + (this.transparencySupported ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapProducerCapabilities)) {
            return false;
        }
        MapProducerCapabilities other = (MapProducerCapabilities)obj;
        if (this.paletteSupported != other.paletteSupported) {
            return false;
        }
        if (this.tiledRequestsSupported != other.tiledRequestsSupported) {
            return false;
        }
        return this.transparencySupported == other.transparencySupported;
    }

    public String toString() {
        return "MapProducerCapabilities [framesMimeType=" + this.paletteSupported + ", tiledRequestsSupported=" + this.tiledRequestsSupported + ", transparencySupported=" + this.transparencySupported + "]";
    }
}

