/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.dimension;

import java.util.Date;
import org.geoserver.catalog.DimensionDefaultValueSetting;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.wms.dimension.DimensionDefaultValueSelectionStrategy;
import org.geotools.feature.type.DateUtil;

public abstract class AbstractDefaultValueSelectionStrategy
implements DimensionDefaultValueSelectionStrategy {
    @Override
    public String getCapabilitiesRepresentation(ResourceInfo resource, String dimensionName, DimensionInfo dimensionInfo) {
        String retval = null;
        if (dimensionName.equals("time")) {
            Date dateValue = (Date)this.getDefaultValue(resource, dimensionName, dimensionInfo, Date.class);
            if (dateValue == null) {
                return DimensionDefaultValueSetting.TIME_CURRENT;
            }
            retval = DateUtil.serializeDateTime((long)dateValue.getTime(), (boolean)true);
        } else if (dimensionName.equals("elevation")) {
            Number numberValue = (Number)this.getDefaultValue(resource, dimensionName, dimensionInfo, Number.class);
            if (numberValue == null) {
                return "0";
            }
            retval = numberValue.toString();
        } else {
            Object value = this.getDefaultValue(resource, dimensionName, dimensionInfo, Object.class);
            retval = this.stringRepresentation(value);
        }
        return retval;
    }

    private String stringRepresentation(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Date) {
            Date dateValue = (Date)value;
            return DateUtil.serializeDateTime((long)dateValue.getTime(), (boolean)true);
        }
        return value.toString();
    }
}

