/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.featureinfo;

import java.util.List;
import org.geoserver.wms.FeatureInfoRequestParameters;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;

public interface LayerIdentifier<T> {
    public boolean canHandle(MapLayerInfo var1);

    public List<FeatureCollection> identify(FeatureInfoRequestParameters var1, int var2) throws Exception;

    public T handleClipParam(FeatureInfoRequestParameters var1, T var2);

    public static ReferencedEnvelope getEnvelopeFilter(FeatureInfoRequestParameters params, double radius) {
        int x = params.getX();
        int y = params.getY();
        ReferencedEnvelope bbox = params.getRequestedBounds();
        int width = params.getWidth();
        int height = params.getHeight();
        Coordinate upperLeft = WMS.pixelToWorld((double)x - radius, (double)y - radius, bbox, width, height);
        Coordinate lowerRight = WMS.pixelToWorld((double)x + radius, (double)y + radius, bbox, width, height);
        return new ReferencedEnvelope(upperLeft.x, lowerRight.x, lowerRight.y, upperLeft.y, bbox.getCoordinateReferenceSystem());
    }
}

