/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.Point;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.ServiceException;
import org.geoserver.platform.resource.Resource;
import org.geoserver.wms.GetMapOutputFormat;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WatermarkInfo;
import org.geoserver.wms.decoration.MapDecorationLayout;
import org.geoserver.wms.decoration.MetatiledMapDecorationLayout;
import org.geoserver.wms.decoration.WatermarkDecoration;
import org.geotools.api.filter.expression.Expression;
import org.geotools.util.logging.Logging;
import org.springframework.util.Assert;

public abstract class AbstractMapOutputFormat
implements GetMapOutputFormat {
    public static final Logger LOGGER = Logging.getLogger(GetMapOutputFormat.class);
    private final String mime;
    private final Set<String> outputFormatNames;
    protected WMS wms;

    protected AbstractMapOutputFormat(String mime) {
        this(mime, mime);
    }

    protected AbstractMapOutputFormat(String mime, String ... outputFormats) {
        this(mime, (Set<String>)(outputFormats == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(outputFormats))));
    }

    protected AbstractMapOutputFormat(String mime, Set<String> outputFormats) {
        Assert.notNull((Object)mime, (String)"mime");
        this.mime = mime;
        if (outputFormats == null) {
            outputFormats = Collections.emptySet();
        }
        Set<String> formats = AbstractMapOutputFormat.caseInsensitiveOutputFormats(outputFormats);
        formats.add(mime);
        this.outputFormatNames = Collections.unmodifiableSet(formats);
    }

    private static Set<String> caseInsensitiveOutputFormats(Set<String> outputFormats) {
        TreeSet<String> caseInsensitiveFormats = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitiveFormats.addAll(outputFormats);
        return caseInsensitiveFormats;
    }

    protected AbstractMapOutputFormat() {
        this(null, (String[])null);
    }

    @Override
    public String getMimeType() {
        return this.mime;
    }

    @Override
    public Set<String> getOutputFormatNames() {
        return this.outputFormatNames;
    }

    protected MapDecorationLayout findDecorationLayout(GetMapRequest request, boolean tiled) {
        MapDecorationLayout.Block watermark;
        if (this.wms == null) {
            throw new IllegalAccessError();
        }
        String layoutName = null;
        if (request.getFormatOptions() != null) {
            layoutName = (String)request.getFormatOptions().get("layout");
        }
        MapDecorationLayout layout = null;
        if (layoutName != null && !layoutName.trim().isEmpty()) {
            try {
                GeoServerResourceLoader loader = this.wms.getCatalog().getResourceLoader();
                Resource layouts = loader.get("layouts");
                if (layouts.getType() == Resource.Type.DIRECTORY) {
                    Resource layoutConfig = layouts.get(layoutName + ".xml");
                    if (layoutConfig.getType() == Resource.Type.RESOURCE) {
                        layout = MapDecorationLayout.fromFile(layoutConfig, tiled);
                    } else {
                        LOGGER.log(Level.WARNING, "Unknown layout requested: " + layoutName);
                    }
                } else {
                    LOGGER.log(Level.WARNING, "No layouts directory defined");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Unable to load layout: " + layoutName, e);
            }
            if (layout == null) {
                throw new ServiceException("Could not find decoration layout named: " + layoutName);
            }
        }
        if (layout == null) {
            MapDecorationLayout mapDecorationLayout = layout = tiled ? new MetatiledMapDecorationLayout() : new MapDecorationLayout();
        }
        if ((watermark = AbstractMapOutputFormat.getWatermark(this.wms.getServiceInfo())) != null) {
            layout.addBlock(watermark);
        }
        return layout;
    }

    public static MapDecorationLayout.Block getWatermark(WMSInfo wms) {
        WatermarkInfo watermark;
        WatermarkInfo watermarkInfo = watermark = wms == null ? null : wms.getWatermark();
        if (watermark != null && watermark.isEnabled()) {
            HashMap<String, Expression> options = new HashMap<String, Expression>();
            options.put("url", (Expression)MapDecorationLayout.FF.literal((Object)watermark.getURL()));
            options.put("opacity", (Expression)MapDecorationLayout.FF.literal((255.0f - (float)watermark.getTransparency()) / 2.55f));
            WatermarkDecoration d = new WatermarkDecoration();
            try {
                d.loadOptions(options);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Couldn't construct watermark from configuration", e);
                throw new ServiceException((Throwable)e);
            }
            MapDecorationLayout.Block.Position p = null;
            switch (watermark.getPosition()) {
                case TOP_LEFT: {
                    p = MapDecorationLayout.Block.Position.UL;
                    break;
                }
                case TOP_CENTER: {
                    p = MapDecorationLayout.Block.Position.UC;
                    break;
                }
                case TOP_RIGHT: {
                    p = MapDecorationLayout.Block.Position.UR;
                    break;
                }
                case MID_LEFT: {
                    p = MapDecorationLayout.Block.Position.CL;
                    break;
                }
                case MID_CENTER: {
                    p = MapDecorationLayout.Block.Position.CC;
                    break;
                }
                case MID_RIGHT: {
                    p = MapDecorationLayout.Block.Position.CR;
                    break;
                }
                case BOT_LEFT: {
                    p = MapDecorationLayout.Block.Position.LL;
                    break;
                }
                case BOT_CENTER: {
                    p = MapDecorationLayout.Block.Position.LC;
                    break;
                }
                case BOT_RIGHT: {
                    p = MapDecorationLayout.Block.Position.LR;
                    break;
                }
                default: {
                    throw new ServiceException("Unknown WatermarkInfo.Position value.  Something is seriously wrong.");
                }
            }
            return new MapDecorationLayout.Block(d, p, null, new Point(0, 0));
        }
        return null;
    }
}

