/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import it.geosolutions.jaiext.lookup.LookupTable;
import it.geosolutions.jaiext.lookup.LookupTableFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterFactory;
import javax.media.jai.operator.ConstantDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSMapContent;
import org.geoserver.wms.map.RasterSymbolizerVisitor;
import org.geoserver.wms.map.RenderedImageMapOutputFormat;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.data.Query;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.SrsSyntax;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ColorUtilities;
import org.geotools.map.Layer;
import org.geotools.parameter.Parameter;
import org.geotools.process.Processors;
import org.geotools.process.function.ProcessFunction;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.RenderingTransformationHelper;
import org.geotools.renderer.lite.gridcoverage2d.ChannelSelectionUpdateStyleVisitor;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;

class DirectRasterRenderer {
    static final Logger LOGGER = Logging.getLogger(DirectRasterRenderer.class);
    private static final int MAX_TILE_SIZE = 1024;
    public static final String DISABLE_GUTTER_KEY = "wms.raster.disableGutter";
    private static Boolean DISABLE_GUTTER = Boolean.getBoolean("wms.raster.disableGutter");
    public static final String RASTER_CHAIN_DEBUG_KEY = "wms.raster.enableRasterChainDebug";
    private static Boolean RASTER_CHAIN_DEBUG = Boolean.getBoolean("wms.raster.enableRasterChainDebug");
    private final int mapWidth;
    private final int mapHeight;
    private final Layer layer;
    private final WMSMapContent mapContent;
    private final int layerIndex;
    private final Interpolation layerInterpolation;
    private final WMS wms;
    private Expression transformation;
    private final ReferencedEnvelope mapEnvelope;
    private final Rectangle mapRasterArea;
    private final AffineTransform worldToScreen;
    private final Color bgColor;
    private final boolean transparent;
    private final Interpolation interpolation;
    private int tileSizeX;
    private int tileSizeY;
    private final int[] bandIndices;
    private RasterSymbolizer symbolizer;

    public DirectRasterRenderer(WMS wms, WMSMapContent mapContent, int layerIndex, Interpolation layerInterpolation, boolean transparencySupported) throws FactoryException {
        this.wms = wms;
        this.mapContent = mapContent;
        this.layerIndex = layerIndex;
        this.layerInterpolation = layerInterpolation;
        double scaleDenominator = mapContent.getScaleDenominator(true);
        this.layer = (Layer)mapContent.layers().get(layerIndex);
        FeatureType featureType = this.layer.getFeatureSource().getSchema();
        Style style = this.layer.getStyle();
        RasterSymbolizerVisitor visitor = new RasterSymbolizerVisitor(scaleDenominator, featureType);
        style.accept((StyleVisitor)visitor);
        List<RasterSymbolizer> symbolizers = visitor.getRasterSymbolizers();
        if (symbolizers.size() == 1) {
            this.symbolizer = symbolizers.get(0);
            this.transformation = visitor.getRasterRenderingTransformation();
        }
        this.mapWidth = mapContent.getMapWidth();
        this.mapHeight = mapContent.getMapHeight();
        this.mapEnvelope = this.getEastNorthEnvelope(mapContent.getRenderingArea());
        this.mapRasterArea = new Rectangle(0, 0, this.mapWidth, this.mapHeight);
        this.worldToScreen = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)this.mapEnvelope, (Rectangle)this.mapRasterArea);
        this.transparent = mapContent.isTransparent() && transparencySupported;
        this.bgColor = this.getBackgroundColor(this.transparent);
        this.interpolation = this.getInterpolation();
        this.tileSizeX = -1;
        this.tileSizeY = -1;
        if (mapContent.getTileSize() != -1) {
            this.tileSizeX = this.tileSizeY = mapContent.getTileSize();
        } else if (this.mapWidth < 1024 && this.mapHeight < 1024) {
            this.tileSizeX = this.mapWidth;
            this.tileSizeY = this.mapHeight;
        }
        this.bandIndices = (int[])(this.transformation == null && this.symbolizer != null ? ChannelSelectionUpdateStyleVisitor.getBandIndicesFromSelectionChannels((RasterSymbolizer)this.symbolizer) : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RenderedImage render() throws FactoryException {
        if (this.symbolizer == null) {
            return null;
        }
        if (DirectRasterRenderer.isVectorSource(this.transformation)) {
            return null;
        }
        ReadingContext context = new ReadingContext();
        RenderedImage image = null;
        GridCoverage2D coverage = null;
        RenderingHints interpolationHints = new RenderingHints(JAI.KEY_INTERPOLATION, this.interpolation);
        try {
            boolean advancedProjectionHandling;
            Color readerBgColor = this.transparent ? null : this.bgColor;
            CoordinateReferenceSystem mapCRS = this.mapEnvelope.getCoordinateReferenceSystem();
            boolean bl = advancedProjectionHandling = this.wms.isAdvancedProjectionHandlingEnabled() && RenderedImageMapOutputFormat.getFormatOptionAsBoolean(this.mapContent.getRequest(), "advancedProjectionHandling");
            if (this.transformation == null && advancedProjectionHandling) {
                image = this.readWithProjectionHandling(interpolationHints, readerBgColor, mapCRS);
            } else {
                CoordinateReferenceSystem coverageCRS = this.layer.getFeatureSource().getSchema().getCoordinateReferenceSystem();
                GridGeometry2D readGG = this.getReadGeometry(mapCRS, coverageCRS);
                if (this.transformation != null) {
                    Object result = this.readAndTransform(interpolationHints, coverageCRS, readGG);
                    if (result == null) {
                        coverage = null;
                    } else {
                        if (!(result instanceof GridCoverage2D)) return null;
                        coverage = (GridCoverage2D)result;
                        this.symbolizer = this.updateSymbolizerForBandSelection(context, this.symbolizer, this.bandIndices);
                    }
                } else {
                    coverage = this.readCoverage(context, readerBgColor, readGG);
                }
                if (coverage == null) {
                    image = DirectRasterRenderer.createBkgImage(this.mapWidth, this.mapHeight, this.bgColor, null);
                }
                if (image == null) {
                    GridCoverageRenderer gcr = new GridCoverageRenderer(mapCRS, (Envelope)ReferencedEnvelope.reference((Bounds)readGG.getEnvelope()), (Rectangle)readGG.getGridRange2D(), this.worldToScreen, interpolationHints);
                    gcr.setAdvancedProjectionHandlingEnabled(false);
                    image = gcr.renderImage(coverage, this.symbolizer, this.interpolation, null, this.tileSizeX, this.tileSizeY);
                }
            }
        }
        catch (Throwable e) {
            throw new ServiceException(e);
        }
        if (image == null) {
            return null;
        }
        Rectangle imageBounds = PlanarImage.wrapRenderedImage((RenderedImage)image).getBounds();
        Rectangle intersection = imageBounds.intersection(this.mapRasterArea);
        if (intersection.isEmpty()) {
            return null;
        }
        ImageLayout layout = new ImageLayout();
        layout.setMinX(0);
        layout.setMinY(0);
        layout.setWidth(this.mapWidth);
        layout.setHeight(this.mapHeight);
        if (this.tileSizeX > 0 && this.tileSizeY > 0) {
            layout.setTileGridXOffset(0);
            layout.setTileGridYOffset(0);
            layout.setTileWidth(this.tileSizeX);
            layout.setTileHeight(this.tileSizeY);
        }
        ColorModel cm = image.getColorModel();
        double[] bgValues = null;
        PlanarImage[] alphaChannels = null;
        int transparencyType = cm.getTransparency();
        if (cm instanceof IndexColorModel) {
            int bgColorIndex;
            ImageWorker worker = new ImageWorker(image);
            IndexColorModel icm = (IndexColorModel)cm;
            if (this.transparent) {
                bgColorIndex = icm.getTransparentPixel();
            } else if (icm.hasAlpha() && icm.isAlphaPremultiplied()) {
                bgColorIndex = -1;
            } else {
                if (icm.getTransparency() != 1) {
                    icm = ColorUtilities.applyBackgroundColor((IndexColorModel)icm, (Color)this.bgColor);
                    cm = icm;
                    ImageLayout ilColorModel = new ImageLayout(image);
                    ilColorModel.setColorModel((ColorModel)icm);
                    RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, ilColorModel);
                    worker.setRenderingHints(hints);
                    worker.format(image.getSampleModel().getDataType());
                    image = worker.getRenderedImage();
                }
                bgColorIndex = ColorUtilities.findColorIndex((Color)this.bgColor, (IndexColorModel)icm);
            }
            if (bgColorIndex == -1) {
                bgValues = new double[]{this.bgColor.getRed(), this.bgColor.getGreen(), this.bgColor.getBlue(), this.transparent ? 0.0 : 255.0};
                worker.setBackground(bgValues);
                image = worker.forceComponentColorModel().getRenderedImage();
                if (this.transparent && !image.getColorModel().hasAlpha()) {
                    image = this.addAlphaChannel(image);
                    worker.setImage(image);
                    transparencyType = image.getColorModel().getTransparency();
                }
                cm = image.getColorModel();
            } else {
                bgValues = new double[]{bgColorIndex};
            }
            if (cm.hasAlpha() && bgColorIndex == -1) {
                worker.forceComponentColorModel();
                RenderedImage alpha = worker.retainLastBand().getRenderedImage();
                alphaChannels = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)alpha)};
            }
        }
        boolean noDataTransparencyApplied = false;
        if (cm instanceof ComponentColorModel) {
            RenderedImage alpha;
            ImageWorker iw;
            ComponentColorModel ccm = (ComponentColorModel)cm;
            boolean hasAlpha = cm.hasAlpha();
            if (ccm.getNumColorComponents() == 1) {
                if (!DirectRasterRenderer.isLevelOfGray(this.bgColor) && !this.transparent || ccm.getTransferType() == 5 || ccm.getTransferType() == 4 || ccm.getTransferType() == 32) {
                    iw = new ImageWorker(image);
                    if (hasAlpha) {
                        alpha = iw.retainLastBand().getRenderedImage();
                        RenderedImage gray = new ImageWorker(image).retainFirstBand().getRenderedImage();
                        image = new ImageWorker(gray).bandMerge(3).addBand(alpha, false).forceComponentColorModel().forceColorSpaceRGB().getRenderedImage();
                    } else {
                        image = iw.bandMerge(3).forceComponentColorModel().forceColorSpaceRGB().getRenderedImage();
                    }
                } else if (!hasAlpha) {
                    if (this.transparent) {
                        RenderedImage transparentImage = this.grayNoDataTransparent(image);
                        if (transparentImage == null) {
                            image = this.addAlphaChannel(image);
                            bgValues = new double[]{this.mapToGrayColor(this.bgColor, ccm), 0.0};
                        } else {
                            image = transparentImage;
                            noDataTransparencyApplied = true;
                        }
                    } else {
                        bgValues = new double[]{this.mapToGrayColor(this.bgColor, ccm)};
                    }
                } else {
                    iw = new ImageWorker(image);
                    alpha = iw.retainLastBand().getRenderedImage();
                    alphaChannels = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)alpha)};
                    bgValues = this.transparent ? new double[]{this.mapToGrayColor(this.bgColor, ccm), 0.0} : new double[]{this.mapToGrayColor(this.bgColor, ccm), 255.0};
                }
                cm = image.getColorModel();
                hasAlpha = cm.hasAlpha();
            }
            if (bgValues == null && !noDataTransparencyApplied) {
                if (hasAlpha) {
                    iw = new ImageWorker(image);
                    alpha = iw.retainLastBand().getRenderedImage();
                    alphaChannels = new PlanarImage[]{PlanarImage.wrapRenderedImage((RenderedImage)alpha)};
                    bgValues = this.transparent ? new double[]{this.bgColor.getRed(), this.bgColor.getGreen(), this.bgColor.getBlue(), 0.0} : new double[]{this.bgColor.getRed(), this.bgColor.getGreen(), this.bgColor.getBlue(), 255.0};
                } else if (this.transparent) {
                    RenderedImage imageTransparent = this.rgbNoDataTransparent(image);
                    if (imageTransparent != null) {
                        image = imageTransparent;
                        noDataTransparencyApplied = true;
                    } else {
                        image = this.addAlphaChannel(image);
                        bgValues = new double[]{0.0, 0.0, 0.0, 0.0};
                    }
                } else {
                    bgValues = new double[]{this.bgColor.getRed(), this.bgColor.getGreen(), this.bgColor.getBlue()};
                }
            }
        }
        ImageWorker iw = new ImageWorker(image);
        Object roiCandidate = image.getProperty("ROI");
        if (!imageBounds.contains(this.mapRasterArea) && !imageBounds.equals(this.mapRasterArea) || transparencyType != 1 || iw.getNoData() != null || roiCandidate instanceof ROI) {
            image = this.applyBackgroundTransparency(this.mapRasterArea, image, intersection, layout, bgValues, alphaChannels, transparencyType, iw, roiCandidate, noDataTransparencyApplied);
        } else if (imageBounds.contains(this.mapRasterArea) && !imageBounds.equals(this.mapRasterArea)) {
            iw.setBackground(bgValues);
            iw.crop(0.0f, 0.0f, (float)this.mapWidth, (float)this.mapHeight);
            image = iw.getRenderedImage();
        }
        if (LOGGER.isLoggable(Level.FINE) && image != null) {
            LOGGER.log(Level.FINE, "Direct rendering path produced the following image chain:\n" + RenderedImageBrowser.dumpChain((RenderedImage)image));
        }
        Map<String, String> rawKvp = null;
        if (!RASTER_CHAIN_DEBUG.booleanValue() || (rawKvp = this.mapContent.getRequest().getRawKvp()) == null || !Boolean.valueOf(rawKvp.get("showchain")).booleanValue()) return image;
        RenderedImageBrowser.showChainAndWaitOnClose((RenderedImage)image);
        return image;
    }

    private GridCoverage2D readCoverage(ReadingContext context, Color readerBgColor, GridGeometry2D readGG) throws IOException {
        Feature feature = ((Layer)this.mapContent.layers().get(0)).getFeatureSource().getFeatures().features().next();
        GridCoverage2DReader reader = (GridCoverage2DReader)feature.getProperty("grid").getValue();
        Object params = feature.getProperty("params").getValue();
        context.reader = reader;
        context.params = params;
        GridCoverage2D coverage = DirectRasterRenderer.readBestCoverage(context, ReferencedEnvelope.reference((Bounds)readGG.getEnvelope()), (Rectangle)readGG.getGridRange2D(), this.interpolation, readerBgColor, this.bandIndices);
        this.symbolizer = this.updateSymbolizerForBandSelection(context, this.symbolizer, this.bandIndices);
        return coverage;
    }

    private Object readAndTransform(RenderingHints interpolationHints, CoordinateReferenceSystem coverageCRS, GridGeometry2D readGG) throws IOException, SchemaException, TransformException, FactoryException {
        boolean advancedProjectionHandling = this.wms.isAdvancedProjectionHandlingEnabled() && RenderedImageMapOutputFormat.getFormatOptionAsBoolean(this.mapContent.getRequest(), "advancedProjectionHandling");
        boolean continuousMapWrapping = this.wms.isContinuousMapWrappingEnabled() && RenderedImageMapOutputFormat.getFormatOptionAsBoolean(this.mapContent.getRequest(), "mapWrapping");
        GCRRenderingTransformationHelper helper = new GCRRenderingTransformationHelper(this.mapContent, this.interpolation, advancedProjectionHandling, continuousMapWrapping);
        Object result = helper.applyRenderingTransformation(this.transformation, this.layer.getFeatureSource(), this.layer.getQuery(), Query.ALL, readGG, coverageCRS, interpolationHints);
        return result;
    }

    private GridGeometry2D getReadGeometry(CoordinateReferenceSystem mapCRS, CoordinateReferenceSystem coverageCRS) throws IOException {
        GridGeometry2D readGG;
        boolean useGutter;
        boolean bl = useGutter = DISABLE_GUTTER == false;
        if (useGutter) {
            boolean sameCRS;
            boolean equalsMetadata = CRS.equalsIgnoreMetadata((Object)mapCRS, (Object)coverageCRS);
            try {
                sameCRS = equalsMetadata || CRS.findMathTransform((CoordinateReferenceSystem)mapCRS, (CoordinateReferenceSystem)coverageCRS, (boolean)true).isIdentity();
            }
            catch (FactoryException e1) {
                IOException ioe = new IOException();
                ioe.initCause(e1);
                throw ioe;
            }
            boolean bl2 = useGutter = !sameCRS || !(this.interpolation instanceof InterpolationNearest);
        }
        if (!useGutter) {
            readGG = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(this.mapRasterArea), (Bounds)this.mapEnvelope);
        } else {
            Rectangle bufferedTargetArea = (Rectangle)this.mapRasterArea.clone();
            bufferedTargetArea.add(this.mapRasterArea.x + this.mapRasterArea.width + 10, this.mapRasterArea.y + this.mapRasterArea.height + 10);
            bufferedTargetArea.add(this.mapRasterArea.x - 10, this.mapRasterArea.y - 10);
            try {
                readGG = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(bufferedTargetArea), PixelInCell.CELL_CORNER, (MathTransform)new AffineTransform2D(this.worldToScreen.createInverse()), mapCRS, null);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return readGG;
    }

    private RenderedImage readWithProjectionHandling(RenderingHints interpolationHints, Color readerBgColor, CoordinateReferenceSystem mapCRS) throws IOException, TransformException, NoninvertibleTransformException, FactoryException {
        Feature feature = DataUtilities.first((FeatureCollection)((Layer)this.mapContent.layers().get(0)).getFeatureSource().getFeatures());
        if (feature == null || feature.getProperty("grid") == null) {
            return null;
        }
        GridCoverage2DReader reader = (GridCoverage2DReader)feature.getProperty("grid").getValue();
        Object params = feature.getProperty("params").getValue();
        GeneralParameterValue[] readParameters = DirectRasterRenderer.getReadParameters(params, null, null, this.interpolation, readerBgColor, this.bandIndices);
        GridCoverageRenderer gcr = new GridCoverageRenderer(mapCRS, (Envelope)this.mapEnvelope, this.mapRasterArea, this.worldToScreen, interpolationHints);
        gcr.setAdvancedProjectionHandlingEnabled(true);
        boolean continuousMapWrappingEnabled = this.wms.isContinuousMapWrappingEnabled() && RenderedImageMapOutputFormat.getFormatOptionAsBoolean(this.mapContent.getRequest(), "mapWrapping");
        gcr.setWrapEnabled(continuousMapWrappingEnabled);
        RenderedImage image = gcr.renderImage(reader, readParameters, this.symbolizer, this.interpolation, null, this.tileSizeX, this.tileSizeY);
        if (image == null) {
            image = DirectRasterRenderer.createBkgImage(this.mapWidth, this.mapHeight, this.bgColor, null);
        }
        return image;
    }

    private Interpolation getInterpolation() {
        Interpolation interpolation;
        if (this.layerInterpolation != null) {
            interpolation = this.layerInterpolation;
        } else {
            LayerInfo.WMSInterpolation byLayerInterpolation = null;
            if (this.mapContent.getRequest().getLayers().size() > this.layerIndex) {
                LayerInfo layerInfo = this.mapContent.getRequest().getLayers().get(this.layerIndex).getLayerInfo();
                byLayerInterpolation = RenderedImageMapOutputFormat.getConfiguredLayerInterpolation(layerInfo);
            }
            WMSInfo.WMSInterpolation byServiceInterpolation = null;
            if (byLayerInterpolation == null && this.wms != null) {
                byServiceInterpolation = this.wms.getInterpolation();
            }
            interpolation = byLayerInterpolation != null ? RenderedImageMapOutputFormat.toInterpolationObject(byLayerInterpolation) : (byServiceInterpolation != null ? RenderedImageMapOutputFormat.toInterpolationObject(byServiceInterpolation) : Interpolation.getInstance((int)0));
        }
        return interpolation;
    }

    private Color getBackgroundColor(boolean transparent) {
        Color bgColor = this.mapContent.getBgColor();
        bgColor = transparent ? new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 0) : new Color(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), 255);
        return bgColor;
    }

    private static boolean isVectorSource(Expression tranformation) {
        if (tranformation instanceof ProcessFunction) {
            ProcessFunction processFunction = (ProcessFunction)tranformation;
            Name processName = processFunction.getProcessName();
            Map params = Processors.getParameterInfo((Name)processName);
            for (org.geotools.api.data.Parameter param : params.values()) {
                if (!SimpleFeatureCollection.class.isAssignableFrom(param.getType())) continue;
                return true;
            }
        }
        return false;
    }

    private ReferencedEnvelope getEastNorthEnvelope(ReferencedEnvelope envelope) throws FactoryException {
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        if (CRS.getAxisOrder((CoordinateReferenceSystem)crs) != CRS.AxisOrder.NORTH_EAST) {
            return envelope;
        }
        String code = ResourcePool.lookupIdentifier((CoordinateReferenceSystem)crs, (boolean)true);
        if (code == null) {
            return envelope;
        }
        CoordinateReferenceSystem eastNorthCrs = CRS.decode((String)SrsSyntax.AUTH_CODE.getSRS(code), (boolean)true);
        return new ReferencedEnvelope(envelope.getMinY(), envelope.getMaxY(), envelope.getMinX(), envelope.getMaxX(), eastNorthCrs);
    }

    private static GridCoverage2D readBestCoverage(ReadingContext context, ReferencedEnvelope envelope, Rectangle requestedRasterArea, Interpolation interpolation, Color bgColor, int[] bandIndices) throws IOException {
        GridCoverage2DReader reader = context.reader;
        Object params = context.params;
        GeneralParameterValue[] readParams = DirectRasterRenderer.getReadParameters(params, envelope, requestedRasterArea, interpolation, bgColor, bandIndices);
        GridCoverage2D coverage = reader.read(readParams);
        context.params = readParams;
        return coverage;
    }

    private static GeneralParameterValue[] getReadParameters(Object params, ReferencedEnvelope envelope, Rectangle requestedRasterArea, Interpolation interpolation, Color bgColor, int[] bandIndices) {
        GeneralParameterValue[] readParams;
        int length;
        Parameter bgColorParam;
        Parameter readGG = null;
        if (envelope != null) {
            readGG = (Parameter)AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
            readGG.setValue((Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(requestedRasterArea), (Bounds)envelope));
        }
        Parameter readInterpolation = (Parameter)ImageMosaicFormat.INTERPOLATION.createValue();
        readInterpolation.setValue((Object)interpolation);
        if (bgColor != null) {
            bgColorParam = (Parameter)AbstractGridFormat.BACKGROUND_COLOR.createValue();
            bgColorParam.setValue((Object)bgColor);
        } else {
            bgColorParam = null;
        }
        Parameter bandIndicesParam = null;
        if (bandIndices != null) {
            bandIndicesParam = (Parameter)AbstractGridFormat.BANDS.createValue();
            bandIndicesParam.setValue((Object)bandIndices);
        }
        int n = length = (readParams = (GeneralParameterValue[])params) == null ? 0 : readParams.length;
        if (length > 0) {
            String readGGName = AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString();
            String readInterpolationName = ImageMosaicFormat.INTERPOLATION.getName().toString();
            String bgColorName = AbstractGridFormat.BACKGROUND_COLOR.getName().toString();
            String bandsListName = AbstractGridFormat.BANDS.getName().toString();
            boolean foundInterpolation = false;
            boolean foundGG = false;
            boolean foundBgColor = false;
            boolean foundBandIndices = false;
            for (int i = 0; i < length; ++i) {
                String paramName = readParams[i].getDescriptor().getName().toString();
                if (paramName.equalsIgnoreCase(readGGName) && readGG != null) {
                    ((Parameter)readParams[i]).setValue((Object)readGG);
                    foundGG = true;
                    continue;
                }
                if (paramName.equalsIgnoreCase(readInterpolationName)) {
                    ((Parameter)readParams[i]).setValue((Object)interpolation);
                    foundInterpolation = true;
                    continue;
                }
                if (paramName.equalsIgnoreCase(bgColorName) && bgColor != null) {
                    ((Parameter)readParams[i]).setValue((Object)bgColor);
                    foundBgColor = true;
                    continue;
                }
                if (!paramName.equalsIgnoreCase(bandsListName) || bandIndices == null) continue;
                ((Parameter)readParams[i]).setValue((Object)bandIndices);
                foundBandIndices = true;
            }
            if (!(foundGG && foundInterpolation && foundBgColor && bgColor != null && foundBandIndices)) {
                ArrayList<Object> paramList = new ArrayList<Object>();
                paramList.addAll(Arrays.asList(readParams));
                if (!foundGG && readGG != null) {
                    paramList.add(readGG);
                }
                if (!foundInterpolation) {
                    paramList.add(readInterpolation);
                }
                if (!foundBgColor && bgColor != null) {
                    paramList.add(bgColorParam);
                }
                if (!foundBandIndices && bandIndices != null) {
                    paramList.add(bandIndicesParam);
                }
                readParams = paramList.toArray(new GeneralParameterValue[paramList.size()]);
            }
        } else {
            ArrayList<Parameter> paramList = new ArrayList<Parameter>();
            if (readGG != null) {
                paramList.add(readGG);
            }
            if (bgColor != null) {
                paramList.add(bgColorParam);
            }
            if (bandIndices != null) {
                paramList.add(bandIndicesParam);
            }
            paramList.add(readInterpolation);
            readParams = paramList.toArray(new GeneralParameterValue[paramList.size()]);
        }
        return readParams;
    }

    private RenderedImage applyBackgroundTransparency(Rectangle mapRasterArea, RenderedImage image, Rectangle intersection, ImageLayout layout, double[] bgValues, PlanarImage[] alphaChannels, int transparencyType, ImageWorker iw, Object roiCandidate, boolean preProcessedWithTransparency) {
        double[][] dArrayArray;
        ROI[] rois;
        ROI[] rOIArray;
        ROIShape roi;
        if (roiCandidate instanceof ROI) {
            ROI imageROI = (ROI)roiCandidate;
            try {
                roi = new ROIGeometry(mapRasterArea).intersect(imageROI);
            }
            catch (IllegalArgumentException e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Failed to intersect image ROI with target bounds, returning empty result", e);
                }
                return null;
            }
        } else {
            roi = new ROIShape((Shape)(!intersection.isEmpty() ? intersection : mapRasterArea));
        }
        if (!preProcessedWithTransparency) {
            ROI[] rOIArray2 = new ROI[1];
            rOIArray = rOIArray2;
            rOIArray2[0] = roi;
        } else {
            rOIArray = rois = null;
        }
        if (!preProcessedWithTransparency) {
            double[][] dArrayArray2 = new double[1][];
            dArrayArray = dArrayArray2;
            dArrayArray2[0] = new double[]{ColorUtilities.getThreshold((int)image.getSampleModel().getDataType())};
        } else {
            dArrayArray = null;
        }
        double[][] thresholds = dArrayArray;
        iw.setRenderingHint(JAI.KEY_IMAGE_LAYOUT, (Object)layout);
        iw.setBackground(bgValues);
        iw.mosaic(new RenderedImage[]{image}, alphaChannels != null && transparencyType == 3 ? MosaicDescriptor.MOSAIC_TYPE_BLEND : MosaicDescriptor.MOSAIC_TYPE_OVERLAY, alphaChannels, rois, (double[][])thresholds, null);
        image = iw.getRenderedImage();
        return image;
    }

    private RasterSymbolizer updateSymbolizerForBandSelection(ReadingContext context, RasterSymbolizer symbolizer, int[] bandIndices) {
        Object params;
        GridCoverage2DReader reader = context != null ? context.reader : null;
        Object object = params = context != null ? context.params : null;
        if (params != null && reader != null && bandIndices != null) {
            Format format = reader.getFormat();
            ParameterValueGroup readParameters = null;
            ParameterDescriptorGroup descriptorGroup = null;
            List descriptors = null;
            if (format != null && (readParameters = format.getReadParameters()) != null && (descriptorGroup = readParameters.getDescriptor()) != null && (descriptors = descriptorGroup.descriptors()) != null && descriptors.contains(AbstractGridFormat.BANDS) && bandIndices != null) {
                symbolizer = GridCoverageRenderer.setupSymbolizerForBandsSelection((RasterSymbolizer)symbolizer);
            }
        }
        return symbolizer;
    }

    private RenderedImage rgbNoDataTransparent(RenderedImage image) {
        return this.makeNoDataTransparent(image, 3);
    }

    private RenderedImage grayNoDataTransparent(RenderedImage image) {
        return this.makeNoDataTransparent(image, 1);
    }

    private RenderedImage makeNoDataTransparent(RenderedImage image, int numBands) {
        int maxValue;
        int minValue;
        ImageWorker iw = new ImageWorker(image);
        Range noData = iw.getNoData();
        ColorModel cm = image.getColorModel();
        int numColorBands = cm.getNumColorComponents();
        if (noData != null && image.getSampleModel().getDataType() == 0 && numColorBands == numBands && cm instanceof ComponentColorModel && (minValue = noData.getMin().intValue()) == (maxValue = noData.getMax().intValue()) && minValue >= -128 && minValue <= 127) {
            Color transparentColor = new Color(minValue, minValue, minValue);
            iw.makeColorTransparent(transparentColor);
            return iw.getRenderedImage();
        }
        return null;
    }

    private RenderedImage addAlphaChannel(RenderedImage image) {
        RenderedImage alpha = this.buildAlphaBand(image);
        ImageWorker iw = new ImageWorker(image);
        iw.addBand(alpha, false, true, null);
        return iw.getRenderedImage();
    }

    private RenderedImage buildAlphaBand(RenderedImage image) {
        ImageLayout tempLayout = new ImageLayout(image);
        tempLayout.unsetValid(512).unsetValid(256);
        int width = image.getWidth();
        int height = image.getHeight();
        Object roiCandidate = image.getProperty("ROI");
        if (roiCandidate instanceof ROI) {
            PlanarImage roiImage = ((ROI)roiCandidate).getAsImage();
            ImageWorker iw = new ImageWorker((RenderedImage)roiImage);
            byte[] lookup = new byte[256];
            Arrays.fill(lookup, (byte)-1);
            lookup[0] = 0;
            LookupTable lookupTable = LookupTableFactory.create((byte[])lookup);
            SampleModel sm = RasterFactory.createPixelInterleavedSampleModel((int)0, (int)width, (int)height, (int)1);
            ColorModel cm = PlanarImage.createColorModel((SampleModel)sm);
            tempLayout.setSampleModel(sm);
            tempLayout.setColorModel(cm);
            iw.setRenderingHints(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, tempLayout));
            iw.lookup(lookupTable);
            return iw.getRenderedImage();
        }
        return ConstantDescriptor.create((Float)Float.valueOf(width), (Float)Float.valueOf(height), (Number[])new Byte[]{(byte)-1}, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, tempLayout));
    }

    double mapToGrayColor(Color gray, ComponentColorModel cm) {
        double[] rescaleFactors = new double[33];
        rescaleFactors[0] = 1.0;
        rescaleFactors[2] = 255.0;
        rescaleFactors[3] = 8421504.0;
        rescaleFactors[1] = 512.0;
        rescaleFactors[5] = 0.00392156862745098;
        rescaleFactors[4] = 0.00392156862745098;
        rescaleFactors[32] = 1.0;
        return (double)gray.getRed() / rescaleFactors[cm.getTransferType()];
    }

    private static boolean isLevelOfGray(Color color) {
        return color.getRed() == color.getBlue() && color.getRed() == color.getGreen();
    }

    private static final RenderedImage createBkgImage(float width, float height, Color bgColor, RenderingHints renderingHints) {
        Number[] bands = new Byte[]{(byte)bgColor.getRed(), (byte)bgColor.getGreen(), (byte)bgColor.getBlue(), (byte)bgColor.getAlpha()};
        return ConstantDescriptor.create((Float)Float.valueOf(width), (Float)Float.valueOf(height), (Number[])bands, (RenderingHints)renderingHints);
    }

    private class GCRRenderingTransformationHelper
    extends RenderingTransformationHelper {
        private final Interpolation interpolation;
        private final boolean advancedProjectionHandling;
        private final boolean mapWrapping;
        private final WMSMapContent mapContent;

        public GCRRenderingTransformationHelper(WMSMapContent mapContent, Interpolation interpolation, boolean advancedProjectionHandling, boolean mapWrapping) {
            this.mapContent = mapContent;
            this.interpolation = interpolation;
            this.advancedProjectionHandling = advancedProjectionHandling;
            this.mapWrapping = mapWrapping;
        }

        protected GridCoverage2D readCoverage(GridCoverage2DReader reader, Object readParams, GridGeometry2D readGG) throws IOException {
            RenderingHints interpolationHints = new RenderingHints(JAI.KEY_INTERPOLATION, this.interpolation);
            try {
                int mapWidth = this.mapContent.getMapWidth();
                int mapHeight = this.mapContent.getMapHeight();
                ReferencedEnvelope mapEnvelope = DirectRasterRenderer.this.getEastNorthEnvelope(this.mapContent.getRenderingArea());
                Rectangle mapRasterArea = new Rectangle(0, 0, mapWidth, mapHeight);
                AffineTransform worldToScreen = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)mapEnvelope, (Rectangle)mapRasterArea);
                GridCoverageRenderer gcr = new GridCoverageRenderer(mapEnvelope.getCoordinateReferenceSystem(), (Envelope)mapEnvelope, mapRasterArea, worldToScreen, interpolationHints);
                gcr.setAdvancedProjectionHandlingEnabled(this.advancedProjectionHandling);
                gcr.setWrapEnabled(this.mapWrapping);
                GeneralParameterValue[] readingParams = this.setInterpolation(this.interpolation, (GeneralParameterValue[])readParams);
                RenderedImage ri = gcr.renderImage(reader, readingParams, null, this.interpolation, null, 256, 256);
                if (ri != null) {
                    PlanarImage pi = PlanarImage.wrapRenderedImage((RenderedImage)ri);
                    GridCoverage2D gc2d = (GridCoverage2D)pi.getProperty("ParentCoverage");
                    return gc2d;
                }
                return null;
            }
            catch (NoninvertibleTransformException | FactoryException | TransformException e) {
                throw new IOException("Failure rendering the coverage", e);
            }
        }

        private GeneralParameterValue[] setInterpolation(Interpolation interpolation, GeneralParameterValue[] readParams) {
            if (interpolation != null) {
                List<Object> paramList = new ArrayList<Parameter>();
                if (readParams != null) {
                    paramList = Arrays.stream(readParams).filter(param -> this.notInterpolation((GeneralParameterValue)param)).collect(Collectors.toList());
                }
                Parameter readInterpolation = (Parameter)ImageMosaicFormat.INTERPOLATION.createValue();
                readInterpolation.setValue((Object)interpolation);
                paramList.add(readInterpolation);
                readParams = paramList.toArray(new GeneralParameterValue[paramList.size()]);
            }
            return readParams;
        }

        private boolean notInterpolation(GeneralParameterValue param) {
            return !param.getDescriptor().equals(ImageMosaicFormat.INTERPOLATION);
        }
    }

    static class ReadingContext {
        GridCoverage2DReader reader;
        Object params;

        ReadingContext() {
        }
    }
}

