/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.wfs.json.JSONType;
import org.geoserver.wms.WMSTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class WMSServiceExceptionTest
extends WMSTestSupport {
    @Test
    public void testException111() throws Exception {
        this.assertResponse111("wms?version=1.1.1&request=getmap&layers=foobar");
    }

    @Test
    public void testException110() throws Exception {
        this.assertResponse111("wms?version=1.1.0&request=getmap&layers=foobar");
    }

    @Test
    public void testPng8InImageFormat111() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=-130,24,-66,50&styles=I_DONT_EXIST&layers=states&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&version=1.1.1&service=WMS&EXCEPTIONS=application/vnd.ogc.se_inimage");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    @Test
    public void testPng8InImageFormat130() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=-130,24,-66,50&styles=I_DONT_EXIST&layers=states&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&version=1.3.0&service=WMS&EXCEPTIONS=application/vnd.ogc.se_inimage");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    void assertResponse111(String path) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        String content = response.getContentAsString();
        Assert.assertTrue((boolean)content.contains("<!DOCTYPE ServiceExceptionReport SYSTEM \"http://localhost:8080/geoserver/schemas/wms/1.1.1/WMS_exception_1_1_1.dtd\">"));
        Assert.assertEquals((Object)"application/vnd.ogc.se_xml", (Object)this.getBaseMimeType(response.getContentType()));
        Document dom = this.dom(new ByteArrayInputStream(content.getBytes()));
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"1.1.1", (Object)dom.getDocumentElement().getAttribute("version"));
    }

    @Test
    public void testException130() throws Exception {
        this.assertResponse130("wms?version=1.3.0&request=getmap&layers=foobar");
    }

    void assertResponse130(String path) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        String content = response.getContentAsString();
        Assert.assertTrue((boolean)content.contains("xsi:schemaLocation=\"http://www.opengis.net/ogc http://localhost:8080/geoserver/schemas/wms/1.3.0/exceptions_1_3_0.xsd\""));
        Assert.assertEquals((Object)"text/xml", (Object)this.getBaseMimeType(response.getContentType()));
        Document dom = this.dom(new ByteArrayInputStream(content.getBytes()));
        Assert.assertEquals((Object)"ServiceExceptionReport", (Object)dom.getDocumentElement().getNodeName());
        Assert.assertEquals((Object)"1.3.0", (Object)dom.getDocumentElement().getAttribute("version"));
    }

    @Test
    public void testJsonException130() throws Exception {
        String path = "wms?version=1.3.0&request=getmap&layers=foobar&EXCEPTIONS=text/javascript&format_options=callback:myMethod";
        JSONType.setJsonpEnabled((boolean)true);
        MockHttpServletResponse response = this.getAsServletResponse(path);
        JSONType.setJsonpEnabled((boolean)false);
        String content = response.getContentAsString();
        WMSServiceExceptionTest.testJson(WMSServiceExceptionTest.testJsonP(content));
    }

    private static String testJsonP(String content) {
        Assert.assertTrue((boolean)content.startsWith("myMethod("));
        Assert.assertTrue((boolean)content.endsWith(")"));
        content = content.substring("myMethod(".length(), content.length() - 1);
        return content;
    }

    private static void testJson(String content) {
        JSONObject jsonException = JSONObject.fromObject((Object)content);
        Assert.assertEquals((Object)jsonException.getString("version"), (Object)"1.3.0");
        JSONArray exceptions = jsonException.getJSONArray("exceptions");
        JSONObject exception = exceptions.getJSONObject(0);
        Assert.assertNotNull((Object)exception);
        Assert.assertNotNull((Object)exception.getString("code"));
        Assert.assertNotNull((Object)exception.getString("locator"));
        String exceptionText = exception.getString("text");
        Assert.assertNotNull((Object)exceptionText);
        Assert.assertEquals((Object)exceptionText, (Object)"Could not find layer foobar");
    }

    @Test
    public void testExceptionCodeEscaped() throws Exception {
        String path = "wms?request=GetLegendGraphic&format=image/png&width=20&height=20&layer=cite:Lakes&SLD=file:///this/file/should/not/exist\"><a xmlns:a='http://www.w3.org/1999/xhtml'><a:body onload=\"alert('xss')\"/></a></ServiceException><ServiceException x=\"";
        MockHttpServletResponse response = this.getAsServletResponse(path);
        String content = response.getContentAsString();
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"<ServiceExceptionReport "));
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"</ServiceExceptionReport>"));
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"<ServiceException "));
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"</ServiceException>"));
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"<a:body onload=\"alert('xss')\"/>")));
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.containsString((String)"&lt;a:body onload=&quot;alert(&apos;xss&apos;)&quot;/&gt;"));
    }

    @Test
    public void testExceptionLocatorEscaped() throws Exception {
        String path = "wms?request=%22%3E%3Ca%20xmlns:a=%27http://www.w3.org/1999/xhtml%27%3E%3Ca:body%20onload=%22alert%28%27xss%27%29%22/%3E%3C/a%3E%3C";
        MockHttpServletResponse response = this.getAsServletResponse(path);
        String content = response.getContentAsString();
        Assert.assertTrue((boolean)content.contains("<ServiceExceptionReport "));
        Assert.assertTrue((boolean)content.contains("</ServiceExceptionReport>"));
        Assert.assertTrue((boolean)content.contains("<ServiceException "));
        Assert.assertTrue((boolean)content.contains("</ServiceException>"));
        Assert.assertFalse((boolean)content.contains("<a:body onload=\"alert('xss')\"/>"));
        Assert.assertTrue((boolean)content.contains("&lt;a:body onload=&quot;alert(&apos;xss&apos;)&quot;/&gt;"));
    }

    @Test
    public void testExceptionFormatBlank111() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("wms?bbox=-130,24,-66,50&styles=I_DONT_EXIST&layers=states&Format=image/png8&request=GetMap&width=550&height=250&srs=EPSG:4326&version=1.1.1&service=WMS&EXCEPTIONS=application/vnd.ogc.se_blank");
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    @Test
    public void testExceptionBlank111() throws Exception {
        String wms111 = "wms?LAYERS=cite%3ALakes&STYLES=&FORMAT=image%2Fpng&TILED=true&TILESORIGIN=-0.0018%2C0.0006&SERVICE=WMS&VERSION=1.1.1&REQUEST=GetMap&CRS=EPSG%3A4326&BBOX=-0.0018,0.0006,0.0007,0.0031&WIDTH=256&HEIGHT=256&EXCEPTIONS=application/vnd.ogc.se_blank";
        BufferedImage blankimage111 = ImageIO.read(((Object)((Object)this)).getClass().getResourceAsStream("/ServiceException/vnd.ogc.se_blank.png"));
        BufferedImage image111 = this.getAsImage(wms111, "image/png");
        Assert.assertEquals((long)image111.getWidth(), (long)blankimage111.getWidth());
        Assert.assertEquals((long)image111.getHeight(), (long)blankimage111.getHeight());
        Assert.assertEquals((Object)image111.getColorModel(), (Object)blankimage111.getColorModel());
        Assert.assertEquals((Object)image111.getSampleModel(), (Object)blankimage111.getSampleModel());
        DataBufferByte blankdb111 = (DataBufferByte)blankimage111.getData().getDataBuffer();
        DataBufferByte db111 = (DataBufferByte)image111.getData().getDataBuffer();
        byte[][] blankbankData111 = blankdb111.getBankData();
        byte[][] bankData111 = db111.getBankData();
        for (int i = 0; i < bankData111.length; ++i) {
            Assert.assertArrayEquals((byte[])blankbankData111[i], (byte[])bankData111[i]);
        }
    }
}

