/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.capabilities;

import java.util.Collections;
import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.capabilities.CapabilityUtil;
import org.geotools.util.NumberRange;
import org.junit.Assert;
import org.junit.Test;

public class CapabilityUtilTest
extends WMSTestSupport {
    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        Catalog catalog = this.getCatalog();
        testData.addStyle("multiNamedLayers", "MultiNamedLayers.sld", ((Object)((Object)this)).getClass(), catalog);
        testData.addStyle("regionated", "Regionated.sld", ((Object)((Object)this)).getClass(), catalog);
    }

    @Test
    public void testSearchMinMaxScaleDenominator() throws Exception {
        Catalog catalog = this.getCatalog();
        Set<StyleInfo> styles = Collections.singleton(catalog.getStyleByName("multiNamedLayers"));
        NumberRange denominatorsMultiNamed = CapabilityUtil.searchMinMaxScaleDenominator(styles);
        Assert.assertEquals((String)"There are two NamedLayer sections in this SLD, should grab both to get min denom", (double)1.0E7, (double)((Double)denominatorsMultiNamed.getMinValue()), (double)0.0);
        Assert.assertEquals((String)"There are two NamedLayer sections in this SLD, should grab both to get max denom", (double)3.0E7, (double)((Double)denominatorsMultiNamed.getMaxValue()), (double)0.0);
        Set<StyleInfo> stylesSingle = Collections.singleton(catalog.getStyleByName("regionated"));
        NumberRange denominatorsSingle = CapabilityUtil.searchMinMaxScaleDenominator(stylesSingle);
        Assert.assertEquals((String)"There is one UserStyle section in this SLD, should be able to get min denom", (double)8.0E7, (double)((Double)denominatorsSingle.getMinValue()), (double)0.0);
        Assert.assertEquals((String)"There is one UserStyle section in this SLD, should be able to get max denom", (double)6.4E8, (double)((Double)denominatorsSingle.getMaxValue()), (double)0.0);
    }
}

