/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.decoration;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WMSMapContent;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.Assert;
import org.locationtech.jts.geom.Envelope;

public class DecorationTestSupport {
    protected WMSMapContent createMapContent(double dpi) {
        GetMapRequest request = new GetMapRequest();
        request.setWidth(1000);
        request.setHeight(1000);
        request.setRawKvp(new HashMap());
        if (dpi > 0.0) {
            request.getFormatOptions().put("dpi", dpi);
        }
        WMSMapContent map = new WMSMapContent(request);
        map.setMapWidth(request.getWidth());
        map.setMapHeight(request.getHeight());
        map.getViewport().setBounds(new ReferencedEnvelope(new Envelope(0.0, 0.01, 0.0, 0.01), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        return map;
    }

    protected void assertPixel(BufferedImage image, int i, int j, Color color) {
        Color actual = this.getPixelColor(image, i, j);
        Assert.assertEquals((Object)color, (Object)actual);
    }

    protected Color getPixelColor(BufferedImage image, int i, int j) {
        ColorModel cm = image.getColorModel();
        WritableRaster raster = image.getRaster();
        Object pixel = raster.getDataElements(i, j, null);
        Color actual = cm.hasAlpha() ? new Color(cm.getRed(pixel), cm.getGreen(pixel), cm.getBlue(pixel), cm.getAlpha(pixel)) : new Color(cm.getRed(pixel), cm.getGreen(pixel), cm.getBlue(pixel), 255);
        return actual;
    }
}

