/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.ServiceException;
import org.geoserver.security.urlchecks.AbstractURLCheck;
import org.geoserver.security.urlchecks.GeoServerURLChecker;
import org.geoserver.security.urlchecks.RegexURLCheck;
import org.geoserver.security.urlchecks.StyleURLChecker;
import org.geoserver.security.urlchecks.URLCheckDAO;
import org.geoserver.wms.GetLegendGraphicRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.legendgraphic.GetLegendGraphicKvpReader;
import org.geotools.api.feature.type.Name;
import org.geotools.api.style.Style;
import org.geotools.api.util.InternationalString;
import org.geotools.data.ows.URLCheckerException;
import org.geotools.feature.NameImpl;
import org.geotools.util.GrowableInternationalString;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class GetLegendGraphicKvpReaderTest
extends WMSTestSupport {
    GetLegendGraphicKvpReader requestReader;
    Map<String, String> requiredParameters;
    Map<String, String> optionalParameters;
    Map<String, String> allParameters;
    MockHttpServletRequest httpRequest;
    WMS wms;
    URLCheckDAO dao;

    @Before
    public void setParameters() throws Exception {
        this.requiredParameters = new HashMap<String, String>();
        this.requiredParameters.put("VERSION", "1.0.0");
        this.requiredParameters.put("REQUEST", "GetLegendGraphic");
        this.requiredParameters.put("LAYER", "cite:Ponds");
        this.requiredParameters.put("FORMAT", "image/png");
        this.optionalParameters = new HashMap<String, String>();
        this.optionalParameters.put("STYLE", "Ponds");
        this.optionalParameters.put("FEATURETYPE", "fake_not_used");
        this.optionalParameters.put("SCALE", "1000");
        this.optionalParameters.put("WIDTH", "120");
        this.optionalParameters.put("HEIGHT", "90");
        this.optionalParameters.put("LANGUAGE", "en");
        this.allParameters = new HashMap<String, String>(this.requiredParameters);
        this.allParameters.putAll(this.optionalParameters);
        this.wms = this.getWMS();
        WMSInfo info = this.wms.getServiceInfo();
        info.setDynamicStylingDisabled(Boolean.valueOf(false));
        this.wms.getGeoServer().save((ServiceInfo)info);
        this.requestReader = new GetLegendGraphicKvpReader(this.wms);
        this.httpRequest = this.createRequest("wms", this.allParameters);
        GeoServerExtensions.bean(GeoServerURLChecker.class);
        GeoServerExtensions.bean(StyleURLChecker.class);
        this.dao = (URLCheckDAO)GeoServerExtensions.bean(URLCheckDAO.class);
        this.dao.setEnabled(false);
        this.dao.saveChecks(Collections.emptyList());
    }

    @Test
    public void testRemoteSLDMultipleStyles() throws Exception {
        URL remoteSldUrl = ((Object)((Object)this)).getClass().getResource("MultipleStyles.sld");
        this.allParameters.put("SLD", remoteSldUrl.toExternalForm());
        this.allParameters.put("LAYER", "cite:Ponds");
        this.allParameters.put("STYLE", "Ponds");
        GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters);
        Style selectedStyle = ((GetLegendGraphicRequest.LegendRequest)request.getLegends().get(0)).getStyle();
        Assert.assertNotNull((Object)selectedStyle);
        Assert.assertEquals((Object)"Ponds", (Object)selectedStyle.getName());
        this.allParameters.put("LAYER", "cite:Lakes");
        this.allParameters.put("STYLE", "Lakes");
        request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters);
        selectedStyle = ((GetLegendGraphicRequest.LegendRequest)request.getLegends().get(0)).getStyle();
        Assert.assertNotNull((Object)selectedStyle);
        Assert.assertEquals((Object)"Lakes", (Object)selectedStyle.getName());
    }

    @Test
    public void testRemoteSLDDisabled() {
        WMSInfo info = this.wms.getServiceInfo();
        info.setDynamicStylingDisabled(Boolean.valueOf(true));
        this.wms.getGeoServer().save((ServiceInfo)info);
        URL remoteSldUrl = ((Object)((Object)this)).getClass().getResource("MultipleStyles.sld");
        this.allParameters.put("SLD", remoteSldUrl.toExternalForm());
        this.allParameters.put("LAYER", "cite:Ponds");
        ServiceException exception = (ServiceException)Assert.assertThrows(ServiceException.class, () -> this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters));
        Assert.assertEquals((Object)"Dynamic style usage is forbidden", (Object)exception.getMessage());
    }

    @Test
    public void testRemoteSLDURLCheckerAllowed() throws Exception {
        this.dao.setEnabled(true);
        this.dao.save((AbstractURLCheck)new RegexURLCheck("Multiple", "Multiple", "^.*MultipleStyles.sld$"));
        this.testRemoteSLDMultipleStyles();
    }

    @Test
    public void testRemoteSLDURLCheckerDisallowed() throws Exception {
        this.dao.setEnabled(true);
        URL remoteSldUrl = ((Object)((Object)this)).getClass().getResource("MultipleStyles.sld");
        this.allParameters.put("SLD", remoteSldUrl.toExternalForm());
        this.allParameters.put("LAYER", "cite:Ponds");
        ServiceException exception = (ServiceException)Assert.assertThrows(ServiceException.class, () -> this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters));
        MatcherAssert.assertThat((Object)exception.getCause(), (Matcher)Matchers.instanceOf(URLCheckerException.class));
    }

    @Test
    public void testMissingLayerParameter() throws Exception {
        this.requiredParameters.remove("LAYER");
        try {
            this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
            Assert.fail((String)"Expected ServiceException");
        }
        catch (ServiceException e) {
            Assert.assertEquals((Object)"LayerNotDefined", (Object)e.getCode());
        }
    }

    @Test
    public void testMissingFormatParameter() throws Exception {
        this.requiredParameters.remove("FORMAT");
        try {
            this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
            Assert.fail((String)"Expected ServiceException");
        }
        catch (ServiceException e) {
            Assert.assertEquals((Object)"MissingFormat", (Object)e.getCode());
        }
    }

    @Test
    public void testStrictParameter() throws Exception {
        GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters);
        Assert.assertTrue((boolean)request.isStrict());
        this.allParameters.put("STRICT", "false");
        this.allParameters.remove("LAYER");
        request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters);
        Assert.assertFalse((boolean)request.isStrict());
    }

    @Test
    public void testLayerGroup() throws Exception {
        GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
        Assert.assertEquals((long)1L, (long)request.getLegends().size());
        this.requiredParameters.put("LAYER", "nature");
        request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
        Assert.assertTrue((request.getLegends().size() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testLanguage() throws Exception {
        GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
        Assert.assertNull((Object)request.getLocale());
        request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters);
        Assert.assertEquals((Object)Locale.ENGLISH, (Object)request.getLocale());
    }

    @Test
    public void testStylesForLayerGroup() throws Exception {
        this.requiredParameters.put("LAYER", "nature");
        this.requiredParameters.put("STYLE", "");
        GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
        Assert.assertEquals((long)2L, (long)request.getLegends().size());
    }

    @Test
    public void testRulesForLayerGroup() throws Exception {
        this.requiredParameters.put("LAYER", "nature");
        this.requiredParameters.put("RULE", "rule1,rule2");
        GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
        Assert.assertEquals((long)2L, (long)request.getLegends().size());
    }

    @Test
    public void testLabelsForLayerGroup() throws Exception {
        this.requiredParameters.put("LAYER", "nature");
        GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.requiredParameters, this.requiredParameters);
        Assert.assertNotNull((Object)request.getLegend((Name)new NameImpl("http://www.opengis.net/cite", "Lakes")).getTitle());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testI18nLabelAndDescription() throws Exception {
        FeatureTypeInfo old = this.getCatalog().getFeatureTypeByName("cite", "Ponds");
        try {
            FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName("cite", "Ponds");
            GrowableInternationalString i18nTitle = new GrowableInternationalString();
            i18nTitle.add(Locale.ENGLISH, "en title");
            i18nTitle.add(Locale.ITALIAN, "it title");
            fti.setInternationalTitle((InternationalString)i18nTitle);
            this.getCatalog().save((ResourceInfo)fti);
            this.allParameters.put("LAYER", "cite:Ponds");
            this.allParameters.put("STYLE", "Ponds");
            this.allParameters.put("LANGUAGE", "it");
            GetLegendGraphicRequest request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters);
            GetLegendGraphicRequest.LegendRequest legend = request.getLegend((Name)new NameImpl("http://www.opengis.net/cite", "Ponds"));
            Assert.assertEquals((Object)legend.getTitle(), (Object)"it title");
            this.allParameters.put("LANGUAGE", "en");
            request = this.requestReader.read((Object)new GetLegendGraphicRequest(), this.allParameters, this.allParameters);
            legend = request.getLegend((Name)new NameImpl("http://www.opengis.net/cite", "Ponds"));
            Assert.assertEquals((Object)legend.getTitle(), (Object)"en title");
        }
        finally {
            this.getCatalog().save((ResourceInfo)old);
        }
    }
}

