/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.legendgraphic;

import java.awt.image.BufferedImage;
import java.awt.image.SampleModel;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.legendgraphic.ImageQueue;
import org.geoserver.wms.legendgraphic.Tally;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ImageQueueTest {
    @Test
    public void testAddingToImageQueueWithoutExceedingMemoryLimit() {
        Tally tally = new Tally(100000L);
        ImageQueue imageQueue = new ImageQueue(tally);
        BufferedImage renderedImage = (BufferedImage)Mockito.mock(BufferedImage.class);
        SampleModel sampleModel = (SampleModel)Mockito.mock(SampleModel.class);
        int[] sampleSize = new int[]{100, 100, 200, 500};
        Mockito.when((Object)renderedImage.getSampleModel()).thenReturn((Object)sampleModel);
        Mockito.when((Object)sampleModel.getSampleSize()).thenReturn((Object)sampleSize);
        Mockito.when((Object)renderedImage.getWidth()).thenReturn((Object)10);
        Mockito.when((Object)renderedImage.getHeight()).thenReturn((Object)10);
        imageQueue.add(renderedImage);
        Assert.assertEquals((long)1L, (long)imageQueue.get().size());
    }

    @Test(expected=ServiceException.class)
    public void testExceedingMaxMemoryWhenAddingToImageQueue() {
        Tally tally = new Tally(1000L);
        ImageQueue imageQueue = new ImageQueue(tally);
        BufferedImage renderedImage = (BufferedImage)Mockito.mock(BufferedImage.class);
        SampleModel sampleModel = (SampleModel)Mockito.mock(SampleModel.class);
        int[] sampleSize = new int[]{100, 100, 200, 500};
        Mockito.when((Object)renderedImage.getSampleModel()).thenReturn((Object)sampleModel);
        Mockito.when((Object)sampleModel.getSampleSize()).thenReturn((Object)sampleSize);
        Mockito.when((Object)renderedImage.getWidth()).thenReturn((Object)10);
        Mockito.when((Object)renderedImage.getHeight()).thenReturn((Object)10);
        imageQueue.add(renderedImage);
    }
}

