/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.ows.Dispatcher;
import org.geoserver.platform.ServiceException;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.ows.KvpRequestReaderTestSupport;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSInfoImpl;
import org.geoserver.wms.map.GetMapXmlReader;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.style.Style;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class GetMapXmlReaderTest
extends KvpRequestReaderTestSupport {
    GetMapXmlReader reader;
    Dispatcher dispatcher;

    protected void oneTimeSetUp() throws Exception {
        super.oneTimeSetUp();
        CatalogFactory cf = this.getCatalog().getFactory();
        CatalogBuilder cb = new CatalogBuilder(this.getCatalog());
        LayerGroupInfo gi = cf.createLayerGroup();
        gi.setName("testGroup");
        gi.getLayers().add(this.getCatalog().getLayerByName(MockData.BASIC_POLYGONS.getLocalPart()));
        gi.getStyles().add(this.getCatalog().getStyleByName("polygon"));
        cb.calculateLayerGroupBounds(gi);
        this.getCatalog().add(gi);
    }

    protected void oneTimeTearDown() throws Exception {
        super.oneTimeTearDown();
        GeoServerLoader.setLegacy((boolean)false);
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.dispatcher = (Dispatcher)applicationContext.getBean("dispatcher");
        WMS wms = new WMS(this.getGeoServer());
        this.reader = new GetMapXmlReader(wms);
    }

    @Test
    public void testCreateRequest() throws Exception {
        GetMapRequest request = this.reader.createRequest();
        Assert.assertNotNull((Object)request);
    }

    @Test
    public void testResolveStylesForLayerGroup() throws Exception {
        GetMapRequest request = this.reader.createRequest();
        try (BufferedReader input = this.getResourceInputStream("WMSPostLayerGroupNonDefaultStyle.xml");){
            request = (GetMapRequest)this.reader.read((Object)request, (Reader)input, new HashMap());
            String layer = MockData.BASIC_POLYGONS.getLocalPart();
            Assert.assertEquals((long)1L, (long)request.getLayers().size());
            Assert.assertTrue((boolean)((MapLayerInfo)request.getLayers().get(0)).getName().endsWith(layer));
            Assert.assertEquals((long)1L, (long)request.getStyles().size());
            Style expected = this.getCatalog().getStyleByName("polygon").getStyle();
            Style style = (Style)request.getStyles().get(0);
            Assert.assertEquals((Object)expected, (Object)style);
        }
    }

    @Test
    public void testLayerFeatureConstraintFilterParsing() throws Exception {
        GetMapRequest request = this.reader.createRequest();
        try (BufferedReader input = this.getResourceInputStream("WMSPostLayerFeatureConstraintFilter.xml");){
            request = (GetMapRequest)this.reader.read((Object)request, (Reader)input, new HashMap());
            String linesLayer = MockData.LINES.getLocalPart();
            Assert.assertEquals((long)1L, (long)request.getLayers().size());
            Assert.assertTrue((boolean)((MapLayerInfo)request.getLayers().get(0)).getName().endsWith(linesLayer));
            Assert.assertEquals((long)1L, (long)request.getFilter().size());
            PropertyIsEqualTo parsed = (PropertyIsEqualTo)request.getFilter().get(0);
            Assert.assertEquals((Object)"[ NAME = VALUE ]", (Object)parsed.toString());
        }
    }

    @Test
    public void testAllowDynamicStyles() throws Exception {
        GetMapRequest request = this.reader.createRequest();
        try (BufferedReader input = this.getResourceInputStream("WMSPostLayerGroupNonDefaultStyle.xml");){
            WMS wms = new WMS(this.getGeoServer());
            WMSInfo oldInfo = (WMSInfo)wms.getGeoServer().getService(WMSInfo.class);
            WMSInfoImpl info = new WMSInfoImpl();
            info.setDynamicStylingDisabled(Boolean.TRUE);
            this.getGeoServer().remove((ServiceInfo)oldInfo);
            this.getGeoServer().add((ServiceInfo)info);
            GetMapXmlReader reader = new GetMapXmlReader(wms);
            boolean error = false;
            try {
                reader.read((Object)request, (Reader)input, new HashMap());
            }
            catch (ServiceException e) {
                error = true;
            }
            this.getGeoServer().remove((ServiceInfo)info);
            this.getGeoServer().add((ServiceInfo)oldInfo);
            Assert.assertTrue((boolean)error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCleanServiceException() throws Exception {
        GeoServerInfo cfg = this.getGeoServer().getGlobal();
        GetMapRequest request = this.reader.createRequest();
        try (BufferedReader input = this.getResourceInputStream("WMSPostServiceException.xml");){
            cfg.setXmlExternalEntitiesEnabled(Boolean.valueOf(true));
            this.getGeoServer().save(cfg);
            request = (GetMapRequest)this.reader.read((Object)request, (Reader)input, new HashMap());
            Assert.fail((String)"ServiceException with IOException Expected");
        }
        catch (ServiceException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("xml request is most probably not compliant to GetMap element"));
            Assert.assertTrue((boolean)(e.getCause() instanceof SAXException));
        }
        finally {
            cfg.setXmlExternalEntitiesEnabled(null);
            this.getGeoServer().save(cfg);
            EntityResolverProvider.setEntityResolver((EntityResolver)GeoServerSystemTestSupport.RESOLVE_DISABLED_PROVIDER_DEVMODE);
        }
    }

    private BufferedReader getResourceInputStream(String classRelativePath) throws IOException {
        InputStream resourceStream = ((Object)((Object)this)).getClass().getResource(classRelativePath).openStream();
        BufferedReader input = new BufferedReader(new InputStreamReader(resourceStream));
        return input;
    }
}

