/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.map;

import java.awt.RenderingHints;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSInfoImpl;
import org.geoserver.wms.WMSTestSupport;
import org.geoserver.wms.map.MarkFactoryHintsInjector;
import org.geotools.renderer.style.DynamicSymbolFactoryFinder;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;

public class MarkFactoryProcessorProviderFactoryTest
extends WMSTestSupport {
    @Test
    public void testDefaultResult() throws Exception {
        Hints hints = new Hints();
        MarkFactoryHintsInjector injector = new MarkFactoryHintsInjector(this.getGeoServer());
        injector.addMarkFactoryHints((RenderingHints)hints);
        List expectedFactories = IteratorUtils.toList((Iterator)DynamicSymbolFactoryFinder.getMarkFactories());
        List processedFactories = IteratorUtils.toList((Iterator)DynamicSymbolFactoryFinder.getMarkFactories((Hints)hints));
        Assert.assertEquals((Object)expectedFactories, (Object)processedFactories);
    }

    private String toListString(List<String> list) {
        StringBuilder builder = new StringBuilder();
        boolean started = false;
        for (String value : list) {
            if (started) {
                builder.append(",");
            }
            builder.append(value);
            started = true;
        }
        return builder.toString();
    }

    @Test
    public void testGlobalFilteredResult() throws Exception {
        ArrayList<String> markFactoryNames = new ArrayList<String>(Arrays.asList("WKTMarkFactory", "WellKnownMarkFactory", "TTFMarkFactory"));
        WMSInfo wmsInfo = (WMSInfo)this.getGeoServer().getService(WMSInfo.class);
        wmsInfo.getMetadata().put("MarkFactoryList", (Serializable)((Object)this.toListString(markFactoryNames)));
        this.getGeoServer().save((ServiceInfo)wmsInfo);
        Hints hints = new Hints();
        MarkFactoryHintsInjector injector = new MarkFactoryHintsInjector(this.getGeoServer());
        injector.addMarkFactoryHints((RenderingHints)hints);
        List processedFactories = IteratorUtils.toList((Iterator)DynamicSymbolFactoryFinder.getMarkFactories((Hints)hints));
        Assert.assertEquals(Arrays.asList("WKTMarkFactory", "WellKnownMarkFactory", "TTFMarkFactory"), processedFactories.stream().map(mf -> mf.getClass().getSimpleName()).collect(Collectors.toList()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWorkspaceConfig() throws Exception {
        GeoServer geoServer = this.getGeoServer();
        WorkspaceInfo workspaceInfo = geoServer.getCatalog().getWorkspaceByName("cgf");
        try {
            ArrayList<String> markFactoryNames = new ArrayList<String>(Arrays.asList("WKTMarkFactory", "WellKnownMarkFactory", "TTFMarkFactory"));
            WMSInfoImpl wmsInfo = new WMSInfoImpl();
            wmsInfo.setId("wms");
            wmsInfo.setName("WMS");
            wmsInfo.setEnabled(true);
            wmsInfo.setWorkspace(workspaceInfo);
            wmsInfo.getMetadata().put("MarkFactoryList", (Serializable)((Object)this.toListString(markFactoryNames)));
            geoServer.add((ServiceInfo)wmsInfo);
            LocalWorkspace.set((WorkspaceInfo)workspaceInfo);
            Hints hints = new Hints();
            MarkFactoryHintsInjector injector = new MarkFactoryHintsInjector(this.getGeoServer());
            injector.addMarkFactoryHints((RenderingHints)hints);
            List processedFactories = IteratorUtils.toList((Iterator)DynamicSymbolFactoryFinder.getMarkFactories((Hints)hints));
            Assert.assertEquals(Arrays.asList("WKTMarkFactory", "WellKnownMarkFactory", "TTFMarkFactory"), processedFactories.stream().map(mf -> mf.getClass().getSimpleName()).collect(Collectors.toList()));
        }
        finally {
            WMSInfo wmsInfo = (WMSInfo)geoServer.getService(workspaceInfo, WMSInfo.class);
            geoServer.remove((ServiceInfo)wmsInfo);
            LocalWorkspace.remove();
        }
    }
}

