/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.geoserver.config.GeoServer;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.security.urlchecks.AbstractURLCheck;
import org.geoserver.security.urlchecks.GeoServerURLChecker;
import org.geoserver.security.urlchecks.RegexURLCheck;
import org.geoserver.security.urlchecks.StyleURLChecker;
import org.geoserver.security.urlchecks.URLCheckDAO;
import org.geoserver.wms.WMSTestSupport;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;
import org.w3c.dom.Document;

public class GetMapURLCheckersTest
extends WMSTestSupport {
    private static final boolean debugMode = false;
    private static WireMockServer service;
    private static String bridgesStyleURL;
    private static String burgStyle;

    @BeforeClass
    public static void beforeClass() throws Exception {
        WireMockConfiguration config = WireMockConfiguration.wireMockConfig().dynamicPort();
        service = new WireMockServer((Options)config);
        service.start();
        String bridgesStyleBody = GetMapURLCheckersTest.getResourceAsString("bridges.sld");
        bridgesStyleURL = "http://localhost:" + service.port() + "/styles/bridges.sld";
        service.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/styles/bridges.sld")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody(bridgesStyleBody)));
        burgStyle = GetMapURLCheckersTest.getResourceAsString("burg_remote.sld").replace("${styleBase}", "http://localhost:" + service.port() + "/styles");
        String burgSvg = GetMapURLCheckersTest.getResourceAsString("burg02.svg");
        service.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/styles/burg02.svg")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody(burgSvg)));
        String capabilities = GetMapURLCheckersTest.getWFSResource("capabilities.xml");
        service.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/wfs?REQUEST=GetCapabilities&SERVICE=WFS")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody(capabilities)));
        String describe = GetMapURLCheckersTest.getWFSResource("describePoi.xml");
        Map<String, String> namespaces = Map.of("wfs", "http://www.opengis.net/wfs");
        service.stubFor(WireMock.post((String)"/wfs").withRequestBody((ContentPattern)WireMock.matchingXPath((String)"/wfs:DescribeFeatureType[wfs:TypeName='tiger:poi']", namespaces)).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody(describe)));
        String getFeature = GetMapURLCheckersTest.getWFSResource("getFeature.xml");
        service.stubFor(WireMock.post((String)"/wfs").withRequestBody((ContentPattern)WireMock.matchingXPath((String)"/wfs:GetFeature[wfs:Query[@typeName='tiger:poi']]", namespaces)).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody(getFeature)));
    }

    private static String getWFSResource(String resourceName) throws IOException {
        return GetMapURLCheckersTest.getResourceAsString("poiwfs/" + resourceName).replace("${wfsBase}", "http://localhost:" + service.port() + "/wfs");
    }

    private static String getResourceAsString(String resource) throws IOException {
        return GetMapURLCheckersTest.getResourceAsString(GetMapURLCheckersTest.class, resource);
    }

    private static String getResourceAsString(Class loader, String resource) throws IOException {
        try (InputStream is = loader.getResourceAsStream(resource);){
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        service.stop();
    }

    @Before
    public void setup() throws Exception {
        Assert.assertNotNull((Object)applicationContext.getBean(GeoServerURLChecker.class));
        Assert.assertNotNull((Object)applicationContext.getBean(StyleURLChecker.class));
        URLCheckDAO dao = (URLCheckDAO)applicationContext.getBean(URLCheckDAO.class);
        dao.saveChecks(Collections.emptyList());
    }

    @Override
    protected void onSetUp(SystemTestData testData) throws Exception {
        testData.addStyle("burg", "burg.sld", GeoServer.class, this.getCatalog());
        try (InputStream is = GeoServer.class.getResourceAsStream("burg02.svg");){
            testData.copyTo(is, "styles/burg02.svg");
        }
        is = ((Object)((Object)this)).getClass().getResourceAsStream("burg03.svg");
        try {
            testData.copyTo(is, "burg03.svg");
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        Object base = testData.getDataDirectoryRoot().getAbsolutePath().replace('\\', '/');
        base = "file://" + (((String)base).startsWith("/") ? "" : "/") + (String)base + "/";
        testData.addStyle("burg_query", "burg_query.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        Object sld1 = IOUtils.toString((URL)((Object)((Object)this)).getClass().getResource("burg_query.sld"), (Charset)StandardCharsets.UTF_8);
        int index1 = ((String)sld1).indexOf("burg03");
        sld1 = ((String)sld1).substring(0, index1) + (String)base + ((String)sld1).substring(index1);
        ByteArrayInputStream bytes1 = new ByteArrayInputStream(((String)sld1).getBytes(StandardCharsets.UTF_8));
        testData.copyTo((InputStream)bytes1, "styles/burg_query.sld");
        testData.addStyle("burg_fragment", "burg_fragment.sld", ((Object)((Object)this)).getClass(), this.getCatalog());
        Object sld2 = IOUtils.toString((URL)((Object)((Object)this)).getClass().getResource("burg_fragment.sld"), (Charset)StandardCharsets.UTF_8);
        int index2 = ((String)sld2).indexOf("burg03");
        sld2 = ((String)sld2).substring(0, index2) + (String)base + ((String)sld2).substring(index2);
        ByteArrayInputStream bytes2 = new ByteArrayInputStream(((String)sld2).getBytes(StandardCharsets.UTF_8));
        testData.copyTo((InputStream)bytes2, "styles/burg_fragment.sld");
    }

    @Test
    public void testRemoteStyleAllowed() throws Exception {
        URLCheckDAO dao = (URLCheckDAO)applicationContext.getBean(URLCheckDAO.class);
        dao.save((AbstractURLCheck)new RegexURLCheck("pointStyle", "Just the point style", "^" + bridgesStyleURL + "$"));
        String base = "wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&width=256&height=256&srs=EPSG:4326&format=image/png";
        MockHttpServletResponse response = this.getAsServletResponse(base + "&sld=" + bridgesStyleURL);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"image/png", (Object)response.getContentType());
    }

    @Test
    public void testRemoteStyleDenied() throws Exception {
        URLCheckDAO dao = (URLCheckDAO)applicationContext.getBean(URLCheckDAO.class);
        dao.save((AbstractURLCheck)new RegexURLCheck("deny", "Won't match anything useful", "^abcd$"));
        String base = "wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&width=256&height=256&srs=EPSG:4326&format=image/png";
        Document dom = this.getAsDOM(base + "&sld=" + bridgesStyleURL);
        String message = this.checkLegacyException(dom, "InvalidParameterValue", "sld");
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)bridgesStyleURL));
    }

    @Test
    public void testRemoteWFSAllowed() throws Exception {
        URLCheckDAO dao = (URLCheckDAO)applicationContext.getBean(URLCheckDAO.class);
        String localWfs = "http://localhost:" + service.port() + "/wfs";
        dao.save((AbstractURLCheck)new RegexURLCheck("localWFS", "The local wiremock WFS", "^" + localWfs + ".*$"));
        String request = GetMapURLCheckersTest.getMapRemoteWFS(localWfs);
        BufferedImage image = this.getAsImage(request, "image/png");
        this.assertNotBlank("testRemoteWFSAllowed", image, Color.WHITE);
    }

    @Test
    public void testRemoveWFSDisallowed() throws Exception {
        URLCheckDAO dao = (URLCheckDAO)applicationContext.getBean(URLCheckDAO.class);
        String localWfs = "http://localhost:" + service.port() + "/wfs";
        dao.save((AbstractURLCheck)new RegexURLCheck("deny", "Won't match anything useful", "^abcd$"));
        String request = GetMapURLCheckersTest.getMapRemoteWFS(localWfs);
        Document dom = this.getAsDOM(request);
        String message = this.checkLegacyException(dom, "InvalidParameterValue", "REMOTE_OWS_URL");
        MatcherAssert.assertThat((Object)message, (Matcher)CoreMatchers.containsString((String)localWfs));
    }

    private static String getMapRemoteWFS(String localWfs) {
        return "wms?service=WMS&version=1.1.1&request=GetMap&bbox=-74.044847,40.694924,-73.963094,40.726836&width=256&height=256&srs=EPSG:4326&format=image/png&layers=tiger:poi&styles=point&REMOTE_OWS_URL=" + localWfs + "&REMOTE_OWS_TYPE=WFS";
    }

    @Test
    public void testRemoteIconAllowed() throws Exception {
        URLCheckDAO dao = (URLCheckDAO)applicationContext.getBean(URLCheckDAO.class);
        dao.save((AbstractURLCheck)new RegexURLCheck("icons", "Any SVG icon", "^http://localhost:" + service.port() + "/styles/.*\\.svg$"));
        String base = "wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&width=256&height=256&srs=EPSG:4326&format=image/png";
        BufferedImage image = this.getAsImage(base + "&sld_body=" + ResponseUtils.urlEncode((String)burgStyle, (char[])new char[0]), "image/png");
        this.assertPixel(image, 130, 121, Color.RED);
    }

    @Test
    public void testRemoteIconNotAllowed() throws Exception {
        URLCheckDAO dao = (URLCheckDAO)applicationContext.getBean(URLCheckDAO.class);
        dao.save((AbstractURLCheck)new RegexURLCheck("noIcons", "We like it gray", "^abcd$"));
        String base = "wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&width=256&height=256&srs=EPSG:4326&format=image/png";
        BufferedImage image = this.getAsImage(base + "&sld_body=" + ResponseUtils.urlEncode((String)burgStyle, (char[])new char[0]), "image/png");
        this.assertPixel(image, 130, 121, Color.GRAY);
    }

    @Test
    public void testLocalReference() throws Exception {
        URLCheckDAO dao = (URLCheckDAO)applicationContext.getBean(URLCheckDAO.class);
        dao.save((AbstractURLCheck)new RegexURLCheck("noIcons", "We like it gray", "^abcd$"));
        String base = "wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&width=256&height=256&srs=EPSG:4326&format=image/png&layers=cite:Bridges&styles=burg";
        BufferedImage image = this.getAsImage(base, "image/png");
        this.assertPixel(image, 130, 121, Color.RED);
    }

    @Test
    public void testLocalReferenceWithBadQuery() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&width=256&height=256&srs=EPSG:4326&format=image/png&layers=cite:Bridges&styles=burg_query";
        BufferedImage image = this.getAsImage(base, "image/png");
        this.assertPixel(image, 130, 121, Color.GRAY);
    }

    @Test
    public void testLocalReferenceWithBadFragment() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetMap&bbox=-180,-90,180,90&width=256&height=256&srs=EPSG:4326&format=image/png&layers=cite:Bridges&styles=burg_fragment";
        BufferedImage image = this.getAsImage(base, "image/png");
        this.assertPixel(image, 130, 121, Color.GRAY);
    }
}

