/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.util.HashMap;
import java.util.Map;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.wms.WMSMapContent;
import org.geotools.map.Layer;

public abstract class WebMap {
    private String mimeType;
    private Map<String, String> responseHeaders;
    protected final WMSMapContent mapContent;
    private String extension;
    private String disposition;

    public WebMap(WMSMapContent context) {
        this.mapContent = context;
    }

    public final void dispose() {
        if (this.mapContent != null) {
            this.mapContent.dispose();
        }
        this.disposeInternal();
    }

    protected void disposeInternal() {
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setResponseHeader(String name, String value) {
        if (this.responseHeaders == null) {
            this.responseHeaders = new HashMap<String, String>();
        }
        this.responseHeaders.put(name, value);
    }

    public String[][] getResponseHeaders() {
        if (this.responseHeaders == null || this.responseHeaders.isEmpty()) {
            return null;
        }
        String[][] headers = new String[this.responseHeaders.size()][2];
        int index = 0;
        for (Map.Entry<String, String> entry : this.responseHeaders.entrySet()) {
            headers[index][0] = entry.getKey();
            headers[index][1] = entry.getValue();
            ++index;
        }
        return headers;
    }

    public void setContentDispositionHeader(WMSMapContent mapContent, String extension) {
        this.setContentDispositionHeader(mapContent, extension, true);
    }

    public void setContentDispositionHeader(WMSMapContent mapContent, String extension, boolean attachment) {
        this.extension = extension;
        this.disposition = attachment ? "attachment" : "inline";
    }

    public String getDisposition() {
        return this.disposition;
    }

    public String getAttachmentFileName() {
        String filename = this.getSimpleAttachmentFileName();
        if (filename != null && this.extension != null) {
            return filename + this.extension;
        }
        return filename;
    }

    public String getSimpleAttachmentFileName() {
        String layers;
        Request request = (Request)Dispatcher.REQUEST.get();
        String filename = null;
        if (request != null && request.getRawKvp() != null && request.getRawKvp().get("LAYERS") != null && !(layers = ((String)request.getRawKvp().get("LAYERS")).trim()).isEmpty()) {
            filename = layers.replace(",", "_");
        }
        if (filename == null && this.mapContent != null) {
            StringBuffer sb = new StringBuffer();
            for (Layer layer : this.mapContent.layers()) {
                String title = layer.getTitle();
                if (title == null || title.equals("")) continue;
                sb.append(title).append("_");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
                filename = sb.toString();
            }
        }
        if (filename != null) {
            filename = filename.replace(":", "-");
        }
        return filename;
    }

    public WMSMapContent getMapContent() {
        return this.mapContent;
    }
}

